/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.Biome;
import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.World;
import com.tom.cpl.util.WeakStorage;
import com.tom.cpm.common.BiomeHandlerImpl;
import com.tom.cpm.common.BlockMeta;
import com.tom.cpm.common.BlockStateHandlerImpl;
import com.tom.cpm.shared.animation.AnimationState;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.LightLayer;

public class WorldImpl
implements World {
    public WeakStorage<net.minecraft.core.world.World> level = new WeakStorage();
    public int x;
    public int y;
    public int z;

    public static void setWorld(AnimationState a, Entity ent) {
        if (!(a.world instanceof WorldImpl)) {
            a.world = new WorldImpl();
        }
        WorldImpl i = (WorldImpl)a.world;
        net.minecraft.core.world.World l = ent.world;
        i.level.set(l);
        i.x = (int)ent.x;
        i.y = (int)ent.y;
        i.z = (int)ent.z;
        a.dayTime = l.getWorldTime();
        a.skyLight = l.getSavedLightValue(LightLayer.Sky, i.x, i.y, i.z);
        a.blockLight = l.getSavedLightValue(LightLayer.Block, i.x, i.y, i.z);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        int block = this.level.call(l -> l.getBlockId(this.x + x, this.y + y, this.z + z), 0);
        int meta = this.level.call(l -> l.getBlockMetadata(this.x + x, this.y + y, this.z + z), 0);
        return BlockStateHandlerImpl.impl.wrap(new BlockMeta(block, meta));
    }

    @Override
    public boolean isCovered() {
        return this.level.call(l -> !l.canBlockSeeTheSky(this.x, this.y, this.z), false);
    }

    @Override
    public int getYHeight() {
        return this.y;
    }

    @Override
    public int getMaxHeight() {
        return this.level.call(l -> l.getHeightBlocks(), 0);
    }

    @Override
    public int getMinHeight() {
        return 0;
    }

    @Override
    public World.WeatherType getWeather() {
        return World.WeatherType.CLEAR;
    }

    @Override
    public Biome getBiome() {
        return this.level.call(l -> BiomeHandlerImpl.impl.wrap(l.getBlockBiome(this.x, this.y, this.z)), null);
    }

    @Override
    public String getDimension() {
        return this.level.call(l -> "DIM-" + l.dimension.id, null);
    }
}

