/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.mixin.client;

import com.tom.cpm.client.ClientNetworkImpl;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.shared.io.FastByteArrayInputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.client.world.WorldClientMP;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketCustomPayload;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketHandlerClient.class}, remap=false)
public abstract class ClientNetworkHandlerMixin
implements ClientNetworkImpl {
    @Shadow
    @Final
    private Minecraft mc;
    @Shadow
    private WorldClientMP worldClientMP;
    @Shadow
    @Final
    private NetworkManager netManager;
    private boolean cpm$hasMod;

    @Shadow
    public abstract void addToSendQueue(Packet var1);

    @Override
    public boolean cpm$hasMod() {
        return this.cpm$hasMod;
    }

    @Override
    public void cpm$setHasMod(boolean v) {
        this.cpm$hasMod = v;
    }

    @Override
    public void cpm$sendPacket(String id, byte[] data) {
        this.addToSendQueue((Packet)new PacketCustomPayload(id, data));
    }

    @Override
    public Entity cpm$getEntityByID(int id) {
        if (this.mc.thePlayer.id == id) {
            return this.mc.thePlayer;
        }
        return this.worldClientMP.getEntityFromId(id);
    }

    @Override
    public String cpm$getConnectedServer() {
        SocketAddress sa = this.netManager.getRemoteAddress();
        if (sa instanceof InetSocketAddress) {
            return ((InetSocketAddress)sa).getHostString();
        }
        return null;
    }

    @Inject(at={@At(value="HEAD")}, method={"handleCustomPayload"}, cancellable=true)
    public void onCustomPayload(PacketCustomPayload customPayloadPacket, CallbackInfo cbi) {
        if (customPayloadPacket.channel.startsWith("cpm_net:")) {
            CustomPlayerModelsClient.netHandler.receiveClient(customPayloadPacket.channel, new FastByteArrayInputStream(customPayloadPacket.data), this);
            cbi.cancel();
        }
    }
}

