/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.mixin.server;

import com.tom.cpm.common.ServerHandler;
import com.tom.cpm.common.ServerNetworkImpl;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.io.FastByteArrayInputStream;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketChat;
import net.minecraft.core.net.packet.PacketCustomPayload;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.net.handler.PacketHandlerServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketHandlerServer.class}, remap=false)
public abstract class ServerNetworkHandlerMixin
implements ServerNetworkImpl {
    @Shadow
    private PlayerServer playerEntity;
    private boolean cpm$hasMod;
    private PlayerData cpm$data;

    @Shadow
    public abstract void sendPacket(Packet var1);

    @Shadow
    public abstract void kickPlayer(String var1);

    @Override
    public boolean cpm$hasMod() {
        return this.cpm$hasMod;
    }

    @Override
    public void cpm$setHasMod(boolean v) {
        this.cpm$hasMod = v;
    }

    @Override
    public PlayerData cpm$getEncodedModelData() {
        return this.cpm$data;
    }

    @Override
    public void cpm$setEncodedModelData(PlayerData data) {
        this.cpm$data = data;
    }

    @Override
    public void cpm$sendChat(String msg) {
        this.sendPacket((Packet)new PacketChat(msg));
    }

    @Override
    public Player cpm$getPlayer() {
        return this.playerEntity;
    }

    @Override
    public void cpm$kickPlayer(String msg) {
        this.kickPlayer(msg);
    }

    @Override
    public void cpm$sendPacket(String id, byte[] data) {
        this.sendPacket((Packet)new PacketCustomPayload(id, data));
    }

    @Inject(at={@At(value="HEAD")}, method={"handleCustomPayload"}, cancellable=true)
    public void onCustomPayload(PacketCustomPayload customPayloadPacket, CallbackInfo cbi) {
        if (customPayloadPacket.channel.startsWith("cpm_net:")) {
            ServerHandler.netHandler.receiveServer(customPayloadPacket.channel, new FastByteArrayInputStream(customPayloadPacket.data), this);
            cbi.cancel();
        }
    }
}

