/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.retro;

import com.tom.cpl.util.ILogger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileLogger
implements ILogger {
    private String prefix;
    private PrintStream out;

    public FileLogger(String prefix) {
        this.prefix = prefix;
        try {
            final FileOutputStream fo = new FileOutputStream(prefix.replace(' ', '-') + ".log");
            this.out = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    System.out.write(b);
                    fo.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    System.out.write(b, off, len);
                    fo.write(b, off, len);
                }
            }, true, "UTF-8");
        }
        catch (IOException e) {
            this.out = System.out;
        }
    }

    private String format(String level, String text) {
        return "[" + new SimpleDateFormat("HH:mm:ss").format(new Date()) + "] [" + this.prefix + "/" + level + "]: " + text;
    }

    @Override
    public void warn(String text, Throwable thr) {
        this.out.println(this.format("WARN", text));
        thr.printStackTrace(this.out);
    }

    @Override
    public void warn(String text) {
        this.out.println(this.format("WARN", text));
    }

    @Override
    public void info(String text) {
        this.out.println(this.format("INFO", text));
    }

    @Override
    public void error(String text, Throwable thr) {
        this.out.println(this.format("ERROR", text));
        thr.printStackTrace(this.out);
    }

    @Override
    public void error(String text) {
        this.out.println(this.format("ERROR", text));
    }

    @Override
    public void info(String text, Throwable thr) {
        this.out.println(this.format("INFO", text));
        thr.printStackTrace(this.out);
    }
}

