/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.retro;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tom.cpm.retro.GameProfile;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.io.HTTPIO;
import com.tom.cpm.shared.skin.TextureType;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpm.shared.util.Log;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class GameProfileManager {
    private static final LoadingCache<String, ProfileLookup> usernameCache = CacheBuilder.newBuilder().build(CacheLoader.from(ProfileLookup::new));

    public static GameProfile getProfile(String name) {
        try {
            return ((ProfileLookup)usernameCache.get((Object)name)).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to load player details: " + name, e);
        }
    }

    public static CompletableFuture<GameProfile> getProfileFuture(String name) {
        try {
            return ((ProfileLookup)usernameCache.get((Object)name)).getFuture();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to load player details: " + name, e);
        }
    }

    private static void checkError(Map<String, Object> r) throws IOException {
        if (r == null) {
            throw new IOException("Invalid data returned from the server");
        }
        if (r.containsKey("error") || r.containsKey("errorMessage")) {
            String error = String.valueOf(r.get("error"));
            throw new IOException(error + ": " + String.valueOf(r.get("errorMessage")));
        }
    }

    public static String getTextureUrlSync(String username, TextureType type, String fallback) {
        try {
            return GameProfileManager.getProfileFuture(username).get().getTextureURLMap().getOrDefault((Object)type, fallback);
        }
        catch (InterruptedException | ExecutionException e) {
            return fallback;
        }
    }

    public static void clear() {
        usernameCache.invalidateAll();
    }

    private static class ProfileLookup {
        private GameProfile profile;
        private CompletableFuture<GameProfile> future;
        private Throwable exception;

        public ProfileLookup(String name) {
            UUID offline = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
            this.profile = new GameProfile(offline, name);
            if (name.isEmpty()) {
                this.future = CompletableFuture.completedFuture(this.profile);
                return;
            }
            this.future = CompletableFuture.supplyAsync(this::load, MinecraftClientAccess.get().getDefinitionLoader()::execute).handleAsync((r, ex) -> {
                if (ex != null) {
                    this.exception = ex;
                    return this.profile;
                }
                this.profile = r;
                return this.profile;
            }, MinecraftClientAccess.get()::executeOnGameThread);
        }

        private GameProfile load() {
            String name = this.profile.getName();
            Log.debug("Fetching profile info: " + name);
            try {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
                HttpURLConnection httpCon = HTTPIO.createUrlConnection(url, true);
                String resp = HTTPIO.getResponse(httpCon, url);
                Map r = (Map)MinecraftObjectHolder.gson.fromJson(resp, Object.class);
                GameProfileManager.checkError(r);
                String rawId = (String)r.get("id");
                Log.debug(name + ": " + rawId);
                url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + rawId);
                httpCon = HTTPIO.createUrlConnection(url, true);
                resp = HTTPIO.getResponse(httpCon, url);
                r = (Map)MinecraftObjectHolder.gson.fromJson(resp, Object.class);
                GameProfileManager.checkError(r);
                return new GameProfile(r);
            }
            catch (Exception e) {
                ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load profile info for: " + name, e);
                return this.profile;
            }
        }

        public GameProfile get() {
            return this.profile;
        }

        public CompletableFuture<GameProfile> getFuture() {
            return this.future;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

