/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.retro;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.tom.cpl.util.ILogger;
import com.tom.cpm.retro.SysLogger;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class MCExecutor {
    private static final ILogger logger = new SysLogger("CPM Executor");
    private static final Queue<FutureTask<?>> scheduledTasks = Queues.newArrayDeque();
    private static Thread mcThread;
    public static final Executor ex;

    public static void init() {
        mcThread = Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeAll() {
        Queue<FutureTask<?>> queue = scheduledTasks;
        synchronized (queue) {
            while (!scheduledTasks.isEmpty()) {
                MCExecutor.runTask(scheduledTasks.poll());
            }
        }
    }

    public static <V> V runTask(FutureTask<V> task) {
        try {
            task.run();
            return task.get();
        }
        catch (ExecutionException executionexception) {
            logger.error("Error executing task", executionexception);
        }
        catch (InterruptedException interruptedexception) {
            logger.error("Error executing task", interruptedexception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> ListenableFuture<V> addScheduledTask(Callable<V> callableToSchedule) {
        if (callableToSchedule == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        if (MCExecutor.isCallingFromMinecraftThread()) {
            try {
                return Futures.immediateFuture(callableToSchedule.call());
            }
            catch (Exception exception) {
                return Futures.immediateFailedFuture((Throwable)exception);
            }
        }
        ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(callableToSchedule);
        Queue<FutureTask<?>> queue = scheduledTasks;
        synchronized (queue) {
            scheduledTasks.add((FutureTask<?>)listenablefuturetask);
            return listenablefuturetask;
        }
    }

    public static ListenableFuture<Object> addScheduledTask(Runnable runnableToSchedule) {
        if (runnableToSchedule == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        return MCExecutor.addScheduledTask(Executors.callable(runnableToSchedule));
    }

    public static boolean isCallingFromMinecraftThread() {
        return Thread.currentThread() == mcThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tell(Runnable runnableToSchedule) {
        if (runnableToSchedule == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(Executors.callable(runnableToSchedule));
        Queue<FutureTask<?>> queue = scheduledTasks;
        synchronized (queue) {
            scheduledTasks.add((FutureTask<?>)listenablefuturetask);
        }
    }

    static {
        ex = new Executor(){

            @Override
            public void execute(Runnable command) {
                MCExecutor.addScheduledTask(command);
            }
        };
    }
}

