/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.math.BoundingBox;
import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.ListBuffer;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.Direction;
import com.tom.cpm.shared.model.render.Mesh;
import com.tom.cpm.shared.model.render.PerFaceUV;
import com.tom.cpm.shared.model.render.RenderMode;
import java.util.ArrayList;

public class BoxRender {
    public static Mesh createTexturedSingle(Vec3f pos, Vec3f size, Vec3f sc, float delta, int texU, int texV, int texSize, int sheetSizeX, int sheetSizeY) {
        Vertex vertex6;
        Vertex vertex5;
        Vertex vertex4;
        Vertex vertex3;
        Vertex vertex2;
        Vertex vertex1;
        Vertex vertex;
        Vertex vertex7;
        float x = pos.x;
        float y = pos.y;
        float z = pos.z;
        float w = size.x;
        float h = size.y;
        float d = size.z;
        int ts = Math.abs(texSize);
        int dx = MathHelper.ceil(w * (float)ts);
        int dy = MathHelper.ceil(h * (float)ts);
        int dz = MathHelper.ceil(d * (float)ts);
        float ex = x + w * sc.x;
        float ey = y + h * sc.y;
        float ez = z + d * sc.z;
        x -= delta;
        y -= delta;
        z -= delta;
        ex += delta;
        ey += delta;
        ez += delta;
        texU *= ts;
        texV *= ts;
        if (texSize < 0) {
            float s = ex;
            ex = x;
            x = s;
        }
        if (ex == x || ey == y || ez == z) {
            float tv;
            float tu;
            Quad[] quadList = new Quad[2];
            if (ex == x) {
                vertex7 = new Vertex(x, y, z, 0.0f, 0.0f);
                vertex = new Vertex(ex += 0.001f, y, z, 0.0f, 8.0f);
                vertex1 = new Vertex(ex, ey, z, 8.0f, 8.0f);
                vertex2 = new Vertex(x, ey, z, 8.0f, 0.0f);
                vertex3 = new Vertex(x, y, ez, 0.0f, 0.0f);
                vertex4 = new Vertex(ex, y, ez, 0.0f, 8.0f);
                vertex5 = new Vertex(ex, ey, ez, 8.0f, 8.0f);
                vertex6 = new Vertex(x, ey, ez, 8.0f, 0.0f);
                tu = texU + dz;
                tv = texV + dy;
                quadList[1] = new Quad(new Vertex[]{vertex7, vertex3, vertex6, vertex2}, texU, texV, tu, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.NEGATIVE_X);
                quadList[0] = new Quad(new Vertex[]{vertex4, vertex, vertex1, vertex5}, tu, texV, texU, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.POSITIVE_X);
            } else if (ey == y) {
                vertex7 = new Vertex(x, y, z, 0.0f, 0.0f);
                vertex = new Vertex(ex, y, z, 0.0f, 8.0f);
                vertex1 = new Vertex(ex, ey += 0.001f, z, 8.0f, 8.0f);
                vertex2 = new Vertex(x, ey, z, 8.0f, 0.0f);
                vertex3 = new Vertex(x, y, ez, 0.0f, 0.0f);
                vertex4 = new Vertex(ex, y, ez, 0.0f, 8.0f);
                vertex5 = new Vertex(ex, ey, ez, 8.0f, 8.0f);
                vertex6 = new Vertex(x, ey, ez, 8.0f, 0.0f);
                tu = texU + dx;
                tv = texV + dz;
                quadList[0] = new Quad(new Vertex[]{vertex4, vertex3, vertex7, vertex}, texU, texV, tu, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.NEGATIVE_Y);
                quadList[1] = new Quad(new Vertex[]{vertex1, vertex2, vertex6, vertex5}, tu, texV, texU, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.POSITIVE_Y);
            } else if (ez == z) {
                vertex7 = new Vertex(x, y, z, 0.0f, 0.0f);
                vertex = new Vertex(ex, y, z, 0.0f, 8.0f);
                vertex1 = new Vertex(ex, ey, z, 8.0f, 8.0f);
                vertex2 = new Vertex(x, ey, z, 8.0f, 0.0f);
                vertex3 = new Vertex(x, y, ez += 0.001f, 0.0f, 0.0f);
                vertex4 = new Vertex(ex, y, ez, 0.0f, 8.0f);
                vertex5 = new Vertex(ex, ey, ez, 8.0f, 8.0f);
                vertex6 = new Vertex(x, ey, ez, 8.0f, 0.0f);
                tu = texU + dx;
                tv = texV + dy;
                quadList[0] = new Quad(new Vertex[]{vertex, vertex7, vertex2, vertex1}, texU, texV, tu, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.NEGATIVE_Z);
                quadList[1] = new Quad(new Vertex[]{vertex3, vertex4, vertex5, vertex6}, tu, texV, texU, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.POSITIVE_Z);
            }
            if (quadList[0] != null) {
                return new QuadMesh(quadList, RenderMode.NORMAL);
            }
        }
        Quad[] quadList = new Quad[6];
        vertex7 = new Vertex(x, y, z, 0.0f, 0.0f);
        vertex = new Vertex(ex, y, z, 0.0f, 8.0f);
        vertex1 = new Vertex(ex, ey, z, 8.0f, 8.0f);
        vertex2 = new Vertex(x, ey, z, 8.0f, 0.0f);
        vertex3 = new Vertex(x, y, ez, 0.0f, 0.0f);
        vertex4 = new Vertex(ex, y, ez, 0.0f, 8.0f);
        vertex5 = new Vertex(ex, ey, ez, 8.0f, 8.0f);
        vertex6 = new Vertex(x, ey, ez, 8.0f, 0.0f);
        int txS = Math.max(dx, Math.max(dy, dz));
        float tu = texU + txS;
        float tv = texV + txS;
        quadList[2] = new Quad(new Vertex[]{vertex4, vertex3, vertex7, vertex}, texU, texV, tu, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.NEGATIVE_Y);
        quadList[3] = new Quad(new Vertex[]{vertex1, vertex2, vertex6, vertex5}, texU, texV, tu, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.POSITIVE_Y);
        quadList[1] = new Quad(new Vertex[]{vertex7, vertex3, vertex6, vertex2}, texU, texV, tu, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.NEGATIVE_X);
        quadList[4] = new Quad(new Vertex[]{vertex, vertex7, vertex2, vertex1}, texU, texV, tu, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.NEGATIVE_Z);
        quadList[0] = new Quad(new Vertex[]{vertex4, vertex, vertex1, vertex5}, texU, texV, tu, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.POSITIVE_X);
        quadList[5] = new Quad(new Vertex[]{vertex3, vertex4, vertex5, vertex6}, texU, texV, tu, tv, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.POSITIVE_Z);
        return new QuadMesh(quadList, RenderMode.NORMAL);
    }

    public static Mesh createTextured(Vec3f pos, Vec3f size, Vec3f sc, float delta, int texU, int texV, int texSize, int sheetSizeX, int sheetSizeY) {
        Quad[] quadList = new Quad[6];
        float x = pos.x;
        float y = pos.y;
        float z = pos.z;
        float w = size.x;
        float h = size.y;
        float d = size.z;
        int ts = Math.abs(texSize);
        int dx = MathHelper.ceil(w * (float)ts);
        int dy = MathHelper.ceil(h * (float)ts);
        int dz = MathHelper.ceil(d * (float)ts);
        float ex = x + w * sc.x;
        float ey = y + h * sc.y;
        float ez = z + d * sc.z;
        x -= delta;
        y -= delta;
        z -= delta;
        ex += delta;
        ey += delta;
        ez += delta;
        texU *= ts;
        texV *= ts;
        if (texSize < 0) {
            float s = ex;
            ex = x;
            x = s;
        }
        Vertex vertex7 = new Vertex(x, y, z, 0.0f, 0.0f);
        Vertex vertex = new Vertex(ex, y, z, 0.0f, 8.0f);
        Vertex vertex1 = new Vertex(ex, ey, z, 8.0f, 8.0f);
        Vertex vertex2 = new Vertex(x, ey, z, 8.0f, 0.0f);
        Vertex vertex3 = new Vertex(x, y, ez, 0.0f, 0.0f);
        Vertex vertex4 = new Vertex(ex, y, ez, 0.0f, 8.0f);
        Vertex vertex5 = new Vertex(ex, ey, ez, 8.0f, 8.0f);
        Vertex vertex6 = new Vertex(x, ey, ez, 8.0f, 0.0f);
        float f4 = texU;
        float f5 = (float)texU + (float)dz;
        float f6 = (float)texU + (float)dz + (float)dx;
        float f7 = (float)texU + (float)dz + (float)dx + (float)dx;
        float f8 = (float)texU + (float)dz + (float)dx + (float)dz;
        float f9 = (float)texU + (float)dz + (float)dx + (float)dz + (float)dx;
        float f10 = texV;
        float f11 = (float)texV + (float)dz;
        float f12 = (float)texV + (float)dz + (float)dy;
        quadList[2] = new Quad(new Vertex[]{vertex4, vertex3, vertex7, vertex}, f5, f10, f6, f11, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.NEGATIVE_Y);
        quadList[3] = new Quad(new Vertex[]{vertex1, vertex2, vertex6, vertex5}, f6, f11, f7, f10, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.POSITIVE_Y);
        quadList[1] = new Quad(new Vertex[]{vertex7, vertex3, vertex6, vertex2}, f4, f11, f5, f12, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.NEGATIVE_X);
        quadList[4] = new Quad(new Vertex[]{vertex, vertex7, vertex2, vertex1}, f5, f11, f6, f12, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.NEGATIVE_Z);
        quadList[0] = new Quad(new Vertex[]{vertex4, vertex, vertex1, vertex5}, f6, f11, f8, f12, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.POSITIVE_X);
        quadList[5] = new Quad(new Vertex[]{vertex3, vertex4, vertex5, vertex6}, f8, f11, f9, f12, sheetSizeX, sheetSizeY, texSize < 0, Vec3f.POSITIVE_Z);
        return new QuadMesh(quadList, RenderMode.NORMAL);
    }

    public static Mesh createTextured(Vec3f pos, Vec3f size, Vec3f sc, float delta, PerFaceUV uv, int texSize, int sheetSizeX, int sheetSizeY) {
        ArrayList<Quad> quadList = new ArrayList<Quad>();
        float x = pos.x;
        float y = pos.y;
        float z = pos.z;
        float w = size.x;
        float h = size.y;
        float d = size.z;
        float ex = x + w * sc.x;
        float ey = y + h * sc.y;
        float ez = z + d * sc.z;
        Vertex ptv7 = new Vertex(x -= delta, y -= delta, z -= delta, 0.0f, 0.0f);
        Vertex ptv = new Vertex(ex += delta, y, z, 0.0f, 8.0f);
        Vertex ptv1 = new Vertex(ex, ey += delta, z, 8.0f, 8.0f);
        Vertex ptv2 = new Vertex(x, ey, z, 8.0f, 0.0f);
        Vertex ptv3 = new Vertex(x, y, ez += delta, 0.0f, 0.0f);
        Vertex ptv4 = new Vertex(ex, y, ez, 0.0f, 8.0f);
        Vertex ptv5 = new Vertex(ex, ey, ez, 8.0f, 8.0f);
        Vertex ptv6 = new Vertex(x, ey, ez, 8.0f, 0.0f);
        if (uv.contains(Direction.EAST)) {
            quadList.add(new Quad(new Vertex[]{ptv4, ptv, ptv1, ptv5}, uv.get(Direction.EAST), sheetSizeX, sheetSizeY, Vec3f.POSITIVE_X));
        }
        if (uv.contains(Direction.WEST)) {
            quadList.add(new Quad(new Vertex[]{ptv7, ptv3, ptv6, ptv2}, uv.get(Direction.WEST), sheetSizeX, sheetSizeY, Vec3f.NEGATIVE_X));
        }
        if (uv.contains(Direction.UP)) {
            quadList.add(new Quad(new Vertex[]{ptv4, ptv3, ptv7, ptv}, uv.get(Direction.UP), sheetSizeX, sheetSizeY, Vec3f.NEGATIVE_Y));
        }
        if (uv.contains(Direction.DOWN)) {
            quadList.add(new Quad(new Vertex[]{ptv1, ptv2, ptv6, ptv5}, uv.get(Direction.DOWN), sheetSizeX, sheetSizeY, Vec3f.POSITIVE_Y));
        }
        if (uv.contains(Direction.NORTH)) {
            quadList.add(new Quad(new Vertex[]{ptv, ptv7, ptv2, ptv1}, uv.get(Direction.NORTH), sheetSizeX, sheetSizeY, Vec3f.NEGATIVE_Z));
        }
        if (uv.contains(Direction.SOUTH)) {
            quadList.add(new Quad(new Vertex[]{ptv3, ptv4, ptv5, ptv6}, uv.get(Direction.SOUTH), sheetSizeX, sheetSizeY, Vec3f.POSITIVE_Z));
        }
        return new QuadMesh(quadList.toArray(new Quad[0]), RenderMode.NORMAL);
    }

    public static Mesh createColored(float x, float y, float z, float w, float h, float d, float delta, int sheetSizeX, int sheetSizeY) {
        Quad[] quadList = new Quad[6];
        float ex = x + w;
        float ey = y + h;
        float ez = z + d;
        Vertex vertex7 = new Vertex(x -= delta, y -= delta, z -= delta, 0.0f, 0.0f);
        Vertex vertex = new Vertex(ex += delta, y, z, 0.0f, 8.0f);
        Vertex vertex1 = new Vertex(ex, ey += delta, z, 8.0f, 8.0f);
        Vertex vertex2 = new Vertex(x, ey, z, 8.0f, 0.0f);
        Vertex vertex3 = new Vertex(x, y, ez += delta, 0.0f, 0.0f);
        Vertex vertex4 = new Vertex(ex, y, ez, 0.0f, 8.0f);
        Vertex vertex5 = new Vertex(ex, ey, ez, 8.0f, 8.0f);
        Vertex vertex6 = new Vertex(x, ey, ez, 8.0f, 0.0f);
        int dx = MathHelper.ceil(w);
        int dy = MathHelper.ceil(h);
        int dz = MathHelper.ceil(d);
        float f4 = 0.0f;
        float f5 = dz;
        float f6 = dz + dx;
        float f7 = dz + dx + dx;
        float f8 = dz + dx + dz;
        float f9 = dz + dx + dz + dx;
        float f10 = 0.0f;
        float f11 = dz;
        float f12 = dz + dy;
        quadList[2] = new Quad(new Vertex[]{vertex4, vertex3, vertex7, vertex}, f5, f10, f6, f11, sheetSizeX, sheetSizeY, false, Vec3f.NEGATIVE_Y);
        quadList[3] = new Quad(new Vertex[]{vertex1, vertex2, vertex6, vertex5}, f6, f11, f7, f10, sheetSizeX, sheetSizeY, false, Vec3f.POSITIVE_Y);
        quadList[1] = new Quad(new Vertex[]{vertex7, vertex3, vertex6, vertex2}, f4, f11, f5, f12, sheetSizeX, sheetSizeY, false, Vec3f.NEGATIVE_X);
        quadList[4] = new Quad(new Vertex[]{vertex, vertex7, vertex2, vertex1}, f5, f11, f6, f12, sheetSizeX, sheetSizeY, false, Vec3f.NEGATIVE_Z);
        quadList[0] = new Quad(new Vertex[]{vertex4, vertex, vertex1, vertex5}, f6, f11, f8, f12, sheetSizeX, sheetSizeY, false, Vec3f.POSITIVE_X);
        quadList[5] = new Quad(new Vertex[]{vertex3, vertex4, vertex5, vertex6}, f8, f11, f9, f12, sheetSizeX, sheetSizeY, false, Vec3f.POSITIVE_Z);
        return new QuadMesh(quadList, RenderMode.COLOR);
    }

    public static void drawOrigin(MatrixStack matrixStackIn, VertexBuffer bufferIn, float x, float y, float z, float len) {
        Mat4f matrix4f = matrixStackIn.getLast().getMatrix();
        Mat3f matrix3f = matrixStackIn.getLast().getNormal();
        bufferIn.pos(matrix4f, x, y, z).color(0.0f, 1.0f, 0.0f, 1.0f).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, x, y + len, z).color(0.0f, 1.0f, 0.0f, 1.0f).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, x, y, z).color(1.0f, 0.0f, 0.0f, 1.0f).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, x + len, y, z).color(1.0f, 0.0f, 0.0f, 1.0f).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, x, y, z).color(0.0f, 0.0f, 1.0f, 1.0f).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        bufferIn.pos(matrix4f, x, y, z + len).color(0.0f, 0.0f, 1.0f, 1.0f).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
    }

    public static void drawBoundingBox(MatrixStack matrixStackIn, VertexBuffer bufferIn, BoundingBox bb, float red, float green, float blue, float alpha) {
        Mat4f matrix4f = matrixStackIn.getLast().getMatrix();
        Mat3f matrix3f = matrixStackIn.getLast().getNormal();
        float sx = bb.minX;
        float sy = bb.minY;
        float sz = bb.minZ;
        float ex = bb.maxX;
        float ey = bb.maxY;
        float ez = bb.maxZ;
        bufferIn.pos(matrix4f, sx, sy, sz).color(red, green, blue, alpha).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, ex, sy, sz).color(red, green, blue, alpha).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, sx, sy, sz).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, sx, ey, sz).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, sx, sy, sz).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        bufferIn.pos(matrix4f, sx, sy, ez).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        bufferIn.pos(matrix4f, ex, sy, sz).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, ex, ey, sz).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, ex, ey, sz).color(red, green, blue, alpha).normal(matrix3f, -1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, sx, ey, sz).color(red, green, blue, alpha).normal(matrix3f, -1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, sx, ey, sz).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        bufferIn.pos(matrix4f, sx, ey, ez).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        bufferIn.pos(matrix4f, sx, ey, ez).color(red, green, blue, alpha).normal(matrix3f, 0.0f, -1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, sx, sy, ez).color(red, green, blue, alpha).normal(matrix3f, 0.0f, -1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, sx, sy, ez).color(red, green, blue, alpha).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, ex, sy, ez).color(red, green, blue, alpha).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, ex, sy, ez).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 0.0f, -1.0f).endVertex();
        bufferIn.pos(matrix4f, ex, sy, sz).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 0.0f, -1.0f).endVertex();
        bufferIn.pos(matrix4f, sx, ey, ez).color(red, green, blue, alpha).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, ex, ey, ez).color(red, green, blue, alpha).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, ex, sy, ez).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, ex, ey, ez).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        bufferIn.pos(matrix4f, ex, ey, sz).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        bufferIn.pos(matrix4f, ex, ey, ez).color(red, green, blue, alpha).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
    }

    public static void fillBoundingBox(MatrixStack matrixStackIn, VertexBuffer bufferIn, BoundingBox bb, float red, float green, float blue, float alpha) {
        float sx = bb.minX * 16.0f;
        float sy = bb.minY * 16.0f;
        float sz = bb.minZ * 16.0f;
        float ex = bb.maxX * 16.0f;
        float ey = bb.maxY * 16.0f;
        float ez = bb.maxZ * 16.0f;
        BoxRender.createColored(sx, sy, sz, ex - sx, ey - sy, ez - sz, 0.0f, 64, 64).draw(matrixStackIn, bufferIn, red, green, blue, alpha);
    }

    public static Mesh createTexturedExtruded(Vec3f pos, Vec3f size, Vec3f sc, float delta, int texU, int texV, int texSize, int sheetSizeX, int sheetSizeY) {
        float x = pos.x;
        float y = pos.y;
        float z = pos.z;
        float w = size.x;
        float h = size.y;
        float d = size.z;
        int ts = Math.abs(texSize);
        int dx = MathHelper.ceil(w * (float)ts);
        int dy = MathHelper.ceil(h * (float)ts);
        x -= delta;
        y -= delta;
        z -= delta;
        w = w * sc.x + delta * 2.0f;
        h = h * sc.y + delta * 2.0f;
        d = d * sc.z + delta * 2.0f;
        texU *= ts;
        texV *= ts;
        MatrixStack stack = new MatrixStack();
        if (texSize < 0) {
            stack.translate(x / 16.0f, (y + h) / 16.0f, z / 16.0f);
            stack.scale(w / 16.0f, -h / 16.0f, -d / 16.0f);
        } else {
            stack.translate((x + w) / 16.0f, (y + h) / 16.0f, (z + d) / 16.0f);
            stack.scale(-w / 16.0f, -h / 16.0f, d / 16.0f);
        }
        MatrixStack.Entry e = stack.getLast();
        float tu = texU + dx;
        float tv = texV + dy;
        return new ExtrudedMesh(e.getMatrix(), e.getNormal(), (float)texU / (float)sheetSizeX, (float)texV / (float)sheetSizeY, tu / (float)sheetSizeX, tv / (float)sheetSizeY, dx, dy);
    }

    public static int getExtrudeSize(Vec3f size, int texSize) {
        float w = size.x;
        float h = size.y;
        int ts = Math.abs(texSize);
        int dx = MathHelper.ceil(w * (float)ts);
        int dy = MathHelper.ceil(h * (float)ts);
        return dx * dy * 3 / 4;
    }

    private static class Quad {
        public final Vertex[] vertexPositions;
        public final Vec3f normal;

        public Quad(Vertex[] posIn, PerFaceUV.Face f, float texWidth, float texHeight, Vec3f directionIn) {
            this.vertexPositions = posIn;
            for (int i = 0; i < posIn.length; ++i) {
                posIn[i] = posIn[i].setTextureUV((float)f.getVertexU(i) / texWidth, (float)f.getVertexV(i) / texHeight);
            }
            this.normal = new Vec3f(directionIn);
        }

        public Quad(Vertex[] posIn, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirrorIn, Vec3f directionIn) {
            this.vertexPositions = posIn;
            posIn[0] = posIn[0].setTextureUV(u2 / texWidth, v1 / texHeight);
            posIn[1] = posIn[1].setTextureUV(u1 / texWidth, v1 / texHeight);
            posIn[2] = posIn[2].setTextureUV(u1 / texWidth, v2 / texHeight);
            posIn[3] = posIn[3].setTextureUV(u2 / texWidth, v2 / texHeight);
            if (mirrorIn) {
                int i = posIn.length;
                for (int j = 0; j < i / 2; ++j) {
                    Vertex vertex = posIn[j];
                    posIn[j] = posIn[i - 1 - j];
                    posIn[i - 1 - j] = vertex;
                }
            }
            this.normal = new Vec3f(directionIn);
            if (mirrorIn) {
                this.normal.mul(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    private static class Vertex {
        public final Vec3f position;
        public final float textureU;
        public final float textureV;

        public Vertex(float x, float y, float z, float texU, float texV) {
            this(new Vec3f(x, y, z), texU, texV);
        }

        public Vertex setTextureUV(float texU, float texV) {
            return new Vertex(this.position, texU, texV);
        }

        public Vertex(Vec3f posIn, float texU, float texV) {
            this.position = posIn;
            this.textureU = texU;
            this.textureV = texV;
        }
    }

    private static class QuadMesh
    implements Mesh {
        private final Quad[] quadList;
        private final RenderMode mode;

        public QuadMesh(Quad[] quadList, RenderMode mode) {
            this.quadList = quadList;
            this.mode = mode;
        }

        @Override
        public void draw(MatrixStack matrixStackIn, VertexBuffer bufferIn, float red, float green, float blue, float alpha) {
            Mat4f matrix4f = matrixStackIn.getLast().getMatrix();
            Mat3f matrix3f = matrixStackIn.getLast().getNormal();
            for (Quad quad : this.quadList) {
                Vec3f vector3f = quad.normal.copy();
                vector3f.transform(matrix3f);
                float f = vector3f.x;
                float f1 = vector3f.y;
                float f2 = vector3f.z;
                for (int i = 0; i < 4; ++i) {
                    Vertex vertex = quad.vertexPositions[i];
                    float f3 = vertex.position.x / 16.0f;
                    float f4 = vertex.position.y / 16.0f;
                    float f5 = vertex.position.z / 16.0f;
                    Vec4f vector4f = new Vec4f(f3, f4, f5, 1.0f);
                    vector4f.transform(matrix4f);
                    bufferIn.addVertex(vector4f.x, vector4f.y, vector4f.z, red, green, blue, alpha, vertex.textureU, vertex.textureV, f, f1, f2);
                }
            }
        }

        @Override
        public RenderMode getLayer() {
            return this.mode;
        }

        @Override
        public void free() {
        }
    }

    private static class ExtrudedMesh
    implements Mesh {
        private ListBuffer buffer = new ListBuffer();

        public ExtrudedMesh(Mat4f matrix4f, Mat3f matrix3f, float minU, float minV, float maxU, float maxV, int texWidth, int texHeight) {
            float f9;
            float f8;
            float f7;
            int k;
            this.buffer.pos(matrix4f, 0.0f, 0.0f, 0.0f).normal(matrix3f, 0.0f, 0.0f, 1.0f).tex(maxU, maxV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            this.buffer.pos(matrix4f, 1.0f, 0.0f, 0.0f).normal(matrix3f, 0.0f, 0.0f, 1.0f).tex(minU, maxV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            this.buffer.pos(matrix4f, 1.0f, 1.0f, 0.0f).normal(matrix3f, 0.0f, 0.0f, 1.0f).tex(minU, minV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            this.buffer.pos(matrix4f, 0.0f, 1.0f, 0.0f).normal(matrix3f, 0.0f, 0.0f, 1.0f).tex(maxU, minV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            this.buffer.pos(matrix4f, 0.0f, 1.0f, -1.0f).normal(matrix3f, 0.0f, 0.0f, -1.0f).tex(maxU, minV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            this.buffer.pos(matrix4f, 1.0f, 1.0f, -1.0f).normal(matrix3f, 0.0f, 0.0f, -1.0f).tex(minU, minV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            this.buffer.pos(matrix4f, 1.0f, 0.0f, -1.0f).normal(matrix3f, 0.0f, 0.0f, -1.0f).tex(minU, maxV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            this.buffer.pos(matrix4f, 0.0f, 0.0f, -1.0f).normal(matrix3f, 0.0f, 0.0f, -1.0f).tex(maxU, maxV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            float f5 = 0.5f * (maxU - minU) / (float)texWidth;
            float f6 = 0.5f * (maxV - minV) / (float)texHeight;
            for (k = 0; k < texWidth; ++k) {
                f7 = (float)k / (float)texWidth;
                f8 = maxU + (minU - maxU) * f7 - f5;
                this.buffer.pos(matrix4f, f7, 0.0f, -1.0f).normal(matrix3f, -1.0f, 0.0f, 0.0f).tex(f8, maxV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, f7, 0.0f, 0.0f).normal(matrix3f, -1.0f, 0.0f, 0.0f).tex(f8, maxV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, f7, 1.0f, 0.0f).normal(matrix3f, -1.0f, 0.0f, 0.0f).tex(f8, minV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, f7, 1.0f, -1.0f).normal(matrix3f, -1.0f, 0.0f, 0.0f).tex(f8, minV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            }
            for (k = 0; k < texWidth; ++k) {
                f7 = (float)k / (float)texWidth;
                f8 = maxU + (minU - maxU) * f7 - f5;
                f9 = f7 + 1.0f / (float)texWidth;
                this.buffer.pos(matrix4f, f9, 1.0f, -1.0f).normal(matrix3f, 1.0f, 0.0f, 0.0f).tex(f8, minV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, f9, 1.0f, 0.0f).normal(matrix3f, 1.0f, 0.0f, 0.0f).tex(f8, minV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, f9, 0.0f, 0.0f).normal(matrix3f, 1.0f, 0.0f, 0.0f).tex(f8, maxV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, f9, 0.0f, -1.0f).normal(matrix3f, 1.0f, 0.0f, 0.0f).tex(f8, maxV).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            }
            for (k = 0; k < texHeight; ++k) {
                f7 = (float)k / (float)texHeight;
                f8 = maxV + (minV - maxV) * f7 - f6;
                f9 = f7 + 1.0f / (float)texHeight;
                this.buffer.pos(matrix4f, 0.0f, f9, 0.0f).normal(matrix3f, 0.0f, 1.0f, 0.0f).tex(maxU, f8).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, 1.0f, f9, 0.0f).normal(matrix3f, 0.0f, 1.0f, 0.0f).tex(minU, f8).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, 1.0f, f9, -1.0f).normal(matrix3f, 0.0f, 1.0f, 0.0f).tex(minU, f8).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, 0.0f, f9, -1.0f).normal(matrix3f, 0.0f, 1.0f, 0.0f).tex(maxU, f8).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            }
            for (k = 0; k < texHeight; ++k) {
                f7 = (float)k / (float)texHeight;
                f8 = maxV + (minV - maxV) * f7 - f6;
                this.buffer.pos(matrix4f, 1.0f, f7, 0.0f).normal(matrix3f, 0.0f, -1.0f, 0.0f).tex(minU, f8).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, 0.0f, f7, 0.0f).normal(matrix3f, 0.0f, -1.0f, 0.0f).tex(maxU, f8).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, 0.0f, f7, -1.0f).normal(matrix3f, 0.0f, -1.0f, 0.0f).tex(maxU, f8).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
                this.buffer.pos(matrix4f, 1.0f, f7, -1.0f).normal(matrix3f, 0.0f, -1.0f, 0.0f).tex(minU, f8).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            }
        }

        @Override
        public void draw(MatrixStack matrixStackIn, VertexBuffer bufferIn, float red, float green, float blue, float alpha) {
            this.buffer.draw(matrixStackIn, bufferIn, red, green, blue, alpha);
        }

        @Override
        public RenderMode getLayer() {
            return RenderMode.NORMAL;
        }

        @Override
        public void free() {
        }
    }
}

