/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.definition;

import com.tom.cpm.shared.editor.actions.Action;
import java.util.Map;

public abstract class MapAction<K, V>
extends Action {
    private Map<K, V> map;
    private K key;
    private V value;
    private V oldValue;

    public MapAction(Map<K, V> map, K key, V value) {
        this.map = map;
        this.key = key;
        this.value = value;
    }

    public static <K, V> MapAction<K, V> add(Map<K, V> map, K key, V value) {
        return new Add<K, V>(map, key, value);
    }

    public static <K, V> MapAction<K, V> remove(Map<K, V> map, K key, V value) {
        return new Remove<K, V>(map, key, value);
    }

    protected void add() {
        this.oldValue = this.map.put(this.key, this.value);
    }

    protected void remove() {
        if (this.oldValue != null) {
            this.map.put(this.key, this.oldValue);
            this.oldValue = null;
        } else {
            this.map.remove(this.key);
        }
    }

    private static class Add<K, V>
    extends MapAction<K, V> {
        public Add(Map<K, V> map, K key, V value) {
            super(map, key, value);
        }

        @Override
        public void undo() {
            this.remove();
        }

        @Override
        public void run() {
            this.add();
        }
    }

    private static class Remove<K, V>
    extends MapAction<K, V> {
        public Remove(Map<K, V> map, K key, V value) {
            super(map, key, value);
        }

        @Override
        public void undo() {
            this.add();
        }

        @Override
        public void run() {
            this.remove();
        }
    }
}

