/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IGui$$Lambda$1;
import com.tom.cpl.gui.IGui$$Lambda$2;
import com.tom.cpl.gui.IGui$$Lambda$3;
import com.tom.cpl.gui.IGui$$Lambda$4;
import com.tom.cpl.gui.UI;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpm.shared.util.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public class IGui$
implements UI {
    public static void drawBox(IGui this_, float x, float y, float w, float h, int color) {
        this_.drawBox((int)x, (int)y, (int)w, (int)h, color);
    }

    public static void executeLater(IGui this_, Runnable r) {
        MinecraftClientAccess$.get().executeOnGameThread(IGui$$Lambda$1.lambdaFactory$(r));
    }

    public static void pushMatrix(IGui this_) {
        this_.getStack().push();
    }

    public static void setPosOffset(IGui this_, Box box) {
        IGui.Ctx current = this_.getContext();
        current.cutBox = current.cutBox.intersect(new Box(current.off.x + box.x, current.off.y + box.y, box.w, box.h));
        current.cutBox.w = Math.max(current.cutBox.w, 0);
        current.cutBox.h = Math.max(current.cutBox.h, 0);
        current.off = new Vec2i(current.off.x + box.x, current.off.y + box.y);
    }

    public static void popMatrix(IGui this_) {
        this_.getStack().pop();
    }

    public static IGui.Ctx getContext(IGui this_) {
        return IGui.CtxStack.access$000(this_.getStack());
    }

    public static Vec2i getOffset(IGui this_) {
        return IGui.CtxStack.access$000((IGui.CtxStack)this_.getStack()).off;
    }

    public static void drawRectangle(IGui this_, int x, int y, int w, int h, int color) {
        this_.drawBox(x, y, w, 1, color);
        this_.drawBox(x, y, 1, h, color);
        this_.drawBox(x, y + h - 1, w, 1, color);
        this_.drawBox(x + w - 1, y, 1, h, color);
    }

    public static void drawRectangle(IGui this_, float x, float y, float w, float h, int color) {
        this_.drawBox(x, y, w, 1.0f, color);
        this_.drawBox(x, y, 1.0f, h, color);
        this_.drawBox(x, y + h - 1.0f, w, 1.0f, color);
        this_.drawBox(x + w - 1.0f, y, 1.0f, h, color);
    }

    public static void onGuiException(IGui this_, String msg, Throwable e, boolean fatal) {
        Log.error(msg, e);
        ErrorLog.addLog(ErrorLog.LogLevel.ERROR, msg, e);
        if (fatal) {
            Frame frm = this_.getFrame();
            if (frm != null) {
                try {
                    frm.onCrashed(msg, e);
                }
                catch (Throwable ex) {
                }
            }
            this_.displayError(msg + ": " + e.toString());
        } else {
            Frame frm = this_.getFrame();
            if (frm != null) {
                try {
                    frm.logMessage(msg + ": " + e.toString());
                }
                catch (Throwable ex) {
                    this_.onGuiException(msg, e, true);
                }
            } else {
                this_.displayError(msg + "\n" + e.toString());
            }
        }
    }

    public static String wordWrap(IGui this_, String in, int w) {
        return IGui$.wordWrap(in, w, IGui$$Lambda$2.lambdaFactory$(this_));
    }

    public static String wordWrap(String in, int w, ToIntFunction<String> width) {
        ArrayList<String> text = new ArrayList<String>();
        int splitStart = 0;
        int space = -1;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == ' ' || c == '\\') {
                String s = in.substring(splitStart, i);
                int lw = width.applyAsInt(s);
                if (lw > w) {
                    if (splitStart == space + 1) {
                        text.add(s);
                        splitStart = i + 1;
                    } else {
                        text.add(in.substring(splitStart, space));
                        splitStart = space + 1;
                    }
                }
                space = i;
            }
            if (c != '\\') continue;
            text.add(in.substring(splitStart, i));
            splitStart = i + 1;
        }
        text.add(in.substring(splitStart, in.length()));
        return text.stream().collect(Collectors.joining("\\"));
    }

    public static void drawText(IGui this_, int x, int y, String text, int bgColor, int color) {
        this_.drawBox(x, y, this_.textWidth(text), 10, bgColor);
        this_.drawText(x, y + 1, text, color);
    }

    public static boolean canScaleVanilla(IGui this_) {
        return true;
    }

    public static void openURL(IGui this_, String url) {
        try {
            URI uri = new URI(url);
            String s = uri.getScheme();
            if (s == null) {
                throw new URISyntaxException(url, "Missing protocol");
            }
            if (!IGui.ALLOWED_PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(url, "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
            }
            ConfirmPopup p = new ConfirmPopup(this_.getFrame(), this_.i18nFormat("label.cpm.openURL.title", new Object[0]), this_.i18nFormat("label.cpm.openURL.text", url), IGui$$Lambda$3.lambdaFactory$(this_, url), null);
            GuiElement cancel = p.getElements().remove(p.getElements().size() - 1);
            String c = this_.i18nFormat("button.cpm.copy", new Object[0]);
            Button copy = new Button(this_, c, IGui$$Lambda$4.lambdaFactory$(this_, url, p));
            copy.setBounds(new Box(cancel.getBounds().x, cancel.getBounds().y, 25 + this_.textWidth(c), 20));
            cancel.setBounds(new Box(cancel.getBounds().x + copy.getBounds().w + 5, cancel.getBounds().y, cancel.getBounds().w, cancel.getBounds().h));
            p.addElement(copy);
            p.addElement(cancel);
            this_.getFrame().openPopup(p);
        }
        catch (URISyntaxException urisyntaxexception) {
            Log.error("Can't open url for " + url, urisyntaxexception);
        }
    }

    public static Object getNativeGui(IGui this_) {
        return this_;
    }

    public static void displayMessagePopup(IGui this_, String title, String text, String closeBtn) {
        this_.getFrame().openPopup(new MessagePopup(this_.getFrame(), title, text, closeBtn));
    }

    public static void displayPopup(IGui this_, Function factory) {
        this_.getFrame().openPopup((PopupPanel)factory.apply(this_.getFrame()));
    }

    public static void displayConfirm(IGui this_, String title, String msg, Runnable ok, Runnable cancel, String okTxt, String cancelTxt) {
        this_.getFrame().openPopup(new ConfirmPopup(this_.getFrame(), title, msg, ok, cancel, okTxt, cancelTxt));
    }

    static /* synthetic */ void lambda$openURL$2(IGui this_, String url, ConfirmPopup p) {
        this_.setClipboardText(url);
        p.close();
    }

    static /* synthetic */ void lambda$openURL$1(IGui this_, String url) {
        this_.openURL0(url);
    }

    static /* synthetic */ void lambda$executeLater$0(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable e) {
            Log.error("Exception while executing task", e);
            ErrorLog.addLog(ErrorLog.LogLevel.ERROR, "Exception while executing task", e);
        }
    }
}

