/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.function.FloatUnaryOperator;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.ComboSlider$$Lambda$1;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.math.Box;
import java.util.function.Function;

public class ComboSlider
extends Slider {
    private Spinner spinner;
    private Function<Float, String> valueToString;
    private FloatUnaryOperator value;
    private FloatUnaryOperator normalize;

    public ComboSlider(IGui gui, Function<Float, String> valueToString, FloatUnaryOperator value, FloatUnaryOperator normalize) {
        super(gui, valueToString.apply(Float.valueOf(0.0f)));
        this.valueToString = valueToString;
        this.value = value;
        this.normalize = normalize;
        this.spinner = new Spinner(gui);
        this.spinner.addChangeListener(ComboSlider$$Lambda$1.lambdaFactory$(this));
        this.spinner.visible = false;
    }

    private void updateSpinner() {
        float max = this.value.apply(1.0f);
        if (this.spinner.getValue() > max) {
            this.spinner.setValue(max);
        }
        float min = this.value.apply(0.0f);
        if (this.spinner.getValue() < min) {
            this.spinner.setValue(min);
        }
        this.setValue0(this.normalize.apply(this.spinner.getValue()));
        this.onAction();
    }

    public void setActualValue(float v) {
        this.setValue0(this.normalize.apply(v));
        this.spinner.setValue(v);
    }

    @Override
    public void setValue(float v) {
        this.setValue0(v);
        this.spinner.setValue(this.value.apply(v));
    }

    private void setValue0(float v) {
        super.setValue(v);
        this.setText(this.valueToString.apply(Float.valueOf(this.getActualValue())));
    }

    public float getActualValue() {
        return this.value.apply(this.getValue());
    }

    @Override
    protected void onAction() {
        this.setText(this.valueToString.apply(Float.valueOf(this.getActualValue())));
        super.onAction();
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (this.spinner.visible) {
            this.spinner.mouseClick(event);
        }
        if (event.isHovered(this.bounds)) {
            if (event.btn == 1) {
                this.spinner.setValue(this.getActualValue());
                if (this.bounds.y < 30) {
                    this.spinner.setBounds(new Box(this.bounds.x + this.bounds.w / 2, this.bounds.y + this.bounds.h - 20, this.bounds.w / 2, 20));
                } else {
                    this.spinner.setBounds(new Box(this.bounds.x, this.bounds.y + this.bounds.h - 20, this.bounds.w, 20));
                }
                this.spinner.visible = true;
                event.consume();
            }
        } else if (!event.isConsumed() && this.spinner.visible) {
            this.hideSpinner();
            event.consume();
        }
        super.mouseClick(event);
    }

    @Override
    public void mouseRelease(MouseEvent event) {
        if (this.spinner.visible) {
            this.spinner.mouseRelease(event);
        }
        super.mouseRelease(event);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (this.spinner.visible) {
            if (event.keyCode == this.gui.getKeyCodes().KEY_ESCAPE) {
                this.hideSpinner();
                event.consume();
            } else {
                this.spinner.keyPressed(event);
            }
        }
    }

    public void hideSpinner() {
        if (this.spinner.visible) {
            this.spinner.visible = false;
            this.setActualValue(this.spinner.getValue());
            this.onAction();
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        if (this.spinner.visible) {
            if (this.bounds.y < 30) {
                this.gui.drawText(this.bounds.x, this.bounds.y + this.bounds.h / 2 - 4, this.name, this.gui.getColors().button_text_color);
            } else {
                this.gui.drawText(this.bounds.x, this.bounds.y, this.name, this.gui.getColors().button_text_color);
            }
            this.spinner.draw(event, partialTicks);
        } else {
            super.draw(event, partialTicks);
        }
    }

    public Spinner getSpinner() {
        return this.spinner;
    }

    static /* synthetic */ void access$lambda$0(ComboSlider comboSlider) {
        comboSlider.updateSpinner();
    }
}

