/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.DropDownBox$$Lambda$1;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.math.Vec2i;
import java.util.List;

public class DropDownBox<T>
extends GuiElement {
    private List<T> values;
    private int selectedId = -1;
    private Frame frm;
    protected Runnable action;

    public DropDownBox(Frame frm, List<T> values) {
        super(frm.getGui());
        this.frm = frm;
        this.values = values;
        if (!values.isEmpty()) {
            this.selectedId = 0;
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        String v = this.values.size() > this.selectedId && this.selectedId >= 0 ? String.valueOf(this.values.get(this.selectedId)) : this.gui.i18nFormat("label.cpm.no_elements", new Object[0]);
        int w = this.gui.textWidth(v);
        int bgColor = this.gui.getColors().button_fill;
        int color = this.gui.getColors().button_text_color;
        if (!this.enabled) {
            color = this.gui.getColors().button_text_disabled;
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
            bgColor = this.gui.getColors().button_hover;
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
        this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 - 4, v, color);
        this.gui.drawTexture(this.bounds.x + this.bounds.w - 10, this.bounds.y + this.bounds.h / 2 - 4, 8, 8, 0, 8, "editor");
    }

    @Override
    public void mouseClick(MouseEvent evt) {
        if (this.enabled && evt.isInBounds(this.bounds) && !evt.isConsumed()) {
            PopupMenu pmenu = new PopupMenu(this.gui, this.frm);
            for (T t : this.values) {
                pmenu.addButton(String.valueOf(t), DropDownBox$$Lambda$1.lambdaFactory$(this, t));
            }
            if (this.values.isEmpty()) {
                pmenu.addButton(this.gui.i18nFormat("label.cpm.no_elements", new Object[0]), null).setEnabled(false);
            }
            Vec2i p = evt.getPos();
            pmenu.display(p.x - evt.x + this.bounds.x, p.y - evt.y + this.bounds.h + this.bounds.y, this.bounds.w);
            evt.consume();
        }
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    public void setSelected(T sel) {
        this.selectedId = this.values.indexOf(sel);
    }

    public T getSelected() {
        return this.values.size() > this.selectedId && this.selectedId >= 0 ? (T)this.values.get(this.selectedId) : null;
    }

    static /* synthetic */ void lambda$mouseClick$0(DropDownBox this_, Object t) {
        this_.setSelected(t);
        if (this_.action != null) {
            this_.action.run();
        }
    }
}

