/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupMenu$$Lambda$1;
import com.tom.cpl.gui.elements.PopupMenu$$Lambda$2;
import com.tom.cpl.gui.elements.PopupMenu$$Lambda$3;
import com.tom.cpl.gui.elements.PopupMenu$$Lambda$4;
import com.tom.cpl.gui.elements.PopupMenu$$Lambda$5;
import com.tom.cpl.gui.elements.PopupMenu$$Lambda$6;
import com.tom.cpl.gui.elements.PopupMenu$$Lambda$7;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.math.Box;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class PopupMenu
extends PopupPanel {
    private int x;
    private int y;
    private Frame frame;
    private ScrollPanel scroll;
    private Panel panel;

    public PopupMenu(IGui gui, Frame frm) {
        super(gui);
        this.frame = frm;
        this.scroll = new ScrollPanel(gui);
        this.panel = new Panel(gui);
        this.scroll.setDisplay(this.panel);
        this.addElement(this.scroll);
    }

    public Button addButton(String name, Runnable r) {
        Button btn = new Button(this.gui, name, PopupMenu$$Lambda$1.lambdaFactory$(this, r));
        btn.setBounds(new Box(0, this.panel.elements.size() * 20, 80, 20));
        this.panel.addElement(btn);
        return btn;
    }

    public Button addMenuButton(String name, PopupMenu menu) {
        int y = this.panel.elements.size() * 20;
        Button btn = new Button(this.gui, name, null);
        btn.setAction(PopupMenu$$Lambda$2.lambdaFactory$(this, menu, y));
        btn.setBounds(new Box(0, y, 80, 20));
        this.panel.addElement(btn);
        return btn;
    }

    public Button addMenuButton(String name, Supplier<PopupMenu> menuIn) {
        int y = this.panel.elements.size() * 20;
        Button btn = new Button(this.gui, name, null);
        btn.setAction(PopupMenu$$Lambda$3.lambdaFactory$(this, menuIn, y));
        btn.setBounds(new Box(0, y, 80, 20));
        this.panel.addElement(btn);
        return btn;
    }

    public Checkbox addCheckbox(String name, Runnable r) {
        Checkbox box = new Checkbox(this.gui, name);
        box.setAction(PopupMenu$$Lambda$4.lambdaFactory$(this, r));
        box.setBounds(new Box(0, this.panel.elements.size() * 20, 80, 20));
        this.panel.addElement(box);
        return box;
    }

    public Checkbox addCheckbox(String name, Consumer<Checkbox> r) {
        Checkbox box = new Checkbox(this.gui, name);
        box.setAction(PopupMenu$$Lambda$5.lambdaFactory$(this, r, box));
        box.setBounds(new Box(0, this.panel.elements.size() * 20, 80, 20));
        this.panel.addElement(box);
        return box;
    }

    public void add(GuiElement elem) {
        if (elem.bounds == null) {
            elem.bounds = new Box(0, 0, 0, 0);
        }
        elem.setBounds(new Box(elem.bounds.x, elem.bounds.y + this.panel.elements.size() * 20, 80, 20));
        this.panel.addElement(elem);
    }

    public void display(int x, int y) {
        this.display(x, y, 80);
    }

    public void display(int x, int y, int w) {
        this.x = x;
        this.y = y;
        for (GuiElement elem : this.panel.elements) {
            if (elem instanceof Button) {
                w = Math.max(w, this.gui.textWidth(((Button)elem).getText()) + 20);
                continue;
            }
            if (!(elem instanceof Checkbox)) continue;
            w = Math.max(w, this.gui.textWidth(((Checkbox)elem).getText()) + 30);
        }
        for (GuiElement elem : this.panel.elements) {
            Box b = elem.getBounds();
            elem.setBounds(new Box(b.x, b.y, w, b.h));
        }
        int h = this.panel.elements.size() * 20;
        int ph = Math.min(h, this.frame.getBounds().h - y);
        this.panel.setBounds(new Box(0, 0, w, h));
        Box fb = this.frame.getBounds();
        this.setBounds(new Box(Math.min(x, fb.w - w), Math.min(y, fb.h - ph), w, ph));
        this.scroll.setBounds(new Box(0, 0, w, ph));
        this.frame.openPopup(this);
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (!event.isConsumed() && !event.isInBounds(this.bounds)) {
            this.close();
        }
        super.mouseClick(event);
    }

    @Override
    public boolean hasDecoration() {
        return false;
    }

    public int getY() {
        return this.panel.elements.size() * 20;
    }

    static /* synthetic */ void lambda$addCheckbox$4(PopupMenu this_, Consumer r, Checkbox box) {
        r.accept(box);
        this_.close();
    }

    static /* synthetic */ void lambda$addCheckbox$3(PopupMenu this_, Runnable r) {
        r.run();
        this_.close();
    }

    static /* synthetic */ void lambda$addMenuButton$2(PopupMenu this_, Supplier menuIn, int y) {
        PopupMenu menu = (PopupMenu)menuIn.get();
        menu.display(this_.x + this_.getBounds().w, this_.y + y - this_.scroll.getScrollY());
        menu.setOnClosed(PopupMenu$$Lambda$6.lambdaFactory$(this_));
    }

    static /* synthetic */ void lambda$addMenuButton$1(PopupMenu this_, PopupMenu menu, int y) {
        menu.display(this_.x + this_.getBounds().w, this_.y + y - this_.scroll.getScrollY());
        menu.setOnClosed(PopupMenu$$Lambda$7.lambdaFactory$(this_));
    }

    static /* synthetic */ void lambda$addButton$0(PopupMenu this_, Runnable r) {
        r.run();
        this_.close();
    }
}

