/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ProcessPopup$$Lambda$1;
import com.tom.cpl.gui.elements.ProcessPopup$$Lambda$2;
import com.tom.cpl.gui.elements.ProcessPopup$$Lambda$3;
import com.tom.cpl.gui.elements.ProcessPopup$$Lambda$4;
import com.tom.cpl.gui.elements.ProcessPopup$$Lambda$5;
import com.tom.cpl.gui.elements.ProcessPopup$$Lambda$6;
import com.tom.cpl.gui.elements.ProcessPopup$$Lambda$7;
import com.tom.cpl.gui.elements.ProcessPopup$$Lambda$8;
import com.tom.cpl.gui.elements.ProcessPopup$$Lambda$9;
import com.tom.cpl.math.Box;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class ProcessPopup<R>
extends PopupPanel
implements Runnable {
    protected String title;
    protected Thread processThread;
    protected final Frame frame;
    protected AtomicBoolean cancelled;
    protected Callable<R> function;
    protected Consumer<R> finished;
    protected Consumer<Throwable> error;
    protected Button cancel;

    public ProcessPopup(Frame frame, String title, String text, Callable<R> function, CompletableFuture<R> cf) {
        CompletableFuture<R> completableFuture = cf;
        completableFuture.getClass();
        Consumer consumer = ProcessPopup$$Lambda$1.lambdaFactory$(completableFuture);
        CompletableFuture<R> completableFuture2 = cf;
        completableFuture2.getClass();
        this(frame, title, text, function, consumer, ProcessPopup$$Lambda$2.lambdaFactory$(completableFuture2));
    }

    public ProcessPopup(Frame frame, String title, String text, Callable<R> function, Consumer<R> finished, Consumer<Throwable> error) {
        this(frame);
        this.title = title;
        this.function = function;
        this.finished = finished;
        this.error = error;
        this.setupLabels(text);
    }

    protected ProcessPopup(Frame frame) {
        super(frame.getGui());
        this.cancelled = new AtomicBoolean();
        this.frame = frame;
        this.cancel = new Button(this.gui, this.gui.i18nFormat("button.cpm.cancel", new Object[0]), ProcessPopup$$Lambda$3.lambdaFactory$(this));
        this.addElement(this.cancel);
        this.processThread = new Thread((Runnable)this, "CPM Process Thread");
        this.processThread.setDaemon(true);
    }

    protected List<GuiElement> setupLabels(String text) {
        int w;
        int i;
        ArrayList<GuiElement> labels = new ArrayList<GuiElement>();
        String[] lines = text.split("\\\\");
        int wm = 180;
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            if (w <= wm) continue;
            wm = w;
        }
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            labels.add(this.addElement(new Label(this.gui, lines[i]).setBounds(new Box(wm / 2 - w / 2 + 10, 15 + i * 10, 0, 0))));
        }
        this.setBounds(new Box(0, 0, wm + 20, 55 + lines.length * 10));
        this.cancel.setBounds(new Box(wm / 2 - 10, 30 + lines.length * 10, 40, 20));
        return labels;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void start() {
        this.processThread.start();
        this.frame.openPopup(this);
    }

    @Override
    public void run() {
        try {
            R r = this.function.call();
            if (!this.cancelled.get()) {
                this.gui.executeLater(ProcessPopup$$Lambda$4.lambdaFactory$(this, r));
            } else {
                this.gui.executeLater(ProcessPopup$$Lambda$5.lambdaFactory$(this));
            }
            this.gui.executeLater(ProcessPopup$$Lambda$6.lambdaFactory$(this));
        }
        catch (Throwable e) {
            try {
                if (!this.cancelled.get()) {
                    this.gui.executeLater(ProcessPopup$$Lambda$7.lambdaFactory$(this, e));
                }
                this.gui.executeLater(ProcessPopup$$Lambda$8.lambdaFactory$(this));
            }
            catch (Throwable throwable) {
                this.gui.executeLater(ProcessPopup$$Lambda$9.lambdaFactory$(this));
                throw throwable;
            }
        }
    }

    static /* synthetic */ void lambda$run$3(ProcessPopup this_, Throwable e) {
        this_.error.accept(e);
    }

    static /* synthetic */ void lambda$run$2(ProcessPopup this_) {
        this_.error.accept(new InterruptedException());
    }

    static /* synthetic */ void lambda$run$1(ProcessPopup this_, Object r) {
        this_.finished.accept(r);
    }

    static /* synthetic */ void lambda$new$0(ProcessPopup this_) {
        this_.cancelled.set(true);
        this_.processThread.interrupt();
    }
}

