/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.util.StackTooltip;
import com.tom.cpl.item.Stack;
import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.MinecraftClientAccess$;
import java.util.Arrays;
import java.util.List;

public class StackTagSlot
extends GuiElement {
    private TagManager<Stack> mngr;
    private int index;
    private long lastInc;
    private List<Stack> stacks;

    public StackTagSlot(IGui gui, TagManager<Stack> mngr, String elem) {
        super(gui);
        this.mngr = mngr;
        this.stacks = mngr.listStacks(Arrays.asList(elem));
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        if (this.stacks.isEmpty()) {
            this.gui.drawTexture(this.bounds.x, this.bounds.y, 16, 16, 64, 0, "editor");
            return;
        }
        long ticks = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine().getTime();
        if (this.lastInc + 1000L < ticks && this.stacks.size() > 1) {
            this.lastInc = ticks;
            this.index = (this.index + 1) % this.stacks.size();
        }
        Stack st = this.stacks.get(this.index);
        this.gui.drawStack(this.bounds.x, this.bounds.y, st);
        if (event.isHovered(this.bounds)) {
            new StackTooltip(this.gui.getFrame(), st).set();
        }
    }

    public void setStacks(String elem) {
        this.stacks = this.mngr.listStacks(Arrays.asList(elem));
        this.index = 0;
    }
}

