/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.render.VertexBuffer$;

public abstract class DirectBuffer<B>
implements VertexBuffer {
    protected B buffer;
    private float x;
    private float y;
    private float z;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private float u;
    private float v;
    private float nx;
    private float ny;
    private float nz;

    public DirectBuffer(B buffer) {
        this.buffer = buffer;
    }

    @Override
    public VertexBuffer pos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @Override
    public VertexBuffer color(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    @Override
    public VertexBuffer tex(float u, float v) {
        this.u = u;
        this.v = v;
        return this;
    }

    @Override
    public VertexBuffer normal(float x, float y, float z) {
        this.nx = x;
        this.ny = y;
        this.nz = z;
        return this;
    }

    @Override
    public void endVertex() {
        this.pushVertex(this.x, this.y, this.z, this.red, this.green, this.blue, this.alpha, this.u, this.v, this.nx, this.ny, this.nz);
    }

    protected abstract void pushVertex(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12);

    @Override
    public abstract void finish();

    @Override
    public void addVertex(MatrixStack.Entry entry, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        VertexBuffer$.addVertex(this, entry, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    @Override
    public void addVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        VertexBuffer$.addVertex(this, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    @Override
    public VertexBuffer normal(Mat3f mat3f, float f, float f2, float f3) {
        return VertexBuffer$.normal(this, mat3f, f, f2, f3);
    }

    @Override
    public VertexBuffer pos(Mat4f mat4f, float f, float f2, float f3) {
        return VertexBuffer$.pos(this, mat4f, f, f2, f3);
    }

    @Override
    public VertexBuffer color(int n) {
        return VertexBuffer$.color(this, n);
    }
}

