/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.render.VertexBuffer$;

public class DualBuffer
implements VertexBuffer {
    private VertexBuffer first;
    private VertexBuffer second;

    public DualBuffer(VertexBuffer first, VertexBuffer second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public VertexBuffer pos(float x, float y, float z) {
        this.first.pos(x, y, z);
        this.second.pos(x, y, z);
        return this;
    }

    @Override
    public VertexBuffer tex(float u, float v) {
        this.first.tex(u, v);
        this.second.tex(u, v);
        return this;
    }

    @Override
    public VertexBuffer color(float red, float green, float blue, float alpha) {
        this.first.color(red, green, blue, alpha);
        this.second.color(red, green, blue, alpha);
        return this;
    }

    @Override
    public VertexBuffer normal(float x, float y, float z) {
        this.first.normal(x, y, z);
        this.second.normal(x, y, z);
        return this;
    }

    @Override
    public void endVertex() {
        this.first.endVertex();
        this.second.endVertex();
    }

    @Override
    public void finish() {
        this.first.finish();
        this.second.finish();
    }

    @Override
    public void addVertex(MatrixStack.Entry entry, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        VertexBuffer$.addVertex(this, entry, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    @Override
    public void addVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        VertexBuffer$.addVertex(this, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    @Override
    public VertexBuffer pos(Mat4f mat4f, float f, float f2, float f3) {
        return VertexBuffer$.pos(this, mat4f, f, f2, f3);
    }

    @Override
    public VertexBuffer normal(Mat3f mat3f, float f, float f2, float f3) {
        return VertexBuffer$.normal(this, mat3f, f, f2, f3);
    }

    @Override
    public VertexBuffer color(int n) {
        return VertexBuffer$.color(this, n);
    }
}

