/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.render.VertexBuffer$;
import java.util.ArrayList;
import java.util.List;

public class ListBuffer
implements VertexBuffer {
    private List<Entry> toReplay = new ArrayList<Entry>();
    private Entry entry = new Entry();

    @Override
    public VertexBuffer pos(float x, float y, float z) {
        this.entry.x = x;
        this.entry.y = y;
        this.entry.z = z;
        return this;
    }

    @Override
    public VertexBuffer color(float red, float green, float blue, float alpha) {
        this.entry.red = red;
        this.entry.green = green;
        this.entry.blue = blue;
        this.entry.alpha = alpha;
        return this;
    }

    @Override
    public VertexBuffer tex(float u, float v) {
        this.entry.u = u;
        this.entry.v = v;
        return this;
    }

    @Override
    public VertexBuffer normal(float x, float y, float z) {
        this.entry.nx = x;
        this.entry.ny = y;
        this.entry.nz = z;
        return this;
    }

    @Override
    public void endVertex() {
        this.toReplay.add(this.entry);
        this.entry = new Entry();
    }

    @Override
    public void finish() {
    }

    public void draw(MatrixStack stack, VertexBuffer buf) {
        if (!this.toReplay.isEmpty()) {
            for (Entry entry : this.toReplay) {
                entry.replay(stack, buf);
            }
        }
    }

    public void draw(MatrixStack stack, VertexBuffer buf, float red, float green, float blue, float alpha) {
        if (!this.toReplay.isEmpty()) {
            for (Entry entry : this.toReplay) {
                entry.replay(stack, buf, red, green, blue, alpha);
            }
        }
    }

    public void draw(VertexBuffer buf) {
        if (!this.toReplay.isEmpty()) {
            for (Entry entry : this.toReplay) {
                entry.replay(buf);
            }
        }
    }

    public void draw(VertexBuffer buf, float red, float green, float blue, float alpha) {
        if (!this.toReplay.isEmpty()) {
            for (Entry entry : this.toReplay) {
                entry.replay(buf, red, green, blue, alpha);
            }
        }
    }

    @Override
    public void addVertex(MatrixStack.Entry entry, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        VertexBuffer$.addVertex(this, entry, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    @Override
    public void addVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        VertexBuffer$.addVertex(this, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    @Override
    public VertexBuffer normal(Mat3f mat3f, float f, float f2, float f3) {
        return VertexBuffer$.normal(this, mat3f, f, f2, f3);
    }

    @Override
    public VertexBuffer pos(Mat4f mat4f, float f, float f2, float f3) {
        return VertexBuffer$.pos(this, mat4f, f, f2, f3);
    }

    @Override
    public VertexBuffer color(int n) {
        return VertexBuffer$.color(this, n);
    }

    private static class Entry {
        private float x;
        private float y;
        private float z;
        private float red;
        private float green;
        private float blue;
        private float alpha;
        private float u;
        private float v;
        private float nx;
        private float ny;
        private float nz;

        private Entry() {
        }

        public void replay(MatrixStack stack, VertexBuffer parent) {
            parent.addVertex(stack.getLast(), this.x, this.y, this.z, this.red, this.green, this.blue, this.alpha, this.u, this.v, this.nx, this.ny, this.nz);
        }

        public void replay(MatrixStack stack, VertexBuffer parent, float red, float green, float blue, float alpha) {
            parent.addVertex(stack.getLast(), this.x, this.y, this.z, red, green, blue, alpha, this.u, this.v, this.nx, this.ny, this.nz);
        }

        public void replay(VertexBuffer parent) {
            parent.addVertex(this.x, this.y, this.z, this.red, this.green, this.blue, this.alpha, this.u, this.v, this.nx, this.ny, this.nz);
        }

        public void replay(VertexBuffer parent, float red, float green, float blue, float alpha) {
            parent.addVertex(this.x, this.y, this.z, red, green, blue, alpha, this.u, this.v, this.nx, this.ny, this.nz);
        }
    }
}

