/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.render.RenderTypeBuilder$$Lambda$1;
import com.tom.cpl.render.RenderTypeBuilder$$Lambda$2;
import com.tom.cpl.render.RenderTypeBuilder$$Lambda$3;
import com.tom.cpl.render.RenderTypeBuilder$$Lambda$4;
import com.tom.cpl.render.RenderTypeBuilder$$Lambda$5;
import com.tom.cpl.render.RenderTypeBuilder$$Lambda$6;
import com.tom.cpl.render.RenderTypeBuilder$$Lambda$7;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.retro.RetroGLAccess;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class RenderTypeBuilder<RL, RT> {
    private Map<RenderMode, Function<RL, RT>> modeFactories = new EnumMap<RenderMode, Function<RL, RT>>(RenderMode.class);
    private Map<RenderMode, Integer> renderLayers = new EnumMap<RenderMode, Integer>(RenderMode.class);
    private Supplier<RL> getDynamic;

    public void build(RenderTypes<RenderMode> renderTypes, TextureHandler<RL, RT> handler) {
        renderTypes.put(RenderMode.NORMAL, new VBuffers.NativeRenderType(0));
        for (Map.Entry<RenderMode, Function<RL, RT>> e : this.modeFactories.entrySet()) {
            int layer = this.renderLayers.get((Object)e.getKey());
            renderTypes.put((RenderMode)((Enum)e.getKey()), new VBuffers.NativeRenderType(e.getValue().apply(handler.getTexture()), layer));
        }
        renderTypes.put(RenderMode.DEFAULT, new VBuffers.NativeRenderType(handler.getRenderType(), 0));
    }

    public void build(RenderTypes<RenderMode> renderTypes, RL texture) {
        renderTypes.put(RenderMode.NORMAL, new VBuffers.NativeRenderType(0));
        for (Map.Entry<RenderMode, Function<RL, RT>> e : this.modeFactories.entrySet()) {
            int layer = this.renderLayers.get((Object)e.getKey());
            renderTypes.put((RenderMode)((Enum)e.getKey()), new VBuffers.NativeRenderType(e.getValue().apply(texture), layer));
        }
    }

    public void build(RenderTypes<RenderMode> renderTypes, TextureProvider texture) {
        if (this.getDynamic == null) {
            throw new IllegalStateException("Get dynamic is not initialized");
        }
        Object tex = null;
        if (texture != null) {
            texture.bind();
            tex = this.getDynamic.get();
        }
        renderTypes.put(RenderMode.NORMAL, new VBuffers.NativeRenderType(this.modeFactories.get((Object)RenderMode.DEFAULT).apply(tex), 0));
        for (Map.Entry<RenderMode, Function<RL, RT>> e : this.modeFactories.entrySet()) {
            int layer = this.renderLayers.get((Object)e.getKey());
            renderTypes.put((RenderMode)((Enum)e.getKey()), new VBuffers.NativeRenderType(e.getValue().apply(tex), layer));
        }
    }

    public static <RL> RenderTypeBuilder<RL, RetroGLAccess.RetroLayer> setupRetro(RetroGLAccess<RL> gl) {
        RenderTypeBuilder this0 = new RenderTypeBuilder();
        RetroGLAccess<RL> retroGLAccess = gl;
        retroGLAccess.getClass();
        this0.register(RenderMode.DEFAULT, RenderTypeBuilder$$Lambda$1.lambdaFactory$(retroGLAccess), 0);
        RetroGLAccess<RL> retroGLAccess2 = gl;
        retroGLAccess2.getClass();
        this0.register(RenderMode.GLOW, RenderTypeBuilder$$Lambda$2.lambdaFactory$(retroGLAccess2), 1);
        RetroGLAccess<RL> retroGLAccess3 = gl;
        retroGLAccess3.getClass();
        this0.register(RenderMode.COLOR, RenderTypeBuilder$$Lambda$3.lambdaFactory$(retroGLAccess3), 0);
        RetroGLAccess<RL> retroGLAccess4 = gl;
        retroGLAccess4.getClass();
        this0.register(RenderMode.COLOR_GLOW, RenderTypeBuilder$$Lambda$4.lambdaFactory$(retroGLAccess4), 1);
        RetroGLAccess<RL> retroGLAccess5 = gl;
        retroGLAccess5.getClass();
        this0.register(RenderMode.OUTLINE, RenderTypeBuilder$$Lambda$5.lambdaFactory$(retroGLAccess5), 2);
        RetroGLAccess<RL> retroGLAccess6 = gl;
        retroGLAccess6.getClass();
        this0.getDynamic = RenderTypeBuilder$$Lambda$6.lambdaFactory$(retroGLAccess6);
        return this0;
    }

    public RenderTypeBuilder<RL, RT> register(RenderMode mode, Function<RL, RT> factory, int layer) {
        if (mode == RenderMode.NORMAL) {
            throw new IllegalArgumentException("Can't init built-in layer");
        }
        this.modeFactories.put(mode, factory);
        this.renderLayers.put(mode, layer);
        return this;
    }

    public RenderTypeBuilder<RL, RT> register(RenderMode mode, Supplier<RT> factory, int layer) {
        if (mode == RenderMode.NORMAL) {
            throw new IllegalArgumentException("Can't init built-in layer");
        }
        this.modeFactories.put(mode, RenderTypeBuilder$$Lambda$7.lambdaFactory$(factory));
        this.renderLayers.put(mode, layer);
        return this;
    }

    static /* synthetic */ Object lambda$register$0(Supplier factory, Object __) {
        return factory.get();
    }

    public static interface TextureHandler<RL, RT> {
        public RL getTexture();

        public void setTexture(RL var1);

        public RT getRenderType();
    }
}

