/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.render.RecordBuffer;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.ReplayBuffer;
import com.tom.cpl.render.TransformedBuffer;
import com.tom.cpl.render.VBuffers$$Lambda$1;
import com.tom.cpl.render.VBuffers$$Lambda$2;
import com.tom.cpl.render.VBuffers$$Lambda$3;
import com.tom.cpl.render.VBuffers$$Lambda$4;
import com.tom.cpl.render.VBuffers$$Lambda$5;
import com.tom.cpl.render.VBuffers$$Lambda$6;
import com.tom.cpl.render.VBuffers$$Lambda$7;
import com.tom.cpl.render.VBuffers$$Lambda$8;
import com.tom.cpl.render.VBuffers$$Lambda$9;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.render.VertexBuffer$;
import com.tom.cpl.render.WrappedBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class VBuffers {
    private Function<NativeRenderType, VertexBuffer> bufferFactory;
    private Map<NativeRenderType, VertexBuffer> buffers = new HashMap<NativeRenderType, VertexBuffer>();
    private VertexBuffer normalBuffer;
    private boolean batched;

    public VBuffers(Function<NativeRenderType, VertexBuffer> bufferFactory, VertexBuffer normalBuffer) {
        this.bufferFactory = bufferFactory;
        this.normalBuffer = normalBuffer;
    }

    public VBuffers(Function<NativeRenderType, VertexBuffer> bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    public VertexBuffer getBuffer(NativeRenderType type) {
        if (type == NativeRenderType.DISABLE) {
            return VertexBuffer.NULL;
        }
        if (type.nativeType == null && this.normalBuffer != null) {
            this.buffers.put(type, this.normalBuffer);
            return new VBuf(this.normalBuffer, this, type);
        }
        return new VBuf(this.buffers.computeIfAbsent(type, this.bufferFactory), this, type);
    }

    public <E extends Enum<E>> VertexBuffer getBuffer(RenderTypes<E> types, E type) {
        return this.getBuffer(types.get(type));
    }

    public void finish(NativeRenderType type) {
        VertexBuffer buf = this.buffers.remove(type);
        if (buf != null) {
            buf.finish();
        }
    }

    public void finishAll() {
        ArrayList<NativeRenderType> rts = new ArrayList<NativeRenderType>(this.buffers.keySet());
        rts.sort(VBuffers$$Lambda$1.lambdaFactory$());
        rts.forEach(VBuffers$$Lambda$2.lambdaFactory$(this));
        this.buffers.clear();
    }

    public VBuffers replay() {
        return new VBuffers(VBuffers$$Lambda$3.lambdaFactory$(this), this.normalBuffer).setBatched(true);
    }

    public VBuffers normal(VertexBuffer normal) {
        return new VBuffers(VBuffers$$Lambda$4.lambdaFactory$(this), normal).setBatched(this.batched);
    }

    public VBuffers map(UnaryOperator<VertexBuffer> map) {
        return new VBuffers(VBuffers$$Lambda$5.lambdaFactory$(this, map), this.normalBuffer != null ? (VertexBuffer)map.apply(this.normalBuffer) : null).setBatched(this.batched);
    }

    public VBuffers map(BiFunction<NativeRenderType, VertexBuffer, VertexBuffer> map) {
        return new VBuffers(VBuffers$$Lambda$6.lambdaFactory$(this, map), this.normalBuffer != null ? map.apply(null, this.normalBuffer) : null).setBatched(this.batched);
    }

    public VBuffers transform(MatrixStack stack) {
        MatrixStack.Entry e = stack.storeLast();
        return this.map(VBuffers$$Lambda$7.lambdaFactory$(e));
    }

    public boolean isBatched() {
        return this.batched;
    }

    public VBuffers setBatched(boolean batched) {
        this.batched = batched;
        return this;
    }

    public static VBuffers record(BiConsumer<NativeRenderType, RecordBuffer> recordStarted) {
        return new VBuffers(VBuffers$$Lambda$8.lambdaFactory$(recordStarted)).setBatched(true);
    }

    static /* synthetic */ VertexBuffer lambda$record$7(BiConsumer recordStarted, NativeRenderType rt) {
        RecordBuffer buffer = new RecordBuffer();
        recordStarted.accept(rt, buffer);
        return buffer;
    }

    static /* synthetic */ VertexBuffer lambda$transform$6(MatrixStack.Entry e, VertexBuffer b) {
        return new TransformedBuffer(b, e);
    }

    static /* synthetic */ VertexBuffer lambda$map$5(VBuffers this_, BiFunction map, NativeRenderType rt) {
        return (VertexBuffer)map.apply(rt, this_.getBuffer(rt));
    }

    static /* synthetic */ VertexBuffer lambda$map$4(VBuffers this_, UnaryOperator map, NativeRenderType rt) {
        return (VertexBuffer)map.apply(this_.getBuffer(rt));
    }

    static /* synthetic */ VertexBuffer lambda$replay$3(VBuffers this_, NativeRenderType rt) {
        return new ReplayBuffer(VBuffers$$Lambda$9.lambdaFactory$(this_, rt));
    }

    static /* synthetic */ VertexBuffer lambda$null$2(VBuffers this_, NativeRenderType rt) {
        return this_.getBuffer(rt);
    }

    static /* synthetic */ void lambda$finishAll$1(VBuffers this_, NativeRenderType rt) {
        this_.buffers.get(rt).finish();
    }

    static /* synthetic */ int lambda$finishAll$0(NativeRenderType a, NativeRenderType b) {
        return Integer.compare(a.layer, b.layer);
    }

    private static class VBuf
    extends WrappedBuffer {
        private final VBuffers bufs;
        private final NativeRenderType rt;

        public VBuf(VertexBuffer buffer, VBuffers bufs, NativeRenderType rt) {
            super(buffer);
            this.bufs = bufs;
            this.rt = rt;
        }

        @Override
        public void finish() {
            this.bufs.finish(this.rt);
        }

        @Override
        public void addVertex(MatrixStack.Entry entry, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
            VertexBuffer$.addVertex(this, entry, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        }

        @Override
        public void addVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
            VertexBuffer$.addVertex(this, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        }

        @Override
        public VertexBuffer normal(Mat3f mat3f, float f, float f2, float f3) {
            return VertexBuffer$.normal(this, mat3f, f, f2, f3);
        }

        @Override
        public VertexBuffer pos(Mat4f mat4f, float f, float f2, float f3) {
            return VertexBuffer$.pos(this, mat4f, f, f2, f3);
        }

        @Override
        public VertexBuffer color(int n) {
            return VertexBuffer$.color(this, n);
        }
    }

    public static class NativeRenderType {
        public static final NativeRenderType DISABLE = new NativeRenderType(0);
        private final Object nativeType;
        private int layer;

        public NativeRenderType(Object nativeType, int layer) {
            this.nativeType = nativeType;
            this.layer = layer;
        }

        public NativeRenderType(int layer) {
            this.nativeType = null;
            this.layer = layer;
        }

        public <RT> RT getNativeType() {
            return (RT)this.nativeType;
        }
    }
}

