/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VertexBuffer;

public class VertexBuffer$ {
    public static void addVertex(VertexBuffer this_, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, float normalX, float normalY, float normalZ) {
        this_.pos(x, y, z);
        this_.color(red, green, blue, alpha);
        this_.tex(texU, texV);
        this_.normal(normalX, normalY, normalZ);
        this_.endVertex();
    }

    public static void addVertex(VertexBuffer this_, MatrixStack.Entry mat, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, float normalX, float normalY, float normalZ) {
        this_.pos(mat.getMatrix(), x, y, z);
        this_.color(red, green, blue, alpha);
        this_.tex(texU, texV);
        this_.normal(mat.getNormal(), normalX, normalY, normalZ);
        this_.endVertex();
    }

    public static VertexBuffer pos(VertexBuffer this_, Mat4f matrixIn, float x, float y, float z) {
        Vec4f vector4f = new Vec4f(x, y, z, 1.0f);
        vector4f.transform(matrixIn);
        return this_.pos(vector4f.x, vector4f.y, vector4f.z);
    }

    public static VertexBuffer normal(VertexBuffer this_, Mat3f matrix, float x, float y, float z) {
        Vec3f vec3f = new Vec3f(x, y, z);
        vec3f.transform(matrix);
        return this_.normal(vec3f.x, vec3f.y, vec3f.z);
    }

    public static VertexBuffer color(VertexBuffer this_, int argb) {
        int a = (argb & 0xFF000000) >>> 24;
        int r = (argb & 0xFF0000) >> 16;
        int g = (argb & 0xFF00) >> 8;
        int b = argb & 0xFF;
        this_.color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        return this_;
    }
}

