/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.tag;

import com.tom.cpl.tag.CPMTag;
import com.tom.cpl.tag.NativeTag;
import com.tom.cpl.tag.NativeTagManager;
import com.tom.cpl.tag.Tag;
import com.tom.cpl.tag.TagManager$$Lambda$1;
import com.tom.cpl.tag.TagManager$$Lambda$2;
import com.tom.cpl.tag.TagManager$$Lambda$3;
import com.tom.cpl.tag.TagManager$$Lambda$4;
import com.tom.cpl.tag.TagManager$$Lambda$5;
import com.tom.cpl.tag.TagManager$$Lambda$6;
import com.tom.cpl.tag.TagManager$$Lambda$7;
import com.tom.cpl.tag.TagManager$$Lambda$8;
import com.tom.cpl.tag.TagManager$$Lambda$9;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpm.shared.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TagManager<T> {
    protected final NativeTagManager<T> nativeManager;
    protected TagManager<T> parent;
    protected Map<String, CPMTag<T>> tags = new HashMap<String, CPMTag<T>>();

    public TagManager(NativeTagManager<T> nativeManager) {
        this.nativeManager = nativeManager;
    }

    public TagManager(TagManager<T> parent) {
        this.nativeManager = parent.nativeManager;
        this.parent = parent;
    }

    public Tag<T> create(String id, String ... strings) {
        CPMTag tag = new CPMTag(this, id, Arrays.asList(strings));
        this.tags.put(id, tag);
        return tag;
    }

    public List<T> listStacks(List<String> entries) {
        return this.listStacksInt(entries, null);
    }

    protected List<T> listStacksInt(List<String> entries, Set<CPMTag<T>> dejavu) {
        return this.listStacksInt(entries, true, dejavu);
    }

    private List<T> listStacksInt(List<String> entries, boolean scanNative, Set<CPMTag<T>> dejavu) {
        if (dejavu == null) {
            dejavu = new HashSet<CPMTag<T>>();
        }
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        if (this.parent != null) {
            list.addAll(super.listStacksInt(entries, false, dejavu));
        }
        for (String e : entries) {
            if (e.isEmpty()) continue;
            if (e.charAt(0) == '$') {
                CPMTag<T> tag = this.tags.get(e.substring(1));
                if (!dejavu.add(tag) || !this.checkTag(tag) || tag == null) continue;
                list.addAll(tag.getAllStacksInt(dejavu));
                continue;
            }
            if (!scanNative) continue;
            list.addAll(this.nativeManager.listNativeEntries(e));
        }
        return new ArrayList(list);
    }

    protected boolean checkTag(CPMTag<T> tag) {
        return this.parent == null ? tag.isBuiltin() : true;
    }

    public boolean isInTag(List<String> entries, T stack) {
        return this.isInTag(entries, stack, true);
    }

    private boolean isInTag(List<String> entries, T stack, boolean scanNative) {
        if (this.parent != null && super.isInTag(entries, stack, false)) {
            return true;
        }
        for (String e : entries) {
            CPMTag<T> tag;
            if (e.isEmpty() || !(e.charAt(0) == '$' ? (tag = this.tags.get(e.substring(1))) != null && this.checkTag(tag) && tag.is(stack) : scanNative && this.nativeManager.isInNativeTag(e, stack))) continue;
            return true;
        }
        return false;
    }

    public List<Tag<T>> listStackTags(T stack) {
        return this.listStackTags(stack, true);
    }

    private List<Tag<T>> listStackTags(T stack, boolean scanNative) {
        ArrayList<Tag<T>> list = new ArrayList<Tag<T>>();
        if (this.parent != null) {
            list.addAll(super.listStackTags(stack, false));
        }
        for (CPMTag<T> e : this.tags.values()) {
            if (!this.checkTag(e) || !e.is(stack)) continue;
            list.add(e);
        }
        if (scanNative) {
            list.addAll(this.nativeManager.listNativeTags(stack).stream().map(TagManager$$Lambda$1.lambdaFactory$(this)).collect(Collectors.toList()));
        }
        return list;
    }

    public void applyBuiltin(Map<String, List<Map<String, Object>>> tagMap, String prefix) {
        this.tags.clear();
        tagMap.forEach(TagManager$$Lambda$2.lambdaFactory$(this));
        long bi = this.tags.values().stream().filter(TagManager$$Lambda$3.lambdaFactory$()).count();
        Log.info("Loaded " + bi + " built-in, " + ((long)this.tags.size() - bi) + " custom " + prefix + " tags");
    }

    protected void setParent(TagManager<T> parent) {
        this.parent = parent;
    }

    public List<Tag<T>> listAllTags() {
        return this.listAllTags(true);
    }

    private List<Tag<T>> listAllTags(boolean listNative) {
        ArrayList<Tag<T>> list = new ArrayList<Tag<T>>();
        if (this.parent != null) {
            list.addAll(super.listAllTags(false));
        }
        Stream<CPMTag<T>> stream = this.tags.values().stream().filter(TagManager$$Lambda$4.lambdaFactory$(this));
        ArrayList<Tag<T>> arrayList = list;
        arrayList.getClass();
        stream.forEach(TagManager$$Lambda$5.lambdaFactory$(arrayList));
        if (listNative) {
            Stream stream2 = this.nativeManager.listNativeTags().stream().map(TagManager$$Lambda$6.lambdaFactory$(this));
            ArrayList<Tag<T>> arrayList2 = list;
            arrayList2.getClass();
            stream2.forEach(TagManager$$Lambda$7.lambdaFactory$(arrayList2));
        }
        return list;
    }

    public NativeTagManager<T> getNativeManager() {
        return this.nativeManager;
    }

    public void fromMap(Map<String, List<String>> tagsIn) {
        tagsIn.forEach(TagManager$$Lambda$8.lambdaFactory$(this));
    }

    static /* synthetic */ void lambda$fromMap$4(TagManager this_, String k, List e) {
        this_.create(k, e.toArray(new String[0]));
    }

    static /* synthetic */ NativeTag lambda$listAllTags$3(TagManager this_, String t) {
        return new NativeTag(this_.nativeManager, t);
    }

    static /* synthetic */ void lambda$applyBuiltin$2(TagManager this_, String t, List j) {
        try {
            ArrayList<String> entries = new ArrayList<String>();
            Boolean builtin = null;
            for (Map map : j) {
                boolean b = map.getOrDefault("builtin", false);
                if (map.getOrDefault("replace", false).booleanValue()) {
                    entries.clear();
                    if (builtin != null && builtin.booleanValue() && !b) {
                        throw new IllegalStateException("Can't replace built-in tag with non-builtin");
                    }
                    builtin = b;
                }
                if (builtin == null) {
                    builtin = b;
                } else if (builtin != b) {
                    throw new IllegalStateException("Can't append to a built-in tag to a non-builtin");
                }
                ((List)map.get("entries")).forEach(TagManager$$Lambda$9.lambdaFactory$(entries));
            }
            this_.tags.put(t, new CPMTag(this_, t, entries, builtin));
        }
        catch (Exception e) {
            ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm builtin tag: " + t, e);
        }
    }

    static /* synthetic */ void lambda$null$1(List entries, Object e) {
        entries.add((String)e);
    }

    static /* synthetic */ NativeTag lambda$listStackTags$0(TagManager this_, String t) {
        return new NativeTag(this_.nativeManager, t);
    }
}

