/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.text;

import com.tom.cpl.text.CompositeText$$Lambda$1;
import com.tom.cpl.text.I18n;
import com.tom.cpl.text.IText;
import com.tom.cpl.text.IText$;
import com.tom.cpl.text.TextRemapper;
import com.tom.cpl.text.TextStyle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class CompositeText
implements IText {
    private final IText[] parts;

    public CompositeText(IText ... parts) {
        this.parts = parts;
    }

    @Override
    public <C> C remap(TextRemapper<C> remapper) {
        if (this.parts.length == 0) {
            return remapper.string("");
        }
        C r = this.parts[0].remap(remapper);
        for (int i = 1; i < this.parts.length; ++i) {
            r = remapper.combine(r, this.parts[i].remap(remapper));
        }
        return r;
    }

    @Override
    public String toString(I18n gui) {
        StringBuilder sb = new StringBuilder();
        for (IText iText : this.parts) {
            sb.append(iText.toString(gui));
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("parts", Arrays.stream(this.parts).map(CompositeText$$Lambda$1.lambdaFactory$()).collect(Collectors.toList()));
        return m;
    }

    @Override
    public void walkParts(I18n gui, BiConsumer<String, TextStyle> renderer) {
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].walkParts(gui, renderer);
        }
    }

    public Object remap() {
        return IText$.remap(this);
    }
}

