/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.text;

import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.text.I18n;
import com.tom.cpl.text.IText;
import com.tom.cpl.text.IText$;
import com.tom.cpl.text.TextRemapper;
import com.tom.cpm.shared.MinecraftClientAccess$;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class KeybindText
implements IText {
    private final String name;
    private final String fallback;

    public KeybindText(String name, String fallback) {
        this.name = name;
        this.fallback = fallback;
    }

    @Override
    public <C> C remap(TextRemapper<C> remapper) {
        if (remapper.hasKeybind()) {
            return remapper.keyBind(this.name);
        }
        if (MinecraftClientAccess$.get() != null) {
            String k;
            IKeybind rtkb = null;
            for (IKeybind kb : MinecraftClientAccess$.get().getKeybinds()) {
                if (!kb.getName().startsWith(this.fallback)) continue;
                rtkb = kb;
            }
            String string = k = rtkb == null ? "?" : rtkb.getBoundKey();
            if (k.isEmpty()) {
                return remapper.translate("label.cpm.key_unbound", new Object[0]);
            }
            return remapper.string(k);
        }
        return remapper.string("?");
    }

    @Override
    public String toString(I18n gui) {
        String k;
        IKeybind rtkb = null;
        for (IKeybind kb : MinecraftClientAccess$.get().getKeybinds()) {
            if (!kb.getName().startsWith(this.fallback)) continue;
            rtkb = kb;
        }
        String string = k = rtkb == null ? "?" : rtkb.getBoundKey();
        if (k.isEmpty()) {
            k = gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
        }
        return k;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("kb", this.name);
        m.put("fallback", this.fallback);
        return m;
    }

    public Object remap() {
        return IText$.remap(this);
    }

    public void walkParts(I18n i18n, BiConsumer biConsumer) {
        IText$.walkParts(this, i18n, biConsumer);
    }
}

