/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess$;

public class DynamicTexture {
    private Image image;
    private boolean needReload;
    private ITexture texture;

    public DynamicTexture(Image image) {
        this.image = image;
        this.needReload = true;
    }

    public void bind() {
        if (this.texture == null) {
            this.texture = MinecraftClientAccess$.get().createTexture();
            this.needReload = true;
        }
        if (this.needReload) {
            this.texture.load(this.image);
            this.needReload = false;
        }
        this.texture.bind();
    }

    public void markDirty() {
        this.needReload = true;
    }

    public void setImage(Image image) {
        this.image = image;
        this.needReload = true;
    }

    public void free() {
        if (this.texture != null) {
            this.texture.free();
        }
        this.texture = null;
    }

    public ITexture getNative() {
        return this.texture;
    }

    public Image getImage() {
        return this.image;
    }

    public static interface ITexture {
        public void bind();

        public void load(Image var1);

        public void free();
    }
}

