/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import com.tom.cpl.util.Image$$Lambda$1;
import com.tom.cpl.util.ImageIO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.CompletableFuture;

public class Image {
    private final int[] data;
    private final int w;
    private final int h;

    public Image(int w, int h) {
        this.w = w;
        this.h = h;
        this.data = new int[w * h];
    }

    public Image(Image cpyFrom) {
        this(cpyFrom.w, cpyFrom.h);
        System.arraycopy(cpyFrom.data, 0, this.data, 0, this.data.length);
    }

    public Image(int[] data, int w) {
        this.data = data;
        this.w = w;
        this.h = data.length / w;
    }

    public void setRGB(int x, int y, int rgb) {
        this.data[y * this.w + x] = rgb;
    }

    public int getRGB(int x, int y) {
        return this.data[y * this.w + x];
    }

    public int[] getData() {
        return this.data;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public static CompletableFuture<Image> loadFrom(File f) {
        return ImageIO.read(f);
    }

    public static Image loadFrom(InputStream f) throws IOException {
        return ImageIO.read(f);
    }

    public void storeTo(File f) throws IOException {
        ImageIO.write(this, f);
    }

    public void storeTo(OutputStream f) throws IOException {
        ImageIO.write(this, f);
    }

    public void draw(Image i) {
        for (int x = 0; x < this.w && x < i.w; ++x) {
            for (int y = 0; y < this.h && y < i.h; ++y) {
                this.data[y * this.w + x] = i.data[y * i.w + x];
            }
        }
    }

    public void draw(Image i, int xs, int ys) {
        for (int x = 0; x + xs < this.w && x < i.w; ++x) {
            for (int y = 0; y + ys < this.h && y < i.h; ++y) {
                int p = (y + ys) * this.w + x + xs;
                if (p < 0) continue;
                this.data[p] = i.data[y * i.w + x];
            }
        }
    }

    public void draw(Image i, int xs, int ys, int w, int h) {
        for (int y = 0; y < h; ++y) {
            int yp = (y + ys) * w;
            for (int x = 0; x < w; ++x) {
                int ix = x * i.getWidth() / w;
                int iy = y * i.getHeight() / h;
                this.data[yp + x + xs] = i.getRGB(Math.min(ix, i.getWidth() - 1), Math.min(iy, i.getHeight() - 1));
            }
        }
    }

    public static CompletableFuture<Image> download(String url) {
        return CompletableFuture.supplyAsync(Image$$Lambda$1.lambdaFactory$(url));
    }

    public void fill(int color) {
        for (int y = 0; y < this.h; ++y) {
            for (int x = 0; x < this.w; ++x) {
                this.data[y * this.w + x] = color;
            }
        }
    }

    public void fill(int xs, int ys, int w, int h, int color) {
        for (int x = 0; x + xs < this.w && x < w; ++x) {
            for (int y = 0; y + ys < this.h && y < h; ++y) {
                this.data[(y + ys) * this.w + x + xs] = color;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Image lambda$download$0(String url) {
        Image image;
        URL input = new URL(url);
        InputStream istream = null;
        try {
            istream = input.openStream();
        }
        catch (IOException e) {
            throw new IOException("Can't get input stream from URL!", e);
        }
        try {
            image = ImageIO.read(istream);
        }
        catch (Throwable throwable) {
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        istream.close();
        return image;
    }
}

