/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IGui$;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UI$;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpm.CPMVersion;
import com.tom.cpm.client.GuiImpl$$Lambda$1;
import com.tom.cpm.client.GuiImpl$$Lambda$2;
import com.tom.cpm.client.GuiImpl$$Lambda$3;
import com.tom.cpm.client.GuiImpl$$Lambda$4;
import com.tom.cpm.client.GuiImpl$$Lambda$5;
import com.tom.cpm.client.LWJGLKeyCodes;
import com.tom.cpm.client.Lang;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.util.Log;
import cpw.mods.fml.client.FMLClientHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiChat;
import net.minecraft.src.GuiIngame;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiTextField;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderItem;
import net.minecraft.src.ScaledResolution;
import net.minecraft.src.Tessellator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiImpl
extends GuiScreen
implements IGui {
    private static final KeyCodes CODES = new LWJGLKeyCodes();
    private static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    protected static RenderItem itemRenderer = new RenderItem();
    private Frame gui;
    private GuiScreen parent;
    private IGui.CtxStack stack;
    private UIColors colors = new UIColors();
    private Consumer<Runnable> closeListener;
    private int vanillaScale = -1;
    private int eventButton = 0;
    private long dragStart = 0L;

    public GuiImpl(Function<IGui, Frame> creator, GuiScreen parent) {
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiImpl, N> fac) {
        return GuiImpl$$Lambda$1.lambdaFactory$(fac);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        try {
            GL11.glEnable((int)3089);
            this.stack = new IGui.CtxStack(this.width, this.height);
            this.gui.draw(mouseX, mouseY, partialTicks);
        }
        catch (Throwable e) {
            this.onGuiException("Error drawing gui", e, true);
        }
        finally {
            GL11.glDisable((int)3089);
            String s = "Minecraft 1.2.5 (fml,forge) " + CPMVersion.getVersion();
            this.fontRenderer.drawString(s, this.width - this.fontRenderer.getStringWidth(s) - 4, 2, -16777216);
            s = FMLClientHandler.instance().getClient().debug;
            this.fontRenderer.drawString(s, this.width - this.fontRenderer.getStringWidth(s) - 4, 11, -16777216);
        }
        if (this.mc.thePlayer != null && this.gui.enableChat()) {
            try {
                ScaledResolution res = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
                Method m = GuiIngame.class.getDeclaredMethod("renderChat", Integer.TYPE, Integer.TYPE);
                m.setAccessible(true);
                m.invoke((Object)this.mc.ingameGUI, res.getScaledWidth(), res.getScaledHeight());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.vanillaScale != -1 && this.vanillaScale != this.mc.gameSettings.guiScale) {
            this.mc.gameSettings.guiScale = this.vanillaScale;
        }
        if (this.parent != null) {
            GuiScreen p = this.parent;
            this.parent = null;
            this.mc.displayGuiScreen(p);
        }
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        GuiImpl.drawRect(x += this.getOffset().x, y += this.getOffset().y, x + w, y + h, color);
    }

    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        try {
            this.gui.init(this.width, this.height);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        this.fontRenderer.drawString(text, x += this.getOffset().x, y += this.getOffset().y, color);
    }

    protected void keyTyped(char typedChar, int keyCode) {
        try {
            KeyboardEvent evt = new KeyboardEvent(keyCode, 0, typedChar, Keyboard.getKeyName((int)keyCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.mc.thePlayer != null && this.mc.gameSettings.keyBindChat.keyCode == keyCode) {
                this.mc.displayGuiScreen((GuiScreen)new Overlay());
            }
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        try {
            this.gui.mouseClick(new MouseEvent(mouseX, mouseY, mouseButton));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    protected void func_85041_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        try {
            this.gui.mouseDrag(new MouseEvent(mouseX, mouseY, clickedMouseButton));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int state) {
        if (state == -1) {
            return;
        }
        try {
            this.gui.mouseRelease(new MouseEvent(mouseX, mouseY, state));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    public void handleMouseInput() {
        int var1 = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int var2 = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        if (Mouse.getEventButtonState()) {
            this.eventButton = Mouse.getEventButton();
            this.dragStart = System.currentTimeMillis();
            this.mouseClicked(var1, var2, this.eventButton);
        } else if (Mouse.getEventButton() != -1) {
            this.eventButton = -1;
            this.mouseMovedOrUp(var1, var2, Mouse.getEventButton());
        } else if (this.eventButton != -1 && this.dragStart > 0L) {
            long var3 = System.currentTimeMillis() - this.dragStart;
            this.func_85041_a(var1, var2, this.eventButton, var3);
        }
        int i = Mouse.getEventDWheel();
        if (i > 0) {
            i = 1;
        }
        if (i < 0) {
            i = -1;
        }
        if (i != 0) {
            try {
                int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
                int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
                this.gui.mouseWheel(new MouseEvent(x, y, i));
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
            }
        }
    }

    @Override
    public void displayError(final String e) {
        final GuiScreen p = this.parent;
        this.parent = null;
        FMLClientHandler.instance().getClient().displayGuiScreen(new GuiScreen(){
            private GuiScreen parent;
            private String message1;
            private String message2;
            {
                this.parent = p;
                this.message1 = "Custom Player Models";
                this.message2 = Lang.format("error.cpm.crash", e);
            }

            public void initGui() {
                super.initGui();
                this.controlList.add(new GuiButton(0, this.width / 2 - 100, 140, Lang.format("gui.cancel", new Object[0])));
            }

            protected void keyTyped(char typedChar, int keyCode) {
            }

            public void drawScreen(int par1, int par2, float par3) {
                GuiImpl.drawGradientRect(0, 0, this.width, this.height, -12574688, -11530224, 0.0);
                this.drawCenteredString(this.fontRenderer, this.message1, this.width / 2, 90, 0xFFFFFF);
                this.drawCenteredString(this.fontRenderer, this.message2, this.width / 2, 110, 0xFFFFFF);
                super.drawScreen(par1, par2, par3);
            }

            public void onGuiClosed() {
                if (this.parent != null) {
                    GuiScreen p2 = this.parent;
                    this.parent = null;
                    this.mc.displayGuiScreen(p2);
                }
            }

            protected void useItem(GuiButton button) {
                this.mc.displayGuiScreen((GuiScreen)null);
            }
        });
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(GuiImpl$$Lambda$2.lambdaFactory$(this));
        } else {
            this.mc.displayGuiScreen((GuiScreen)null);
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/assets/cpm/textures/gui/" + texture + ".png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(x += this.getOffset().x, y += this.getOffset().y, u, v, w, h);
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/assets/cpm/textures/gui/" + texture + ".png"));
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        this.drawTexturedModalRect(x, y, u, v, w, h);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV((double)(x += this.getOffset().x), (double)((y += this.getOffset().y) + height), 0.0, (double)u1, (double)v2);
        t.addVertexWithUV((double)(x + width), (double)(y + height), 0.0, (double)u2, (double)v2);
        t.addVertexWithUV((double)(x + width), (double)y, 0.0, (double)u2, (double)v1);
        t.addVertexWithUV((double)x, (double)y, 0.0, (double)u1, (double)v1);
        t.draw();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return Lang.format(key, obj);
    }

    @Override
    public void setupCut() {
        float multiplierX = (float)this.mc.displayWidth / (float)this.width;
        float multiplierY = (float)this.mc.displayHeight / (float)this.height;
        Box box = this.getContext().cutBox;
        GL11.glScissor((int)((int)((float)box.x * multiplierX)), (int)(this.mc.displayHeight - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
    }

    @Override
    public int textWidth(String text) {
        return this.fontRenderer.getStringWidth(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return GuiImpl.isShiftKeyDown();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiImpl.isCtrlKeyDown();
    }

    @Override
    public boolean isAltDown() {
        return false;
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x;
        int top = y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        RetroGL.glBlendFunc(770, 771, 1, 0);
        GL11.glShadeModel((int)7425);
        RetroGL.RetroTessellator t = RetroGL.tessellator;
        t.begin(7);
        t.pos(right, top, this.zLevel).color(rtr, gtr, btr, atr).endVertex();
        t.pos(left, top, this.zLevel).color(rtl, gtl, btl, atl).endVertex();
        t.pos(left, bottom, this.zLevel).color(rbl, gbl, bbl, abl).endVertex();
        t.pos(right, bottom, this.zLevel).color(rbr, gbr, bbr, abr).endVertex();
        t.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        GuiImpl.setClipboardString((String)text);
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return GuiImpl.getClipboardString();
    }

    @Override
    public void setScale(int value) {
        if (value != this.mc.gameSettings.guiScale) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = this.mc.gameSettings.guiScale;
            }
            if (value == -1) {
                if (this.mc.gameSettings.guiScale != this.vanillaScale) {
                    this.mc.gameSettings.guiScale = this.vanillaScale;
                    this.vanillaScale = -1;
                    ScaledResolution scaledresolution = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
                    int j = scaledresolution.getScaledWidth();
                    int k = scaledresolution.getScaledHeight();
                    this.setWorldAndResolution(this.mc, j, k);
                }
            } else {
                this.mc.gameSettings.guiScale = value;
                ScaledResolution scaledresolution = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
                int j = scaledresolution.getScaledWidth();
                int k = scaledresolution.getScaledHeight();
                this.setWorldAndResolution(this.mc, j, k);
            }
        }
    }

    @Override
    public int getScale() {
        return this.mc.gameSettings.guiScale;
    }

    @Override
    public int getMaxScale() {
        return 4;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void updateScreen() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x += (float)this.getOffset().x), (float)(y += (float)this.getOffset().y), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.fontRenderer.drawString((String)text.remap(), 0, 0, color);
        GL11.glPopMatrix();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.fontRenderer.getStringWidth((String)text.remap());
    }

    @Override
    public void openURL0(String url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            Log.error("Couldn't open link: " + (throwable == null ? "<UNKNOWN>" : throwable.getMessage()));
        }
    }

    public void onOpened() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        GL11.glEnable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        RenderHelper.enableGUIStandardItemLighting();
        itemRenderer.renderItemIntoGUI(this.fontRenderer, this.mc.renderEngine, s, x, y);
        itemRenderer.renderItemOverlayIntoGUI(this.fontRenderer, this.mc.renderEngine, s, x, y);
        GL11.glDisable((int)2929);
        GL11.glPopMatrix();
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        this.drawItemStackTooltip(s, mx, my);
    }

    protected void drawItemStackTooltip(ItemStack par1ItemStack, int par2, int par3) {
        List list = par1ItemStack.getItemNameandInformation();
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, "\u00a7" + Integer.toHexString(par1ItemStack.getRarity().rarityColor) + (String)list.get(k));
                continue;
            }
            list.set(k, "\u00a77" + (String)list.get(k));
        }
        this.drawHoveringText(list, par2, par3, this.fontRenderer);
    }

    protected void drawHoveringText(List<String> par1List, int par2, int par3, FontRenderer font) {
        if (!par1List.isEmpty()) {
            int j1;
            GL11.glDisable((int)32826);
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                j1 = font.getStringWidth(s);
                if (j1 <= k) continue;
                k = j1;
            }
            int i1 = par2 + 12;
            j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.width) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.height) {
                j1 = this.height - k1 - 6;
            }
            this.zLevel = 300.0f;
            GuiImpl.itemRenderer.zLevel = 300.0f;
            int l1 = -267386864;
            this.drawGradientRect(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.drawGradientRect(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.drawGradientRect(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.drawGradientRect(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = par1List.get(k2);
                font.drawStringWithShadow(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.zLevel = 0.0f;
            GuiImpl.itemRenderer.zLevel = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.enableStandardItemLighting();
            GL11.glEnable((int)32826);
        }
    }

    public static void drawRect(int var0, int var1, int var2, int var3, int var4) {
        int var5;
        if (var0 < var2) {
            var5 = var0;
            var0 = var2;
            var2 = var5;
        }
        if (var1 < var3) {
            var5 = var1;
            var1 = var3;
            var3 = var5;
        }
        float var10 = (float)(var4 >> 24 & 0xFF) / 255.0f;
        float var6 = (float)(var4 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(var4 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(var4 & 0xFF) / 255.0f;
        Tessellator var9 = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)var6, (float)var7, (float)var8, (float)var10);
        var9.startDrawingQuads();
        var9.addVertex((double)var0, (double)var3, 0.0);
        var9.addVertex((double)var2, (double)var3, 0.0);
        var9.addVertex((double)var2, (double)var1, 0.0);
        var9.addVertex((double)var0, (double)var1, 0.0);
        var9.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    protected void drawGradientRect(int var1, int var2, int var3, int var4, int var5, int var6) {
        GuiImpl.drawGradientRect(var1, var2, var3, var4, var5, var6, this.zLevel);
    }

    protected static void drawGradientRect(int var1, int var2, int var3, int var4, int var5, int var6, double z) {
        float var7 = (float)(var5 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(var5 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(var5 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(var5 & 0xFF) / 255.0f;
        float var11 = (float)(var6 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(var6 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(var6 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(var6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.instance;
        var15.startDrawingQuads();
        var15.setColorRGBA_F(var8, var9, var10, var7);
        var15.addVertex((double)var3, (double)var2, z);
        var15.addVertex((double)var1, (double)var2, z);
        var15.setColorRGBA_F(var12, var13, var14, var11);
        var15.addVertex((double)var1, (double)var4, z);
        var15.addVertex((double)var3, (double)var4, z);
        var15.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    static /* synthetic */ void lambda$closeGui$1(GuiImpl this_) {
        this_.mc.displayGuiScreen((GuiScreen)null);
    }

    static /* synthetic */ Object lambda$local$0(Function fac, Supplier f) {
        return fac.apply((GuiImpl)f.get());
    }

    static {
        nativeComponents.register(TextField.class, GuiImpl.local(GuiImpl$$Lambda$3.lambdaFactory$()));
        nativeComponents.register(FileChooserPopup.class, GuiImpl$$Lambda$4.lambdaFactory$());
        nativeComponents.register(Panel3d.class, GuiImpl$$Lambda$5.lambdaFactory$());
    }

    static /* synthetic */ TextField.ITextField access$lambda$0(GuiImpl guiImpl) {
        return guiImpl.createTextField();
    }

    @Override
    public void displayConfirm(String string, Runnable runnable, Runnable runnable2) {
        UI$.displayConfirm(this, string, runnable, runnable2);
    }

    @Override
    public String wordWrap(String string, int n) {
        return IGui$.wordWrap(this, string, n);
    }

    @Override
    public void executeLater(Runnable runnable) {
        IGui$.executeLater(this, runnable);
    }

    @Override
    public void displayMessagePopup(String string, String string2, String string3) {
        IGui$.displayMessagePopup(this, string, string2, string3);
    }

    @Override
    public void displayConfirm(String string, String string2, Runnable runnable, Runnable runnable2, String string3, String string4) {
        IGui$.displayConfirm(this, string, string2, runnable, runnable2, string3, string4);
    }

    @Override
    public void drawRectangle(float f, float f2, float f3, float f4, int n) {
        IGui$.drawRectangle((IGui)this, f, f2, f3, f4, n);
    }

    @Override
    public Vec2i getOffset() {
        return IGui$.getOffset(this);
    }

    @Override
    public boolean canScaleVanilla() {
        return IGui$.canScaleVanilla(this);
    }

    @Override
    public void openURL(String string) {
        IGui$.openURL(this, string);
    }

    @Override
    public void drawBox(float f, float f2, float f3, float f4, int n) {
        IGui$.drawBox(this, f, f2, f3, f4, n);
    }

    @Override
    public IGui.Ctx getContext() {
        return IGui$.getContext(this);
    }

    @Override
    public void popMatrix() {
        IGui$.popMatrix(this);
    }

    @Override
    public void pushMatrix() {
        IGui$.pushMatrix(this);
    }

    @Override
    public void drawText(int n, int n2, String string, int n3, int n4) {
        IGui$.drawText(this, n, n2, string, n3, n4);
    }

    @Override
    public void displayConfirm(String string, String string2, Runnable runnable, Runnable runnable2, String string3) {
        UI$.displayConfirm(this, string, string2, runnable, runnable2, string3);
    }

    @Override
    public void onGuiException(String string, Throwable throwable, boolean bl) {
        IGui$.onGuiException(this, string, throwable, bl);
    }

    public Object getNativeGui() {
        return IGui$.getNativeGui(this);
    }

    @Override
    public void drawRectangle(int n, int n2, int n3, int n4, int n5) {
        IGui$.drawRectangle((IGui)this, n, n2, n3, n4, n5);
    }

    @Override
    public void displayMessagePopup(String string, String string2) {
        UI$.displayMessagePopup(this, string, string2);
    }

    @Override
    public void displayConfirm(String string, String string2, Runnable runnable, Runnable runnable2) {
        UI$.displayConfirm(this, string, string2, runnable, runnable2);
    }

    @Override
    public void setPosOffset(Box box) {
        IGui$.setPosOffset(this, box);
    }

    public void displayPopup(Function function) {
        IGui$.displayPopup(this, function);
    }

    public class Overlay
    extends GuiChat {
        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            GuiImpl.this.drawScreen(Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            super.drawScreen(mouseX, mouseY, partialTicks);
        }

        public GuiScreen getGui() {
            return GuiImpl.this;
        }
    }

    private class TxtField
    implements TextField.ITextField {
        private GuiTextField field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean refreshTextBox;

        public TxtField() {
            this.field = new GuiTextField(GuiImpl.this.fontRenderer, 0, 0, 0, 0);
            this.field.setMaxStringLength(0x100000);
            this.field.setEnableBackgroundDrawing(false);
            this.field.enabledColor = ((GuiImpl)GuiImpl.this).colors.label_text_color;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiImpl.this.getOffset();
            this.field.xPos = bounds.x + off.x + 4;
            this.field.yPos = bounds.y + off.y + 6;
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.width = bounds.w - 5;
            this.field.height = bounds.h - 12;
            if (this.refreshTextBox) {
                this.field.func_50038_e();
                this.refreshTextBox = false;
            }
            this.field.drawTextBox();
        }

        @Override
        public void keyPressed(KeyboardEvent e) {
            if (e.isConsumed()) {
                return;
            }
            String text = this.field.getText();
            boolean b = this.field.textboxKeyTyped(e.charTyped, e.keyCode);
            if (b) {
                e.consume();
            }
            if (b && this.eventListener != null && !text.equals(this.field.getText())) {
                this.eventListener.run();
            }
        }

        @Override
        public void mouseClick(MouseEvent e) {
            if (e.isConsumed()) {
                this.field.mouseClicked(Integer.MIN_VALUE, Integer.MIN_VALUE, e.btn);
                return;
            }
            this.field.xPos = this.bounds.x + this.currentOff.x;
            this.field.yPos = this.bounds.y + this.currentOff.y;
            this.field.width = this.bounds.w;
            this.field.height = this.bounds.h;
            this.field.mouseClicked(e.x + this.currentOff.x, e.y + this.currentOff.y, e.btn);
            if (this.bounds.isInBounds(e.x, e.y)) {
                e.consume();
            }
        }

        @Override
        public String getText() {
            return this.field.getText();
        }

        @Override
        public void setText(String txt) {
            this.field.setText(txt);
            this.refreshTextBox = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.isEnabled = enabled;
        }

        @Override
        public boolean isFocused() {
            return this.field.getIsFocused();
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.setFocused(focused);
        }

        @Override
        public int getCursorPos() {
            return this.field.func_50035_h();
        }

        @Override
        public void setCursorPos(int pos) {
            this.field.func_50030_e(pos);
        }

        @Override
        public void setSelectionPos(int pos) {
            this.field.func_50030_e(pos);
        }

        @Override
        public int getSelectionPos() {
            return this.field.field_50048_p;
        }
    }
}

