/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.block.entity.ActiveEffect;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpm.client.PlayerProfile$$Lambda$1;
import com.tom.cpm.client.PlayerProfile$1$$Lambda$1;
import com.tom.cpm.client.PlayerProfile$1$$Lambda$2;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.retro.GameProfile;
import com.tom.cpm.retro.GameProfileManager;
import com.tom.cpm.retro.NetHandlerExt;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBow;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.PotionEffect;

public class PlayerProfile
extends Player<EntityPlayer>
implements NetHandlerExt.IPlayerProfile {
    public static boolean inGui;
    private final GameProfile profile;
    public int encGesture;

    public PlayerProfile(GameProfile profile) {
        this.profile = new GameProfile(profile.getId(), profile.getName());
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.DEFAULT;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals(other.profile));
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(){

            @Override
            protected CompletableFuture<Void> load0() {
                return GameProfileManager.getProfileFuture(PlayerProfile.this.profile.getName()).thenAccept(PlayerProfile$1$$Lambda$1.lambdaFactory$(this));
            }

            static /* synthetic */ void lambda$load0$1(1 this_, GameProfile gp) {
                this_.defineAll(gp.getTextureURLMap(), PlayerProfile$1$$Lambda$2.lambdaFactory$());
            }

            static /* synthetic */ String lambda$null$0(String f) {
                return f;
            }
        };
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(EntityPlayer player) {
        this.animState.resetPlayer();
        if (player.isPlayerSleeping()) {
            this.animState.sleeping = true;
        }
        if (player.isDead) {
            this.animState.dying = true;
        }
        if (player.isRiding() && player.ridingEntity != null && player.ridingEntity.shouldRiderSit()) {
            this.animState.riding = true;
        }
        if (player.isSneaking()) {
            this.animState.sneaking = true;
        }
        if (player.isSprinting()) {
            this.animState.sprinting = true;
        }
        if (player.isUsingItem() && player.getItemInUse() != null) {
            this.animState.usingAnimation = HandAnimation.of(player.getItemInUse().getItemUseAction());
        }
        if (player.isInWater()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = (float)(player.posX - player.prevPosX);
        this.animState.moveAmountY = (float)(player.posY - player.prevPosY);
        this.animState.moveAmountZ = (float)(player.posZ - player.prevPosZ);
        this.animState.yaw = player.rotationYawHead * 2.0f - player.renderYawOffset;
        this.animState.pitch = player.rotationPitch;
        this.animState.bodyYaw = player.rotationYawHead;
        this.animState.encodedState = this.encGesture;
        this.animState.wearingHelm = player.inventory.armorInventory[3] != null;
        this.animState.wearingBody = player.inventory.armorInventory[2] != null;
        this.animState.wearingLegs = player.inventory.armorInventory[1] != null;
        this.animState.wearingBoots = player.inventory.armorInventory[0] != null;
        this.animState.activeHand = this.animState.mainHand = Hand.RIGHT;
        this.animState.hurtTime = player.hurtTime;
        this.animState.isOnLadder = player.isOnLadder();
        this.animState.isBurning = player.isBurning();
        this.animState.inGui = inGui;
        PlayerInventory.setInv(this.animState, player.inventory);
        WorldImpl.setWorld(this.animState, (Entity)player);
        if (player.ridingEntity != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(player.ridingEntity.getClass());
        }
        player.getActivePotionEffects().forEach(PlayerProfile$$Lambda$1.lambdaFactory$(this));
        if (player.getItemInUse() != null && player.getItemInUse().getItem() instanceof ItemBow) {
            float f = 20.0f;
            float f1 = MathHelper.clamp((float)player.getItemInUseDuration(), 0.0f, f);
            this.animState.bowPullback = f1 / f;
        }
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof ModelBiped) {
            ModelBiped m = (ModelBiped)model;
            this.animState.resetModel();
            this.animState.attackTime = m.onGround;
            this.animState.leftArm = PlayerModelSetup.ArmPose.EMPTY;
            if (m.heldItemRight == 1) {
                this.animState.rightArm = PlayerModelSetup.ArmPose.ITEM;
            } else if (m.heldItemRight == 3) {
                this.animState.rightArm = PlayerModelSetup.ArmPose.BLOCK;
            }
            if (m.heldItemLeft == 1) {
                this.animState.leftArm = PlayerModelSetup.ArmPose.ITEM;
            } else if (m.heldItemLeft == 3) {
                this.animState.leftArm = PlayerModelSetup.ArmPose.BLOCK;
            }
            if (m.aimedBow) {
                this.animState.rightArm = PlayerModelSetup.ArmPose.BOW_AND_ARROW;
            }
        }
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    @Override
    public void setEncGesture(int g) {
        this.encGesture = g;
    }

    static /* synthetic */ void lambda$updateFromPlayer$0(PlayerProfile this_, PotionEffect e) {
        this_.animState.allEffects.add(new ActiveEffect(e.getEffectName(), e.getAmplifier(), e.getDuration(), false));
    }
}

