/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.DirectBuffer;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.render.VertexBuffer$;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.RetroGL$$Lambda$1;
import com.tom.cpm.client.RetroGL$$Lambda$2;
import com.tom.cpm.client.RetroGL$$Lambda$3;
import com.tom.cpm.client.RetroGL$$Lambda$4;
import com.tom.cpm.client.RetroGL$$Lambda$5;
import com.tom.cpm.client.RetroGL$$Lambda$6;
import com.tom.cpm.client.RetroGL$$Lambda$7;
import com.tom.cpm.client.RetroGL$$Lambda$8;
import com.tom.cpm.shared.retro.RetroGLAccess;
import net.minecraft.src.OpenGlHelper;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTBlendFuncSeparate;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;

public class RetroGL
implements RetroGLAccess<Integer> {
    public static final RetroTessellator tessellator = new RetroTessellator(Tessellator.instance);
    public static int renderCallLoc;
    public static final int GLINT_OVERLAY_LOC = 1;
    public static final int HURT_OVERLAY_LOC = 2;
    private static final RenderStage lines;
    private static final RenderStage color;
    public static float clx;
    public static float cly;
    private static float lx;
    private static float ly;
    private static float red;
    private static float green;
    private static float blue;
    private static float alpha;
    private static final boolean blendExt;
    private static final boolean openGL14;

    public RenderStage texture(Integer tex) {
        return new RenderStage(true, true, true, RetroGL$$Lambda$1.lambdaFactory$(tex), RetroGL$$Lambda$2.lambdaFactory$(), 7);
    }

    public RenderStage eyes(Integer tex) {
        return new RenderStage(true, true, true, RetroGL$$Lambda$3.lambdaFactory$(tex), RetroGL$$Lambda$4.lambdaFactory$(), 7);
    }

    @Override
    public RenderStage linesNoDepth() {
        return lines;
    }

    @Override
    public RenderStage color() {
        return color;
    }

    private static void bindTex(Integer tex) {
        if (tex != null) {
            GL11.glBindTexture((int)3553, (int)tex);
        }
    }

    public static VertexBuffer buffer(VBuffers.NativeRenderType type) {
        RenderStage stage = (RenderStage)type.getNativeType();
        return new RetroBuffer(tessellator, stage);
    }

    public static Vec4f getColor() {
        return new Vec4f(red, green, blue, alpha);
    }

    public static void color4f(float r, float g, float b, float a) {
        red = r;
        green = g;
        blue = b;
        alpha = a;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    @Override
    public Integer getDynTexture() {
        return MinecraftObject.Texture.bound != null ? Integer.valueOf(MinecraftObject.Texture.bound.getId()) : null;
    }

    public static void glBlendFunc(int p_148821_0_, int p_148821_1_, int p_148821_2_, int p_148821_3_) {
        if (openGL14) {
            if (blendExt) {
                EXTBlendFuncSeparate.glBlendFuncSeparateEXT((int)p_148821_0_, (int)p_148821_1_, (int)p_148821_2_, (int)p_148821_3_);
            } else {
                GL14.glBlendFuncSeparate((int)p_148821_0_, (int)p_148821_1_, (int)p_148821_2_, (int)p_148821_3_);
            }
        } else {
            GL11.glBlendFunc((int)p_148821_0_, (int)p_148821_1_);
        }
    }

    static /* synthetic */ void lambda$eyes$7() {
        if (renderCallLoc == 2) {
            return;
        }
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)lx, (float)ly);
        RetroGL.glBlendFunc(770, 771, 1, 0);
        GL11.glEnable((int)3008);
    }

    static /* synthetic */ void lambda$eyes$6(Integer tex) {
        if (renderCallLoc == 2) {
            return;
        }
        lx = clx;
        ly = cly;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDepthMask((boolean)true);
        int i = 240;
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)j, (float)k);
        RetroGL.bindTex(tex);
    }

    static /* synthetic */ void lambda$texture$5() {
    }

    static /* synthetic */ void lambda$texture$4(Integer tex) {
        RetroGL.bindTex(tex);
        if (renderCallLoc != 1) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    static /* synthetic */ void lambda$static$3() {
        GL11.glEnable((int)3553);
    }

    static /* synthetic */ void lambda$static$2() {
        GL11.glDisable((int)3553);
    }

    static /* synthetic */ void lambda$static$1() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
    }

    static /* synthetic */ void lambda$static$0() {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
    }

    static {
        lines = new RenderStage(true, false, false, RetroGL$$Lambda$5.lambdaFactory$(), RetroGL$$Lambda$6.lambdaFactory$(), 1);
        color = new RenderStage(true, false, false, RetroGL$$Lambda$7.lambdaFactory$(), RetroGL$$Lambda$8.lambdaFactory$(), 7);
        ContextCapabilities contextcapabilities = GLContext.getCapabilities();
        blendExt = contextcapabilities.GL_EXT_blend_func_separate && !contextcapabilities.OpenGL14;
        openGL14 = contextcapabilities.OpenGL14 || contextcapabilities.GL_EXT_blend_func_separate;
    }

    public static class RetroTessellator {
        private Tessellator t;
        private double x;
        private double y;
        private double z;

        public RetroTessellator(Tessellator t) {
            this.t = t;
        }

        public RetroTessellator tex(float i, float j) {
            this.t.setTextureUV((double)i, (double)j);
            return this;
        }

        public void endVertex() {
            this.t.addVertex(this.x, this.y, this.z);
        }

        public void begin(int p_78371_1_) {
            this.t.startDrawing(p_78371_1_);
        }

        public RetroTessellator pos(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public RetroTessellator color(float p_78369_1_, float p_78369_2_, float p_78369_3_, float p_78369_4_) {
            this.t.setColorRGBA_F(p_78369_1_, p_78369_2_, p_78369_3_, p_78369_4_);
            return this;
        }

        public RetroTessellator normal(float p_78375_1_, float p_78375_2_, float p_78375_3_) {
            this.t.setNormal(p_78375_1_, p_78375_2_, p_78375_3_);
            return this;
        }

        public int draw() {
            return this.t.draw();
        }
    }

    private static class RetroBuffer
    extends DirectBuffer<RetroTessellator> {
        private RenderStage stage;

        public RetroBuffer(RetroTessellator tes, RenderStage stage) {
            super(tes);
            this.stage = stage;
            stage.begin((RetroTessellator)this.buffer);
        }

        @Override
        protected void pushVertex(float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, float nx, float ny, float nz) {
            ((RetroTessellator)this.buffer).pos(x, y, z);
            if (this.stage.texture) {
                ((RetroTessellator)this.buffer).tex(u, v);
            }
            if (this.stage.color) {
                ((RetroTessellator)this.buffer).color(red, green, blue, alpha);
            }
            if (this.stage.normal) {
                ((RetroTessellator)this.buffer).normal(nx, ny, nz);
            }
            ((RetroTessellator)this.buffer).endVertex();
        }

        @Override
        public void finish() {
            ((RetroTessellator)this.buffer).draw();
            this.stage.end();
        }

        @Override
        public void addVertex(MatrixStack.Entry entry, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
            VertexBuffer$.addVertex(this, entry, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        }

        @Override
        public void addVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
            VertexBuffer$.addVertex(this, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        }

        @Override
        public VertexBuffer normal(Mat3f mat3f, float f, float f2, float f3) {
            return VertexBuffer$.normal(this, mat3f, f, f2, f3);
        }

        @Override
        public VertexBuffer pos(Mat4f mat4f, float f, float f2, float f3) {
            return VertexBuffer$.pos(this, mat4f, f, f2, f3);
        }

        @Override
        public VertexBuffer color(int n) {
            return VertexBuffer$.color(this, n);
        }
    }

    private static class RenderStage
    implements RetroGLAccess.RetroLayer {
        private boolean color;
        private boolean texture;
        private boolean normal;
        private Runnable begin;
        private Runnable end;
        private int glMode;

        public RenderStage(boolean color, boolean texture, boolean normal, Runnable begin, Runnable end, int glMode) {
            this.color = color;
            this.texture = texture;
            this.normal = normal;
            this.begin = begin;
            this.end = end;
            this.glMode = glMode;
        }

        public void begin(RetroTessellator buf) {
            this.begin.run();
            buf.begin(this.glMode);
        }

        public void end() {
            this.end.run();
        }
    }
}

