/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.command.CommandHandler$;
import com.tom.cpl.command.StringCommandHandler;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.text.IText;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.common.Command$CommandHandlerBase$$Lambda$1;
import com.tom.cpm.common.Command$CommandHandlerBase$$Lambda$2;
import com.tom.cpm.common.Command$CommandHandlerBase$$Lambda$3;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.src.EntityPlayer;

public class Command {

    public static abstract class CommandHandlerBase<L>
    extends StringCommandHandler<Void, L, CommandException> {
        private Map<String, StringCommandHandler.CommandImpl> commands;

        public CommandHandlerBase(Map<String, StringCommandHandler.CommandImpl> commands) {
            super(Command$CommandHandlerBase$$Lambda$1.lambdaFactory$(commands), false);
            this.commands = commands;
        }

        public CommandHandlerBase() {
            this(new HashMap<String, StringCommandHandler.CommandImpl>());
        }

        @Override
        public String toStringPlayer(Object pl) {
            return ((EntityPlayer)pl).username;
        }

        public boolean onCommand(L sender, String fullText) {
            try {
                String[] sp = fullText.split(" ");
                StringCommandHandler.CommandImpl cmd = this.commands.get(sp[0]);
                if (cmd != null) {
                    cmd.execute(null, sender, Arrays.copyOfRange(sp, 1, sp.length));
                    return true;
                }
            }
            catch (CommandException e) {
                this.sendMessage(sender, "\u00a7c" + (String)e.msg.remap());
                return true;
            }
            return false;
        }

        public List<String> onTabComplete(String command) {
            String[] sp = command.split(" ");
            try {
                StringCommandHandler.CommandImpl cmd = this.commands.get(sp[0]);
                if (cmd != null) {
                    return cmd.getTabCompletions(null, null, Arrays.copyOfRange(sp, 1, sp.length));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Collections.emptyList();
        }

        @Override
        public void sendSuccess(L sender, IText text) {
            this.sendMessage(sender, (String)text.remap());
        }

        protected abstract void sendMessage(L var1, String var2);

        @Override
        public CommandException generic(String text, Object ... format) {
            return new CommandException(new FormatText(text, format));
        }

        @Override
        public CommandException wrongUsage(String text, Object ... format) {
            return new CommandException(new FormatText(text, format));
        }

        @Override
        public Object getPlayerObj(Void server, L sender, String name) throws CommandException {
            return CustomPlayerModels.proxy.getPlayersOnline().stream().filter(Command$CommandHandlerBase$$Lambda$2.lambdaFactory$(name)).findFirst().orElse(null);
        }

        @Override
        public CommandException checkExc(Exception exc) {
            if (exc instanceof CommandException) {
                return (CommandException)exc;
            }
            return new CommandException(new FormatText("commands.generic.exception", new Object[0]));
        }

        @Override
        public List<String> getOnlinePlayers(Void server) {
            return CustomPlayerModels.proxy.getPlayersOnline().stream().map(Command$CommandHandlerBase$$Lambda$3.lambdaFactory$()).collect(Collectors.toList());
        }

        static /* synthetic */ String lambda$getOnlinePlayers$2(EntityPlayer e) {
            return e.username;
        }

        static /* synthetic */ boolean lambda$getPlayerObj$1(String name, EntityPlayer e) {
            return e.username.equals(name);
        }

        static /* synthetic */ void lambda$new$0(Map commands, StringCommandHandler.CommandImpl i) {
            commands.put(i.getName(), i);
        }

        @Override
        public void registerClient() {
            CommandHandler$.registerClient(this);
        }

        @Override
        public void registerCommon() {
            CommandHandler$.registerCommon(this);
        }
    }

    private static class CommandException
    extends Exception {
        private static final long serialVersionUID = 3508944502637337553L;
        private IText msg;

        public CommandException(IText msg) {
            this.msg = msg;
        }
    }
}

