/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.item.ItemStackHandler;
import com.tom.cpl.item.NbtMapper;
import com.tom.cpl.item.Stack;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.common.ItemStackHandlerImpl$$Lambda$1;
import forge.oredict.OreDictionary;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTBase;
import net.minecraft.src.NBTTagByteArray;
import net.minecraft.src.NBTTagIntArray;
import net.minecraft.src.NBTTagList;

public class ItemStackHandlerImpl
extends ItemStackHandler<ItemStack> {
    private static final String AIR = "minecraft:air";
    public static final ItemStackHandlerImpl impl = new ItemStackHandlerImpl();
    public static final NBT nbt = new NBT();
    private static Map<String, Integer> oreIDs;

    @Override
    public int getCount(ItemStack stack) {
        return stack == null ? 0 : stack.stackSize;
    }

    @Override
    public int getMaxCount(ItemStack stack) {
        return stack == null ? 0 : stack.getMaxStackSize();
    }

    @Override
    public int getDamage(ItemStack stack) {
        return stack == null ? 0 : stack.getItemDamage();
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return stack == null ? 0 : stack.getMaxDamage();
    }

    @Override
    public boolean itemEquals(ItemStack a, ItemStack b) {
        return a == null && b == null ? true : (a != null && b != null ? (!a.isItemStackDamageable() ? a.isItemEqual(b) : a.getItem() == b.getItem()) : false);
    }

    @Override
    public boolean itemEqualsFull(ItemStack a, ItemStack b) {
        return (a == null && b == null || a != null && b != null && a.isItemEqual(b)) && ItemStack.func_46154_a((ItemStack)a, (ItemStack)b);
    }

    @Override
    public List<String> listNativeTags() {
        return Collections.emptyList();
    }

    @Override
    public List<Stack> getAllElements() {
        ArrayList stacks = new ArrayList();
        for (int i = 0; i < Item.itemsList.length; ++i) {
            Item item = Item.itemsList[i];
            if (item == null) continue;
            item.addCreativeItems(stacks);
        }
        return stacks.stream().map(ItemStackHandlerImpl$$Lambda$1.lambdaFactory$(this)).collect(Collectors.toList());
    }

    @Override
    public NBTTagCompound getTag(ItemStack stack) {
        return stack != null && stack.hasTagCompound() ? nbt.wrap(stack.getTagCompound()) : null;
    }

    @Override
    public List<Stack> listNativeEntries(String tag) {
        return Collections.emptyList();
    }

    @Override
    public boolean isInTag(String tag, ItemStack stack) {
        if (tag.charAt(0) == '#') {
            return ItemStackHandlerImpl.checkIdMetaTags(tag, stack.itemID, stack.getItemDamage());
        }
        if (stack == null) {
            return false;
        }
        return this.getItemId(stack).equals(tag);
    }

    public static boolean checkIdMetaTags(String tag, int id, int meta) {
        if (tag.startsWith("#id:")) {
            Integer i = ItemStackHandlerImpl.parseInt(tag = tag.substring(4));
            if (i == null) {
                return false;
            }
            return i == id;
        }
        if (tag.startsWith("#idmeta:")) {
            String[] sp = (tag = tag.substring(8)).split("/");
            if (sp.length != 2) {
                return false;
            }
            Integer i = ItemStackHandlerImpl.parseInt(sp[0]);
            Integer m = ItemStackHandlerImpl.parseInt(sp[1]);
            if (i == null || m == null) {
                return false;
            }
            return i == id && m == meta;
        }
        return false;
    }

    private static Integer parseInt(String tag) {
        try {
            return Integer.parseInt(tag);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public List<String> listTags(ItemStack stack) {
        if (stack == null) {
            return Collections.emptyList();
        }
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("#idmeta:" + stack.itemID + "/" + stack.getItemDamage());
        tags.add("#id:" + stack.itemID);
        return tags;
    }

    @Override
    public String getItemId(ItemStack stack) {
        if (stack == null) {
            return AIR;
        }
        return "unloc:" + stack.getItem().getItemName();
    }

    @Override
    public Stack emptyObject() {
        return this.wrap(null);
    }

    @Override
    public String getItemDisplayName(ItemStack stack) {
        return stack.getItem().getItemName();
    }

    static {
        try {
            Field oi = OreDictionary.class.getDeclaredField("oreIDs");
            oi.setAccessible(true);
            oreIDs = (Map)oi.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class NBT
    extends NbtMapper<NBTBase, net.minecraft.src.NBTTagCompound, NBTTagList, NBTPrimitive> {
        @Override
        public long getLong(NBTPrimitive t) {
            return t.cpm$getLong();
        }

        @Override
        public int getInt(NBTPrimitive t) {
            return t.cpm$getInt();
        }

        @Override
        public short getShort(NBTPrimitive t) {
            return t.cpm$getShort();
        }

        @Override
        public byte getByte(NBTPrimitive t) {
            return t.cpm$getByte();
        }

        @Override
        public double getDouble(NBTPrimitive t) {
            return t.cpm$getDouble();
        }

        @Override
        public float getFloat(NBTPrimitive t) {
            return t.cpm$getFloat();
        }

        @Override
        public NBTPrimitive asNumber(NBTBase t) {
            return t instanceof NBTPrimitive ? (NBTPrimitive)t : null;
        }

        @Override
        public String getString(NBTBase t) {
            return t.toString();
        }

        @Override
        public NBTBase getTag(net.minecraft.src.NBTTagCompound t, String name) {
            return t.getTag(name);
        }

        @Override
        public NBTTagList asList(NBTBase t) {
            return t instanceof NBTTagList ? (NBTTagList)t : null;
        }

        @Override
        public net.minecraft.src.NBTTagCompound asCompound(NBTBase t) {
            return t instanceof net.minecraft.src.NBTTagCompound ? (net.minecraft.src.NBTTagCompound)t : null;
        }

        @Override
        public int listSize(NBTTagList t) {
            return t.tagCount();
        }

        @Override
        public NBTBase getAt(NBTTagList t, int i) {
            return t.tagAt(i);
        }

        @Override
        public boolean contains(net.minecraft.src.NBTTagCompound t, String name, int type) {
            if (!t.hasKey(name)) {
                return false;
            }
            return t.getTag(name).setScheduledTime() == type;
        }

        @Override
        public net.minecraft.src.NBTTagCompound newCompound() {
            return new net.minecraft.src.NBTTagCompound();
        }

        @Override
        public NBTTagList newList() {
            return new NBTTagList();
        }

        @Override
        public Iterable<String> keys(net.minecraft.src.NBTTagCompound t) {
            return t.tagMap.keySet();
        }

        @Override
        public int getId(NBTBase t) {
            return t.setScheduledTime();
        }

        @Override
        public byte[] getByteArray(NBTBase t) {
            return t instanceof NBTTagByteArray ? ((NBTTagByteArray)t).byteArray : new byte[]{};
        }

        @Override
        public int[] getIntArray(NBTBase t) {
            return t instanceof NBTTagIntArray ? ((NBTTagIntArray)t).field_48181_a : new int[]{};
        }

        @Override
        public long[] getLongArray(NBTBase t) {
            return new long[0];
        }
    }

    public static interface NBTPrimitive {
        public long cpm$getLong();

        public int cpm$getInt();

        public short cpm$getShort();

        public byte cpm$getByte();

        public double cpm$getDouble();

        public float cpm$getFloat();
    }
}

