/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.retro;

import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.skin.TextureType;
import java.util.Base64;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GameProfile {
    private final UUID id;
    private final String name;
    private String skinType;
    private Map<TextureType, String> textureURLMap = new EnumMap<TextureType, String>(TextureType.class);

    public GameProfile(UUID id, String name) {
        if (id == null && name.isEmpty()) {
            throw new IllegalArgumentException("Name and ID cannot both be blank");
        }
        this.id = id;
        this.name = name;
        this.skinType = "default";
    }

    public GameProfile(Map<String, Object> data) {
        this.id = GameProfile.fromString((String)data.get("id"));
        this.name = (String)data.get("name");
        this.skinType = "default";
        if (this.id == null || this.name == null) {
            throw new IllegalArgumentException("Invalid details");
        }
        List pr = (List)data.get("properties");
        for (Map map : pr) {
            if (!"textures".equals(map.get("name"))) continue;
            String val = new String(Base64.getDecoder().decode((String)map.get("value")));
            Map p = (Map)MinecraftObjectHolder.gson.fromJson(val, Object.class);
            Map tex = (Map)p.get("textures");
            for (Map.Entry entry : tex.entrySet()) {
                TextureType tt = TextureType.valueOf((String)entry.getKey());
                String url = (String)((Map)entry.getValue()).get("url");
                Object meta = ((Map)entry.getValue()).get("metadata");
                if (tt == TextureType.SKIN && meta != null) {
                    this.skinType = (String)((Map)meta).get("model");
                }
                if (this.skinType == null) {
                    this.skinType = "default";
                }
                if (!url.startsWith("http://textures.minecraft.net/texture/")) continue;
                this.textureURLMap.put(tt, url);
            }
        }
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GameProfile that = (GameProfile)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GameProfile[id=" + this.id + ", name=" + this.name + "]";
    }

    private static UUID fromString(String input) {
        return UUID.fromString(input.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
    }

    public Map<TextureType, String> getTextureURLMap() {
        return this.textureURLMap;
    }
}

