/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.retro;

import com.tom.cpm.externals.com.google.common.cache.CacheBuilder;
import com.tom.cpm.externals.com.google.common.cache.CacheLoader;
import com.tom.cpm.externals.com.google.common.cache.LoadingCache;
import com.tom.cpm.retro.GameProfile;
import com.tom.cpm.retro.GameProfileManager$$Lambda$1;
import com.tom.cpm.retro.GameProfileManager$ProfileLookup$$Lambda$1;
import com.tom.cpm.retro.GameProfileManager$ProfileLookup$$Lambda$2;
import com.tom.cpm.retro.GameProfileManager$ProfileLookup$$Lambda$3;
import com.tom.cpm.retro.GameProfileManager$ProfileLookup$$Lambda$4;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.io.HTTPIO;
import com.tom.cpm.shared.skin.TextureType;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpm.shared.util.Log;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class GameProfileManager {
    private static final LoadingCache<String, ProfileLookup> usernameCache = CacheBuilder.newBuilder().build(CacheLoader.from(GameProfileManager$$Lambda$1.lambdaFactory$()));

    public static GameProfile getProfile(String name) {
        try {
            return usernameCache.get(name).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to load player details: " + name, e);
        }
    }

    public static CompletableFuture<GameProfile> getProfileFuture(String name) {
        try {
            return usernameCache.get(name).getFuture();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to load player details: " + name, e);
        }
    }

    private static void checkError(Map<String, Object> r) throws IOException {
        if (r == null) {
            throw new IOException("Invalid data returned from the server");
        }
        if (r.containsKey("error") || r.containsKey("errorMessage")) {
            String error = String.valueOf(r.get("error"));
            throw new IOException(error + ": " + String.valueOf(r.get("errorMessage")));
        }
    }

    public static String getTextureUrlSync(String username, TextureType type, String fallback) {
        try {
            return GameProfileManager.getProfileFuture(username).get().getTextureURLMap().getOrDefault((Object)type, fallback);
        }
        catch (InterruptedException | ExecutionException e) {
            return fallback;
        }
    }

    public static void clear() {
        usernameCache.invalidateAll();
    }

    private static class ProfileLookup {
        private GameProfile profile;
        private CompletableFuture<GameProfile> future;
        private Throwable exception;

        public ProfileLookup(String name) {
            UUID offline = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
            this.profile = new GameProfile(offline, name);
            if (name.isEmpty()) {
                this.future = CompletableFuture.completedFuture(this.profile);
                return;
            }
            Supplier supplier = GameProfileManager$ProfileLookup$$Lambda$1.lambdaFactory$(this);
            ModelDefinitionLoader modelDefinitionLoader = MinecraftClientAccess$.get().getDefinitionLoader();
            modelDefinitionLoader.getClass();
            CompletableFuture completableFuture = CompletableFuture.supplyAsync(supplier, GameProfileManager$ProfileLookup$$Lambda$2.lambdaFactory$(modelDefinitionLoader));
            BiFunction biFunction = GameProfileManager$ProfileLookup$$Lambda$3.lambdaFactory$(this);
            MinecraftClientAccess minecraftClientAccess = MinecraftClientAccess$.get();
            minecraftClientAccess.getClass();
            this.future = completableFuture.handleAsync(biFunction, GameProfileManager$ProfileLookup$$Lambda$4.lambdaFactory$(minecraftClientAccess));
        }

        private GameProfile load() {
            String name = this.profile.getName();
            Log.debug("Fetching profile info: " + name);
            try {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
                HttpURLConnection httpCon = HTTPIO.createUrlConnection(url, true);
                String resp = HTTPIO.getResponse(httpCon, url);
                Map r = (Map)MinecraftObjectHolder.gson.fromJson(resp, Object.class);
                GameProfileManager.checkError(r);
                String rawId = (String)r.get("id");
                Log.debug(name + ": " + rawId);
                url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + rawId);
                httpCon = HTTPIO.createUrlConnection(url, true);
                resp = HTTPIO.getResponse(httpCon, url);
                r = (Map)MinecraftObjectHolder.gson.fromJson(resp, Object.class);
                GameProfileManager.checkError(r);
                return new GameProfile(r);
            }
            catch (Exception e) {
                ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load profile info for: " + name, e);
                return this.profile;
            }
        }

        public GameProfile get() {
            return this.profile;
        }

        public CompletableFuture<GameProfile> getFuture() {
            return this.future;
        }

        public Throwable getException() {
            return this.exception;
        }

        static /* synthetic */ GameProfile lambda$new$0(ProfileLookup this_, GameProfile r, Throwable ex) {
            if (ex != null) {
                this_.exception = ex;
                return this_.profile;
            }
            this_.profile = r;
            return this_.profile;
        }

        static /* synthetic */ GameProfile access$lambda$0(ProfileLookup profileLookup) {
            return profileLookup.load();
        }
    }
}

