/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.server;

import com.tom.cpl.command.CommandHandler$;
import com.tom.cpl.text.IText;
import com.tom.cpm.CommonProxy;
import com.tom.cpm.common.Command;
import com.tom.cpm.common.ServerNetworkImpl;
import com.tom.cpm.shared.util.Log;
import cpw.mods.fml.server.FMLServerHandler;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.EntityTracker;
import net.minecraft.src.EntityTrackerEntry;
import net.minecraft.src.ICommandListener;
import net.minecraft.src.WorldServer;

public class ServerProxy
extends CommonProxy {
    private static final Command.CommandHandlerBase<ICommandListener> cpm = new Command.CommandHandlerBase<ICommandListener>(){

        @Override
        protected void sendMessage(ICommandListener sender, String string) {
            sender.log(string);
        }

        @Override
        public void sendSuccess(ICommandListener sender, IText text) {
            String t = (String)text.remap();
            sender.log(t);
            String r = sender.getUsername();
            t = "[" + r + ": " + t + "]";
            Log.info(t);
            FMLServerHandler.instance().getServer().configManager.sendChatMessageToAllOps("\u00a77\u00a7o" + t);
        }

        @Override
        public void registerClient() {
            CommandHandler$.registerClient(this);
        }

        @Override
        public void registerCommon() {
            CommandHandler$.registerCommon(this);
        }
    };

    public static CommonProxy makeProxy() {
        return new ServerProxy();
    }

    @Override
    public void getTracking(EntityPlayer player, Consumer<EntityPlayer> f) {
        for (EntityTrackerEntry tr : ((WorldServer)player.worldObj).entityTracker.trackedEntitySet) {
            if (!(tr.trackedEntity instanceof EntityPlayer) || !tr.trackedPlayers.contains(player)) continue;
            f.accept((EntityPlayer)((EntityPlayerMP)tr.trackedEntity));
        }
    }

    @Override
    public Set<EntityPlayer> getTrackingPlayers(Entity entity) {
        EntityTracker et = ((WorldServer)entity.worldObj).entityTracker;
        EntityTrackerEntry entry = (EntityTrackerEntry)et.trackedEntityHashTable.lookup(entity.entityId);
        if (entry == null) {
            return Collections.emptySet();
        }
        return entry.trackedPlayers;
    }

    @Override
    public List<EntityPlayer> getPlayersOnline() {
        return FMLServerHandler.instance().getServer().configManager.playerEntities;
    }

    @Override
    public ServerNetworkImpl getServer(EntityPlayer pl) {
        return (ServerNetworkImpl)((EntityPlayerMP)pl).playerNetServerHandler;
    }

    @Override
    public boolean runCommand(String command, String sender, Object listener) {
        return cpm.onCommand((ICommandListener)listener, command);
    }
}

