/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared;

import com.tom.cpl.command.ArgType;
import com.tom.cpl.command.CommandCtx;
import com.tom.cpl.command.CommandHandler;
import com.tom.cpl.command.LiteralCommandBuilder;
import com.tom.cpl.command.RequiredCommandBuilder;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$1;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$10;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$11;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$12;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$13;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$14;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$15;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$16;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$17;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$2;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$3;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$4;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$5;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$6;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$7;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$8;
import com.tom.cpm.shared.CommandCPMClient$$Lambda$9;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.gui.SocialGui;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CommandCPMClient {
    public static void register(CommandHandler<?> dispatcher) {
        LiteralCommandBuilder cpm = (LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)new LiteralCommandBuilder("cpmclient").then(new LiteralCommandBuilder("profile").then(new RequiredCommandBuilder("player", ArgType.STRING, false).setPossibleValues(CommandCPMClient$$Lambda$1.lambdaFactory$()).run(CommandCPMClient$$Lambda$2.lambdaFactory$())))).then(new LiteralCommandBuilder("safety").run(CommandCPMClient$$Lambda$3.lambdaFactory$()))).then(new LiteralCommandBuilder("animate").then(((RequiredCommandBuilder)new RequiredCommandBuilder("animation", ArgType.STRING, false).setPossibleValues(CommandCPMClient$$Lambda$4.lambdaFactory$()).run(CommandCPMClient$$Lambda$5.lambdaFactory$())).then(new RequiredCommandBuilder("value", ArgType.INT, Pair.of(0, 255)).run(CommandCPMClient$$Lambda$6.lambdaFactory$()))))).then(new LiteralCommandBuilder("set_model").then(new RequiredCommandBuilder("model", ArgType.STRING, false).setPossibleValues(CommandCPMClient$$Lambda$7.lambdaFactory$()).run(CommandCPMClient$$Lambda$8.lambdaFactory$())))).then(new LiteralCommandBuilder("reset_model").run(CommandCPMClient$$Lambda$9.lambdaFactory$()));
        dispatcher.register(cpm, false);
    }

    private static void resetModel() {
        ModConfig.getCommonConfig().clearValue("selectedModel");
        ModConfig.getCommonConfig().save();
        if (MinecraftClientAccess$.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
            MinecraftClientAccess$.get().sendSkinUpdate();
        }
    }

    private static void setModel(CommandCtx<?> context) {
        if (MinecraftClientAccess$.get().getServerSideStatus() != MinecraftClientAccess.ServerStatus.INSTALLED) {
            context.fail(new FormatText("label.cpm.feature_unavailable", new Object[0]));
            return;
        }
        String modelF = (String)context.getArgument("model");
        if (!CommandCPMClient.getModelsList(context).contains(modelF)) {
            context.fail(new FormatText("commands.cpmclient.set_model.not_found", modelF));
            return;
        }
        ModConfig.getCommonConfig().setString("selectedModel", modelF);
        ModConfig.getCommonConfig().save();
        MinecraftClientAccess$.get().sendSkinUpdate();
    }

    private static List<String> getModelsList(CommandCtx<?> c) {
        ArrayList<String> l = new ArrayList<String>();
        File modelsDir = new File(MinecraftClientAccess$.get().getGameDir(), "player_models");
        if (modelsDir.exists()) {
            CommandCPMClient.walkDirs(modelsDir, null, l);
        }
        return l;
    }

    private static void walkDirs(File d, String path, List<String> l) {
        File[] fs = d.listFiles(CommandCPMClient$$Lambda$10.lambdaFactory$());
        for (int i = 0; i < fs.length; ++i) {
            String p;
            File f = fs[i];
            if (f.getName().equals(".temp.cpmmodel") || f.getName().equals("autosaves")) continue;
            String string = p = path != null ? path + "/" + f.getName() : f.getName();
            if (f.isDirectory()) {
                CommandCPMClient.walkDirs(f, p, l);
                continue;
            }
            l.add(p);
        }
    }

    private static void openProfile(String player) {
        ModelDefinitionLoader d = MinecraftClientAccess$.get().getDefinitionLoader();
        for (Object gp : MinecraftClientAccess$.get().getPlayers()) {
            if (!player.equals(d.getGP_Name(gp))) continue;
            UUID uuid = d.getGP_UUID(gp);
            CommandCPMClient.openGui(CommandCPMClient$$Lambda$11.lambdaFactory$(uuid));
            return;
        }
    }

    private static List<String> getPlayers() {
        ModelDefinitionLoader d = MinecraftClientAccess$.get().getDefinitionLoader();
        Stream stream = MinecraftClientAccess$.get().getPlayers().stream();
        ModelDefinitionLoader modelDefinitionLoader = d;
        modelDefinitionLoader.getClass();
        return stream.map(CommandCPMClient$$Lambda$12.lambdaFactory$(modelDefinitionLoader)).filter(CommandCPMClient$$Lambda$13.lambdaFactory$()).collect(Collectors.toList());
    }

    private static void openSafety() {
        CommandCPMClient.openGui(CommandCPMClient$$Lambda$14.lambdaFactory$());
    }

    private static void openGui(Function<IGui, Frame> creator) {
        MinecraftClientAccess$.get().executeNextFrame(CommandCPMClient$$Lambda$15.lambdaFactory$(creator));
    }

    private static List<String> getAnimationList(CommandCtx<?> context) {
        ArrayList<String> l = new ArrayList<String>();
        Player<?> player = MinecraftClientAccess$.get().getCurrentClientPlayer();
        ModelDefinition def = player.getModelDefinition();
        if (def != null) {
            AnimationRegistry ar = def.getAnimations();
            return ar.getCommandActionsMap().entrySet().stream().filter(CommandCPMClient$$Lambda$16.lambdaFactory$()).map(CommandCPMClient$$Lambda$17.lambdaFactory$()).collect(Collectors.toList());
        }
        return l;
    }

    private static void setAnimation(CommandCtx<?> context, int value) {
        String id = (String)context.getArgument("animation");
        if (!CommandCPMClient.playAnimation(id, value)) {
            context.fail(new FormatText("commands.cpmclient.animate.invalid", id));
        }
    }

    private static boolean playAnimation(String id, int value) {
        AnimationEngine an = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine();
        return an.applyCommand(id, value, false);
    }

    static /* synthetic */ boolean lambda$getAnimationList$13(Map.Entry e) {
        return !((CommandAction)e.getValue()).isCommandControlled();
    }

    static /* synthetic */ void lambda$openGui$12(Function creator) {
        MinecraftClientAccess$.get().openGui(creator);
    }

    static /* synthetic */ boolean lambda$getPlayers$11(String e) {
        return e != null;
    }

    static /* synthetic */ Frame lambda$openProfile$10(UUID uuid, IGui g) {
        return new SocialGui(g, uuid);
    }

    static /* synthetic */ boolean lambda$walkDirs$9(File f, String n) {
        return n.endsWith(".cpmmodel") || new File(f, n).isDirectory();
    }

    static /* synthetic */ void lambda$register$8(CommandCtx c) {
        CommandCPMClient.resetModel();
    }

    static /* synthetic */ void lambda$register$7(CommandCtx c) {
        CommandCPMClient.setModel(c);
    }

    static /* synthetic */ List lambda$register$6(CommandCtx c) {
        return CommandCPMClient.getModelsList(c);
    }

    static /* synthetic */ void lambda$register$5(CommandCtx c) {
        CommandCPMClient.setAnimation(c, (Integer)c.getArgument("value"));
    }

    static /* synthetic */ void lambda$register$4(CommandCtx c) {
        CommandCPMClient.setAnimation(c, -1);
    }

    static /* synthetic */ List lambda$register$3(CommandCtx c) {
        return CommandCPMClient.getAnimationList(c);
    }

    static /* synthetic */ void lambda$register$2(CommandCtx c) {
        CommandCPMClient.openSafety();
    }

    static /* synthetic */ void lambda$register$1(CommandCtx c) {
        CommandCPMClient.openProfile((String)c.getArgument("player"));
    }

    static /* synthetic */ List lambda$register$0() {
        return CommandCPMClient.getPlayers();
    }
}

