/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationHandler$$Lambda$1;
import com.tom.cpm.shared.animation.AnimationHandler$$Lambda$2;
import com.tom.cpm.shared.animation.AnimationHandler$$Lambda$3;
import com.tom.cpm.shared.animation.AnimationHandler$$Lambda$4;
import com.tom.cpm.shared.animation.AnimationHandler$$Lambda$5;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.AnimationTrigger;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

public class AnimationHandler {
    private final Supplier<ModelDefinition> player;
    private final AnimationEngine.AnimationMode mode;
    private List<PlayingAnim> currentAnimations = new ArrayList<PlayingAnim>();
    private List<NextAnim> nextAnims = new ArrayList<NextAnim>();

    public AnimationHandler(Supplier<ModelDefinition> player, AnimationEngine.AnimationMode mode) {
        this.player = player;
        this.mode = mode;
    }

    public void animate(AnimationState state, long currentTime) {
        boolean needsSort = false;
        this.currentAnimations.removeIf(AnimationHandler$$Lambda$1.lambdaFactory$(this));
        for (NextAnim animation : this.nextAnims) {
            boolean found = false;
            for (int i = 0; i < this.currentAnimations.size(); ++i) {
                if (this.currentAnimations.get(i).currentAnimation != animation.animation) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.currentAnimations.add(new PlayingAnim(animation, currentTime));
            needsSort = true;
        }
        if (needsSort) {
            this.currentAnimations.sort(Comparator.comparingInt(AnimationHandler$$Lambda$2.lambdaFactory$(this)));
        }
        this.player.get().resetAnimationPos();
        for (PlayingAnim a : this.currentAnimations) {
            if (a.finished) continue;
            long currentStep = currentTime - a.currentStart;
            a.currentAnimation.animate(a.getTime(state, currentStep), this.player.get(), this.mode);
            if (!a.loop && currentStep / (long)a.currentAnimation.getDuration(this.mode) != a.lastFrame / (long)a.currentAnimation.getDuration(this.mode)) {
                a.finished = true;
            }
            a.lastFrame = currentStep;
        }
        this.nextAnims.clear();
    }

    public void addAnimations(List<AnimationTrigger> next, IPose pose) {
        Player<?> pl = this.player.get().getPlayerObj();
        next.stream().filter(AnimationHandler$$Lambda$3.lambdaFactory$(this, pl)).forEach(AnimationHandler$$Lambda$4.lambdaFactory$(this));
    }

    public void clear() {
        this.nextAnims.clear();
        this.currentAnimations.clear();
    }

    static /* synthetic */ void lambda$addAnimations$4(AnimationHandler this_, AnimationTrigger t) {
        for (IAnimation a : t.animations) {
            this_.nextAnims.add(new NextAnim(a, t));
        }
    }

    static /* synthetic */ boolean lambda$addAnimations$3(AnimationHandler this_, Player pl, AnimationTrigger t) {
        return t.canPlay(pl, this_.mode);
    }

    static /* synthetic */ int lambda$animate$2(AnimationHandler this_, PlayingAnim e) {
        return e.currentAnimation.getPriority(this_.mode);
    }

    static /* synthetic */ boolean lambda$animate$1(AnimationHandler this_, PlayingAnim a) {
        return this_.nextAnims.stream().noneMatch(AnimationHandler$$Lambda$5.lambdaFactory$(a)) && a.checkAndUpdateRemove(this_.mode);
    }

    static /* synthetic */ boolean lambda$null$0(PlayingAnim a, NextAnim n) {
        return n.animation == a.currentAnimation;
    }

    private class PlayingAnim {
        private IAnimation currentAnimation;
        private AnimationTrigger trigger;
        private long currentStart;
        private long lastFrame;
        private boolean loop;
        private boolean finished;
        private boolean mustFinish;

        public PlayingAnim(NextAnim anim, long currentStart) {
            this.currentAnimation = anim.animation;
            this.currentAnimation.prepare(AnimationHandler.this.mode);
            this.trigger = anim.trigger;
            this.currentStart = currentStart;
            this.loop = anim.isLoop();
            this.finished = false;
            this.mustFinish = ((NextAnim)anim).trigger.mustFinish;
        }

        public boolean checkAndUpdateRemove(AnimationEngine.AnimationMode mode) {
            if (this.mustFinish) {
                this.loop = false;
                return this.currentAnimation.checkAndUpdateRemove(mode) && this.finished;
            }
            return this.currentAnimation.checkAndUpdateRemove(mode);
        }

        public long getTime(AnimationState state, long time) {
            if (this.trigger == null || !this.currentAnimation.useTriggerTime()) {
                return time;
            }
            return this.trigger.getTime(state, time);
        }
    }

    private static class NextAnim {
        private IAnimation animation;
        private AnimationTrigger trigger;

        public NextAnim(IAnimation animation, AnimationTrigger trigger) {
            this.animation = animation;
            this.trigger = trigger;
        }

        public boolean isLoop() {
            return this.trigger.looping;
        }
    }
}

