/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationTrigger;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.StagedAnimation$$Lambda$1;
import com.tom.cpm.shared.animation.StagedAnimation$$Lambda$2;
import com.tom.cpm.shared.animation.StagedAnimation$$Lambda$3;
import com.tom.cpm.shared.animation.StagedAnimation$Anim$$Lambda$1;
import com.tom.cpm.shared.animation.StagedAnimation$Anim$$Lambda$2;
import com.tom.cpm.shared.animation.StagedAnimation$Anim$$Lambda$3;
import com.tom.cpm.shared.definition.ModelDefinition;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class StagedAnimation {
    private Map<AnimationEngine.AnimationMode, Stage> currentStage = new EnumMap<AnimationEngine.AnimationMode, Stage>(AnimationEngine.AnimationMode.class);
    private List<Anim> pre = new ArrayList<Anim>();
    private List<Anim> play = new ArrayList<Anim>();
    private List<Anim> post = new ArrayList<Anim>();
    private List<IAnimation> all = new ArrayList<IAnimation>();

    @Deprecated
    public IAnimation addPre(IAnimation anim) {
        Anim a = new Anim(null, anim, Stage.SETUP);
        this.pre.add(a);
        this.all.add(a);
        return a;
    }

    @Deprecated
    public IAnimation addPlay(IAnimation anim, boolean mustFinish) {
        if (anim instanceof Anim) {
            return anim;
        }
        Anim a = new Anim(mustFinish, anim, Stage.PLAY);
        this.play.add(a);
        this.all.add(a);
        return a;
    }

    @Deprecated
    public IAnimation addPost(IAnimation anim) {
        Anim a = new Anim(null, anim, Stage.FINISH);
        this.post.add(a);
        this.all.add(a);
        return a;
    }

    public void addPre(AnimationTrigger tr) {
        tr.animations.forEach(StagedAnimation$$Lambda$1.lambdaFactory$(this, tr));
    }

    public void addPlay(AnimationTrigger tr) {
        tr.animations.forEach(StagedAnimation$$Lambda$2.lambdaFactory$(this, tr));
    }

    public void addPost(AnimationTrigger tr) {
        tr.animations.forEach(StagedAnimation$$Lambda$3.lambdaFactory$(this, tr));
    }

    public List<IAnimation> getAll() {
        return this.all;
    }

    static /* synthetic */ void lambda$addPost$2(StagedAnimation this_, AnimationTrigger tr, IAnimation anim) {
        Anim a = this_.new Anim(tr, anim, Stage.FINISH);
        this_.post.add(a);
        this_.all.add(a);
    }

    static /* synthetic */ void lambda$addPlay$1(StagedAnimation this_, AnimationTrigger tr, IAnimation anim) {
        Anim a = this_.new Anim(tr, anim, Stage.PLAY);
        this_.play.add(a);
        this_.all.add(a);
    }

    static /* synthetic */ void lambda$addPre$0(StagedAnimation this_, AnimationTrigger tr, IAnimation anim) {
        Anim a = this_.new Anim(tr, anim, Stage.SETUP);
        this_.pre.add(a);
        this_.all.add(a);
    }

    public static enum Stage {
        SETUP,
        PLAY,
        FINISH;

    }

    private class Anim
    implements IAnimation {
        private final AnimationTrigger tr;
        private final IAnimation parent;
        private final Stage stage;
        private Map<AnimationEngine.AnimationMode, AnimData> data = new EnumMap<AnimationEngine.AnimationMode, AnimData>(AnimationEngine.AnimationMode.class);
        private boolean mustFinish;

        public Anim(AnimationTrigger tr, IAnimation parent, Stage stage) {
            this.tr = tr;
            this.parent = parent;
            this.stage = stage;
            this.mustFinish = stage == Stage.PLAY && tr.mustFinish;
        }

        @Deprecated
        public Anim(boolean mustFinish, IAnimation parent, Stage stage) {
            this.tr = null;
            this.mustFinish = mustFinish;
            this.parent = parent;
            this.stage = stage;
        }

        @Override
        public int getDuration(AnimationEngine.AnimationMode mode) {
            if (this.stage == Stage.FINISH) {
                return Integer.MAX_VALUE;
            }
            return this.parent.getDuration(mode);
        }

        @Override
        public int getPriority(AnimationEngine.AnimationMode mode) {
            return this.parent.getPriority(mode);
        }

        @Override
        public void animate(long millis, ModelDefinition def, AnimationEngine.AnimationMode mode) {
            AnimData d = this.data.get((Object)mode);
            long lf = d.lastFrame;
            d.lastFrame = millis;
            if (StagedAnimation.this.currentStage.get((Object)mode) == this.stage) {
                if (this.stage == Stage.FINISH && millis >= d.offset + (long)this.parent.getDuration(mode)) {
                    return;
                }
                if (this.stage == Stage.SETUP && millis - d.offset >= (long)this.parent.getDuration(mode)) {
                    d.finished = true;
                    if (StagedAnimation.this.pre.stream().allMatch(StagedAnimation$Anim$$Lambda$1.lambdaFactory$(mode))) {
                        StagedAnimation.this.currentStage.put(mode, Stage.PLAY);
                    }
                } else if (this.stage == Stage.PLAY && d.finishing && (millis - d.offset) / (long)this.parent.getDuration(mode) != (lf - d.offset) / (long)this.parent.getDuration(mode)) {
                    d.finished = true;
                } else if (this.tr == null || this.tr.canPlay(def.getPlayerObj(), mode)) {
                    this.parent.animate(millis - d.offset, def, mode);
                }
            } else {
                d.offset = millis;
            }
        }

        @Override
        public boolean checkAndUpdateRemove(AnimationEngine.AnimationMode mode) {
            AnimData d = this.data.get((Object)mode);
            if (d == null) {
                return true;
            }
            if (this.stage == Stage.FINISH) {
                if (StagedAnimation.this.play.stream().allMatch(StagedAnimation$Anim$$Lambda$2.lambdaFactory$(mode))) {
                    StagedAnimation.this.currentStage.put(mode, Stage.FINISH);
                    if (d.lastFrame >= d.offset + (long)this.parent.getDuration(mode)) {
                        d.offset = 0L;
                        return true;
                    }
                }
                return false;
            }
            if (this.stage == Stage.PLAY && this.mustFinish) {
                d.finishing = true;
                return d.finished;
            }
            d.finished = false;
            d.offset = 0L;
            return true;
        }

        @Override
        public void prepare(AnimationEngine.AnimationMode mode) {
            StagedAnimation.this.currentStage.put(mode, StagedAnimation.this.pre.isEmpty() ? Stage.PLAY : Stage.SETUP);
            StagedAnimation.this.all.forEach(StagedAnimation$Anim$$Lambda$3.lambdaFactory$(mode));
        }

        @Override
        public boolean useTriggerTime() {
            return this.stage != Stage.FINISH;
        }

        private void reset(AnimationEngine.AnimationMode mode) {
            AnimData d = this.data.get((Object)mode);
            if (d == null) {
                d = new AnimData();
                this.data.put(mode, d);
            }
            d.offset = 0L;
            d.finished = false;
            d.finishing = false;
        }

        static /* synthetic */ void lambda$prepare$2(AnimationEngine.AnimationMode mode, IAnimation a) {
            ((Anim)a).reset(mode);
        }

        static /* synthetic */ boolean lambda$checkAndUpdateRemove$1(AnimationEngine.AnimationMode mode, Anim a) {
            AnimData dt = a.data.get((Object)mode);
            return !a.mustFinish || dt.finished;
        }

        static /* synthetic */ boolean lambda$animate$0(AnimationEngine.AnimationMode mode, Anim a) {
            return a.data.get((Object)mode).finished;
        }
    }

    private static class AnimData {
        private long offset;
        private long lastFrame;
        private boolean finished;
        private boolean finishing;

        private AnimData() {
        }
    }
}

