/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.text.I18n;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.ServerAnimationState;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$1;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$10;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$11;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$12;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$13;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$14;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$15;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$16;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$17;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$2;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$3;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$4;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$5;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$6;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$7;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$8;
import com.tom.cpm.shared.animation.VanillaPose$$Lambda$9;
import com.tom.cpm.shared.network.ModelEventType;
import java.util.Locale;
import java.util.function.Supplier;

public enum VanillaPose implements IPose
{
    CUSTOM,
    STANDING,
    WALKING,
    RUNNING,
    SNEAKING,
    SWIMMING,
    FALLING,
    SLEEPING,
    RIDING,
    FLYING,
    DYING,
    SKULL_RENDER,
    GLOBAL,
    CREATIVE_FLYING,
    EATING_LEFT,
    EATING_RIGHT,
    RETRO_SWIMMING,
    JUMPING,
    SNEAK_WALK,
    PUNCH_LEFT(VanillaPose$$Lambda$2.lambdaFactory$()),
    PUNCH_RIGHT(VanillaPose$$Lambda$3.lambdaFactory$()),
    ARMOR_HEAD,
    ARMOR_BODY,
    ARMOR_LEGS,
    ARMOR_BOOTS,
    WEARING_ELYTRA,
    BOW_LEFT(VanillaPose$$Lambda$4.lambdaFactory$()),
    BOW_RIGHT(VanillaPose$$Lambda$5.lambdaFactory$()),
    CROSSBOW_LEFT,
    CROSSBOW_RIGHT,
    CROSSBOW_CH_LEFT(VanillaPose$$Lambda$6.lambdaFactory$()),
    CROSSBOW_CH_RIGHT(VanillaPose$$Lambda$7.lambdaFactory$()),
    TRIDENT_LEFT,
    TRIDENT_RIGHT,
    TRIDENT_SPIN,
    SPYGLASS_LEFT,
    SPYGLASS_RIGHT,
    HOLDING_LEFT,
    HOLDING_RIGHT,
    WEARING_SKULL,
    BLOCKING_LEFT,
    BLOCKING_RIGHT,
    PARROT_LEFT,
    PARROT_RIGHT,
    HURT,
    ON_FIRE,
    FREEZING,
    ON_LADDER,
    CLIMBING_ON_LADDER,
    SPEAKING(VanillaPose$$Lambda$8.lambdaFactory$()),
    TOOT_HORN_LEFT,
    TOOT_HORN_RIGHT,
    IN_GUI,
    FIRST_PERSON_MOD,
    VOICE_MUTED,
    VR_FIRST_PERSON,
    VR_THIRD_PERSON_SITTING,
    VR_THIRD_PERSON_STANDING,
    FIRST_PERSON_HAND,
    HEALTH(VanillaPose.syncedState(VanillaPose$$Lambda$9.lambdaFactory$(), VanillaPose$$Lambda$10.lambdaFactory$())),
    HUNGER(VanillaPose.syncedState(VanillaPose$$Lambda$11.lambdaFactory$(), VanillaPose$$Lambda$12.lambdaFactory$())),
    AIR(VanillaPose.syncedState(VanillaPose$$Lambda$13.lambdaFactory$(), VanillaPose$$Lambda$14.lambdaFactory$())),
    IN_MENU,
    INVISIBLE,
    LIGHT(VanillaPose$$Lambda$15.lambdaFactory$()),
    HEAD_ROTATION_YAW(VanillaPose$$Lambda$16.lambdaFactory$()),
    HEAD_ROTATION_PITCH(VanillaPose$$Lambda$17.lambdaFactory$()),
    BRUSH_LEFT,
    BRUSH_RIGHT,
    CRAWLING;

    private final String i18nKey = "label.cpm.pose." + this.name().toLowerCase(Locale.ROOT);
    private ToFloatFunction<AnimationState> stateGetter;
    public static final VanillaPose[] VALUES;
    public static final int DYNAMIC_DURATION_MUL = 1000;
    public static final int DYNAMIC_DURATION_DIV = 1001;

    private VanillaPose() {
    }

    private static ToFloatFunction<AnimationState> syncedState(ToFloatFunction<ServerAnimationState> state, Supplier<ModelEventType> type) {
        return VanillaPose$$Lambda$1.lambdaFactory$(type, state);
    }

    private static float calcHeadYaw(AnimationState s) {
        double ccd;
        double cd;
        float d;
        float bodyYaw;
        float yaw = s.yaw % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if ((bodyYaw = s.bodyYaw % 360.0f) < 0.0f) {
            bodyYaw += 360.0f;
        }
        if ((d = Math.abs(yaw - bodyYaw)) > 180.0f) {
            d = 360.0f - d;
        }
        if ((cd = ((double)(bodyYaw - yaw) + 360.0) % 360.0) < (ccd = ((double)(yaw - bodyYaw) + 360.0) % 360.0)) {
            d = -d;
        }
        return MathHelper.clamp((d + 90.0f) / 180.0f, 0.0f, 1.0f);
    }

    private VanillaPose(ToFloatFunction<AnimationState> stateGetter) {
        this();
        this.stateGetter = stateGetter;
    }

    @Override
    public String getName(I18n gui, String display) {
        if (display == null) {
            return gui.i18nFormat(this.i18nKey, new Object[0]);
        }
        return gui.i18nFormat("label.cpm.vanilla_anim", gui.i18nFormat(this.i18nKey, new Object[0]), display);
    }

    @Override
    public long getTime(AnimationState state, long time) {
        if (this.stateGetter != null && state != null) {
            return (long)(this.stateGetter.apply(state) * 1000.0f);
        }
        return time;
    }

    public boolean hasStateGetter() {
        return this.stateGetter != null;
    }

    static /* synthetic */ float lambda$syncedState$15(Supplier type, ToFloatFunction state, AnimationState s) {
        boolean reqEvent = MinecraftClientAccess$.get().requiresSelfEventForAnimation((ModelEventType)((Object)type.get()));
        if (s.serverState.updated && (!s.serverState.isSelf || reqEvent)) {
            return state.apply(s.serverState);
        }
        return state.apply(s.localState);
    }

    static /* synthetic */ float lambda$static$14(AnimationState s) {
        return MathHelper.clamp((s.pitch + 90.0f) / 180.0f, 0.0f, 1.0f);
    }

    static /* synthetic */ float lambda$static$13(AnimationState s) {
        return (float)Math.max(s.skyLight, s.blockLight) / 15.0f;
    }

    static /* synthetic */ ModelEventType lambda$static$12() {
        return ModelEventType.AIR;
    }

    static /* synthetic */ float lambda$static$11(ServerAnimationState s) {
        return s.air;
    }

    static /* synthetic */ ModelEventType lambda$static$10() {
        return ModelEventType.HUNGER;
    }

    static /* synthetic */ float lambda$static$9(ServerAnimationState s) {
        return s.hunger;
    }

    static /* synthetic */ ModelEventType lambda$static$8() {
        return ModelEventType.HEALTH;
    }

    static /* synthetic */ float lambda$static$7(ServerAnimationState s) {
        return s.health;
    }

    static /* synthetic */ float lambda$static$6(AnimationState s) {
        return s.speakLevel;
    }

    static /* synthetic */ float lambda$static$5(AnimationState s) {
        return s.crossbowPullback;
    }

    static /* synthetic */ float lambda$static$4(AnimationState s) {
        return s.crossbowPullback;
    }

    static /* synthetic */ float lambda$static$3(AnimationState s) {
        return s.bowPullback;
    }

    static /* synthetic */ float lambda$static$2(AnimationState s) {
        return s.bowPullback;
    }

    static /* synthetic */ float lambda$static$1(AnimationState s) {
        return s.attackTime;
    }

    static /* synthetic */ float lambda$static$0(AnimationState s) {
        return s.attackTime;
    }

    static {
        VALUES = VanillaPose.values();
    }

    static /* synthetic */ float access$lambda$0(AnimationState animationState) {
        return VanillaPose.calcHeadYaw(animationState);
    }
}

