/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.config;

import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpm.externals.com.google.common.collect.LinkedHashMultimap;
import com.tom.cpm.externals.com.google.common.collect.Multimap;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.MinecraftCommonAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player$$Lambda$1;
import com.tom.cpm.shared.config.Player$$Lambda$2;
import com.tom.cpm.shared.config.Player$$Lambda$3;
import com.tom.cpm.shared.config.Player$$Lambda$4;
import com.tom.cpm.shared.config.Player$$Lambda$5;
import com.tom.cpm.shared.config.Player$$Lambda$6;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.EnumMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public abstract class Player<P> {
    private static boolean enableRendering = true;
    private CompletableFuture<ModelDefinition> definition;
    private EnumMap<AnimationEngine.AnimationMode, AnimationHandler> animHandler = new EnumMap(AnimationEngine.AnimationMode.class);
    private PlayerTextureLoader textures;
    public AnimationState animState = new AnimationState();
    public VanillaPose prevPose;
    public IPose currentPose;
    public boolean forcedSkin;
    public boolean sentEventSubs;
    public String unique;
    public boolean isModel;

    public PlayerTextureLoader getTextures() {
        if (this.textures == null) {
            this.textures = this.initTextures();
            this.textures.load();
        }
        return this.textures;
    }

    public abstract SkinType getSkinType();

    protected abstract PlayerTextureLoader initTextures();

    public abstract String getName();

    public abstract UUID getUUID();

    public abstract void updateFromPlayer(P var1);

    public abstract Object getGameProfile();

    public abstract void updateFromModel(Object var1);

    public void updatePlayer(P player) {
        this.updateFromPlayer(player);
        NetHandler<?, ?, ?> net = MinecraftClientAccess$.get().getNetHandler();
        net.updatePlayer(player, this.animState.localState);
        this.animState.speakLevel = (float)MinecraftCommonAccess$.get().getApi().clientApi().getVoiceProviders().stream().mapToDouble(Player$$Lambda$1.lambdaFactory$(player)).max().orElse(0.0);
        this.animState.voiceMuted = MinecraftCommonAccess$.get().getApi().clientApi().getVoiceMutedProviders().stream().anyMatch(Player$$Lambda$2.lambdaFactory$(player));
    }

    public void setModelDefinition(CompletableFuture<ModelDefinition> definition, boolean isModel) {
        this.definition = definition.exceptionally(Player$$Lambda$3.lambdaFactory$(this));
        this.isModel = isModel;
    }

    public ModelDefinition getModelDefinition0() {
        try {
            return enableRendering && this.definition != null ? (ModelDefinition)this.definition.getNow(null) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ModelDefinition getModelDefinition() {
        ModelDefinition def = this.getModelDefinition0();
        if (def != null) {
            if (def.getResolveState() == ModelDefinition.ModelLoadingState.NEW) {
                def.startResolve();
            } else if (def.getResolveState() == ModelDefinition.ModelLoadingState.LOADED && def.doRender()) {
                return def;
            }
        }
        return null;
    }

    public CompletableFuture<ModelDefinition> getDefinitionFuture() {
        return this.definition;
    }

    public AnimationHandler getAnimationHandler(AnimationEngine.AnimationMode mode) {
        return this.animHandler.computeIfAbsent(mode, Player$$Lambda$4.lambdaFactory$(this));
    }

    public static boolean isEnableRendering() {
        return enableRendering;
    }

    public static void setEnableRendering(boolean enableRendering) {
        Player.enableRendering = enableRendering;
    }

    public static boolean isEnableNames() {
        return ModConfig.getCommonConfig().getBoolean("renderNames", true);
    }

    public static void setEnableNames(boolean enableNames) {
        ModConfig.getCommonConfig().setBoolean("renderNames", enableNames);
        ModConfig.getCommonConfig().save();
    }

    public static boolean isEnableLoadingInfo() {
        return ModConfig.getCommonConfig().getBoolean("showLoadingInfo", true);
    }

    public void cleanup() {
        ModelDefinition def = this.getModelDefinition0();
        if (def != null) {
            MinecraftClientAccess minecraftClientAccess = MinecraftClientAccess$.get();
            ModelDefinition modelDefinition = def;
            modelDefinition.getClass();
            minecraftClientAccess.executeOnGameThread(Player$$Lambda$5.lambdaFactory$(modelDefinition));
        }
    }

    public boolean isClientPlayer() {
        return this.getUUID().equals(MinecraftClientAccess$.get().getCurrentClientPlayer().getUUID());
    }

    public void sendEventSubs() {
        ModelDefinition def = this.getModelDefinition();
        if (!this.sentEventSubs && def != null) {
            this.sentEventSubs = true;
            MinecraftClientAccess$.get().getNetHandler().sendEventSubs(def);
        }
    }

    public static <P> void cloneProperties(Multimap<String, P> from, Multimap<String, P> to) {
        try {
            if (from.containsKey("textures")) {
                to.putAll("textures", from.get("textures"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <P> Multimap<String, P> cloneProperties(Multimap<String, P> from) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        Player.cloneProperties(from, map);
        return map;
    }

    static /* synthetic */ AnimationHandler lambda$getAnimationHandler$3(Player this_, AnimationEngine.AnimationMode k) {
        return new AnimationHandler(Player$$Lambda$6.lambdaFactory$(this_), k);
    }

    static /* synthetic */ ModelDefinition lambda$setModelDefinition$2(Player this_, Throwable e) {
        return new ModelDefinition(e, this_);
    }

    static /* synthetic */ boolean lambda$updatePlayer$1(Object player, Predicate p) {
        return p.test(player);
    }

    static /* synthetic */ double lambda$updatePlayer$0(Object player, ToFloatFunction f) {
        return f.apply(player);
    }
}

