/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.config;

import com.tom.cpl.command.ArgType;
import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.text.IText;
import com.tom.cpl.text.LiteralText;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.config.BuiltInSafetyProfiles;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$$Lambda$1;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$$Lambda$2;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$$Lambda$3;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$1$$Lambda$1;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$1$$Lambda$2;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$2$$Lambda$1;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$2$$Lambda$2;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$2$$Lambda$3;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$3$$Lambda$1;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$3$$Lambda$2;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey$3$$Lambda$3;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.definition.SafetyException;
import com.tom.cpm.shared.gui.panel.SafetyPanel;
import java.util.EnumMap;
import java.util.Locale;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class PlayerSpecificConfigKey<V> {
    protected String name;
    private EnumMap<KeyGroup, V> defValue;

    private PlayerSpecificConfigKey(String name, EnumMap<KeyGroup, V> defValue) {
        this.name = name;
        this.defValue = defValue;
    }

    public static <T extends Enum<T>> PlayerSpecificConfigKey<T> createEnum(String name, T[] values, Object ... defVal) {
        return new PlayerSpecificConfigKey<T>(name, (EnumMap)PlayerSpecificConfigKey.parseMap(defVal), (Enum[])values){
            final /* synthetic */ Enum[] val$values;
            {
                this.val$values = enumArray;
                super(name, defValue);
            }

            @Override
            public GuiElement createConfigElement(SafetyPanel panel) {
                IGui gui = panel.getGui();
                Panel p = new Panel(gui);
                Enum val = (Enum)this.getValueFor(null, panel.uuid, panel.mainConfig);
                Button btn = new Button(gui, this.formatName(gui, val), null);
                Button clr = new Button(gui, gui.i18nFormat("button.cpm.safetyClear", new Object[0]), null);
                clr.setAction(PlayerSpecificConfigKey$1$$Lambda$1.lambdaFactory$(this, panel, btn, gui, clr));
                clr.setEnabled(this.hasValue(panel.getConfig()));
                btn.setAction(PlayerSpecificConfigKey$1$$Lambda$2.lambdaFactory$(this, panel, this.val$values, btn, gui, clr));
                btn.setBounds(new Box(5, 0, panel.getBounds().w - 35, 20));
                clr.setBounds(new Box(panel.getBounds().w - 25, 0, 20, 20));
                p.addElement(btn);
                p.addElement(clr);
                p.setBounds(new Box(0, 0, panel.getBounds().w, 20));
                return p;
            }

            private String formatName(IGui gui, T v) {
                return this.formatValue((T)v).toString(gui);
            }

            @Override
            public IText formatValue(T v) {
                return new FormatText("label.cpm.safety." + this.name, new FormatText("label.cpm.safety." + this.name + "." + ((Enum)v).name().toLowerCase(Locale.ROOT), new Object[0]));
            }

            @Override
            public void setValue(ConfigEntry c, T v) {
                c.setInt(this.name, ((Enum)v).ordinal());
            }

            @Override
            public T getValue(ConfigEntry c, T d) {
                return this.val$values[Math.abs(c.getInt(this.name, ((Enum)d).ordinal()) % this.val$values.length)];
            }

            @Override
            public ArgType getType() {
                return ArgType.STRING;
            }

            @Override
            public Object getTypeArg() {
                return this.val$values;
            }

            static /* synthetic */ void lambda$createConfigElement$1(1 this_, SafetyPanel panel, Enum[] values, Button btn, IGui gui, Button clr) {
                Enum v = (Enum)this_.getValue(panel.getConfig(), (T)((Object)panel.getKeyGroup()));
                v = values[(v.ordinal() + 1) % values.length];
                btn.setText(this_.formatName(gui, v));
                this_.setValue(panel.getConfig(), (T)v);
                clr.setEnabled(true);
            }

            static /* synthetic */ void lambda$createConfigElement$0(1 this_, SafetyPanel panel, Button btn, IGui gui, Button clr) {
                Enum v = (Enum)this_.getValueFor(null, panel.uuid, panel.mainConfig);
                this_.resetValue(panel.getConfig());
                btn.setText(this_.formatName(gui, v));
                clr.setEnabled(false);
            }
        };
    }

    public static PlayerSpecificConfigKey<Boolean> createBool(String name, Object ... defVal) {
        return new PlayerSpecificConfigKey<Boolean>(name, PlayerSpecificConfigKey.parseMap(defVal)){

            @Override
            public GuiElement createConfigElement(SafetyPanel panel) {
                IGui gui = panel.getGui();
                Panel p = new Panel(gui);
                Checkbox chbx = new Checkbox(gui, gui.i18nFormat("label.cpm.safety." + this.name, new Object[0]));
                Button clr = new Button(gui, gui.i18nFormat("button.cpm.safetyClear", new Object[0]), null);
                clr.setAction(PlayerSpecificConfigKey$2$$Lambda$1.lambdaFactory$(this, chbx, panel, clr));
                clr.setEnabled(this.hasValue(panel.getConfig()));
                chbx.setSelected(this.getValue(panel.getConfig(), (Boolean)this.getValueFor(null, panel.uuid, panel.mainConfig)));
                chbx.setAction(PlayerSpecificConfigKey$2$$Lambda$2.lambdaFactory$(this, chbx, panel, clr));
                chbx.setBounds(new Box(5, 0, panel.getBounds().w - 35, 20));
                clr.setBounds(new Box(panel.getBounds().w - 25, 0, 20, 20));
                p.addElement(chbx);
                p.addElement(clr);
                p.setBounds(new Box(0, 0, panel.getBounds().w, 20));
                return p;
            }

            @Override
            public void setValue(ConfigEntry c, Boolean v) {
                c.setBoolean(this.name, v);
            }

            @Override
            public Boolean getValue(ConfigEntry c, Boolean d) {
                return c.getBoolean(this.name, d);
            }

            @Override
            public void checkFor(Player<?> player, SafetyException.BlockReason err) throws SafetyException {
                this.checkFor(player, PlayerSpecificConfigKey$2$$Lambda$3.lambdaFactory$(), err);
            }

            @Override
            public ArgType getType() {
                return ArgType.BOOLEAN;
            }

            static /* synthetic */ boolean lambda$checkFor$2(Boolean v) {
                return v;
            }

            static /* synthetic */ void lambda$createConfigElement$1(2 this_, Checkbox chbx, SafetyPanel panel, Button clr) {
                boolean v = !chbx.isSelected();
                chbx.setSelected(v);
                this_.setValue(panel.getConfig(), v);
                clr.setEnabled(true);
            }

            static /* synthetic */ void lambda$createConfigElement$0(2 this_, Checkbox chbx, SafetyPanel panel, Button clr) {
                chbx.setSelected((Boolean)this_.getValueFor(null, panel.uuid, panel.mainConfig));
                this_.resetValue(panel.getConfig());
                clr.setEnabled(false);
            }
        };
    }

    public static PlayerSpecificConfigKey<Integer> createInt(String name, int minVal, int maxVal, Object ... defVal) {
        return PlayerSpecificConfigKey.createIntF(name, minVal, maxVal, DoubleUnaryOperator.identity(), DoubleUnaryOperator.identity(), PlayerSpecificConfigKey$$Lambda$1.lambdaFactory$(), 0.0f, defVal);
    }

    public static PlayerSpecificConfigKey<Integer> createIntF(String name, final int minVal, final int maxVal, final DoubleUnaryOperator sliderFunc, final DoubleUnaryOperator revFunc, final Function<Integer, String> toStringFunc, final float sliderStep, Object ... defVal) {
        return new PlayerSpecificConfigKey<Integer>(name, PlayerSpecificConfigKey.parseMap(defVal)){

            @Override
            public GuiElement createConfigElement(SafetyPanel panel) {
                IGui gui = panel.getGui();
                Panel p = new Panel(gui);
                int val = (Integer)this.getValueFor(null, panel.uuid, panel.mainConfig);
                double min = sliderFunc.applyAsDouble(minVal);
                double div = sliderFunc.applyAsDouble(maxVal) - min;
                Slider slider = new Slider(gui, this.formatText(gui, val));
                Button clr = new Button(gui, gui.i18nFormat("button.cpm.safetyClear", new Object[0]), null);
                clr.setAction(PlayerSpecificConfigKey$3$$Lambda$1.lambdaFactory$(this, panel, slider, sliderFunc, min, div, gui, clr));
                clr.setEnabled(this.hasValue(panel.getConfig()));
                slider.setSteps(sliderStep);
                slider.setValue((float)((sliderFunc.applyAsDouble(val) - min) / div));
                slider.setAction(PlayerSpecificConfigKey$3$$Lambda$2.lambdaFactory$(this, revFunc, slider, div, min, panel, gui, clr));
                slider.setBounds(new Box(5, 0, panel.getBounds().w - 35, 20));
                clr.setBounds(new Box(panel.getBounds().w - 25, 0, 20, 20));
                p.addElement(slider);
                p.addElement(clr);
                p.setBounds(new Box(0, 0, panel.getBounds().w, 20));
                return p;
            }

            private String formatText(IGui gui, int v) {
                return gui.i18nFormat("label.cpm.safety.slider", gui.i18nFormat("label.cpm.safety." + this.name, new Object[0]), toStringFunc.apply(v));
            }

            @Override
            public void setValue(ConfigEntry c, Integer v) {
                c.setInt(this.name, v);
            }

            @Override
            public IText formatValue(Integer value) {
                return new LiteralText((String)toStringFunc.apply(value));
            }

            @Override
            public Integer getValue(ConfigEntry c, Integer d) {
                return MathHelper.clamp(c.getInt(this.name, d), minVal, maxVal);
            }

            @Override
            public void checkFor(Player<?> player, Integer w, SafetyException.BlockReason err) throws SafetyException {
                ((PlayerSpecificConfigKey)this).checkFor(player, PlayerSpecificConfigKey$3$$Lambda$3.lambdaFactory$(w), err);
            }

            @Override
            public ArgType getType() {
                return ArgType.INT;
            }

            @Override
            public Object getTypeArg() {
                return Pair.of(minVal, maxVal);
            }

            static /* synthetic */ boolean lambda$checkFor$2(Integer w, Integer o) {
                return w <= o;
            }

            static /* synthetic */ void lambda$createConfigElement$1(3 this_, DoubleUnaryOperator revFunc2, Slider slider, double div, double min, SafetyPanel panel, IGui gui, Button clr) {
                int v = (int)revFunc2.applyAsDouble((double)slider.getValue() * div + min);
                this_.setValue(panel.getConfig(), v);
                slider.setText(this_.formatText(gui, v));
                clr.setEnabled(true);
            }

            static /* synthetic */ void lambda$createConfigElement$0(3 this_, SafetyPanel panel, Slider slider, DoubleUnaryOperator sliderFunc2, double min, double div, IGui gui, Button clr) {
                int v = (Integer)this_.getValueFor(null, panel.uuid, panel.mainConfig);
                this_.resetValue(panel.getConfig());
                slider.setValue((float)((sliderFunc2.applyAsDouble(v) - min) / div));
                slider.setText(this_.formatText(gui, v));
                clr.setEnabled(false);
            }
        };
    }

    public static PlayerSpecificConfigKey<Integer> createIntLog2(String name, int minVal, int maxVal, Function<Integer, String> toStringFunc, Object ... defVal) {
        return PlayerSpecificConfigKey.createIntF(name, minVal, maxVal, PlayerSpecificConfigKey$$Lambda$2.lambdaFactory$(), PlayerSpecificConfigKey$$Lambda$3.lambdaFactory$(), toStringFunc, (float)(1.0 / (MathHelper.log2(maxVal) - MathHelper.log2(minVal))), defVal);
    }

    private static <T> EnumMap<KeyGroup, T> parseMap(Object[] array) {
        EnumMap map = new EnumMap(KeyGroup.class);
        int i = 0;
        if (array.length == 1 || !(array[i] instanceof KeyGroup)) {
            ++i;
            PlayerSpecificConfigKey.putAll(map, KeyGroup.GLOBAL, array[0]);
        }
        while (i < array.length) {
            KeyGroup kg = (KeyGroup)((Object)array[i]);
            Object val = array[i + 1];
            PlayerSpecificConfigKey.putAll(map, kg, val);
            i += 2;
        }
        return map;
    }

    private static <T> void putAll(EnumMap<KeyGroup, T> map, KeyGroup key, T value) {
        for (int i = key.ordinal(); i < KeyGroup.VALUES.length; ++i) {
            KeyGroup kg = KeyGroup.VALUES[i];
            map.put(kg, value);
        }
    }

    public void checkFor(Player<?> player, Predicate<V> check, SafetyException.BlockReason err) throws SafetyException {
        if (player.isClientPlayer()) {
            return;
        }
        if (!check.test(this.getValueFor(player))) {
            throw new SafetyException(err);
        }
    }

    public void checkFor(Player<?> player, V v, SafetyException.BlockReason err) throws SafetyException {
        throw new SafetyException(err);
    }

    public void checkFor(Player<?> player, SafetyException.BlockReason err) throws SafetyException {
        throw new SafetyException(err);
    }

    public V getValueFor(String server, String uuid, ConfigEntry ce) {
        ConfigEntry e;
        ConfigEntry gs = ce.getEntry("globalSettings");
        String[] spf = gs.getString("safetyProfile", BuiltInSafetyProfiles.MEDIUM.name().toLowerCase(Locale.ROOT)).split(":", 2);
        BuiltInSafetyProfiles profile = SocialConfig.getProfile(spf);
        ConfigEntry fr = ce.getEntry("friendSettings");
        ConfigEntry ss = ce.getEntry("serverSettings");
        if (server != null && ss.hasEntry(server) && (e = ss.getEntry(server)).hasEntry("safetyProfile")) {
            spf = e.getString("safetyProfile", BuiltInSafetyProfiles.MEDIUM.name().toLowerCase(Locale.ROOT)).split(":", 2);
            profile = SocialConfig.getProfile(spf);
        }
        if (uuid != null && SocialConfig.isFriend(uuid) && fr.hasEntry(this.name)) {
            return this.getValue(fr, this.defValue.get((Object)KeyGroup.FRIEND));
        }
        if (server != null && ss.hasEntry(server) && (e = ss.getEntry(server)).hasEntry(this.name)) {
            return this.getValue(e, this.defValue.get((Object)KeyGroup.GLOBAL));
        }
        ConfigEntry spfs = ce.getEntry("safetyProfiles");
        if (profile == BuiltInSafetyProfiles.CUSTOM) {
            ConfigEntry e2;
            if (spfs.hasEntry(spf[1]) && (e2 = spfs.getEntry(spf[1])).hasEntry(this.name)) {
                return this.getValue(e2, this.defValue.get((Object)KeyGroup.GLOBAL));
            }
        } else {
            V v = this.getValue(profile);
            if (v != null) {
                return v;
            }
        }
        return this.defValue.get((Object)KeyGroup.GLOBAL);
    }

    public V getValueFor(Player<?> player) {
        String uuid = null;
        if (player != null) {
            ConfigEntry e;
            uuid = player.getUUID().toString();
            ConfigEntry pl = ModConfig.getCommonConfig().getEntry("playerSettings");
            if (pl.hasEntry(uuid) && (e = pl.getEntry(player.getUUID().toString())).hasEntry(this.name)) {
                return this.getValue(e, this.defValue.get((Object)KeyGroup.GLOBAL));
            }
        }
        String server = MinecraftClientAccess$.get().getConnectedServer();
        return this.getValueFor(server, uuid, ModConfig.getCommonConfig());
    }

    public V getValue(ConfigEntry ce, KeyGroup group) {
        return this.getValue(ce, this.defValue.get((Object)group));
    }

    public V getValue(BuiltInSafetyProfiles profile) {
        if (profile == BuiltInSafetyProfiles.CUSTOM) {
            return null;
        }
        return profile.getValue(this.name);
    }

    public void resetValue(ConfigEntry ce) {
        ce.clearValue(this.name);
    }

    public boolean hasValue(ConfigEntry ce) {
        return ce.hasEntry(this.name);
    }

    public abstract GuiElement createConfigElement(SafetyPanel var1);

    public abstract void setValue(ConfigEntry var1, V var2);

    public abstract V getValue(ConfigEntry var1, V var2);

    public abstract ArgType getType();

    public Object getTypeArg() {
        return null;
    }

    public IText formatValue(V value) {
        return new LiteralText(String.valueOf(value));
    }

    public String getName() {
        return this.name;
    }

    public void copyValue(ConfigEntry from, ConfigEntry to) {
        if (this.hasValue(from)) {
            this.setValue(to, this.getValue(from, (V)((Object)KeyGroup.GLOBAL)));
        }
    }

    static /* synthetic */ double lambda$createIntLog2$0(double v) {
        return Math.pow(2.0, v);
    }

    public static enum KeyGroup {
        GLOBAL,
        FRIEND;

        public static final KeyGroup[] VALUES;

        static {
            VALUES = KeyGroup.values();
        }
    }
}

