/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.definition;

import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.LocalizedIOException;
import com.tom.cpm.externals.com.google.common.cache.Cache;
import com.tom.cpm.externals.com.google.common.cache.CacheBuilder;
import com.tom.cpm.externals.com.google.common.cache.CacheLoader;
import com.tom.cpm.externals.com.google.common.cache.LoadingCache;
import com.tom.cpm.externals.com.google.common.cache.RemovalListener;
import com.tom.cpm.externals.com.google.common.cache.RemovalNotification;
import com.tom.cpm.externals.com.google.common.util.concurrent.UncheckedExecutionException;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.config.ResourceLoader$;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$1;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$10;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$11;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$2;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$3;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$4;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$5;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$6;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$7;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$8;
import com.tom.cpm.shared.definition.ModelDefinitionLoader$$Lambda$9;
import com.tom.cpm.shared.definition.SafetyException;
import com.tom.cpm.shared.io.ChecksumInputStream;
import com.tom.cpm.shared.io.ChecksumOutputStream;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.io.SkinDataInputStream;
import com.tom.cpm.shared.loaders.GistResourceLoader;
import com.tom.cpm.shared.loaders.GithubRepoResourceLoader;
import com.tom.cpm.shared.loaders.ModelsCDNResourceLoader;
import com.tom.cpm.shared.loaders.PasteResourceLoader;
import com.tom.cpm.shared.loaders.PastebinResourceLoader;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.ModelPartEnd;
import com.tom.cpm.shared.parts.ModelPartSkinType;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.skin.TextureType;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.ModelLoadingPool;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class ModelDefinitionLoader<GP> {
    public static final String PLAYER_UNIQUE = "player";
    public static final String SKULL_UNIQUE = "skull";
    public static final Executor THREAD_POOL = ModelLoadingPool.workerPool();
    private Function<GP, Player<?>> playerFactory;
    private Function<GP, UUID> getUUID;
    private Function<GP, String> getName;
    private final LoadingCache<Key, Player<?>> cache = CacheBuilder.newBuilder().expireAfterAccess(MinecraftObjectHolder.DEBUGGING ? 10000L : 15L, TimeUnit.SECONDS).removalListener(new RemovalListener<Key, Player<?>>(){

        @Override
        public void onRemoval(RemovalNotification<Key, Player<?>> notification) {
            notification.getValue().cleanup();
        }
    }).build(CacheLoader.from(ModelDefinitionLoader$$Lambda$5.lambdaFactory$(this)));
    private static final Map<String, ResourceLoader> LOADERS = new HashMap<String, ResourceLoader>();
    private final Cache<Link, Link.ResolvedLink> linkCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final Cache<Link, Link.ResolvedLink> localCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private ConcurrentHashMap<Key, byte[]> serverModels = new ConcurrentHashMap();
    private Image template;
    public static final int HEADER = 83;

    private Player<?> loadPlayer(Key key) {
        Player<?> player = this.playerFactory.apply(key.profile);
        try {
            player.unique = key.uniqueKey;
            CompletableFuture<Void> texLoad = player.getTextures().load();
            if (key.uniqueKey.startsWith("model:")) {
                String b64 = key.uniqueKey.substring(6);
                Log.debug("Loading key model for " + key.profile);
                player.setModelDefinition(CompletableFuture.supplyAsync(ModelDefinitionLoader$$Lambda$1.lambdaFactory$(this, b64, player), THREAD_POOL), true);
            } else if (this.serverModels.containsKey(key)) {
                Log.debug("Loading server model for " + key.profile);
                player.setModelDefinition(CompletableFuture.supplyAsync(ModelDefinitionLoader$$Lambda$2.lambdaFactory$(this, key, player), THREAD_POOL), true);
            } else {
                Log.debug("Loading skin model for " + key.profile);
                player.setModelDefinition((CompletableFuture<ModelDefinition>)((CompletableFuture)texLoad.thenCompose(ModelDefinitionLoader$$Lambda$3.lambdaFactory$(player))).thenApplyAsync(ModelDefinitionLoader$$Lambda$4.lambdaFactory$(this, player), THREAD_POOL), false);
            }
        }
        catch (Exception e) {
            player.setModelDefinition(CompletableFuture.completedFuture(new ModelDefinition(e, player)), false);
        }
        return player;
    }

    public ModelDefinitionLoader(Function<GP, Player<?>> playerFactory, Function<GP, UUID> getUUID, Function<GP, String> getName) {
        try {
            InputStream is = ModelDefinitionLoader.class.getResourceAsStream("/assets/cpm/textures/template/free_space_template.png");
            Throwable throwable = null;
            try {
                this.template = Image.loadFrom(is);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load template", e);
        }
        this.playerFactory = playerFactory;
        this.getUUID = getUUID;
        this.getName = getName;
    }

    public Player<?> loadPlayer(GP player, String unique) {
        try {
            return this.cache.get(new Key(player, unique));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Log.debug("Error loading player model data", e);
            return null;
        }
    }

    public ModelDefinition loadModel(String data, Player<?> player) {
        return this.loadModel(Base64.getDecoder().decode(data), player);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelDefinition loadModel(byte[] data, Player<?> player) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Throwable throwable = null;
            try {
                ModelDefinition modelDefinition = this.loadModel(in, player);
                return modelDefinition;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (Exception e) {
            return new ModelDefinition(e, player);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelDefinition loadModel(Image skin, Player<?> player) {
        try {
            SkinDataInputStream in = new SkinDataInputStream(skin, this.template, player.getSkinType().getChannel());
            Throwable throwable = null;
            try {
                ModelDefinition modelDefinition = this.loadModel(in, player);
                return modelDefinition;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (Exception e) {
            return new ModelDefinition(e, player);
        }
    }

    private ModelDefinition loadModel(InputStream in, Player<?> player) {
        ModelDefinition def = new ModelDefinition(this, player);
        try {
            if (in.read() != 83) {
                return null;
            }
            ConfigKeys.ENABLE_MODEL_LOADING.checkFor(player, (Boolean)((Object)ModelDefinitionLoader$$Lambda$6.lambdaFactory$()), SafetyException.BlockReason.CONFIG_DISABLED);
            if (SocialConfig.isBlocked(player.getUUID().toString())) {
                throw new SafetyException(SafetyException.BlockReason.BLOCK_LIST);
            }
            ChecksumInputStream cis = new ChecksumInputStream(in);
            IOHelper din = new IOHelper(cis);
            ArrayList<IModelPart> parts = new ArrayList<IModelPart>();
            while (true) {
                IModelPart part;
                if ((part = (IModelPart)din.readObjectBlock(ModelPartType.VALUES, ModelDefinitionLoader$$Lambda$7.lambdaFactory$(def))) == null) continue;
                if (part instanceof ModelPartSkinType && in instanceof SkinDataInputStream) {
                    SkinDataInputStream sin = (SkinDataInputStream)in;
                    SkinType type = ((ModelPartSkinType)part).getSkinType();
                    if (type != SkinType.UNKNOWN && type.getChannel() != sin.getChannel()) {
                        sin.setChannel(type.getChannel());
                        Log.debug("Mismatching skin type");
                    }
                }
                if (part instanceof ModelPartEnd) break;
                parts.add(part);
            }
            cis.checkSum();
            def.setParts(parts);
            def.validate();
            if (MinecraftClientAccess$.get().isInGame()) {
                MinecraftClientAccess$.get().getNetHandler().requestPlayerState(player.getUUID());
            }
            Log.debug(def);
        }
        catch (Throwable e) {
            def.setError(e);
        }
        return def;
    }

    public InputStream load(Link link, ResourceLoader.ResourceEncoding enc, ModelDefinition def) throws IOException {
        try {
            Link.ResolvedLink rl = this.linkCache.get(link, ModelDefinitionLoader$$Lambda$8.lambdaFactory$(this, link, enc, def));
            return rl.getData();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SafetyException) {
                throw (SafetyException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    private Link.ResolvedLink load0(Link link, ResourceLoader.ResourceEncoding enc, ModelDefinition def) throws SafetyException {
        try {
            ResourceLoader rl = LOADERS.get(link.loader);
            if (rl == null) {
                throw new IOException("Couldn't find loader");
            }
            return new Link.ResolvedLink(rl.loadResource(link, enc, def));
        }
        catch (SafetyException e) {
            throw e;
        }
        catch (IOException e) {
            Link.ResolvedLink rl = this.localCache.getIfPresent(link);
            if (rl != null) {
                return rl;
            }
            return new Link.ResolvedLink(e);
        }
    }

    public Image getTemplate() {
        return this.template;
    }

    public void putLocalResource(Link key, byte[] value) {
        this.localCache.put(key, new Link.ResolvedLink(value));
    }

    public void clearCache() {
        this.linkCache.invalidateAll();
        this.cache.invalidateAll();
        MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine().resetGestureData();
    }

    public void clearServerData() {
        this.serverModels.clear();
    }

    public void setModel(GP forPlayer, byte[] data, boolean forced) {
        if (data == null) {
            Key key = new Key(forPlayer, null);
            this.serverModels.remove(key);
            this.invalidateAll(key);
        } else {
            this.serverModels.put(new Key(forPlayer, null), data);
            Player<?> player = this.reloadPlayer(forPlayer, PLAYER_UNIQUE);
            player.forcedSkin = forced;
        }
    }

    public byte[] getModel(GP forPlayer) {
        Key key = new Key(forPlayer, null);
        return this.serverModels.get(key);
    }

    public Player<?> getLoadedPlayer(GP forPlayer) {
        Key key = new Key(forPlayer, PLAYER_UNIQUE);
        return (Player)this.cache.getIfPresent(key);
    }

    private void invalidateAll(Key key) {
        Set set = this.cache.asMap().keySet();
        Key key2 = key;
        key2.getClass();
        set.removeIf(ModelDefinitionLoader$$Lambda$9.lambdaFactory$(key2));
    }

    public void execute(Runnable task) {
        THREAD_POOL.execute(task);
    }

    public List<Player<?>> getPlayers() {
        return new ArrayList(this.cache.asMap().values());
    }

    public void settingsChanged(UUID uuid) {
        this.invalidateAll(new Key(uuid));
    }

    public UUID getGP_UUID(GP gp) {
        return this.getUUID.apply(gp);
    }

    public String getGP_Name(GP gp) {
        return this.getName.apply(gp);
    }

    public CompletableFuture<Boolean> cloneModel(Player<?> player, String name) {
        ModelDefinition d = player.getModelDefinition();
        if (d != null && d.cloneable != null) {
            String desc = d.cloneable.desc;
            Image icon = d.cloneable.icon;
            byte[] data = this.serverModels.get(new Key(player.getUUID()));
            if (data == null) {
                return ((CompletableFuture)player.getTextures().load().thenCompose(ModelDefinitionLoader$$Lambda$10.lambdaFactory$(player))).thenApplyAsync(ModelDefinitionLoader$$Lambda$11.lambdaFactory$(this, player, name, desc, icon), THREAD_POOL);
            }
            try {
                this.storeModel(name, desc, icon, data);
                return CompletableFuture.completedFuture(true);
            }
            catch (IOException e) {
                e.printStackTrace();
                return CompletableFuture.completedFuture(false);
            }
        }
        return CompletableFuture.completedFuture(false);
    }

    private void storeModel(String name, String desc, Image icon, byte[] data) throws IOException {
        File models = new File(MinecraftClientAccess$.get().getGameDir(), "player_models");
        models.mkdirs();
        File out = new File(models, name.replaceAll("[^a-zA-Z0-9\\.\\-]", "") + ".cpmmodel");
        Random r = new Random();
        while (out.exists()) {
            out = new File(models, name.replaceAll("[^a-zA-Z0-9\\.\\-]", "") + "_" + Integer.toHexString(r.nextInt()) + ".cpmmodel");
        }
        FileOutputStream fout = new FileOutputStream(out);
        Throwable throwable = null;
        try {
            fout.write(83);
            ChecksumOutputStream cos = new ChecksumOutputStream(fout);
            IOHelper h = new IOHelper(cos);
            h.writeUTF(name);
            h.writeUTF(desc != null ? desc : "");
            h.writeVarInt(data.length);
            h.write(data);
            h.writeVarInt(0);
            if (icon != null) {
                h.writeImage(icon);
            } else {
                h.writeVarInt(0);
            }
            cos.close();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (fout != null) {
                if (throwable != null) {
                    try {
                        fout.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    fout.close();
                }
            }
        }
    }

    public static Link parseLink(String link) throws LocalizedIOException, URISyntaxException {
        URI url = new URI(link);
        for (ResourceLoader rl : LOADERS.values()) {
            Link r;
            ResourceLoader.Validator v = rl.getValidator();
            if (v == null || (r = v.test(link)) == null) continue;
            return r;
        }
        throw new LocalizedIOException("Unknown domain: " + url.getHost(), new FormatText("label.cpm.link.unknownDomain", url.getHost()));
    }

    public Player<?> reloadPlayer(GP gprofile, String unique) {
        Key key = new Key(gprofile, null);
        this.invalidateAll(key);
        return this.loadPlayer(gprofile, unique);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ Boolean lambda$cloneModel$8(ModelDefinitionLoader this_, Player player, String name, String desc, Image icon, Image skin) {
        try {
            SkinDataInputStream in = new SkinDataInputStream(skin, this_.template, player.getSkinType().getChannel());
            Throwable throwable = null;
            try {
                IOHelper ioh = new IOHelper();
                IOHelper.copy(in, ioh.getDout());
                if (ioh.flip().read() != 83) {
                    Boolean bl2 = false;
                    return bl2;
                }
                this_.storeModel(name, desc, icon, ioh.toBytes());
                Boolean bl = true;
                return bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    static /* synthetic */ CompletionStage lambda$cloneModel$7(Player player, Void v) {
        return player.getTextures().getTexture(TextureType.SKIN);
    }

    static /* synthetic */ Link.ResolvedLink lambda$load$6(ModelDefinitionLoader this_, Link link, ResourceLoader.ResourceEncoding enc, ModelDefinition def) throws Exception {
        return this_.load0(link, enc, def);
    }

    static /* synthetic */ IModelPart lambda$loadModel$5(ModelDefinition def, ModelPartType t, IOHelper d) throws IOException {
        return t.getFactory().create(d, def);
    }

    static /* synthetic */ boolean lambda$loadModel$4(Boolean v) {
        return v;
    }

    static /* synthetic */ ModelDefinition lambda$loadPlayer$3(ModelDefinitionLoader this_, Player player, Image skin) {
        if (skin != null && player.getModelDefinition() == null) {
            return this_.loadModel(skin, player);
        }
        if (!player.getTextures().hasTexture(TextureType.SKIN) && player.isClientPlayer()) {
            return new ModelDefinition(new LocalizedIOException("Custom skin not found", new FormatText("error.cpm.no_skin_url", new Object[0])), player);
        }
        return null;
    }

    static /* synthetic */ CompletionStage lambda$loadPlayer$2(Player player, Void v) {
        return player.getTextures().getTexture(TextureType.SKIN);
    }

    static /* synthetic */ ModelDefinition lambda$loadPlayer$1(ModelDefinitionLoader this_, Key key, Player player) {
        return this_.loadModel(this_.serverModels.get(key), player);
    }

    static /* synthetic */ ModelDefinition lambda$loadPlayer$0(ModelDefinitionLoader this_, String b64, Player player) {
        return this_.loadModel(b64, player);
    }

    static {
        LOADERS.put("git", new GistResourceLoader());
        LOADERS.put("gh", new GithubRepoResourceLoader());
        LOADERS.put("p", new PasteResourceLoader());
        LOADERS.put("pb", new PastebinResourceLoader());
        LOADERS.put("ms", new ModelsCDNResourceLoader());
        LOADERS.put("local", new ResourceLoader(){

            @Override
            public byte[] loadResource(String path, ResourceLoader.ResourceEncoding enc, ModelDefinition def) throws IOException {
                throw new LocalizedIOException("Test in-game model", new FormatText("error.cpm.testModel", new Object[0]));
            }

            @Override
            public ResourceLoader.Validator getValidator() {
                return ResourceLoader$.getValidator(this);
            }

            @Override
            public byte[] loadResource(Link link, ResourceLoader.ResourceEncoding resourceEncoding, ModelDefinition modelDefinition) {
                return ResourceLoader$.loadResource(this, link, resourceEncoding, modelDefinition);
            }
        });
    }

    static /* synthetic */ Player access$lambda$0(ModelDefinitionLoader modelDefinitionLoader, Key key) {
        return modelDefinitionLoader.loadPlayer(key);
    }

    private class Key {
        private UUID uuid;
        private GP profile;
        private String uniqueKey;

        public Key(GP player, String unique) {
            this.profile = player;
            this.uuid = (UUID)ModelDefinitionLoader.this.getUUID.apply(player);
            this.uniqueKey = unique;
        }

        public Key(UUID uuid) {
            this.uuid = uuid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
                return false;
            }
            if (this.uniqueKey == null || other.uniqueKey == null) {
                return true;
            }
            return this.uniqueKey.equals(other.uniqueKey);
        }
    }
}

