/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$1;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$10;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$11;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$12;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$13;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$14;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$15;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$16;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$17;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$18;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$19;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$2;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$20;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$21;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$22;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$23;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$24;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$25;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$26;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$27;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$28;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$29;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$3;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$30;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$31;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$32;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$33;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$4;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$5;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$6;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$7;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$8;
import com.tom.cpm.shared.editor.AnimationExporter$$Lambda$9;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ExportException;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.AnimatorChannel;
import com.tom.cpm.shared.parts.anim.ConstantTimeBool;
import com.tom.cpm.shared.parts.anim.ConstantTimeFloat;
import com.tom.cpm.shared.parts.anim.ParameterDetails;
import com.tom.cpm.shared.parts.anim.SerializedAnimation;
import com.tom.cpm.shared.parts.anim.SerializedTrigger;
import com.tom.cpm.shared.parts.anim.StageType;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.BoolParameterToggleButtonData;
import com.tom.cpm.shared.parts.anim.menu.CustomPoseGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.DropdownButtonData;
import com.tom.cpm.shared.parts.anim.menu.ValueParameterButtonData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnimationExporter {
    public final Editor editor;
    public final AnimLoaderState an;
    public ParameterDetails.ParameterAllocator paramAlloc = new ParameterDetails.ParameterAllocator();
    public List<Pair<Integer, AbstractGestureButtonData>> buttons = new ArrayList<Pair<Integer, AbstractGestureButtonData>>();
    public Map<String, ParameterInfo> allButtons = new HashMap<String, ParameterInfo>();
    public Set<ModelElement> allElems = new HashSet<ModelElement>();
    public Map<SerializedTrigger, Integer> triggers = new HashMap<SerializedTrigger, Integer>();
    public Map<EditorAnim, Integer> animTriggers = new HashMap<EditorAnim, Integer>();
    public Map<EditorAnim, SerializedAnimation> anims = new HashMap<EditorAnim, SerializedAnimation>();
    public Map<EditorAnim, Staging> stagingAnimMap = new HashMap<EditorAnim, Staging>();
    public List<Staging> stagingAnimList = new ArrayList<Staging>();
    public Map<String, Integer> dropdownParams = new HashMap<String, Integer>();
    public Map<EditorAnim, Integer> dropdownAnims = new HashMap<EditorAnim, Integer>();

    public AnimationExporter(Editor editor, AnimLoaderState an) {
        this.editor = editor;
        this.an = an;
    }

    public void processElements() {
        List<ModelElement> list = this.editor.elements;
        Set<ModelElement> set = this.allElems;
        set.getClass();
        Editor.walkElements(list, AnimationExporter$$Lambda$1.lambdaFactory$(set));
    }

    public void processAnimation(EditorAnim a) {
        SerializedTrigger tr = new SerializedTrigger();
        if (a.pose instanceof VanillaPose) {
            tr.pose = (VanillaPose)a.pose;
            tr.mustFinish = a.mustFinish;
        } else if (a.type == AnimationType.CUSTOM_POSE || a.type == AnimationType.GESTURE || a.type.isLayer()) {
            boolean bl = tr.looping = a.type == AnimationType.GESTURE ? a.loop : true;
            if (!this.allButtons.containsKey(a.getId())) {
                int len;
                ParameterInfo info = this.makeButtonInfo(a);
                if (!a.type.isLayer()) {
                    info.button.layerCtrl = a.layerControlled;
                }
                info.button.command = a.command;
                info.button.isProperty = a.isProperty;
                info.apply(tr);
                if (a.type == AnimationType.GESTURE && !a.loop && (len = this.editor.animations.stream().mapToInt(AnimationExporter$$Lambda$2.lambdaFactory$()).max().orElse(-1)) > 0) {
                    ((CustomPoseGestureButtonData)info.button).gestureTimeout = (int)Math.ceil((float)len / 50.0f) + 5;
                }
            } else {
                this.allButtons.get(a.getId()).apply(tr);
            }
            tr.anim = a.type;
            tr.mustFinish = a.mustFinish;
        } else if (a.type.isStaged()) {
            List l = a.findLinkedAnims().collect(Collectors.toList());
            Stream stream = l.stream();
            Map<EditorAnim, Staging> map = this.stagingAnimMap;
            map.getClass();
            Staging st = (Staging)stream.map(AnimationExporter$$Lambda$3.lambdaFactory$(map)).filter(AnimationExporter$$Lambda$4.lambdaFactory$()).findFirst().orElseGet(AnimationExporter$$Lambda$5.lambdaFactory$(this, a));
            l.forEach(AnimationExporter$$Lambda$6.lambdaFactory$(this, st));
            this.stagingAnimMap.put(a, st);
            st.play.addAll(l);
            if (a.type == AnimationType.SETUP) {
                st.setup.add(a);
            } else {
                st.finish.add(a);
            }
            tr.stage = a.type == AnimationType.SETUP ? StageType.SETUP : StageType.FINISH;
            tr.stagingID = st.id;
        }
        AnimLoaderState animLoaderState = this.an;
        animLoaderState.getClass();
        int id = this.triggers.computeIfAbsent(tr, AnimationExporter$$Lambda$7.lambdaFactory$(animLoaderState));
        this.animTriggers.put(a, id);
        SerializedAnimation anim = new SerializedAnimation();
        this.anims.put(a, anim);
        anim.triggerID = id;
        anim.priority = a.priority;
        anim.duration = a.pose instanceof VanillaPose && ((VanillaPose)a.pose).hasStateGetter() || a.type == AnimationType.VALUE_LAYER ? 1001 : a.duration;
        this.an.newAnimation(anim);
        List<ModelElement> elems = a.getComponentsFiltered();
        List<AnimFrame> frames = a.getFrames();
        elems.forEach(AnimationExporter$$Lambda$8.lambdaFactory$(this, anim, a, frames));
    }

    private static void addChannel(SerializedAnimation anim, Map<InterpolatorChannel, Integer> c, ModelElement elem, InterpolatorChannel chn, EditorAnim ea, float empty) {
        List<AnimFrame> frames = ea.getFrames();
        float[] array = new float[frames.size()];
        for (int i = 0; i < frames.size(); ++i) {
            AnimFrame frm = frames.get(i);
            IElem dt = frm.getData(elem);
            if (dt == null) {
                if (ea.add) {
                    array[i] = empty;
                    continue;
                }
                array[i] = elem.part(chn);
                continue;
            }
            array[i] = dt.part(chn);
        }
        anim.animatorChannels.get((Object)c.get((Object)chn)).frameData = new ConstantTimeFloat(ea.intType, array);
    }

    public List<AbstractGestureButtonData> sortButtons() {
        return this.buttons.stream().sorted(Comparator.comparingInt(AnimationExporter$$Lambda$9.lambdaFactory$())).map(AnimationExporter$$Lambda$10.lambdaFactory$()).collect(Collectors.toList());
    }

    public void linkStagingAnims() {
        this.stagingAnimList.forEach(AnimationExporter$$Lambda$11.lambdaFactory$(this));
        this.dropdownParams.forEach(AnimationExporter$$Lambda$12.lambdaFactory$(this));
    }

    private ParameterInfo makeButtonInfo(EditorAnim a) {
        switch (a.type) {
            case CUSTOM_POSE: 
            case GESTURE: {
                CustomPoseGestureButtonData dt = new CustomPoseGestureButtonData(a.type == AnimationType.CUSTOM_POSE);
                dt.setName(a.getId());
                dt.id = a.type == AnimationType.CUSTOM_POSE ? this.paramAlloc.newPose(a.getId()) : this.paramAlloc.newGesture(a.getId());
                dt.layerCtrl = a.layerControlled;
                dt.hidden = a.hidden;
                ParameterInfo param = new ParameterInfo((AbstractGestureButtonData.AbstractCommandTriggerableData)dt, dt.id);
                this.allButtons.put(a.getId(), param);
                this.buttons.add(Pair.of(a.order, dt));
                return param;
            }
            case LAYER: {
                if (a.group != null) {
                    if (!this.allButtons.containsKey(a.group)) {
                        DropdownButtonData dt = new DropdownButtonData();
                        dt.parameter = this.paramAlloc.allocByteSync(a.group, (byte)0);
                        dt.setName(a.group);
                        dt.add("");
                        ParameterInfo param = new ParameterInfo(dt, dt.parameter, 0, false);
                        this.allButtons.put(a.group, param);
                        this.buttons.add(Pair.of(a.order, dt));
                        this.dropdownParams.put(a.group, dt.parameter);
                    }
                    ParameterInfo info = this.allButtons.get(a.group);
                    if (!(info.button instanceof DropdownButtonData)) {
                        throw new RuntimeException("Animation name conflict " + a.group);
                    }
                    DropdownButtonData dt = (DropdownButtonData)info.button;
                    int id = dt.add(a.getId());
                    ParameterInfo pr = new ParameterInfo(dt, dt.parameter, id, false);
                    this.allButtons.put(a.getId(), pr);
                    this.dropdownAnims.put(a, id);
                    return pr;
                }
                BoolParameterToggleButtonData dt = new BoolParameterToggleButtonData();
                ParameterDetails.ParameterAllocator.BitInfo bit = this.paramAlloc.allocBitSync(a.getId(), a.layerDefault > 0.5f);
                dt.setInfo(bit);
                dt.setName(a.getId());
                dt.hidden = a.hidden;
                ParameterInfo param = new ParameterInfo((AbstractGestureButtonData.AbstractCommandTriggerableData)dt, bit);
                this.allButtons.put(a.getId(), param);
                this.buttons.add(Pair.of(a.order, dt));
                return param;
            }
            case VALUE_LAYER: {
                ValueParameterButtonData dt = new ValueParameterButtonData();
                dt.setName(a.getId());
                dt.parameter = this.paramAlloc.allocByteSync(a.getId(), (byte)(a.layerDefault * 255.0f));
                dt.maxValue = a.maxValue;
                dt.hidden = a.hidden;
                ParameterInfo param = new ParameterInfo(dt, dt.parameter, a.interpolateValue);
                this.allButtons.put(a.getId(), param);
                this.buttons.add(Pair.of(a.order, dt));
                return param;
            }
        }
        return null;
    }

    static /* synthetic */ void lambda$linkStagingAnims$22(AnimationExporter this_, String g, Integer p) {
        EditorAnim defV = this_.editor.animations.stream().filter(AnimationExporter$$Lambda$13.lambdaFactory$(g)).findFirst().orElse(null);
        if (defV != null) {
            this_.paramAlloc.setDefaultValue(p, this_.dropdownAnims.get(defV));
        }
    }

    static /* synthetic */ boolean lambda$null$21(String g, EditorAnim e) {
        return g.equals(e.group) && e.layerDefault > 0.5f;
    }

    static /* synthetic */ void lambda$linkStagingAnims$20(AnimationExporter this_, Staging s) {
        SerializedTrigger tr = new SerializedTrigger();
        tr.stagingID = s.id;
        tr.stage = StageType.PLAY;
        tr.mustFinish = s.play.stream().anyMatch(AnimationExporter$$Lambda$14.lambdaFactory$());
        AnimLoaderState animLoaderState = this_.an;
        animLoaderState.getClass();
        int id = this_.triggers.computeIfAbsent(tr, AnimationExporter$$Lambda$15.lambdaFactory$(animLoaderState));
        Stream stream = s.play.stream();
        Map<EditorAnim, Integer> map = this_.animTriggers;
        map.getClass();
        Stream stream2 = stream.map(AnimationExporter$$Lambda$16.lambdaFactory$(map));
        Map<Integer, SerializedTrigger> map2 = this_.an.getTriggers();
        map2.getClass();
        List trigs = stream2.map(AnimationExporter$$Lambda$17.lambdaFactory$(map2)).filter(AnimationExporter$$Lambda$18.lambdaFactory$()).distinct().collect(Collectors.toList());
        Stream stream3 = s.play.stream();
        Map<EditorAnim, SerializedAnimation> map3 = this_.anims;
        map3.getClass();
        stream3.map(AnimationExporter$$Lambda$19.lambdaFactory$(map3)).filter(AnimationExporter$$Lambda$20.lambdaFactory$()).forEach(AnimationExporter$$Lambda$21.lambdaFactory$(id));
        if (trigs.size() != 1) {
            if (trigs.isEmpty()) {
                throw new ExportException(new FormatText("error.cpm.stagingMissingMain", Stream.concat(s.setup.stream(), s.finish.stream()).map(AnimationExporter$$Lambda$22.lambdaFactory$()).findFirst().orElse("??")));
            }
            String anims = Stream.concat(s.setup.stream(), s.finish.stream()).map(AnimationExporter$$Lambda$23.lambdaFactory$()).collect(Collectors.joining("\\"));
            String info = s.play.stream().map(AnimationExporter$$Lambda$24.lambdaFactory$(this_)).filter(AnimationExporter$$Lambda$25.lambdaFactory$()).collect(Collectors.groupingBy(AnimationExporter$$Lambda$26.lambdaFactory$())).values().stream().map(AnimationExporter$$Lambda$27.lambdaFactory$()).collect(Collectors.joining("\\----\\", "----\\", ""));
            throw new ExportException(new FormatText("error.cpm.stagingMultipleMain", anims, info));
        }
        s.triggerId = this_.triggers.get(trigs.get(0));
        ((SerializedTrigger)trigs.get((int)0)).mustFinish = false;
        this_.an.getStagedList().add(s.triggerId);
    }

    static /* synthetic */ String lambda$null$19(List l) {
        return l.stream().map(AnimationExporter$$Lambda$28.lambdaFactory$()).collect(Collectors.joining("\\"));
    }

    static /* synthetic */ String lambda$null$18(Pair p) {
        return "'" + p.getKey() + "'";
    }

    static /* synthetic */ boolean lambda$null$17(Pair e) {
        return e.getValue() != null;
    }

    static /* synthetic */ Pair lambda$null$16(AnimationExporter this_, EditorAnim e) {
        return Pair.of(e, this_.an.getTriggers().get(this_.animTriggers.get(e)));
    }

    static /* synthetic */ String lambda$null$15(EditorAnim e) {
        return "'" + e + "'";
    }

    static /* synthetic */ String lambda$null$14(EditorAnim e) {
        return e.toString();
    }

    static /* synthetic */ void lambda$null$13(int id, SerializedAnimation a) {
        a.triggerID = id;
    }

    static /* synthetic */ boolean lambda$null$12(SerializedAnimation e) {
        return e != null;
    }

    static /* synthetic */ boolean lambda$null$11(SerializedTrigger e) {
        return e != null;
    }

    static /* synthetic */ boolean lambda$null$10(EditorAnim e) {
        return e.mustFinish;
    }

    static /* synthetic */ void lambda$processAnimation$9(AnimationExporter this_, SerializedAnimation anim, EditorAnim a, List frames, ModelElement me) {
        if (!this_.allElems.contains(me)) {
            return;
        }
        Map<InterpolatorChannel, Integer> c = AnimatorChannel.addCubeToChannels(anim, me.id, a.add);
        if (frames.stream().anyMatch(AnimationExporter$$Lambda$29.lambdaFactory$(me))) {
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.POS_X, a, 0.0f);
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.POS_Y, a, 0.0f);
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.POS_Z, a, 0.0f);
        }
        if (frames.stream().anyMatch(AnimationExporter$$Lambda$30.lambdaFactory$(me))) {
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.ROT_X, a, 0.0f);
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.ROT_Y, a, 0.0f);
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.ROT_Z, a, 0.0f);
        }
        if (frames.stream().anyMatch(AnimationExporter$$Lambda$31.lambdaFactory$(me))) {
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.COLOR_R, a, 0.0f);
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.COLOR_G, a, 0.0f);
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.COLOR_B, a, 0.0f);
        }
        if (frames.stream().anyMatch(AnimationExporter$$Lambda$32.lambdaFactory$(me))) {
            boolean[] array = new boolean[frames.size()];
            for (int i = 0; i < frames.size(); ++i) {
                AnimFrame frm = (AnimFrame)frames.get(i);
                IElem dt = frm.getData(me);
                array[i] = dt == null ? me.isVisible() : dt.isVisible();
            }
            anim.animatorChannels.get((Object)c.get(null)).frameData = new ConstantTimeBool(array);
        }
        if (frames.stream().anyMatch(AnimationExporter$$Lambda$33.lambdaFactory$(me))) {
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.SCALE_X, a, 1.0f);
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.SCALE_Y, a, 1.0f);
            AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.SCALE_Z, a, 1.0f);
        }
    }

    static /* synthetic */ boolean lambda$null$8(ModelElement me, AnimFrame f) {
        return f.hasScaleChanges(me);
    }

    static /* synthetic */ boolean lambda$null$7(ModelElement me, AnimFrame f) {
        return f.hasVisChanges(me);
    }

    static /* synthetic */ boolean lambda$null$6(ModelElement me, AnimFrame f) {
        return f.hasColorChanges(me);
    }

    static /* synthetic */ boolean lambda$null$5(ModelElement me, AnimFrame f) {
        return f.hasRotChanges(me);
    }

    static /* synthetic */ boolean lambda$null$4(ModelElement me, AnimFrame f) {
        return f.hasPosChanges(me);
    }

    static /* synthetic */ void lambda$processAnimation$3(AnimationExporter this_, Staging st, EditorAnim ea) {
        this_.stagingAnimMap.put(ea, st);
    }

    static /* synthetic */ Staging lambda$processAnimation$2(AnimationExporter this_, EditorAnim a) {
        Staging s = new Staging();
        s.id = this_.stagingAnimList.size();
        this_.stagingAnimList.add(s);
        this_.stagingAnimMap.put(a, s);
        return s;
    }

    static /* synthetic */ boolean lambda$processAnimation$1(Staging e) {
        return e != null;
    }

    static /* synthetic */ int lambda$processAnimation$0(EditorAnim ax) {
        return ax.duration;
    }

    public static class ParameterInfo {
        public AbstractGestureButtonData.AbstractCommandTriggerableData button;
        public int parameter;
        public int value;
        public boolean bitMask;
        public boolean interpolate;

        public ParameterInfo(AbstractGestureButtonData.AbstractCommandTriggerableData button, int id) {
            this.button = button;
            this.value = id;
        }

        public ParameterInfo(AbstractGestureButtonData.AbstractCommandTriggerableData button, int parameter, boolean interpolate) {
            this.button = button;
            this.parameter = parameter;
            this.interpolate = interpolate;
        }

        public ParameterInfo(AbstractGestureButtonData.AbstractCommandTriggerableData button, int parameter, int value, boolean bitMask) {
            this.button = button;
            this.parameter = parameter;
            this.value = value;
            this.bitMask = bitMask;
        }

        public ParameterInfo(AbstractGestureButtonData.AbstractCommandTriggerableData button, ParameterDetails.ParameterAllocator.BitInfo bit) {
            this(button, bit.param, bit.mask, true);
        }

        public void apply(SerializedTrigger st) {
            st.parameter = this.parameter;
            st.value = this.value;
            st.bitMask = this.bitMask;
            st.parameterInterpolate = this.interpolate;
        }
    }

    private static class Staging {
        public int id;
        public Set<EditorAnim> setup = new HashSet<EditorAnim>();
        public Set<EditorAnim> play = new HashSet<EditorAnim>();
        public Set<EditorAnim> finish = new HashSet<EditorAnim>();
        public int triggerId;

        private Staging() {
        }
    }
}

