/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.gui.UI;
import com.tom.cpl.gui.UpdaterRegistry;
import com.tom.cpl.gui.elements.Tree;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Direction;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor$$Lambda$1;
import com.tom.cpm.shared.editor.Editor$$Lambda$10;
import com.tom.cpm.shared.editor.Editor$$Lambda$11;
import com.tom.cpm.shared.editor.Editor$$Lambda$12;
import com.tom.cpm.shared.editor.Editor$$Lambda$13;
import com.tom.cpm.shared.editor.Editor$$Lambda$14;
import com.tom.cpm.shared.editor.Editor$$Lambda$15;
import com.tom.cpm.shared.editor.Editor$$Lambda$16;
import com.tom.cpm.shared.editor.Editor$$Lambda$17;
import com.tom.cpm.shared.editor.Editor$$Lambda$18;
import com.tom.cpm.shared.editor.Editor$$Lambda$19;
import com.tom.cpm.shared.editor.Editor$$Lambda$2;
import com.tom.cpm.shared.editor.Editor$$Lambda$20;
import com.tom.cpm.shared.editor.Editor$$Lambda$21;
import com.tom.cpm.shared.editor.Editor$$Lambda$22;
import com.tom.cpm.shared.editor.Editor$$Lambda$23;
import com.tom.cpm.shared.editor.Editor$$Lambda$24;
import com.tom.cpm.shared.editor.Editor$$Lambda$25;
import com.tom.cpm.shared.editor.Editor$$Lambda$26;
import com.tom.cpm.shared.editor.Editor$$Lambda$27;
import com.tom.cpm.shared.editor.Editor$$Lambda$28;
import com.tom.cpm.shared.editor.Editor$$Lambda$29;
import com.tom.cpm.shared.editor.Editor$$Lambda$3;
import com.tom.cpm.shared.editor.Editor$$Lambda$30;
import com.tom.cpm.shared.editor.Editor$$Lambda$31;
import com.tom.cpm.shared.editor.Editor$$Lambda$32;
import com.tom.cpm.shared.editor.Editor$$Lambda$33;
import com.tom.cpm.shared.editor.Editor$$Lambda$34;
import com.tom.cpm.shared.editor.Editor$$Lambda$35;
import com.tom.cpm.shared.editor.Editor$$Lambda$36;
import com.tom.cpm.shared.editor.Editor$$Lambda$37;
import com.tom.cpm.shared.editor.Editor$$Lambda$38;
import com.tom.cpm.shared.editor.Editor$$Lambda$39;
import com.tom.cpm.shared.editor.Editor$$Lambda$4;
import com.tom.cpm.shared.editor.Editor$$Lambda$40;
import com.tom.cpm.shared.editor.Editor$$Lambda$41;
import com.tom.cpm.shared.editor.Editor$$Lambda$42;
import com.tom.cpm.shared.editor.Editor$$Lambda$43;
import com.tom.cpm.shared.editor.Editor$$Lambda$44;
import com.tom.cpm.shared.editor.Editor$$Lambda$45;
import com.tom.cpm.shared.editor.Editor$$Lambda$46;
import com.tom.cpm.shared.editor.Editor$$Lambda$47;
import com.tom.cpm.shared.editor.Editor$$Lambda$48;
import com.tom.cpm.shared.editor.Editor$$Lambda$49;
import com.tom.cpm.shared.editor.Editor$$Lambda$5;
import com.tom.cpm.shared.editor.Editor$$Lambda$50;
import com.tom.cpm.shared.editor.Editor$$Lambda$51;
import com.tom.cpm.shared.editor.Editor$$Lambda$52;
import com.tom.cpm.shared.editor.Editor$$Lambda$53;
import com.tom.cpm.shared.editor.Editor$$Lambda$54;
import com.tom.cpm.shared.editor.Editor$$Lambda$55;
import com.tom.cpm.shared.editor.Editor$$Lambda$56;
import com.tom.cpm.shared.editor.Editor$$Lambda$57;
import com.tom.cpm.shared.editor.Editor$$Lambda$58;
import com.tom.cpm.shared.editor.Editor$$Lambda$59;
import com.tom.cpm.shared.editor.Editor$$Lambda$6;
import com.tom.cpm.shared.editor.Editor$$Lambda$60;
import com.tom.cpm.shared.editor.Editor$$Lambda$61;
import com.tom.cpm.shared.editor.Editor$$Lambda$7;
import com.tom.cpm.shared.editor.Editor$$Lambda$8;
import com.tom.cpm.shared.editor.Editor$$Lambda$9;
import com.tom.cpm.shared.editor.EditorDefinition;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.EditorTool;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.FormatLimits;
import com.tom.cpm.shared.editor.Generators;
import com.tom.cpm.shared.editor.actions.Action;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.anim.AnimationEncodingData;
import com.tom.cpm.shared.editor.anim.AnimationProperties;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.elements.MultiSelector;
import com.tom.cpm.shared.editor.elements.RootGroups;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.gui.RenderUtil;
import com.tom.cpm.shared.editor.gui.ViewportPanel;
import com.tom.cpm.shared.editor.project.ProjectFile;
import com.tom.cpm.shared.editor.project.ProjectIO;
import com.tom.cpm.shared.editor.project.loaders.AnimationsLoaderV1;
import com.tom.cpm.shared.editor.tags.EditorTags;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.template.TemplateSettings;
import com.tom.cpm.shared.editor.tree.ScalingElement;
import com.tom.cpm.shared.editor.tree.TexturesElement;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.editor.util.QuickTask;
import com.tom.cpm.shared.editor.util.StoreIDGen;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.model.PartPosition;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.PerFaceUV;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.skin.TextureType;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.PlayerModelLayer;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Editor {
    public UpdaterRegistry updaterReg = new UpdaterRegistry();
    public UpdaterRegistry.Updater<Vec3f> setOffset = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Vec3f> setRot = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Vec3f> setPosition = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Vec3f> setSize = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Vec3f> setMeshScale = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Float> setMCScale = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setMirror = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<String> updateName = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<String> setModeBtn = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<ModeDisplayType> setModePanel = this.updaterReg.create(ModeDisplayType.NULL);
    public UpdaterRegistry.Updater<Vec3i> setTexturePanel = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setVis = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setDelEn = this.updaterReg.create(false);
    public UpdaterRegistry.Updater<Boolean> setAddEn = this.updaterReg.create(false);
    public UpdaterRegistry.Updater<Boolean> setGlow = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Integer> setPartColor = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setReColor = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Integer> setAnimFrame = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Vec3f> setAnimPos = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Vec3f> setAnimRot = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Vec3f> setAnimScale = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setFrameAddEn = this.updaterReg.create(false);
    public UpdaterRegistry.Updater<Boolean> setAnimDelEn = this.updaterReg.create(false);
    public UpdaterRegistry.Updater<Boolean> setFrameDelEn = this.updaterReg.create(false);
    public UpdaterRegistry.Updater<Integer> setAnimDuration = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Integer> setAnimColor = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setAnimShow = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setAnimPlayEn = this.updaterReg.create(false);
    public UpdaterRegistry.Updater<Boolean> setHiddenEffect = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setSingleTex = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setPerFaceUV = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setExtrudeEffect = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Integer> setAnimPriority = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Integer> setAnimOrder = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> displayViewport = this.updaterReg.create(true);
    public UpdaterRegistry.Updater<Boolean> setEnAddAnimTex = this.updaterReg.create(false);
    public UpdaterRegistry.Updater<Boolean> setCopyTransformEffect = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Boolean> setDisableVanillaEffect = this.updaterReg.create(null);
    public UpdaterRegistry.Updater<Integer> setPenColor = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> setNameDisplay = this.updaterReg.create();
    public UpdaterRegistry.Updater<Void> updateGui = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> setUndo = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> setRedo = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setSkinEdited = this.updaterReg.create();
    public UpdaterRegistry.Updater<String> setReload = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setAnimPlay = this.updaterReg.create();
    public UpdaterRegistry.Updater<EditorAnim> setSelAnim = this.updaterReg.create();
    public UpdaterRegistry.Updater<Float> setValue = this.updaterReg.create();
    public UpdaterRegistry.Updater<Vec4f> setFaceUVs = this.updaterReg.create();
    public UpdaterRegistry.Updater<PerFaceUV.Rot> setFaceRot = this.updaterReg.create();
    public UpdaterRegistry.Updater<Boolean> setAutoUV = this.updaterReg.create();
    public UpdaterRegistry.Updater<Pair<Integer, String>> setInfoMsg = this.updaterReg.create();
    public Tree.TreeHandler<TreeElement> treeHandler = new Tree.TreeHandler<TreeElement>(new TreeElement.ModelTree(this));
    public UpdaterRegistry.UpdaterWithValue<QuickTask> setQuickAction = this.updaterReg.createValue(null);
    public Supplier<Vec2i> cursorPos;
    public int penColor = 0xFFFFFF;
    public UpdaterRegistry.UpdaterWithValue<EditorTool> drawMode = this.updaterReg.createValue(EditorTool.PEN);
    public int brushSize = 1;
    public int alphaValue = 255;
    public UpdaterRegistry.BooleanUpdater drawAllUVs = this.updaterReg.createBool(false);
    public UpdaterRegistry.BooleanUpdater onlyDrawOnSelected = this.updaterReg.createBool(true);
    public UpdaterRegistry.BooleanUpdater playVanillaAnims = this.updaterReg.createBool(true);
    public UpdaterRegistry.BooleanUpdater playAnimatedTex = this.updaterReg.createBool(true);
    public UpdaterRegistry.BooleanUpdater drawParrots = this.updaterReg.createBool(false);
    public boolean displayChat = true;
    public boolean displayAdvScaling = ModConfig.getCommonConfig().getBoolean("advScalingSettings", false);
    public UpdaterRegistry.BooleanUpdater forceHeldItemInAnim = this.updaterReg.createBool(false);
    public UpdaterRegistry.BooleanUpdater displayGizmo = this.updaterReg.createBool(true);
    public UpdaterRegistry.BooleanUpdater showOutlines = this.updaterReg.createBool(true);
    public EnumMap<ItemSlot, DisplayItem> handDisplay = new EnumMap(ItemSlot.class);
    public Set<PlayerModelLayer> modelDisplayLayers = new HashSet<PlayerModelLayer>();
    public Map<String, Float> animTestSliders = new HashMap<String, Float>();
    public Set<VanillaPose> testPoses = EnumSet.noneOf(VanillaPose.class);
    public ScalingElement scalingElem = new ScalingElement(this);
    public UpdaterRegistry.UpdaterWithValue<Direction> perfaceFaceDir = this.updaterReg.createValue(Direction.UP);
    public ViewportCamera camera = new ViewportCamera();
    private Stack<Action> undoQueue = new Stack();
    private Stack<Action> redoQueue = new Stack();
    public UpdaterRegistry.BooleanUpdater renderBase = this.updaterReg.createBool(true);
    public boolean applyAnim;
    public boolean playFullAnim;
    public UpdaterRegistry.BooleanUpdater playerTpose = this.updaterReg.createBool(false);
    public boolean applyScaling;
    public UpdaterRegistry.BooleanUpdater drawBoundingBox = this.updaterReg.createBool(false);
    public long playStartTime;
    public AnimationEncodingData animEnc;
    public UpdaterRegistry.BooleanUpdater showPreviousFrame = this.updaterReg.createBool(true);
    public UI ui;
    private boolean initialized;
    public TreeElement selectedElement;
    public List<ModelElement> elements = new ArrayList<ModelElement>();
    public EditorAnim selectedAnim;
    public List<Runnable> animsToPlay = new ArrayList<Runnable>();
    public IPose poseToApply;
    public IPose renderedPose;
    public List<EditorAnim> animations = new ArrayList<EditorAnim>();
    public List<EditorTemplate> templates = new ArrayList<EditorTemplate>();
    public PartPosition leftHandPos = new PartPosition();
    public PartPosition rightHandPos = new PartPosition();
    public TemplateSettings templateSettings;
    public TexturesElement texElem = new TexturesElement(this);
    public SkinType skinType;
    public boolean customSkinType;
    public ModelDescription description;
    public String modelId;
    public boolean hideHeadIfSkull;
    public boolean removeArmorOffset;
    public boolean removeBedOffset;
    public boolean enableInvisGlow;
    public Image vanillaSkin;
    public boolean dirty;
    public boolean autoSaveDirty;
    public long lastEdit;
    public EditorDefinition definition;
    public Map<TextureSheetType, ETextures> textures = new HashMap<TextureSheetType, ETextures>();
    public TextureProvider textureEditorBg = new TextureProvider(new Image(2, 2), new Vec2i(2, 2));
    public EditorTags tags = new EditorTags(this);
    public File file;
    public ProjectFile project = new ProjectFile();
    public int exportSize;

    public Editor() {
        this.definition = new EditorDefinition(this);
        this.textures.put(TextureSheetType.SKIN, new ETextures(this, TextureSheetType.SKIN, Editor$$Lambda$1.lambdaFactory$(this)));
    }

    public void setUI(UI ui) {
        this.ui = ui;
    }

    public void setVec(Vec3f v, VecType object) {
        if (this.selectedElement != null) {
            this.selectedElement.setVec(v, object);
        }
    }

    public void setValue(float value) {
        if (this.selectedElement != null) {
            this.action("set", "action.cpm.value").updateValueOp(this.selectedElement, Float.valueOf(this.selectedElement.getValue()), Float.valueOf(value), Editor$$Lambda$2.lambdaFactory$()).execute();
        }
    }

    public void setName(String name) {
        if (this.selectedElement != null) {
            this.action("set", "label.cpm.name").updateValueOp(this.selectedElement, this.selectedElement.getElemName(), name, Editor$$Lambda$3.lambdaFactory$()).execute();
            this.treeHandler.update();
            this.updateGui.accept(null);
        }
    }

    public void switchMode() {
        if (this.selectedElement != null) {
            this.selectedElement.modeSwitch();
        }
    }

    public void setColor(int color) {
        this.updateValue(color, Editor$$Lambda$4.lambdaFactory$());
    }

    public void setMcScale(float value) {
        this.updateValue(Float.valueOf(value), Editor$$Lambda$5.lambdaFactory$());
    }

    public void addNew() {
        if (this.selectedElement != null) {
            this.selectedElement.addNew();
        }
    }

    public void deleteSel() {
        if (this.selectedElement != null) {
            this.selectedElement.delete();
        }
    }

    public void switchVis() {
        if (this.selectedElement != null) {
            this.selectedElement.switchVis();
        }
    }

    public void switchEffect(Effect e) {
        if (this.selectedElement != null) {
            this.selectedElement.switchEffect(e);
        }
    }

    public void switchLock() {
        ModelElement me = this.getSelectedElement();
        if (me != null) {
            me.locked = !me.locked;
            this.updateGui();
        }
    }

    public void setTexSize(int x, int y) {
        ETextures texs = this.getTextureProvider();
        if (texs != null) {
            EditorTexture tex = texs.provider;
            ActionBuilder actionBuilder = this.action("set", "action.cpm.texSize").updateValueOp(tex, tex.size.x, x, Editor$$Lambda$6.lambdaFactory$()).updateValueOp(tex, tex.size.y, y, Editor$$Lambda$7.lambdaFactory$());
            ETextures eTextures = texs;
            eTextures.getClass();
            actionBuilder.onAction(Editor$$Lambda$8.lambdaFactory$(eTextures)).onAction(Editor$$Lambda$9.lambdaFactory$(this)).execute();
        }
    }

    public void drawPixel(int x, int y, boolean isSkin) {
        switch (this.drawMode.get()) {
            case PEN: {
                this.setPixel(x, y, this.penColor | this.alphaValue << 24);
                break;
            }
            case RUBBER: {
                this.setPixel(x, y, 0);
                break;
            }
            case FILL: {
                int fillColor;
                Box box;
                ETextures texs = this.getTextureProvider();
                if (texs == null || !texs.isEditable()) break;
                Box box2 = box = this.selectedElement != null ? this.selectedElement.getTextureBox() : null;
                if (box != null && this.onlyDrawOnSelected.get() && !box.isInBounds(x, y)) {
                    return;
                }
                Image img = texs.getImage();
                if (x < 0 || y < 0 || x >= img.getWidth() || y >= img.getHeight()) {
                    return;
                }
                int old = img.getRGB(x, y);
                if (old == (fillColor = this.penColor | this.alphaValue << 24)) {
                    return;
                }
                if (!texs.isEdited()) {
                    this.setSkinEdited.accept(true);
                }
                HashSet<Vec2i> pixels = new HashSet<Vec2i>();
                Stack<Vec2i> nextPixels = new Stack<Vec2i>();
                nextPixels.add(new Vec2i(x, y));
                while (!nextPixels.empty()) {
                    int color;
                    Vec2i p = (Vec2i)nextPixels.pop();
                    if (pixels.contains(p) || p.x < 0 || p.y < 0 || p.x >= img.getWidth() || p.y >= img.getHeight() || (color = img.getRGB(p.x, p.y)) != old && ((old & 0xFF000000) != 0 || (color & 0xFF000000) != 0) || box != null && this.onlyDrawOnSelected.get() && !box.isInBounds(p.x, p.y)) continue;
                    pixels.add(p);
                    nextPixels.add(new Vec2i(p.x - 1, p.y));
                    nextPixels.add(new Vec2i(p.x + 1, p.y));
                    nextPixels.add(new Vec2i(p.x, p.y - 1));
                    nextPixels.add(new Vec2i(p.x, p.y + 1));
                }
                ActionBuilder actionBuilder = this.action("bucketFill").onRun(Editor$$Lambda$10.lambdaFactory$(pixels, texs, fillColor)).onUndo(Editor$$Lambda$11.lambdaFactory$(pixels, texs, old));
                ETextures eTextures = texs;
                eTextures.getClass();
                actionBuilder.onAction(Editor$$Lambda$12.lambdaFactory$(eTextures)).execute();
                break;
            }
        }
    }

    private void setPixel(int x, int y, int color) {
        ETextures texs = this.getTextureProvider();
        if (texs != null && texs.isEditable()) {
            Box box;
            Box box2 = box = this.selectedElement != null ? this.selectedElement.getTextureBox() : null;
            if (box != null && this.onlyDrawOnSelected.get() && !box.isInBounds(x, y)) {
                return;
            }
            Image img = texs.getImage();
            if (x < 0 || y < 0 || x >= img.getWidth() || y >= img.getHeight()) {
                return;
            }
            int old = img.getRGB(x, y);
            if (old == color) {
                return;
            }
            if (!texs.isEdited()) {
                this.setSkinEdited.accept(true);
            }
            ActionBuilder actionBuilder = this.action("draw").onUndo(Editor$$Lambda$13.lambdaFactory$(texs, x, y, old)).onRun(Editor$$Lambda$14.lambdaFactory$(texs, x, y, color));
            ETextures eTextures = texs;
            eTextures.getClass();
            actionBuilder.onAction(Editor$$Lambda$15.lambdaFactory$(eTextures)).execute();
        }
    }

    public void markDirty() {
        this.markDirty0();
        this.redoQueue.clear();
        this.setUndo.accept(this.undoQueue.empty() ? null : this.undoQueue.peek().getName());
        this.setRedo.accept(null);
        this.setQuickAction.accept(null);
    }

    private void markDirty0() {
        this.setNameDisplay.accept((this.file == null ? this.ui.i18nFormat("label.cpm.new_project", new Object[0]) : this.file.getName()) + "*");
        this.dirty = true;
        if (!this.autoSaveDirty) {
            this.lastEdit = System.currentTimeMillis();
        }
        this.autoSaveDirty = true;
    }

    public void updateGui() {
        this.updaterReg.setDefault();
        this.applyScaling = false;
        if (this.templateSettings != null) {
            this.templateSettings.templateArgs.forEach(Editor$$Lambda$16.lambdaFactory$());
        }
        this.templates.forEach(Editor$$Lambda$17.lambdaFactory$());
        if (this.selectedElement != null) {
            this.selectedElement.updateGui();
        }
        this.setNameDisplay.accept((this.file == null ? this.ui.i18nFormat("label.cpm.new_project", new Object[0]) : this.file.getName()) + (this.dirty ? "*" : ""));
        this.setUndo.accept(this.undoQueue.empty() ? null : this.undoQueue.peek().getName());
        this.setRedo.accept(this.redoQueue.empty() ? null : this.redoQueue.peek().getName());
        if (this.selectedAnim != null) {
            this.selectedAnim.updateGui();
        }
        this.setSelAnim.accept(this.selectedAnim);
        ETextures tex = this.getTextureProvider();
        this.setSkinEdited.accept(tex != null ? tex.isEdited() : false);
        this.setReload.accept(tex != null && tex.file != null ? tex.file.getName() : null);
        this.treeHandler.update();
        this.updateGui.accept(null);
    }

    public void loadDefaultPlayerModel() {
        Image skin;
        this.project = new ProjectFile();
        this.elements.clear();
        this.animations.clear();
        this.templates.clear();
        this.templateSettings = null;
        this.textures.values().forEach(Editor$$Lambda$18.lambdaFactory$());
        ETextures skinTex = this.textures.get((Object)TextureSheetType.SKIN);
        this.textures.clear();
        skinTex.clean();
        this.textures.put(TextureSheetType.SKIN, skinTex);
        this.undoQueue.clear();
        this.redoQueue.clear();
        this.leftHandPos = new PartPosition();
        this.rightHandPos = new PartPosition();
        try {
            this.skinType = MinecraftClientAccess$.get().getSkinType();
        }
        catch (NullPointerException e) {
            this.ui.onGuiException(this.ui.i18nFormat("error.cpm.corruptedInstall", new Object[0]), e, true);
            return;
        }
        this.vanillaSkin = skin = this.skinType.getSkinTexture();
        skinTex.setDefaultImg(this.vanillaSkin);
        this.customSkinType = false;
        skinTex.setImage(new Image(skin));
        skinTex.provider.size = new Vec2i(skin.getWidth(), skin.getHeight());
        this.dirty = false;
        this.autoSaveDirty = false;
        this.file = null;
        this.selectedElement = null;
        this.selectedAnim = null;
        this.animEnc = null;
        this.description = null;
        this.scalingElem.reset();
        this.removeArmorOffset = true;
        this.hideHeadIfSkull = true;
        this.removeBedOffset = false;
        this.enableInvisGlow = false;
        this.modelId = null;
        this.tags.clear();
        Player<?> profile = MinecraftClientAccess$.get().getClientPlayer();
        profile.getTextures().load().thenRun(Editor$$Lambda$19.lambdaFactory$(this, profile, skinTex));
        for (PlayerModelParts type : PlayerModelParts.values()) {
            if (type == PlayerModelParts.CUSTOM_PART) continue;
            this.elements.add(new ModelElement(this, ElementType.ROOT_PART, type));
        }
        this.restitchTextures();
    }

    public void preRender() {
        this.definition.preRender();
        this.elements.forEach(Editor$$Lambda$20.lambdaFactory$());
        this.applyAnimations();
        this.elements.forEach(Editor$$Lambda$21.lambdaFactory$());
        if (this.playAnimatedTex.get()) {
            this.textures.values().forEach(Editor$$Lambda$22.lambdaFactory$());
        }
    }

    public void applyAnimations() {
        if (this.applyAnim && this.selectedAnim != null) {
            if (this.playFullAnim) {
                long playTime = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine().getTime();
                long currentStep = playTime - this.playStartTime;
                this.selectedAnim.animate(currentStep, this.definition, AnimationEngine.AnimationMode.PLAYER);
                if (currentStep > (long)this.selectedAnim.duration && !this.selectedAnim.loop && this.selectedAnim.pose == null) {
                    this.playFullAnim = false;
                    this.setAnimPlay.accept(false);
                }
            } else {
                this.selectedAnim.apply();
            }
        } else if (this.applyAnim && !this.animsToPlay.isEmpty()) {
            for (Runnable anim : this.animsToPlay) {
                anim.run();
            }
            this.animsToPlay.clear();
        }
    }

    private CompletableFuture<Void> save0(File file) {
        try {
            StoreIDGen storeIDgen;
            StoreIDGen storeIDGen = storeIDgen = new StoreIDGen();
            storeIDGen.getClass();
            Editor.walkElements(this.elements, Editor$$Lambda$23.lambdaFactory$(storeIDGen));
            ProjectIO.saveProject(this, this.project);
        }
        catch (IOException e) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(e);
            return f;
        }
        return this.project.save(file);
    }

    public CompletableFuture<Void> save(File file) {
        this.setInfoMsg.accept(Pair.of(200000, this.ui.i18nFormat("tooltip.cpm.saving", file.getName())));
        CompletableFuture<Void> completableFuture = this.save0(file);
        Runnable runnable = Editor$$Lambda$24.lambdaFactory$(this, file);
        UI uI = this.ui;
        uI.getClass();
        return completableFuture.thenRunAsync(runnable, Editor$$Lambda$25.lambdaFactory$(uI));
    }

    public CompletableFuture<Void> load(File file) {
        this.setInfoMsg.accept(Pair.of(200000, this.ui.i18nFormat("tooltip.cpm.loading", file.getName())));
        this.loadDefaultPlayerModel();
        CompletableFuture<Void> completableFuture = this.project.load(file);
        Function function = Editor$$Lambda$26.lambdaFactory$(this, file);
        UI uI = this.ui;
        uI.getClass();
        return completableFuture.thenComposeAsync(function, Editor$$Lambda$27.lambdaFactory$(uI));
    }

    public void reloadSkin() {
        ETextures tex = this.getTextureProvider();
        if (tex != null && tex.file != null) {
            if (tex.isChangedLocally()) {
                this.ui.displayConfirm(this.ui.i18nFormat("label.cpm.reloadQuestion", new Object[0]), Editor$$Lambda$28.lambdaFactory$(this, tex), null);
            } else {
                ActionBuilder ab = this.action("loadTexture");
                this.reloadSkin(ab, tex, tex.file);
            }
        }
        this.markDirty();
    }

    public void reloadSkin(ActionBuilder ab, ETextures tex, File file) {
        CompletableFuture<Image> completableFuture = Image.loadFrom(file);
        Consumer consumer = Editor$$Lambda$29.lambdaFactory$(this, ab, tex);
        UI uI = this.ui;
        uI.getClass();
        ((CompletableFuture)completableFuture.thenAcceptAsync(consumer, Editor$$Lambda$30.lambdaFactory$(uI))).exceptionally(Editor$$Lambda$31.lambdaFactory$(this));
    }

    public void saveSkin(File f) {
        ETextures tex = this.getTextureProvider();
        if (tex != null) {
            try {
                tex.getImage().storeTo(f);
                tex.file = f;
                this.updateGui();
            }
            catch (IOException e) {
                Log.error("Failed to save image", e);
                this.ui.displayMessagePopup(this.ui.i18nFormat("label.cpm.error", new Object[0]), this.ui.i18nFormat("error.cpm.img_save_failed", e.getLocalizedMessage()));
            }
        }
    }

    public ActionBuilder action(String name) {
        return new ActionBuilder(this, this.ui.i18nFormat("action.cpm." + name, new Object[0]));
    }

    public ActionBuilder action(String name, String arg) {
        return new ActionBuilder(this, this.ui.i18nFormat("action.cpm." + name, this.ui.i18nFormat(arg, new Object[0])));
    }

    public void executeAction(Action a) {
        this.undoQueue.add(a);
        a.run();
    }

    public void undo() {
        if (this.undoQueue.empty()) {
            return;
        }
        Action r = this.undoQueue.pop();
        if (r != null) {
            this.redoQueue.add(r);
            r.undo();
        }
        this.markDirty0();
        this.updateGui();
    }

    public void redo() {
        if (this.redoQueue.empty()) {
            return;
        }
        Action r = this.redoQueue.pop();
        if (r != null) {
            this.undoQueue.add(r);
            r.run();
        }
        this.markDirty0();
        this.updateGui();
    }

    public <T> void updateValue(T value, BiConsumer<TreeElement, T> func) {
        if (this.selectedElement != null) {
            func.accept(this.selectedElement, (TreeElement)value);
        }
    }

    public void moveElement(ModelElement element, ModelElement to) {
        if (this.checkChild(element.children, to)) {
            return;
        }
        this.action("move", "action.cpm.cube").addToList(to.children, element).removeFromList(element.parent.children, element).updateValueOp(element, element.parent, to, Editor$$Lambda$32.lambdaFactory$()).execute();
        this.selectedElement = null;
        this.updateGui();
    }

    private boolean checkChild(List<ModelElement> elem, ModelElement to) {
        for (ModelElement modelElement : elem) {
            if (modelElement == to) {
                return true;
            }
            if (!this.checkChild(modelElement.children, to)) continue;
            return true;
        }
        return false;
    }

    public static void walkElements(List<ModelElement> elem, Consumer<ModelElement> c) {
        for (ModelElement modelElement : elem) {
            c.accept(modelElement);
            Editor.walkElements(modelElement.children, c);
        }
    }

    public void setAnimRot(Vec3f v) {
        if (this.selectedAnim != null) {
            this.selectedAnim.setRotation(v);
        }
    }

    public void setAnimPos(Vec3f v) {
        if (this.selectedAnim != null) {
            this.selectedAnim.setPosition(v);
        }
    }

    public void setAnimScale(Vec3f v) {
        if (this.selectedAnim != null) {
            this.selectedAnim.setScale(v);
        }
    }

    public void addNewAnim(AnimationProperties prop) {
        String fn = AnimationsLoaderV1.getFileName(prop.pose, prop.displayName);
        EditorAnim anim = new EditorAnim(this, fn, prop.type, true);
        ActionBuilder ab = this.action("add", "action.cpm.anim");
        anim.setProperties(prop, ab);
        ab.addToList(this.animations, anim).onUndo(Editor$$Lambda$33.lambdaFactory$(this)).execute();
        this.selectedAnim = anim;
        this.updateGui();
    }

    public void editAnim(AnimationProperties prop) {
        if (this.selectedAnim != null) {
            boolean add = this.selectedAnim.add;
            ActionBuilder ab = this.action("edit", "action.cpm.anim");
            this.selectedAnim.setProperties(prop, ab);
            ab.onAction(this.selectedAnim, Editor$$Lambda$34.lambdaFactory$()).execute();
            this.updateGui();
            if (add != prop.add) {
                this.setQuickAction.accept(new QuickTask(this.ui.i18nFormat("button.cpm.fixAdditiveToggle", new Object[0]), this.ui.i18nFormat("tooltip.cpm.fixAdditiveToggle", new Object[0]), Editor$$Lambda$35.lambdaFactory$(this)));
            }
        }
    }

    public void delSelectedAnim() {
        if (this.selectedAnim != null) {
            EditorAnim anim = this.selectedAnim;
            this.action("remove", "action.cpm.anim").removeFromList(this.animations, anim).onRun(Editor$$Lambda$36.lambdaFactory$(this)).execute();
            this.selectedAnim = null;
            this.updateGui();
        }
    }

    public void addNewAnimFrame() {
        this.addNewAnimFrame(true);
    }

    public void addNewAnimFrame(boolean copyCurrent) {
        if (this.selectedAnim != null) {
            this.selectedAnim.addFrame(copyCurrent);
            this.updateGui();
        }
    }

    public void delSelectedAnimFrame() {
        if (this.selectedAnim != null) {
            this.selectedAnim.deleteFrame();
            this.updateGui();
        }
    }

    public void setAnimDuration(int value) {
        if (this.selectedAnim == null) {
            return;
        }
        this.action("setAnim", "label.cpm.duration").updateValueOp(this.selectedAnim, this.selectedAnim.duration, value, 1, FormatLimits.getAnimLenLimit(), Editor$$Lambda$37.lambdaFactory$(), this.setAnimDuration).execute();
    }

    public void setAnimPriority(int value) {
        if (this.selectedAnim == null) {
            return;
        }
        this.action("setAnim", "label.cpm.anim_priority").updateValueOp(this.selectedAnim, this.selectedAnim.priority, value, FormatLimits.getAnimSortLimitsMin(), FormatLimits.getAnimSortLimitsMax(), Editor$$Lambda$38.lambdaFactory$(), this.setAnimPriority).execute();
    }

    public void setAnimOrder(int value) {
        if (this.selectedAnim == null) {
            return;
        }
        this.action("setAnim", "label.cpm.anim_order").updateValueOp(this.selectedAnim, this.selectedAnim.order, value, FormatLimits.getAnimSortLimitsMin(), FormatLimits.getAnimSortLimitsMax(), Editor$$Lambda$39.lambdaFactory$(), this.setAnimOrder).execute();
    }

    public void animPrevFrm() {
        if (this.selectedAnim != null) {
            this.selectedAnim.prevFrame();
            this.updateGui();
        }
    }

    public void animNextFrm() {
        if (this.selectedAnim != null) {
            this.selectedAnim.nextFrame();
            this.updateGui();
        }
    }

    public void setAnimColor(int rgb) {
        if (this.selectedAnim != null) {
            this.selectedAnim.setColor(rgb);
            this.updateGui();
        }
    }

    public void delSelectedAnimPartData(boolean all) {
        if (this.selectedAnim != null) {
            this.selectedAnim.clearSelectedData(all);
            this.updateGui();
        }
    }

    public void switchAnimShow() {
        if (this.selectedAnim != null) {
            this.selectedAnim.switchVisible();
            this.updateGui();
        }
    }

    public void applyRenderPoseForAnim(Consumer<VanillaPose> func) {
        if (this.applyAnim && this.selectedAnim != null && this.selectedAnim.pose instanceof VanillaPose) {
            func.accept((VanillaPose)this.selectedAnim.pose);
        } else if (this.applyAnim && this.poseToApply != null && this.poseToApply instanceof VanillaPose) {
            func.accept((VanillaPose)this.poseToApply);
        }
        this.renderedPose = this.poseToApply;
        this.poseToApply = null;
    }

    public boolean hasVanillaParts() {
        for (PlayerModelParts p : PlayerModelParts.VALUES) {
            for (ModelElement el : this.elements) {
                if (el.type != ElementType.ROOT_PART || el.typeData != p || el.hidden) continue;
                return true;
            }
        }
        return false;
    }

    public ETextures getTextureProvider() {
        return this.selectedElement != null ? this.selectedElement.getTexture() : this.textures.get((Object)TextureSheetType.SKIN);
    }

    public ModelElement getSelectedElement() {
        if (this.selectedElement instanceof TreeElement.TreeSettingElement) {
            TreeElement.TreeSettingElement e = (TreeElement.TreeSettingElement)this.selectedElement;
            if (e.getParent() instanceof ModelElement) {
                return (ModelElement)e.getParent();
            }
            return null;
        }
        return this.selectedElement instanceof ModelElement ? (ModelElement)this.selectedElement : null;
    }

    public void forEachSeletectedElement(Consumer<TreeElement> el) {
        TreeElement elem = this.selectedElement;
        if (this.selectedElement instanceof TreeElement.TreeSettingElement) {
            elem = ((TreeElement.TreeSettingElement)this.selectedElement).getParent();
        }
        if (elem instanceof MultiSelector) {
            ((MultiSelector)elem).forEachSelected(el);
        } else {
            el.accept(elem);
        }
    }

    public void free() {
        this.textures.values().forEach(Editor$$Lambda$40.lambdaFactory$());
        this.definition.cleanup();
        this.textureEditorBg.free();
    }

    public void restitchTextures() {
        this.textures.values().forEach(Editor$$Lambda$41.lambdaFactory$());
        if (this.textures.get((Object)TextureSheetType.SKIN).hasStitches() && this.hasVanillaParts()) {
            Generators.convertModel(this);
        }
    }

    public void tick() {
        int autosave = ModConfig.getCommonConfig().getInt("editorAutosaveTime", 300);
        if (this.autoSaveDirty && autosave > 0 && this.lastEdit + (long)(autosave * 1000) < System.currentTimeMillis()) {
            File modelsDir = new File(MinecraftClientAccess$.get().getGameDir(), "player_models");
            File autosaves = new File(modelsDir, "autosaves");
            autosaves.mkdirs();
            File file = new File(autosaves, String.format("autosave-%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS-", System.currentTimeMillis()) + (this.file == null ? this.ui.i18nFormat("label.cpm.new_project", new Object[0]) : this.file.getName()));
            Log.info("Editor autosave: " + file.getName());
            this.setInfoMsg.accept(Pair.of(5000, this.ui.i18nFormat("tooltip.cpm.autosaving", file.getName())));
            this.autoSaveDirty = false;
            CompletableFuture<Void> completableFuture = this.save0(file);
            BiFunction biFunction = Editor$$Lambda$42.lambdaFactory$(this, file);
            UI uI = this.ui;
            uI.getClass();
            completableFuture.handleAsync(biFunction, Editor$$Lambda$43.lambdaFactory$(uI));
        }
    }

    public void addRoot(RootGroups group) {
        ArrayList<ModelElement> elems = new ArrayList<ModelElement>();
        for (int i = 0; i < group.types.length; ++i) {
            RootModelType type = group.types[i];
            if (!this.elements.stream().noneMatch(Editor$$Lambda$44.lambdaFactory$(type))) continue;
            ModelElement e = new ModelElement(this, ElementType.ROOT_PART, type);
            elems.add(e);
        }
        ActionBuilder ab = this.action("add", "action.cpm.root");
        elems.forEach(Editor$$Lambda$45.lambdaFactory$(this, ab));
        ab.onUndo(Editor$$Lambda$46.lambdaFactory$(this));
        Generators.loadTextures(this, group, Editor$$Lambda$47.lambdaFactory$(this, ab));
        ab.execute();
        this.updateGui();
    }

    public void render(MatrixStack stack, VBuffers buf, ViewportPanel panel) {
        if (this.drawBoundingBox.get()) {
            RenderUtil.renderBounds(stack, buf.getBuffer(panel.getRenderTypes(), RenderMode.OUTLINE), this.getRenderedPose(), this.applyScaling, this.scalingElem);
        }
    }

    public VanillaPose getRenderedPose() {
        VanillaPose pose = null;
        if (this.applyAnim && this.selectedAnim != null && this.selectedAnim.pose instanceof VanillaPose) {
            pose = (VanillaPose)this.selectedAnim.pose;
        } else if (this.applyAnim && this.renderedPose != null && this.renderedPose instanceof VanillaPose) {
            pose = (VanillaPose)this.renderedPose;
        }
        return pose;
    }

    public void animMoveFrame(int i) {
        if (this.selectedAnim != null) {
            this.selectedAnim.moveFrame(i);
            this.updateGui();
        }
    }

    public void addAnimTex() {
        ETextures tex;
        if (this.selectedElement != null && (tex = this.selectedElement.getTexture()) != null) {
            tex.addAnimTex();
        }
    }

    public void refreshCaches() {
        this.restitchTextures();
        this.animations.forEach(Editor$$Lambda$48.lambdaFactory$());
        this.markElementsDirty();
    }

    public void markElementsDirty() {
        Editor.walkElements(this.elements, Editor$$Lambda$49.lambdaFactory$());
    }

    public void saveRecovered() throws Exception {
        File modelsDir = new File(MinecraftClientAccess$.get().getGameDir(), "player_models");
        File autosaves = new File(modelsDir, "autosaves");
        autosaves.mkdirs();
        File file = new File(autosaves, String.format("recovered-%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS-", System.currentTimeMillis()) + (this.file == null ? this.ui.i18nFormat("label.cpm.new_project", new Object[0]) : this.file.getName()));
        this.save0(file).thenRun(Editor$$Lambda$50.lambdaFactory$(file));
    }

    public static void walkFromRoot(ModelElement from, Consumer<ModelElement> c) {
        LinkedList<ModelElement> list = new LinkedList<ModelElement>();
        while (from != null) {
            list.addFirst(from);
            from = from.parent;
        }
        list.forEach(c);
    }

    public void reinit() {
        this.updaterReg.reset();
        if (!this.initialized) {
            this.initialized = true;
            this.loadDefaultPlayerModel();
        }
    }

    static /* synthetic */ void lambda$saveRecovered$31(File file) {
        ModConfig.getCommonConfig().setString("reopenProject", file.getAbsolutePath());
        ModConfig.getCommonConfig().save();
        Log.info("Saved recovery project: " + file.getName());
    }

    static /* synthetic */ void lambda$addRoot$30(Editor this_, ActionBuilder ab, TextureSheetType a, ETextures b) {
        ab.addToMap(this_.textures, a, b);
    }

    static /* synthetic */ void lambda$addRoot$29(Editor this_) {
        this_.selectedElement = null;
    }

    static /* synthetic */ void lambda$addRoot$28(Editor this_, ActionBuilder ab, ModelElement e) {
        ab.addToList(this_.elements, e);
    }

    static /* synthetic */ boolean lambda$addRoot$27(RootModelType type, ModelElement e) {
        return e.type == ElementType.ROOT_PART && e.typeData == type;
    }

    static /* synthetic */ Object lambda$tick$26(Editor this_, File file, Void v, Throwable e) {
        if (e != null) {
            this_.ui.onGuiException("Failed to autosave", e, false);
        } else {
            this_.setInfoMsg.accept(Pair.of(2000, this_.ui.i18nFormat("tooltip.cpm.autoSaveSuccess", file.getName())));
        }
        return null;
    }

    static /* synthetic */ void lambda$setAnimOrder$25(EditorAnim a, Integer b) {
        a.order = b;
    }

    static /* synthetic */ void lambda$setAnimPriority$24(EditorAnim a, Integer b) {
        a.priority = b;
    }

    static /* synthetic */ void lambda$setAnimDuration$23(EditorAnim a, Integer b) {
        a.duration = b;
    }

    static /* synthetic */ void lambda$delSelectedAnim$22(Editor this_) {
        this_.selectedAnim = null;
    }

    static /* synthetic */ void lambda$editAnim$21(Editor this_) {
        Generators.fixAdditive(this_);
    }

    static /* synthetic */ void lambda$addNewAnim$20(Editor this_) {
        this_.selectedAnim = null;
    }

    static /* synthetic */ void lambda$moveElement$19(ModelElement a, ModelElement b) {
        a.parent = b;
    }

    static /* synthetic */ Void lambda$reloadSkin$18(Editor this_, Throwable e) {
        Log.error("Failed to load image", e);
        this_.ui.displayMessagePopup(this_.ui.i18nFormat("label.cpm.error", new Object[0]), this_.ui.i18nFormat("error.cpm.img_load_failed", e.getLocalizedMessage()));
        return null;
    }

    static /* synthetic */ void lambda$reloadSkin$17(Editor this_, ActionBuilder ab, ETextures tex, Image img) {
        if (img.getWidth() > 8192 || img.getHeight() > 8192) {
            this_.ui.displayMessagePopup(this_.ui.i18nFormat("label.cpm.error", new Object[0]), this_.ui.i18nFormat("error.cpm.img_load_failed", this_.ui.i18nFormat("label.cpm.tex_size_too_big", 8192)));
            return;
        }
        ab.updateValueOp(tex, tex.getImage(), img, Editor$$Lambda$51.lambdaFactory$()).updateValueOp(tex, tex.isEdited(), true, Editor$$Lambda$52.lambdaFactory$()).updateValueOp(tex, tex.isChangedLocally(), false, Editor$$Lambda$53.lambdaFactory$());
        if (!tex.customGridSize) {
            ab.updateValueOp(tex, tex.provider.size.x, img.getWidth(), Editor$$Lambda$54.lambdaFactory$()).updateValueOp(tex, tex.provider.size.y, img.getHeight(), Editor$$Lambda$55.lambdaFactory$()).onAction(Editor$$Lambda$56.lambdaFactory$(this_));
        }
        ETextures eTextures = tex;
        eTextures.getClass();
        ab.onAction(Editor$$Lambda$57.lambdaFactory$(eTextures));
        ab.execute();
        this_.setSkinEdited.accept(true);
    }

    static /* synthetic */ void lambda$null$16(ETextures a, Integer b) {
        a.provider.size.y = b;
    }

    static /* synthetic */ void lambda$null$15(ETextures a, Integer b) {
        a.provider.size.x = b;
    }

    static /* synthetic */ void lambda$reloadSkin$14(Editor this_, ETextures tex) {
        ActionBuilder ab = this_.action("loadTexture");
        this_.reloadSkin(ab, tex, tex.file);
    }

    static /* synthetic */ CompletionStage lambda$load$13(Editor this_, File file, Void v) {
        try {
            ProjectIO.loadProject(this_, this_.project);
        }
        catch (Exception e) {
            System.out.println("Err:" + e);
            CompletableFuture f = new CompletableFuture();
            f.completeExceptionally(e);
            return f;
        }
        this_.file = file;
        this_.restitchTextures();
        this_.updateGui();
        this_.setInfoMsg.accept(Pair.of(2000, this_.ui.i18nFormat("tooltip.cpm.loadSuccess", file.getName())));
        return CompletableFuture.completedFuture(null);
    }

    static /* synthetic */ void lambda$save$12(Editor this_, File file) {
        this_.file = file;
        this_.dirty = false;
        this_.autoSaveDirty = false;
        this_.setInfoMsg.accept(Pair.of(2000, this_.ui.i18nFormat("tooltip.cpm.saveSuccess", file.getName())));
        this_.updateGui();
    }

    static /* synthetic */ void lambda$loadDefaultPlayerModel$11(Editor this_, Player profile, ETextures skinTex) {
        if (!this_.customSkinType) {
            this_.skinType = profile.getSkinType();
        }
        CompletableFuture<Image> img = profile.getTextures().getTexture(TextureType.SKIN);
        this_.vanillaSkin = this_.skinType.getSkinTexture();
        skinTex.setDefaultImg(this_.vanillaSkin);
        img.thenAccept(Editor$$Lambda$58.lambdaFactory$(this_, skinTex));
    }

    static /* synthetic */ void lambda$null$10(Editor this_, ETextures skinTex, Image s) {
        if (s != null) {
            this_.vanillaSkin = s;
        }
        if (!skinTex.isEdited()) {
            skinTex.provider.size = new Vec2i(this_.vanillaSkin.getWidth(), this_.vanillaSkin.getHeight());
            skinTex.setDefaultImg(this_.vanillaSkin);
            skinTex.setImage(new Image(this_.vanillaSkin));
            skinTex.setChangedLocally(false);
            this_.restitchTextures();
        }
    }

    static /* synthetic */ void lambda$setPixel$9(ETextures texs, int x, int y, int color) {
        texs.setRGB(x, y, color);
    }

    static /* synthetic */ void lambda$setPixel$8(ETextures texs, int x, int y, int old) {
        texs.setRGB(x, y, old);
    }

    static /* synthetic */ void lambda$drawPixel$7(Set pixels, ETextures texs, int old) {
        pixels.forEach(Editor$$Lambda$59.lambdaFactory$(texs, old));
    }

    static /* synthetic */ void lambda$null$6(ETextures texs, int old, Vec2i p) {
        texs.setRGB(p.x, p.y, old);
    }

    static /* synthetic */ void lambda$drawPixel$5(Set pixels, ETextures texs, int fillColor) {
        pixels.forEach(Editor$$Lambda$60.lambdaFactory$(texs, fillColor));
    }

    static /* synthetic */ void lambda$null$4(ETextures texs, int fillColor, Vec2i p) {
        texs.setRGB(p.x, p.y, fillColor);
    }

    static /* synthetic */ void lambda$setTexSize$3(EditorTexture a, Integer b) {
        a.size.y = b;
    }

    static /* synthetic */ void lambda$setTexSize$2(EditorTexture a, Integer b) {
        a.size.x = b;
    }

    static /* synthetic */ void lambda$new$1(Editor this_, TextureStitcher stitcher) {
        this_.templates.forEach(Editor$$Lambda$61.lambdaFactory$(stitcher));
    }

    static /* synthetic */ void lambda$null$0(TextureStitcher stitcher, EditorTemplate e) {
        e.stitch(stitcher);
    }
}

