/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.UI;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.tag.TagType;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ThrowingConsumer;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ExportException;
import com.tom.cpm.shared.editor.Exporter$$Lambda$1;
import com.tom.cpm.shared.editor.Exporter$$Lambda$10;
import com.tom.cpm.shared.editor.Exporter$$Lambda$11;
import com.tom.cpm.shared.editor.Exporter$$Lambda$12;
import com.tom.cpm.shared.editor.Exporter$$Lambda$13;
import com.tom.cpm.shared.editor.Exporter$$Lambda$14;
import com.tom.cpm.shared.editor.Exporter$$Lambda$15;
import com.tom.cpm.shared.editor.Exporter$$Lambda$16;
import com.tom.cpm.shared.editor.Exporter$$Lambda$17;
import com.tom.cpm.shared.editor.Exporter$$Lambda$18;
import com.tom.cpm.shared.editor.Exporter$$Lambda$19;
import com.tom.cpm.shared.editor.Exporter$$Lambda$2;
import com.tom.cpm.shared.editor.Exporter$$Lambda$20;
import com.tom.cpm.shared.editor.Exporter$$Lambda$21;
import com.tom.cpm.shared.editor.Exporter$$Lambda$22;
import com.tom.cpm.shared.editor.Exporter$$Lambda$23;
import com.tom.cpm.shared.editor.Exporter$$Lambda$24;
import com.tom.cpm.shared.editor.Exporter$$Lambda$25;
import com.tom.cpm.shared.editor.Exporter$$Lambda$26;
import com.tom.cpm.shared.editor.Exporter$$Lambda$27;
import com.tom.cpm.shared.editor.Exporter$$Lambda$3;
import com.tom.cpm.shared.editor.Exporter$$Lambda$4;
import com.tom.cpm.shared.editor.Exporter$$Lambda$5;
import com.tom.cpm.shared.editor.Exporter$$Lambda$6;
import com.tom.cpm.shared.editor.Exporter$$Lambda$7;
import com.tom.cpm.shared.editor.Exporter$$Lambda$8;
import com.tom.cpm.shared.editor.Exporter$$Lambda$9;
import com.tom.cpm.shared.editor.ExporterImpl;
import com.tom.cpm.shared.editor.anim.AnimatedTex;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.popup.AnimEncConfigPopup;
import com.tom.cpm.shared.editor.gui.popup.ExportStringResultPopup;
import com.tom.cpm.shared.editor.gui.popup.OverflowPopup;
import com.tom.cpm.shared.editor.tags.EditorTagManager;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.util.ExportHelper;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.effects.EffectColor;
import com.tom.cpm.shared.effects.EffectCopyTransform;
import com.tom.cpm.shared.effects.EffectDisableVanilla;
import com.tom.cpm.shared.effects.EffectExtrude;
import com.tom.cpm.shared.effects.EffectFirstPersonHandPos;
import com.tom.cpm.shared.effects.EffectGlow;
import com.tom.cpm.shared.effects.EffectHide;
import com.tom.cpm.shared.effects.EffectHideSkull;
import com.tom.cpm.shared.effects.EffectInvisGlow;
import com.tom.cpm.shared.effects.EffectModelScale;
import com.tom.cpm.shared.effects.EffectPerFaceUV;
import com.tom.cpm.shared.effects.EffectRemoveArmorOffset;
import com.tom.cpm.shared.effects.EffectRemoveBedOffset;
import com.tom.cpm.shared.effects.EffectRenderItem;
import com.tom.cpm.shared.effects.EffectScale;
import com.tom.cpm.shared.effects.EffectScaling;
import com.tom.cpm.shared.effects.EffectSingleTexture;
import com.tom.cpm.shared.effects.EffectUV;
import com.tom.cpm.shared.io.ChecksumOutputStream;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.io.SkinDataOutputStream;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.ModelPartAnimatedTexture;
import com.tom.cpm.shared.parts.ModelPartAnimation;
import com.tom.cpm.shared.parts.ModelPartCloneable;
import com.tom.cpm.shared.parts.ModelPartDefinition;
import com.tom.cpm.shared.parts.ModelPartDupRoot;
import com.tom.cpm.shared.parts.ModelPartEnd;
import com.tom.cpm.shared.parts.ModelPartPlayer;
import com.tom.cpm.shared.parts.ModelPartPlayerPos;
import com.tom.cpm.shared.parts.ModelPartRenderEffect;
import com.tom.cpm.shared.parts.ModelPartRoot;
import com.tom.cpm.shared.parts.ModelPartSkin;
import com.tom.cpm.shared.parts.ModelPartSkinType;
import com.tom.cpm.shared.parts.ModelPartTags;
import com.tom.cpm.shared.parts.ModelPartTemplate;
import com.tom.cpm.shared.parts.ModelPartTexture;
import com.tom.cpm.shared.parts.ModelPartUUIDLockout;
import com.tom.cpm.shared.parts.PartCollection;
import com.tom.cpm.shared.paste.PasteClient;
import com.tom.cpm.shared.paste.PastePopup;
import com.tom.cpm.shared.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Exporter {
    public static void exportSkin(Editor e, UI gui, File f, boolean forceOut) {
        Exporter.exportSkin(e, gui, Exporter$$Lambda$1.lambdaFactory$(f, gui), forceOut);
    }

    public static void exportSkin(Editor e, UI gui, ThrowingConsumer<Image, IOException> out, boolean forceOut) {
        if (e.vanillaSkin == null) {
            gui.displayMessagePopup("Unknown Error", "Couldn't load vanilla skin");
            return;
        }
        if (e.vanillaSkin.getWidth() != 64 || e.vanillaSkin.getHeight() != 64) {
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("error.cpm.vanillaSkinSize", new Object[0]));
            return;
        }
        Image img = new Image(e.vanillaSkin);
        Exporter.exportSkin0(e, gui, new Result(Exporter$$Lambda$2.lambdaFactory$(img, e), Exporter$$Lambda$3.lambdaFactory$(out, img), Exporter$$Lambda$4.lambdaFactory$(gui, e)), forceOut);
    }

    public static void exportB64(Editor e, UI gui, Consumer<String> b64Out, boolean forceOut) {
        byte[] buffer = new byte[200];
        int[] size = new int[]{0};
        Exporter.exportSkin0(e, gui, new Result(Exporter$$Lambda$5.lambdaFactory$(size, buffer), Exporter$$Lambda$6.lambdaFactory$(b64Out, buffer, size), Exporter$$Lambda$7.lambdaFactory$(gui, e)), forceOut);
    }

    public static void exportUpdate(Editor e, UI gui, Link linkToUpdate) {
        try {
            PartCollection def = Exporter.prepareExport(e);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(83);
            ChecksumOutputStream cos = new ChecksumOutputStream(baos);
            def.writePackage(new IOHelper(cos));
            cos.close();
            String b64 = Base64.getEncoder().encodeToString(baos.toByteArray());
            Log.info(b64);
            if (linkToUpdate.getLoader().equals("p")) {
                PastePopup.runRequest(gui, Exporter$$Lambda$8.lambdaFactory$(linkToUpdate, b64), Exporter$$Lambda$9.lambdaFactory$(gui), Exporter$$Lambda$10.lambdaFactory$(), "uploading");
            } else {
                gui.displayPopup(Exporter$$Lambda$11.lambdaFactory$(b64));
            }
        }
        catch (ExportException ex) {
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), ex.toString(gui));
        }
        catch (Exception ex) {
            gui.onGuiException("Error while exporting", ex, false);
        }
    }

    public static void exportModel(Editor e, UI gui, File f, ModelDescription desc, boolean skinCompat) {
        ModelWriter wr = new ModelWriter(gui, f, skinCompat);
        wr.setDesc(desc.name, desc.desc, desc.icon);
        ModelWriter modelWriter = wr;
        modelWriter.getClass();
        Exporter.exportSkin0(e, gui, new Result(Exporter$$Lambda$12.lambdaFactory$(modelWriter), Exporter$$Lambda$13.lambdaFactory$(wr, gui, f), Exporter$$Lambda$14.lambdaFactory$(wr, gui, e)), false);
    }

    public static boolean exportTempModel(Editor e, UI gui) {
        File models = new File(MinecraftClientAccess$.get().getGameDir(), "player_models");
        models.mkdirs();
        ModelWriter wr = new ModelWriter(gui, new File(models, ".temp.cpmmodel"), false);
        wr.setDesc("Test model", "", null);
        ModelWriter modelWriter = wr;
        modelWriter.getClass();
        Supplier supplier = Exporter$$Lambda$15.lambdaFactory$(modelWriter);
        ModelWriter modelWriter2 = wr;
        modelWriter2.getClass();
        return Exporter.exportSkin0(e, gui, new Result(supplier, Exporter$$Lambda$16.lambdaFactory$(modelWriter2), Exporter$$Lambda$17.lambdaFactory$(wr)), false);
    }

    private static PartCollection prepareExport(Editor e) throws IOException {
        if (ModConfig.getCommonConfig().getBoolean("experimentalExport0614", false)) {
            return ExporterImpl.prepareExport(e);
        }
        return Exporter.prepareDefinition(e);
    }

    @Deprecated
    private static ModelPartDefinition prepareDefinition(Editor e) throws IOException {
        ArrayList<Cube> flatList = new ArrayList<Cube>();
        ExportHelper.flattenElements(e.elements, new int[]{10}, flatList);
        ModelPartDefinition def = new ModelPartDefinition(flatList);
        ModelPartPlayer player = new ModelPartPlayer(e);
        ArrayList<IModelPart> otherParts = new ArrayList<IModelPart>();
        otherParts.add(player);
        if (e.textures.get((Object)TextureSheetType.SKIN).isEdited()) {
            otherParts.add(new ModelPartSkin(e));
        }
        for (PlayerModelParts p : PlayerModelParts.VALUES) {
            for (ModelElement el : e.elements) {
                if (el.type != ElementType.ROOT_PART || el.typeData != p || el.duplicated || el.pos.epsilon(0.1f) && el.rotation.epsilon(0.1f)) continue;
                otherParts.add(new ModelPartPlayerPos(p.getId(el.rc), el.pos, el.rotation));
            }
        }
        ArrayList otherParts2 = new ArrayList();
        ExportHelper.walkElements(e.elements, Exporter$$Lambda$18.lambdaFactory$(otherParts, otherParts2));
        for (ModelElement el : e.elements) {
            if (el.type != ElementType.ROOT_PART) continue;
            if (el.duplicated && el.typeData instanceof PlayerModelParts) {
                if (el.hidden) {
                    otherParts.add(new ModelPartRenderEffect(new EffectHide(el.id)));
                }
                otherParts.add(new ModelPartDupRoot(el.id, (PlayerModelParts)el.typeData));
            } else if (el.typeData instanceof RootModelType) {
                if (el.hidden) {
                    otherParts.add(new ModelPartRenderEffect(new EffectHide(el.id)));
                }
                otherParts.add(new ModelPartRoot(el.id, (RootModelType)el.typeData));
            }
            if (!el.disableVanillaAnim) continue;
            otherParts.add(new ModelPartRenderEffect(new EffectDisableVanilla(el.id)));
        }
        otherParts.addAll(otherParts2);
        if (!e.animations.isEmpty()) {
            otherParts.add(new ModelPartAnimation(e, otherParts));
        }
        e.textures.forEach(Exporter$$Lambda$19.lambdaFactory$(otherParts, e));
        for (EditorTemplate et : e.templates) {
            otherParts.add(new ModelPartTemplate(et));
        }
        if (e.scalingElem.enabled) {
            otherParts.add(new ModelPartRenderEffect(new EffectScaling(e.scalingElem.scaling)));
            if (e.scalingElem.hasTransform()) {
                otherParts.add(new ModelPartRenderEffect(new EffectModelScale(e.scalingElem.pos, e.scalingElem.rotation, e.scalingElem.scale)));
            }
        }
        if (!e.hideHeadIfSkull) {
            otherParts.add(new ModelPartRenderEffect(new EffectHideSkull(e.hideHeadIfSkull)));
        }
        if (e.removeArmorOffset) {
            otherParts.add(new ModelPartRenderEffect(new EffectRemoveArmorOffset(e.removeArmorOffset)));
        }
        if (e.removeBedOffset) {
            otherParts.add(new ModelPartRenderEffect(new EffectRemoveBedOffset()));
        }
        if (e.enableInvisGlow) {
            otherParts.add(new ModelPartRenderEffect(new EffectInvisGlow()));
        }
        if (e.leftHandPos.isChanged() || e.rightHandPos.isChanged()) {
            otherParts.add(new ModelPartRenderEffect(new EffectFirstPersonHandPos(e.leftHandPos, e.rightHandPos)));
        }
        for (Iterator<TreeElement> iterator : TagType.VALUES) {
            if (!((EditorTagManager)e.tags.getByType((TagType)((Object)iterator))).hasTags()) continue;
            otherParts.add(new ModelPartTags((TagType)((Object)iterator), (EditorTagManager<?>)e.tags.getByType((TagType)((Object)iterator))));
        }
        if (e.description != null) {
            switch (e.description.copyProtection) {
                case CLONEABLE: {
                    otherParts.add(new ModelPartCloneable(e.description.name, e.description.desc, e.description.icon));
                    break;
                }
                case NORMAL: {
                    break;
                }
                case UUID_LOCK: {
                    otherParts.add(new ModelPartUUIDLockout(e.description.uuid != null ? e.description.uuid : MinecraftClientAccess$.get().getClientPlayer().getUUID()));
                    break;
                }
            }
        }
        def.setOtherParts(otherParts);
        if (MinecraftObjectHolder.DEBUGGING) {
            Log.info(def);
        }
        return def;
    }

    private static boolean exportSkin0(Editor e, UI gui, Result result, boolean forceOut) {
        try {
            PartCollection def = Exporter.prepareExport(e);
            if (forceOut) {
                Exporter.writeOut(e, gui, def, result);
                return true;
            }
            try {
                OutputStream out = result.get();
                Throwable throwable = null;
                try {
                    out.write(83);
                    ChecksumOutputStream cos = new ChecksumOutputStream(out);
                    IOHelper dout = new IOHelper(cos);
                    Throwable throwable2 = null;
                    try {
                        dout.writeObjectBlock(new ModelPartSkinType(e.skinType));
                        def.writeBlocks(dout);
                        dout.writeObjectBlock(ModelPartEnd.END);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (dout != null) {
                            if (throwable2 != null) {
                                try {
                                    dout.close();
                                }
                                catch (Throwable throwable4) {
                                }
                            } else {
                                dout.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable6) {
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (EOFException unusedException) {
                Exporter.writeOut(e, gui, def, result);
                return true;
            }
            catch (IOException e1) {
                throw new ExportException(new FormatText("error.cpm.unknownError", new Object[0]), (Throwable)e1);
            }
            result.close();
            return true;
        }
        catch (ExportException ex) {
            Log.error("Export exception", ex);
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), ex.toString(gui));
            return false;
        }
        catch (Exception ex) {
            gui.onGuiException("Error while exporting", ex, false);
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("tooltip.cpm.errorTooltip", gui.i18nFormat("error.cpm.unknownError", new Object[0])));
            return false;
        }
    }

    private static void writeOut(Editor e, UI gui, PartCollection def, Result result) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(83);
        ChecksumOutputStream cos = new ChecksumOutputStream(baos);
        def.writePackage(new IOHelper(cos));
        cos.close();
        result.overflowWriter.accept(baos.toByteArray(), Exporter$$Lambda$20.lambdaFactory$(def, result, e, gui));
    }

    public static boolean check(Editor editor, UI gui, Runnable next) {
        if (!editor.animations.isEmpty() && editor.animEnc == null && editor.animations.stream().anyMatch(Exporter$$Lambda$21.lambdaFactory$())) {
            gui.displayPopup(Exporter$$Lambda$22.lambdaFactory$(editor, next));
            return false;
        }
        return true;
    }

    private static void handleOverflow(byte[] data, Consumer<Link> linkC, String reason, UI gui, Editor e) {
        String b64 = Base64.getEncoder().encodeToString(data);
        Log.info(b64);
        gui.displayPopup(Exporter$$Lambda$23.lambdaFactory$(e, b64, reason, linkC));
    }

    public static void convert(ModelFile file, Image imgIn, SkinType type, Consumer<Image> outCons, Runnable error) {
        Image img = new Image(imgIn);
        try {
            SkinDataOutputStream out = new SkinDataOutputStream(img, MinecraftClientAccess$.get().getDefinitionLoader().getTemplate(), type.getChannel());
            Throwable throwable = null;
            try {
                out.write(file.getDataBlock());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (IOException e) {
            Log.error("Failed to convert model file to skin", e);
            error.run();
            return;
        }
        outCons.accept(img);
    }

    static /* synthetic */ PopupPanel lambda$handleOverflow$21(Editor e, String b64, String reason, Consumer linkC, Frame f) {
        return new OverflowPopup(f, e, b64, reason, linkC);
    }

    static /* synthetic */ PopupPanel lambda$check$20(Editor editor, Runnable next, Frame f) {
        return new AnimEncConfigPopup(f.getGui(), editor, next);
    }

    static /* synthetic */ void lambda$writeOut$19(PartCollection def, Result result, Editor e, UI gui, Link link) {
        try {
            IModelPart defLink = def.toLink(link);
            OutputStream out = result.get();
            Throwable throwable = null;
            try {
                out.write(83);
                ChecksumOutputStream cos = new ChecksumOutputStream(out);
                IOHelper dout = new IOHelper(cos);
                Throwable throwable2 = null;
                try {
                    dout.writeObjectBlock(new ModelPartSkinType(e.skinType));
                    dout.writeObjectBlock(defLink);
                    dout.writeObjectBlock(ModelPartEnd.END);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (dout != null) {
                        if (throwable2 != null) {
                            try {
                                dout.close();
                            }
                            catch (Throwable throwable4) {
                            }
                        } else {
                            dout.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                        }
                    } else {
                        out.close();
                    }
                }
            }
            result.close();
        }
        catch (ExportException ex) {
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), ex.toString(gui));
        }
        catch (Exception ex) {
            gui.onGuiException("Error while exporting", ex, false);
        }
    }

    static /* synthetic */ void lambda$prepareDefinition$18(List otherParts, Editor e, TextureSheetType type, ETextures tex) {
        if (type.editable) {
            if (type != TextureSheetType.SKIN) {
                otherParts.add(new ModelPartTexture(e, type));
            }
            if (!tex.animatedTexs.isEmpty()) {
                tex.animatedTexs.forEach(Exporter$$Lambda$24.lambdaFactory$(otherParts, type));
            }
        }
    }

    static /* synthetic */ void lambda$null$17(List otherParts, TextureSheetType type, AnimatedTex at) {
        otherParts.add(new ModelPartAnimatedTexture(type, at));
    }

    static /* synthetic */ void lambda$prepareDefinition$16(List otherParts, List otherParts2, ModelElement el) {
        if (el.type == ElementType.NORMAL) {
            if (el.glow) {
                otherParts.add(new ModelPartRenderEffect(new EffectGlow(el.id)));
            }
            if (Math.abs(el.mcScale) > 1.0E-4f || Math.abs(el.meshScale.x - 1.0f) > 0.01f || Math.abs(el.meshScale.y - 1.0f) > 0.01f || Math.abs(el.meshScale.z - 1.0f) > 0.01f) {
                otherParts.add(new ModelPartRenderEffect(new EffectScale(el.id, el.meshScale, el.mcScale)));
            }
            if (el.hidden) {
                otherParts.add(new ModelPartRenderEffect(new EffectHide(el.id)));
            }
            if (el.recolor) {
                otherParts.add(new ModelPartRenderEffect(new EffectColor(el.id, el.rgb)));
            }
            if (el.singleTex) {
                otherParts.add(new ModelPartRenderEffect(new EffectSingleTexture(el.id)));
            }
            if (el.extrude) {
                otherParts.add(new ModelPartRenderEffect(new EffectExtrude(el.id)));
            }
            if (el.faceUV != null) {
                otherParts.add(new ModelPartRenderEffect(new EffectPerFaceUV(el.id, el.faceUV)));
            } else if (el.u > 255 || el.v > 255) {
                otherParts.add(new ModelPartRenderEffect(new EffectUV(el.id, el.u, el.v)));
            }
            if (el.itemRenderer != null) {
                otherParts.add(new ModelPartRenderEffect(new EffectRenderItem(el.id, el.itemRenderer.slot, el.itemRenderer.slotID)));
            }
            if (el.copyTransform != null && el.copyTransform.from != null) {
                otherParts2.add(new ModelPartRenderEffect(new EffectCopyTransform(el.copyTransform.from.id, el.id, el.copyTransform.toShort(), el.copyTransform.multiply)));
            }
        }
    }

    static /* synthetic */ void lambda$exportTempModel$15(ModelWriter wr, byte[] d, Consumer c) {
        Link l = new Link("local:test" + System.nanoTime());
        wr.setOverflow(d, l);
        c.accept(l);
    }

    static /* synthetic */ void lambda$exportModel$14(ModelWriter wr, UI gui, Editor e, byte[] d, Consumer c) {
        Exporter.handleOverflow(d, Exporter$$Lambda$25.lambdaFactory$(wr, d, c), "model", gui, e);
    }

    static /* synthetic */ void lambda$null$13(ModelWriter wr, byte[] d, Consumer c, Link l) {
        wr.setOverflow(d, l);
        c.accept(l);
    }

    static /* synthetic */ void lambda$exportModel$12(ModelWriter wr, UI gui, File f) throws IOException {
        if (wr.finish()) {
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.export_success", new Object[0]), gui.i18nFormat("label.cpm.export_success.desc", f.getName()));
        }
    }

    static /* synthetic */ PopupPanel lambda$exportUpdate$11(String b64, Frame frame) {
        return new ExportStringResultPopup(frame, "skin_update", b64);
    }

    static /* synthetic */ void lambda$exportUpdate$10() {
    }

    static /* synthetic */ void lambda$exportUpdate$9(UI gui) {
        gui.displayPopup(Exporter$$Lambda$26.lambdaFactory$(gui));
    }

    static /* synthetic */ PopupPanel lambda$null$8(UI gui, Frame frame) {
        MessagePopup popup = new MessagePopup(frame, gui.i18nFormat("label.cpm.export_success", new Object[0]), gui.i18nFormat("label.cpm.paste.updatedModel", new Object[0]));
        ModelDefinitionLoader modelDefinitionLoader = MinecraftClientAccess$.get().getDefinitionLoader();
        modelDefinitionLoader.getClass();
        popup.setOnClosed(Exporter$$Lambda$27.lambdaFactory$(modelDefinitionLoader));
        return popup;
    }

    static /* synthetic */ CompletableFuture lambda$exportUpdate$7(Link linkToUpdate, String b64, PasteClient c) {
        return c.updateFile(linkToUpdate.getPath(), b64.getBytes(StandardCharsets.UTF_8));
    }

    static /* synthetic */ void lambda$exportB64$6(UI gui, Editor e, byte[] d, Consumer c) {
        Exporter.handleOverflow(d, c, "b64", gui, e);
    }

    static /* synthetic */ void lambda$exportB64$5(Consumer b64Out, byte[] buffer, int[] size) throws IOException {
        b64Out.accept(Base64.getEncoder().encodeToString(Arrays.copyOf(buffer, size[0])));
    }

    static /* synthetic */ OutputStream lambda$exportB64$4(int[] size, byte[] buffer) {
        size[0] = 0;
        return new BAOS(buffer, size);
    }

    static /* synthetic */ void lambda$exportSkin$3(UI gui, Editor e, byte[] d, Consumer c) {
        Exporter.handleOverflow(d, c, "skin", gui, e);
    }

    static /* synthetic */ void lambda$exportSkin$2(ThrowingConsumer out, Image img) throws IOException {
        out.accept(img);
    }

    static /* synthetic */ OutputStream lambda$exportSkin$1(Image img, Editor e) {
        return new SkinDataOutputStream(img, MinecraftClientAccess$.get().getDefinitionLoader().getTemplate(), e.skinType.getChannel());
    }

    static /* synthetic */ void lambda$exportSkin$0(File f, UI gui, Image img) throws IOException {
        img.storeTo(f);
        gui.displayMessagePopup(gui.i18nFormat("label.cpm.export_success", new Object[0]), gui.i18nFormat("label.cpm.export_success.desc", f.getName()));
    }

    private static class ModelWriter {
        private final UI gui;
        private byte[] buffer;
        private int[] size = new int[]{0};
        private byte[] overflow;
        private File out;
        private String name;
        private String desc;
        private Link l;
        private Image icon;

        public ModelWriter(UI gui, File out, boolean skinCompat) {
            this.gui = gui;
            this.out = out;
            this.buffer = new byte[skinCompat ? 2048 : 30720];
        }

        public void setDesc(String name, String desc, Image icon) {
            this.name = name;
            this.desc = desc;
            this.icon = icon;
        }

        public OutputStream getOut() {
            this.size[0] = 0;
            return new BAOS(this.buffer, this.size);
        }

        public void setOverflow(byte[] d, Link l) {
            this.overflow = d;
            this.l = l;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean finish() {
            try {
                FileOutputStream fout = new FileOutputStream(this.out);
                Throwable throwable = null;
                try {
                    fout.write(83);
                    ChecksumOutputStream cos = new ChecksumOutputStream(fout);
                    IOHelper h = new IOHelper(cos);
                    h.writeUTF(this.name);
                    h.writeUTF(this.desc);
                    h.writeVarInt(this.size[0]);
                    h.write(this.buffer, 0, this.size[0]);
                    if (this.overflow != null) {
                        h.writeByteArray(this.overflow);
                        this.l.write(h);
                    } else {
                        h.writeVarInt(0);
                    }
                    if (this.icon != null) {
                        h.writeImage(this.icon);
                    } else {
                        h.writeVarInt(0);
                    }
                    cos.close();
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fout != null) {
                        if (throwable != null) {
                            try {
                                fout.close();
                            }
                            catch (Throwable throwable2) {
                            }
                        } else {
                            fout.close();
                        }
                    }
                }
            }
            catch (ExportException ex) {
                this.gui.displayMessagePopup(this.gui.i18nFormat("label.cpm.error", new Object[0]), ex.toString(this.gui));
                return false;
            }
            catch (Exception ex) {
                this.gui.onGuiException("Error while exporting", ex, false);
            }
            return false;
        }
    }

    private static class BAOS
    extends OutputStream {
        private byte[] buffer;
        private int[] size;

        public BAOS(byte[] buffer, int[] size) {
            this.buffer = buffer;
            this.size = size;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.buffer.length <= this.size[0]) {
                throw new EOFException();
            }
            int n = this.size[0];
            this.size[0] = n + 1;
            this.buffer[n] = (byte)b;
        }
    }

    private static class Result
    implements Supplier<OutputStream>,
    Closeable {
        private Supplier<OutputStream> out;
        private Closeable finish;
        private BiConsumer<byte[], Consumer<Link>> overflowWriter;

        public Result(Supplier<OutputStream> out, Closeable finish, BiConsumer<byte[], Consumer<Link>> overflowWriter) {
            this.out = out;
            this.finish = finish;
            this.overflowWriter = overflowWriter;
        }

        @Override
        public OutputStream get() {
            return this.out.get();
        }

        @Override
        public void close() throws IOException {
            this.finish.close();
        }
    }
}

