/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.ChooseElementPopup;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Direction;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.editor.CopyTransformEffect;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.FormatLimits;
import com.tom.cpm.shared.editor.Generators$$Lambda$1;
import com.tom.cpm.shared.editor.Generators$$Lambda$10;
import com.tom.cpm.shared.editor.Generators$$Lambda$11;
import com.tom.cpm.shared.editor.Generators$$Lambda$12;
import com.tom.cpm.shared.editor.Generators$$Lambda$13;
import com.tom.cpm.shared.editor.Generators$$Lambda$14;
import com.tom.cpm.shared.editor.Generators$$Lambda$15;
import com.tom.cpm.shared.editor.Generators$$Lambda$16;
import com.tom.cpm.shared.editor.Generators$$Lambda$17;
import com.tom.cpm.shared.editor.Generators$$Lambda$18;
import com.tom.cpm.shared.editor.Generators$$Lambda$19;
import com.tom.cpm.shared.editor.Generators$$Lambda$2;
import com.tom.cpm.shared.editor.Generators$$Lambda$20;
import com.tom.cpm.shared.editor.Generators$$Lambda$21;
import com.tom.cpm.shared.editor.Generators$$Lambda$22;
import com.tom.cpm.shared.editor.Generators$$Lambda$23;
import com.tom.cpm.shared.editor.Generators$$Lambda$24;
import com.tom.cpm.shared.editor.Generators$$Lambda$25;
import com.tom.cpm.shared.editor.Generators$$Lambda$26;
import com.tom.cpm.shared.editor.Generators$$Lambda$27;
import com.tom.cpm.shared.editor.Generators$$Lambda$28;
import com.tom.cpm.shared.editor.Generators$$Lambda$29;
import com.tom.cpm.shared.editor.Generators$$Lambda$3;
import com.tom.cpm.shared.editor.Generators$$Lambda$30;
import com.tom.cpm.shared.editor.Generators$$Lambda$31;
import com.tom.cpm.shared.editor.Generators$$Lambda$32;
import com.tom.cpm.shared.editor.Generators$$Lambda$33;
import com.tom.cpm.shared.editor.Generators$$Lambda$34;
import com.tom.cpm.shared.editor.Generators$$Lambda$35;
import com.tom.cpm.shared.editor.Generators$$Lambda$36;
import com.tom.cpm.shared.editor.Generators$$Lambda$37;
import com.tom.cpm.shared.editor.Generators$$Lambda$38;
import com.tom.cpm.shared.editor.Generators$$Lambda$39;
import com.tom.cpm.shared.editor.Generators$$Lambda$4;
import com.tom.cpm.shared.editor.Generators$$Lambda$40;
import com.tom.cpm.shared.editor.Generators$$Lambda$41;
import com.tom.cpm.shared.editor.Generators$$Lambda$42;
import com.tom.cpm.shared.editor.Generators$$Lambda$43;
import com.tom.cpm.shared.editor.Generators$$Lambda$44;
import com.tom.cpm.shared.editor.Generators$$Lambda$45;
import com.tom.cpm.shared.editor.Generators$$Lambda$46;
import com.tom.cpm.shared.editor.Generators$$Lambda$47;
import com.tom.cpm.shared.editor.Generators$$Lambda$48;
import com.tom.cpm.shared.editor.Generators$$Lambda$49;
import com.tom.cpm.shared.editor.Generators$$Lambda$5;
import com.tom.cpm.shared.editor.Generators$$Lambda$50;
import com.tom.cpm.shared.editor.Generators$$Lambda$51;
import com.tom.cpm.shared.editor.Generators$$Lambda$52;
import com.tom.cpm.shared.editor.Generators$$Lambda$53;
import com.tom.cpm.shared.editor.Generators$$Lambda$54;
import com.tom.cpm.shared.editor.Generators$$Lambda$55;
import com.tom.cpm.shared.editor.Generators$$Lambda$56;
import com.tom.cpm.shared.editor.Generators$$Lambda$57;
import com.tom.cpm.shared.editor.Generators$$Lambda$58;
import com.tom.cpm.shared.editor.Generators$$Lambda$59;
import com.tom.cpm.shared.editor.Generators$$Lambda$6;
import com.tom.cpm.shared.editor.Generators$$Lambda$60;
import com.tom.cpm.shared.editor.Generators$$Lambda$61;
import com.tom.cpm.shared.editor.Generators$$Lambda$62;
import com.tom.cpm.shared.editor.Generators$$Lambda$63;
import com.tom.cpm.shared.editor.Generators$$Lambda$64;
import com.tom.cpm.shared.editor.Generators$$Lambda$65;
import com.tom.cpm.shared.editor.Generators$$Lambda$66;
import com.tom.cpm.shared.editor.Generators$$Lambda$67;
import com.tom.cpm.shared.editor.Generators$$Lambda$68;
import com.tom.cpm.shared.editor.Generators$$Lambda$69;
import com.tom.cpm.shared.editor.Generators$$Lambda$7;
import com.tom.cpm.shared.editor.Generators$$Lambda$70;
import com.tom.cpm.shared.editor.Generators$$Lambda$71;
import com.tom.cpm.shared.editor.Generators$$Lambda$72;
import com.tom.cpm.shared.editor.Generators$$Lambda$73;
import com.tom.cpm.shared.editor.Generators$$Lambda$74;
import com.tom.cpm.shared.editor.Generators$$Lambda$75;
import com.tom.cpm.shared.editor.Generators$$Lambda$8;
import com.tom.cpm.shared.editor.Generators$$Lambda$9;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.actions.ImageAction;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.elements.RootGroups;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup;
import com.tom.cpm.shared.editor.template.TemplateSettings;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.util.QuickTask;
import com.tom.cpm.shared.editor.util.SafetyLevel;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.PlayerPartValues;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.ItemRenderer;
import com.tom.cpm.shared.model.render.PerFaceUV;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class Generators {
    public static List<Generators> generators = new ArrayList<Generators>();
    public String name;
    public FormatText tooltip;
    public Consumer<EditorGui> func;

    public Generators(String name, FormatText tooltip, Consumer<EditorGui> func) {
        this.name = name;
        this.tooltip = tooltip;
        this.func = func;
    }

    private static void register(String name, String tooltip, Consumer<EditorGui> func) {
        generators.add(new Generators(name, tooltip == null ? null : new FormatText(tooltip, new Object[0]), func));
    }

    private static void addSkinLayer(Editor e) {
        ActionBuilder ab = e.action("i", "button.cpm.tools.add_skin_layer2");
        ab.onUndo(Generators$$Lambda$1.lambdaFactory$(e));
        block0: for (PlayerModelParts p : PlayerModelParts.VALUES) {
            for (ModelElement el : e.elements) {
                if (el.type != ElementType.ROOT_PART || el.typeData != p) continue;
                ModelElement elem = new ModelElement(e);
                ab.addToList(el.children, elem);
                elem.parent = el;
                PlayerPartValues val = PlayerPartValues.getFor(p, e.skinType);
                elem.size = val.getSize();
                elem.offset = val.getOffset();
                elem.texture = true;
                elem.u = val.u2;
                elem.v = val.v2;
                elem.name = e.ui.i18nFormat("label.cpm.layer_" + val.layer.getLowerName(), new Object[0]);
                elem.mcScale = 0.25f;
                continue block0;
            }
        }
        ab.execute();
        e.updateGui();
    }

    public static void convertModel(Editor e) {
        ActionBuilder ab = e.action("i", "button.cpm.tools.convert_model_custom");
        ab.onUndo(Generators$$Lambda$2.lambdaFactory$(e));
        for (ModelElement el : e.elements) {
            if (el.type != ElementType.ROOT_PART || el.hidden) continue;
            ModelElement elem = new ModelElement(e);
            ab.addToList(el.children, elem);
            elem.parent = el;
            PartValues val = ((VanillaModelPart)el.typeData).getDefaultSize(e.skinType);
            elem.size = val.getSize();
            elem.offset = val.getOffset();
            elem.texture = true;
            elem.mcScale = val.getMCScale();
            elem.mirror = val.isMirror();
            Vec2i uv = val.getUV();
            elem.u = uv.x;
            elem.v = uv.y;
            elem.name = e.ui.i18nFormat("label.cpm.elem." + ((VanillaModelPart)el.typeData).getName(), new Object[0]);
            elem.generated = true;
            ab.updateValueOp(el, false, true, Generators$$Lambda$3.lambdaFactory$());
        }
        ab.execute();
        e.updateGui();
    }

    public static void setupTemplateModel(Editor e) {
        ActionBuilder ab = e.action("i", "button.cpm.tools.convert2template");
        ab.onUndo(Generators$$Lambda$4.lambdaFactory$(e));
        block0: for (PlayerModelParts p : PlayerModelParts.VALUES) {
            for (ModelElement el : e.elements) {
                if (el.type != ElementType.ROOT_PART || el.typeData != p) continue;
                if (el.hidden) continue block0;
                ModelElement elem = new ModelElement(e);
                ab.addToList(el.children, elem);
                elem.parent = el;
                PlayerPartValues val = PlayerPartValues.getFor(p, e.skinType);
                elem.size = val.getSize();
                elem.offset = val.getOffset();
                elem.texture = false;
                elem.rgb = 0xFFFFFF;
                elem.name = el.name;
                elem.templateElement = true;
                ab.updateValueOp(el, false, true, Generators$$Lambda$5.lambdaFactory$());
                continue block0;
            }
        }
        ab.execute();
    }

    private static void convertTemplate(EditorGui eg) {
        Editor editor = eg.getEditor();
        IGui gui = eg.getGui();
        if (editor.templateSettings == null) {
            if (editor.dirty) {
                eg.openPopup(new MessagePopup(eg, gui.i18nFormat("label.cpm.info", new Object[0]), gui.i18nFormat("label.cpm.must_save", new Object[0])));
            } else if (editor.file == null) {
                Generators.setupTemplate(editor);
            } else {
                eg.openPopup(new ConfirmPopup(eg, gui.i18nFormat("label.cpm.warning", new Object[0]), gui.i18nFormat("label.cpm.warnTemplate", new Object[0]), new ConfirmPopup(eg, gui.i18nFormat("label.cpm.warning", new Object[0]), gui.i18nFormat("label.cpm.warn_c2t", new Object[0]), Generators$$Lambda$6.lambdaFactory$(editor), null), null));
            }
        }
    }

    private static void convertModel(EditorGui eg) {
        Editor editor = eg.getEditor();
        IGui gui = eg.getGui();
        if (editor.templateSettings != null) {
            if (editor.dirty) {
                eg.openPopup(new MessagePopup(eg, gui.i18nFormat("label.cpm.info", new Object[0]), gui.i18nFormat("label.cpm.must_save", new Object[0])));
            } else {
                editor.templateSettings = null;
                for (ModelElement el : editor.elements) {
                    el.children.removeIf(Generators$$Lambda$7.lambdaFactory$());
                }
                editor.markDirty();
                editor.updateGui();
            }
        }
    }

    private static void setupTemplate(Editor editor) {
        editor.templateSettings = new TemplateSettings(editor);
        Generators.setupTemplateModel(editor);
        editor.markDirty();
        editor.updateGui();
    }

    private static void fillUV(EditorGui eg) {
        Editor editor = eg.getEditor();
        ActionBuilder ab = editor.action("i", "button.cpm.tools.fillUV");
        HashSet texs = new HashSet();
        editor.forEachSeletectedElement(Generators$$Lambda$8.lambdaFactory$(editor, ab, texs));
        ab.onAction(Generators$$Lambda$9.lambdaFactory$(texs));
        ab.execute();
    }

    public static void addItemHoldPos(Editor editor) {
        Generators.addSlots(editor, ItemSlot.SLOTS);
    }

    public static void addParrots(Editor editor) {
        Generators.addSlots(editor, ItemSlot.PARROTS);
    }

    private static void addSlots(Editor editor, ItemSlot[] slots) {
        ActionBuilder ab = editor.action("add", "action.cpm.itemHold");
        HashSet added = new HashSet();
        Editor.walkElements(editor.elements, Generators$$Lambda$10.lambdaFactory$(added));
        for (ItemSlot itemSlot : slots) {
            if (added.contains((Object)itemSlot)) continue;
            ModelElement elem = new ModelElement(editor);
            elem.itemRenderer = new ItemRenderer(itemSlot, 0);
            elem.name = editor.ui.i18nFormat("label.cpm.elem.item." + itemSlot.name().toLowerCase(Locale.ROOT), new Object[0]);
            elem.size = new Vec3f(0.0f, 0.0f, 0.0f);
            switch (itemSlot) {
                case HEAD: {
                    elem.parent = Generators.findPart(editor, PlayerModelParts.HEAD);
                    break;
                }
                case LEFT_HAND: {
                    elem.parent = Generators.findPart(editor, PlayerModelParts.LEFT_ARM);
                    break;
                }
                case RIGHT_HAND: {
                    elem.parent = Generators.findPart(editor, PlayerModelParts.RIGHT_ARM);
                    break;
                }
                case RIGHT_SHOULDER: 
                case LEFT_SHOULDER: {
                    elem.parent = Generators.findPart(editor, PlayerModelParts.BODY);
                    break;
                }
            }
            if (elem.parent == null) continue;
            ab.addToList(elem.parent.children, elem);
        }
        ab.execute();
        editor.updateGui();
    }

    private static ModelElement findPart(Editor editor, VanillaModelPart part) {
        for (ModelElement e : editor.elements) {
            if (e.typeData != part) continue;
            return e;
        }
        return null;
    }

    public static void loadTextures(Editor editor, RootGroups group, BiConsumer<TextureSheetType, ETextures> texs) {
        Stream<RootModelType> stream = Arrays.stream(group.types);
        RootGroups rootGroups = group;
        ((Object)((Object)rootGroups)).getClass();
        stream.map(Generators$$Lambda$11.lambdaFactory$(rootGroups)).distinct().forEach(Generators$$Lambda$12.lambdaFactory$(editor, texs));
    }

    private static void loadTexture(ETextures tex, Player<?> profile, TextureType type) {
        CompletableFuture<Image> img = profile.getTextures().getTexture(type);
        img.thenAccept(Generators$$Lambda$13.lambdaFactory$(tex, type, profile));
    }

    private static void checkSafetyLevel(EditorGui eg) {
        IGui gui = eg.getGui();
        SafetyLevel.SafetyReport report = SafetyLevel.getLevel(eg.getEditor());
        ArrayList<String> msg = new ArrayList<String>();
        String lvl = gui.i18nFormat("label.cpm.safetyLevel", gui.i18nFormat("label.cpm.safetyProfile." + report.getLvl(), new Object[0]));
        msg.add(lvl);
        Stream stream = report.details.stream().map(Generators$$Lambda$14.lambdaFactory$(gui));
        ArrayList<String> arrayList = msg;
        arrayList.getClass();
        stream.forEach(Generators$$Lambda$15.lambdaFactory$(arrayList));
        Generators.collectAnimationDetails(eg, msg);
        eg.openPopup(new MessagePopup(eg, gui.i18nFormat("label.cpm.info", new Object[0]), String.join((CharSequence)"\\", msg)));
    }

    private static void collectAnimationDetails(EditorGui eg, List<String> msgs) {
        Editor e = eg.getEditor();
        long layerCnt = e.animations.stream().filter(Generators$$Lambda$16.lambdaFactory$()).map(Generators$$Lambda$17.lambdaFactory$()).distinct().count();
        long poseCnt = e.animations.stream().filter(Generators$$Lambda$18.lambdaFactory$()).map(Generators$$Lambda$19.lambdaFactory$()).distinct().count();
        long gestureCnt = e.animations.stream().filter(Generators$$Lambda$20.lambdaFactory$()).map(Generators$$Lambda$21.lambdaFactory$()).distinct().count();
        long layerCtrlCnt = e.animations.stream().filter(Generators$$Lambda$22.lambdaFactory$()).map(Generators$$Lambda$23.lambdaFactory$()).distinct().count();
        msgs.add(eg.getGui().i18nFormat("label.cpm.safety.animCnt.pose", poseCnt, 253));
        msgs.add(eg.getGui().i18nFormat("label.cpm.safety.animCnt.gesture", gestureCnt, 253));
        msgs.add(eg.getGui().i18nFormat("label.cpm.safety.animCnt.layer", layerCnt, 253));
        if (e.animEnc != null) {
            int limit = (1 << e.animEnc.freeLayers.size()) - 2;
            msgs.add(eg.getGui().i18nFormat("label.cpm.safety.animCnt.layerCtrl", layerCtrlCnt, limit));
        } else {
            msgs.add(eg.getGui().i18nFormat("label.cpm.safety.animCnt.layerCtrl", layerCtrlCnt, "?"));
        }
    }

    private static void mirrorElement(EditorGui eg) {
        Editor editor = eg.getEditor();
        ActionBuilder b = eg.getEditor().action("i", "button.cpm.tools.mirror");
        HashSet mirrored = new HashSet();
        editor.forEachSeletectedElement(Generators$$Lambda$24.lambdaFactory$(b, mirrored));
        b.execute();
        editor.setQuickAction.accept(new QuickTask(editor.ui.i18nFormat("button.cpm.mirrorAnimations", new Object[0]), editor.ui.i18nFormat("tooltip.cpm.mirrorAnimations", new Object[0]), Generators$$Lambda$25.lambdaFactory$(eg, editor, mirrored)));
    }

    private static void mirrorZ(ModelElement e, ActionBuilder b, Set<ModelElement> mirrored) {
        if (mirrored.contains(e)) {
            return;
        }
        mirrored.add(e);
        if (e.faceUV != null) {
            e.faceUV.mirror(b, Direction.Axis.Z);
        } else {
            b.updateValueOp(e, e.mirror, !e.mirror, Generators$$Lambda$26.lambdaFactory$());
        }
        Vec3f s = e.size;
        Vec3f v = new Vec3f(e.pos);
        v.x = -v.x;
        b.updateValueOp(e, e.pos, v, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false, Generators$$Lambda$27.lambdaFactory$(), Generators$$Lambda$28.lambdaFactory$());
        v = new Vec3f(e.offset);
        v.x = -v.x - s.x;
        b.updateValueOp(e, e.offset, v, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false, Generators$$Lambda$29.lambdaFactory$(), Generators$$Lambda$30.lambdaFactory$());
        v = new Vec3f(e.rotation);
        v.y = 360.0f - v.y;
        v.z = 360.0f - v.z;
        b.updateValueOp(e, e.rotation, v, 0, 360, true, Generators$$Lambda$31.lambdaFactory$(), Generators$$Lambda$32.lambdaFactory$());
        e.children.forEach(Generators$$Lambda$33.lambdaFactory$(b, mirrored));
        b.onAction(Generators$$Lambda$34.lambdaFactory$(e));
    }

    public static void fixAdditive(Editor editor) {
        if (editor.selectedAnim != null) {
            boolean add = editor.selectedAnim.add;
            ActionBuilder ab = editor.action("i", "button.cpm.fixAdditiveToggle");
            editor.selectedAnim.getFrames().forEach(Generators$$Lambda$35.lambdaFactory$(editor, add, ab));
            ab.onAction(editor.selectedAnim, Generators$$Lambda$36.lambdaFactory$());
            Editor editor2 = editor;
            editor2.getClass();
            ab.onRun(Generators$$Lambda$37.lambdaFactory$(editor2));
            ab.execute();
        }
    }

    private static void exportUVMap(EditorGui eg) {
        eg.openPopup(new ExportUVMapPopup(eg));
    }

    private static void make2ndLayer(EditorGui eg) {
        Editor editor = eg.getEditor();
        ActionBuilder b = eg.getEditor().action("i", "button.cpm.tools.make2ndLayer");
        editor.forEachSeletectedElement(Generators$$Lambda$38.lambdaFactory$(editor, b));
        Editor editor2 = editor;
        editor2.getClass();
        b.onRun(Generators$$Lambda$39.lambdaFactory$(editor2));
        b.execute();
    }

    private static void makeArmorLayer(EditorGui eg) {
        Editor editor = eg.getEditor();
        NamedElement.NameMapper<RootModelType> map = new NamedElement.NameMapper<RootModelType>(RootGroups.ARMOR.types, Generators$$Lambda$40.lambdaFactory$(editor));
        eg.openPopup(new ChooseElementPopup<NamedElement<RootModelType>>(eg, editor.ui.i18nFormat("label.cpm.model.selectArmorRootToMake", new Object[0]), map.asList(), Generators$$Lambda$41.lambdaFactory$(editor, eg), null));
    }

    private static void makeArmorLayer(Editor editor, ActionBuilder ab, ModelElement me, ModelElement addTo, Map<ModelElement, ModelElement> ctLookup, RootModelType rmt) {
        ModelElement i = me;
        ArrayList<ModelElement> parts = new ArrayList<ModelElement>();
        while (i.type == ElementType.NORMAL) {
            parts.add(i);
            i = i.parent;
        }
        i = addTo;
        for (int j = parts.size() - 1; j >= 0; --j) {
            ModelElement el = (ModelElement)parts.get(j);
            ModelElement fi = i;
            i = ctLookup.computeIfAbsent(el, Generators$$Lambda$42.lambdaFactory$(fi, el, editor, ab));
        }
        if (i.size.epsilon(0.1f)) {
            ab.updateValueOp(i, i.size, new Vec3f(me.size), Generators$$Lambda$43.lambdaFactory$());
            ab.updateValueOp(i, i.offset, new Vec3f(me.offset), Generators$$Lambda$44.lambdaFactory$());
            ab.updateValueOp(i, i.texture, true, Generators$$Lambda$45.lambdaFactory$());
            ab.updateValueOp(i, i.name, editor.ui.i18nFormat("label.cpm.generatedArmorLayer", me.name), Generators$$Lambda$46.lambdaFactory$());
            ab.updateValueOp(i, Float.valueOf(i.mcScale), Float.valueOf(rmt.getDefaultSize(editor.skinType).getMCScale()), Generators$$Lambda$47.lambdaFactory$());
        } else {
            ModelElement elem = new ModelElement(editor);
            ab.addToList(i.children, elem);
            elem.parent = i;
            elem.size = new Vec3f(me.size);
            elem.offset = new Vec3f(me.offset);
            elem.texture = true;
            elem.name = editor.ui.i18nFormat("label.cpm.generatedArmorLayer", me.name);
            elem.mcScale = rmt.getDefaultSize(editor.skinType).getMCScale();
        }
    }

    public static void afterDuplicate(ModelElement from, ModelElement to) {
        HashMap<ModelElement, ModelElement> dup = new HashMap<ModelElement, ModelElement>();
        ArrayList<CopyTransformEffect> cts = new ArrayList<CopyTransformEffect>();
        Generators.walk(from, to, dup, cts);
        for (CopyTransformEffect e : cts) {
            e.from = dup.getOrDefault(e.from, e.from);
        }
    }

    private static void walk(ModelElement from, ModelElement to, Map<ModelElement, ModelElement> dup, List<CopyTransformEffect> cts) {
        for (int i = 0; i < from.children.size(); ++i) {
            ModelElement f = from.children.get(i);
            ModelElement t = to.children.get(i);
            dup.put(f, t);
            if (t.copyTransform != null) {
                cts.add(t.copyTransform);
            }
            Generators.walk(f, t, dup, cts);
        }
    }

    static /* synthetic */ void lambda$makeArmorLayer$56(ModelElement a, Float b) {
        a.mcScale = b.floatValue();
    }

    static /* synthetic */ void lambda$makeArmorLayer$55(ModelElement a, String b) {
        a.name = b;
    }

    static /* synthetic */ void lambda$makeArmorLayer$54(ModelElement a, Boolean b) {
        a.texture = b;
    }

    static /* synthetic */ void lambda$makeArmorLayer$53(ModelElement a, Vec3f b) {
        a.offset = b;
    }

    static /* synthetic */ void lambda$makeArmorLayer$52(ModelElement a, Vec3f b) {
        a.size = b;
    }

    static /* synthetic */ ModelElement lambda$makeArmorLayer$51(ModelElement fi, ModelElement el, Editor editor, ActionBuilder ab, ModelElement __) {
        for (ModelElement c : fi.children) {
            if (c.copyTransform == null || c.copyTransform.from != el) continue;
            return c;
        }
        ModelElement elem = new ModelElement(editor);
        ab.addToList(fi.children, elem);
        elem.size = new Vec3f(0.0f);
        elem.name = editor.ui.i18nFormat("label.cpm.generatedArmorLayer.ct", el.name);
        elem.parent = fi;
        elem.copyTransform = new CopyTransformEffect(elem);
        elem.copyTransform.from = el;
        elem.copyTransform.setAll(true);
        return elem;
    }

    static /* synthetic */ void lambda$makeArmorLayer$50(Editor editor, EditorGui eg, NamedElement root) {
        RootModelType rmt = (RootModelType)root.getElem();
        ModelElement addTo = Generators.findPart(editor, rmt);
        if (addTo == null) {
            editor.ui.displayMessagePopup(editor.ui.i18nFormat("label.cpm.error", new Object[0]), editor.ui.i18nFormat("label.cpm.model.rootNotFound", new Object[0]));
            return;
        }
        ActionBuilder b = eg.getEditor().action("i", "button.cpm.tools.makeArmorLayer");
        HashMap ctLookup = new HashMap();
        editor.forEachSeletectedElement(Generators$$Lambda$48.lambdaFactory$(editor, b, addTo, ctLookup, rmt));
        Editor editor2 = editor;
        editor2.getClass();
        b.onRun(Generators$$Lambda$49.lambdaFactory$(editor2));
        b.execute();
    }

    static /* synthetic */ void lambda$null$49(Editor editor, ActionBuilder b, ModelElement addTo, Map ctLookup, RootModelType rmt, TreeElement el) {
        if (el instanceof ModelElement) {
            ModelElement me = (ModelElement)el;
            if (me.type == ElementType.NORMAL) {
                Generators.makeArmorLayer(editor, b, me, addTo, ctLookup, rmt);
            }
        }
    }

    static /* synthetic */ String lambda$makeArmorLayer$48(Editor editor, RootModelType n) {
        return editor.ui.i18nFormat("label.cpm.elem." + n.getName(), new Object[0]);
    }

    static /* synthetic */ void lambda$make2ndLayer$47(Editor editor, ActionBuilder b, TreeElement el) {
        if (el instanceof ModelElement) {
            ModelElement me = (ModelElement)el;
            if (me.type == ElementType.NORMAL) {
                ModelElement elem = new ModelElement(editor);
                b.addToList(me.children, elem);
                elem.parent = me;
                elem.size = new Vec3f(me.size);
                elem.offset = new Vec3f(me.offset);
                elem.texture = me.texture;
                if (me.texture) {
                    if (me.faceUV != null) {
                        elem.faceUV = new PerFaceUV(me.faceUV);
                        elem.faceUV.faces.values().forEach(Generators$$Lambda$50.lambdaFactory$());
                    } else {
                        elem.u = me.u + me.getTextureBox().w;
                        elem.v = me.v;
                        elem.texSize = me.texSize;
                        elem.singleTex = me.singleTex;
                    }
                }
                elem.name = editor.ui.i18nFormat("label.cpm.generated2ndLayer", me.name);
                elem.mcScale = 0.25f;
            }
        }
    }

    static /* synthetic */ void lambda$null$46(PerFaceUV.Face f) {
        int d = Math.abs(f.sx - f.ex);
        f.sx += d;
        f.ex += d;
    }

    static /* synthetic */ void lambda$fixAdditive$45(Editor editor, boolean add, ActionBuilder ab, AnimFrame frm) {
        frm.getComponents().forEach(Generators$$Lambda$51.lambdaFactory$(editor, add, ab));
    }

    static /* synthetic */ void lambda$null$44(Editor editor, boolean add, ActionBuilder ab, ModelElement p, AnimFrame.FrameData f) {
        Vec3f pos;
        if (p.type == ElementType.ROOT_PART) {
            VanillaModelPart part = (VanillaModelPart)p.typeData;
            PartValues pv = part.getDefaultSize(editor.skinType);
            pos = pv.getPos().add(p.pos);
        } else {
            pos = p.pos;
        }
        pos = add ? f.getPosition().sub(pos) : f.getPosition().add(pos);
        Vec3f rot = add ? f.getRotation().sub(p.rotation) : f.getRotation().add(p.rotation);
        ab.updateValueOp(f, f.getPosition(), pos, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false, Generators$$Lambda$52.lambdaFactory$(), Generators$$Lambda$53.lambdaFactory$());
        ab.updateValueOp(f, f.getRotation(), rot, 0, 360, true, Generators$$Lambda$54.lambdaFactory$(), Generators$$Lambda$55.lambdaFactory$());
    }

    static /* synthetic */ void lambda$null$43(Vec3f v) {
    }

    static /* synthetic */ void lambda$null$42(Vec3f v) {
    }

    static /* synthetic */ void lambda$mirrorZ$41(ModelElement e) {
        e.markDirty();
    }

    static /* synthetic */ void lambda$mirrorZ$40(ActionBuilder b, Set mirrored, ModelElement p) {
        Generators.mirrorZ(p, b, mirrored);
    }

    static /* synthetic */ void lambda$mirrorZ$39(Vec3f vec) {
    }

    static /* synthetic */ void lambda$mirrorZ$38(ModelElement a, Vec3f c) {
        a.rotation = c;
    }

    static /* synthetic */ void lambda$mirrorZ$37(Vec3f vec) {
    }

    static /* synthetic */ void lambda$mirrorZ$36(ModelElement a, Vec3f c) {
        a.offset = c;
    }

    static /* synthetic */ void lambda$mirrorZ$35(Vec3f vec) {
    }

    static /* synthetic */ void lambda$mirrorZ$34(ModelElement a, Vec3f c) {
        a.pos = c;
    }

    static /* synthetic */ void lambda$mirrorZ$33(ModelElement a, Boolean c) {
        a.mirror = c;
    }

    static /* synthetic */ void lambda$mirrorElement$32(EditorGui eg, Editor editor, Set mirrored) {
        ActionBuilder ab = eg.getEditor().action("i", "button.cpm.tools.mirror");
        editor.animations.forEach(Generators$$Lambda$56.lambdaFactory$(mirrored, ab));
        ab.onAction(Generators$$Lambda$57.lambdaFactory$(editor));
        ab.execute();
    }

    static /* synthetic */ void lambda$null$31(Editor editor) {
        editor.animations.forEach(Generators$$Lambda$58.lambdaFactory$());
    }

    static /* synthetic */ void lambda$null$30(Set mirrored, ActionBuilder ab, EditorAnim a) {
        a.getFrames().forEach(Generators$$Lambda$59.lambdaFactory$(mirrored, ab));
    }

    static /* synthetic */ void lambda$null$29(Set mirrored, ActionBuilder ab, AnimFrame f) {
        mirrored.forEach(Generators$$Lambda$60.lambdaFactory$(f, ab));
    }

    static /* synthetic */ void lambda$null$28(AnimFrame f, ActionBuilder ab, ModelElement me) {
        AnimFrame.FrameData dt = f.getComponents().get(me);
        if (dt != null) {
            dt.mirror(ab);
        }
    }

    static /* synthetic */ void lambda$mirrorElement$27(ActionBuilder b, Set mirrored, TreeElement el) {
        if (el instanceof ModelElement) {
            ModelElement me = (ModelElement)el;
            if (me.type == ElementType.NORMAL) {
                Generators.mirrorZ(me, b, mirrored);
            }
        }
    }

    static /* synthetic */ String lambda$collectAnimationDetails$26(EditorAnim a) {
        return a.getId();
    }

    static /* synthetic */ boolean lambda$collectAnimationDetails$25(EditorAnim a) {
        return (a.type == AnimationType.GESTURE || a.type == AnimationType.CUSTOM_POSE) && a.layerControlled;
    }

    static /* synthetic */ String lambda$collectAnimationDetails$24(EditorAnim a) {
        return a.getId();
    }

    static /* synthetic */ boolean lambda$collectAnimationDetails$23(EditorAnim a) {
        return a.type == AnimationType.GESTURE;
    }

    static /* synthetic */ String lambda$collectAnimationDetails$22(EditorAnim a) {
        return a.getId();
    }

    static /* synthetic */ boolean lambda$collectAnimationDetails$21(EditorAnim a) {
        return a.type == AnimationType.CUSTOM_POSE;
    }

    static /* synthetic */ String lambda$collectAnimationDetails$20(EditorAnim a) {
        return a.getId();
    }

    static /* synthetic */ boolean lambda$collectAnimationDetails$19(EditorAnim a) {
        return a.type.isLayer();
    }

    static /* synthetic */ String lambda$checkSafetyLevel$18(IGui gui, FormatText t) {
        return t.toString(gui);
    }

    static /* synthetic */ void lambda$loadTexture$17(ETextures tex, TextureType type, Player profile, Image s) {
        if (!tex.isEdited()) {
            if (s != null) {
                tex.setDefaultImg(s);
                tex.setImage(new Image(s));
                tex.setChangedLocally(false);
                tex.restitchTexture();
            } else if (type == TextureType.ELYTRA) {
                Generators.loadTexture(tex, profile, TextureType.CAPE);
            } else if (type == TextureType.CAPE) {
                Image.download("http://s.optifine.net/capes/" + profile.getName() + ".png").thenAccept(Generators$$Lambda$61.lambdaFactory$(tex));
            }
        }
    }

    static /* synthetic */ void lambda$null$16(ETextures tex, Image i) {
        if (!tex.isEdited() && i != null) {
            tex.setDefaultImg(i);
            tex.setImage(new Image(i));
            tex.setChangedLocally(false);
            tex.restitchTexture();
        }
    }

    static /* synthetic */ void lambda$loadTextures$15(Editor editor, BiConsumer texs, TextureSheetType tx) {
        if (!editor.textures.containsKey((Object)tx)) {
            ETextures tex = new ETextures(editor, tx);
            texs.accept(tx, tex);
            tex.provider.size = tx.getDefSize();
            Image def = new Image(tex.provider.size.x, tex.provider.size.y);
            try {
                InputStream is = ModelDefinitionLoader.class.getResourceAsStream("/assets/cpm/textures/template/" + tx.name().toLowerCase(Locale.ROOT) + ".png");
                Throwable throwable = null;
                try {
                    def = Image.loadFrom(is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException is) {
                // empty catch block
            }
            tex.setDefaultImg(def);
            tex.setImage(new Image(def));
            tex.markDirty();
            tex.setEdited(tx.texType == null && tx.editable);
            tex.setChangedLocally(false);
            if (tx.texType != null) {
                Player<?> profile = MinecraftClientAccess$.get().getClientPlayer();
                profile.getTextures().load().thenRun(Generators$$Lambda$62.lambdaFactory$(tex, profile, tx));
            }
        }
    }

    static /* synthetic */ void lambda$null$14(ETextures tex, Player profile, TextureSheetType tx) {
        Generators.loadTexture(tex, profile, tx.texType);
    }

    static /* synthetic */ void lambda$addSlots$13(Set added, ModelElement e) {
        if (e.itemRenderer != null) {
            added.add(e.itemRenderer.slot);
        }
    }

    static /* synthetic */ void lambda$fillUV$12(Set texs) {
        texs.forEach(Generators$$Lambda$63.lambdaFactory$());
    }

    static /* synthetic */ void lambda$fillUV$11(Editor editor, ActionBuilder ab, Set texs, TreeElement el) {
        if (el instanceof ModelElement) {
            ModelElement me = (ModelElement)el;
            if (me.type == ElementType.NORMAL && me.texture) {
                if (me.faceUV != null) {
                    PerFaceUV.Face f = me.faceUV.get(editor.perfaceFaceDir.get());
                    if (f != null) {
                        Box box = Box.fromArea(f.sx, f.sy, f.ex, f.ey);
                        ab.action(new ImageAction(me.getTexture().getImage(), box, Generators$$Lambda$64.lambdaFactory$(box)));
                        texs.add(me.getTexture());
                    }
                } else {
                    Box box = me.getTextureBox();
                    int ts = Math.abs(me.texSize);
                    int bx = me.u * ts;
                    int by = me.v * ts;
                    int dx = MathHelper.ceil(me.size.x * (float)ts);
                    int dy = MathHelper.ceil(me.size.y * (float)ts);
                    int dz = MathHelper.ceil(me.size.z * (float)ts);
                    ab.action(new ImageAction(me.getTexture().getImage(), box, Generators$$Lambda$65.lambdaFactory$(bx, dx, dz, by, dy)));
                    texs.add(me.getTexture());
                }
            }
        }
    }

    static /* synthetic */ void lambda$null$10(int bx, int dx, int dz, int by, int dy, Image img) {
        img.fill(bx + dx + dz, by + dz, dz, dy, -65536);
        img.fill(bx, by + dz, dz, dy, -2293760);
        img.fill(bx + dz, by, dx, dz, -16711936);
        img.fill(bx + dz + dx, by, dx, dz, -16720640);
        img.fill(bx + dz, by + dz, dx, dy, -16776961);
        img.fill(bx + dz * 2 + dx, by + dz, dx, dy, -16776995);
    }

    static /* synthetic */ void lambda$null$9(Box box, Image img) {
        img.fill(box.x, box.y, box.w, box.h, -7829368);
    }

    static /* synthetic */ boolean lambda$convertModel$8(ModelElement e) {
        return e.templateElement;
    }

    static /* synthetic */ void lambda$convertTemplate$7(Editor editor) {
        Generators.setupTemplate(editor);
    }

    static /* synthetic */ void lambda$setupTemplateModel$6(ModelElement a, Boolean b) {
        a.hidden = b;
    }

    static /* synthetic */ void lambda$setupTemplateModel$5(Editor e) {
        e.selectedElement = null;
    }

    static /* synthetic */ void lambda$convertModel$4(ModelElement a, Boolean b) {
        a.hidden = b;
    }

    static /* synthetic */ void lambda$convertModel$3(Editor e) {
        e.selectedElement = null;
    }

    static /* synthetic */ void lambda$addSkinLayer$2(Editor e) {
        e.selectedElement = null;
    }

    static /* synthetic */ void lambda$static$1(EditorGui eg) {
        Generators.addSkinLayer(eg.getEditor());
    }

    static /* synthetic */ void lambda$static$0(EditorGui eg) {
        Generators.convertModel(eg.getEditor());
    }

    static {
        Generators.register("button.cpm.tools.convert_model_custom", "tooltip.cpm.tools.convert_model_custom", Generators$$Lambda$66.lambdaFactory$());
        Generators.register("button.cpm.tools.add_skin_layer2", null, Generators$$Lambda$67.lambdaFactory$());
        Generators.register("button.cpm.tools.convert2template", null, Generators$$Lambda$68.lambdaFactory$());
        Generators.register("button.cpm.tools.convert2model", null, Generators$$Lambda$69.lambdaFactory$());
        Generators.register("button.cpm.tools.fillUV", null, Generators$$Lambda$70.lambdaFactory$());
        Generators.register("button.cpm.tools.safetyLevel", null, Generators$$Lambda$71.lambdaFactory$());
        Generators.register("button.cpm.tools.mirror", null, Generators$$Lambda$72.lambdaFactory$());
        Generators.register("button.cpm.tools.exportUVMap", "tooltip.cpm.tools.exportUVMap", Generators$$Lambda$73.lambdaFactory$());
        Generators.register("button.cpm.tools.make2ndLayer", "tooltip.cpm.tools.make2ndLayer", Generators$$Lambda$74.lambdaFactory$());
        Generators.register("button.cpm.tools.makeArmorLayer", "tooltip.cpm.tools.makeArmorLayer", Generators$$Lambda$75.lambdaFactory$());
    }

    static /* synthetic */ void access$lambda$0(EditorGui editorGui) {
        Generators.convertTemplate(editorGui);
    }

    static /* synthetic */ void access$lambda$1(EditorGui editorGui) {
        Generators.convertModel(editorGui);
    }

    static /* synthetic */ void access$lambda$2(EditorGui editorGui) {
        Generators.fillUV(editorGui);
    }

    static /* synthetic */ void access$lambda$3(EditorGui editorGui) {
        Generators.checkSafetyLevel(editorGui);
    }

    static /* synthetic */ void access$lambda$4(EditorGui editorGui) {
        Generators.mirrorElement(editorGui);
    }

    static /* synthetic */ void access$lambda$5(EditorGui editorGui) {
        Generators.exportUVMap(editorGui);
    }

    static /* synthetic */ void access$lambda$6(EditorGui editorGui) {
        Generators.make2ndLayer(editorGui);
    }

    static /* synthetic */ void access$lambda$7(EditorGui editorGui) {
        Generators.makeArmorLayer(editorGui);
    }
}

