/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.anim;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimatedTexture;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$1;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$10;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$11;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$12;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$13;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$14;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$15;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$16;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$17;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$2;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$3;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$4;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$5;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$6;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$7;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$8;
import com.tom.cpm.shared.editor.anim.AnimatedTex$$Lambda$9;
import com.tom.cpm.shared.editor.anim.AnimatedTex$BoolElem$$Lambda$1;
import com.tom.cpm.shared.editor.anim.AnimatedTex$BoolElem$$Lambda$2;
import com.tom.cpm.shared.editor.anim.AnimatedTex$BoolElem$$Lambda$3;
import com.tom.cpm.shared.editor.anim.AnimatedTex$RegionSize$$Lambda$1;
import com.tom.cpm.shared.editor.anim.AnimatedTex$RegionSize$$Lambda$2;
import com.tom.cpm.shared.editor.anim.AnimatedTex$RegionSize$$Lambda$3;
import com.tom.cpm.shared.editor.anim.AnimatedTex$RegionSize$$Lambda$4;
import com.tom.cpm.shared.editor.anim.AnimatedTex$RegionSize$$Lambda$5;
import com.tom.cpm.shared.editor.anim.AnimatedTex$TexElem$$Lambda$1;
import com.tom.cpm.shared.editor.anim.AnimatedTex$TexElem$$Lambda$2;
import com.tom.cpm.shared.editor.anim.AnimatedTex$TexElem$$Lambda$3;
import com.tom.cpm.shared.editor.anim.AnimatedTex$ValElem$$Lambda$1;
import com.tom.cpm.shared.editor.anim.AnimatedTex$ValElem$$Lambda$2;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.TreeElement$;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.editor.util.UVResizableArea;
import com.tom.cpm.shared.model.TextureSheetType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class AnimatedTex
implements TreeElement {
    private final Editor editor;
    private List<TreeElement> options;
    public Vec2i uvStart;
    public Vec2i uvSize;
    public Vec2i animStart;
    public int frameTime;
    public int frameCount;
    public boolean anX;
    public boolean interpolate;
    private final TextureSheetType sheet;
    private TexElemDrag startDrag;
    private RegionSize region;
    private int lastFrame;
    private long lastUpdate;

    public AnimatedTex(Editor editor, TextureSheetType sheet, JsonMap map) {
        this(editor, sheet);
        this.frameTime = map.getInt("frameTime", 0);
        this.frameCount = map.getInt("frameCount", 0);
        this.uvStart = map.getObject("start", AnimatedTex$$Lambda$1.lambdaFactory$(), new Vec2i());
        this.uvSize = map.getObject("size", AnimatedTex$$Lambda$2.lambdaFactory$(), new Vec2i());
        this.animStart = map.getObject("from", AnimatedTex$$Lambda$3.lambdaFactory$(), new Vec2i());
        this.anX = map.getBoolean("anX");
        this.interpolate = map.getBoolean("interpolate");
    }

    public AnimatedTex(Editor editor, TextureSheetType sheet) {
        this.editor = editor;
        this.sheet = sheet;
        this.uvStart = new Vec2i();
        this.uvSize = new Vec2i();
        this.animStart = new Vec2i();
        this.options = new ArrayList<TreeElement>();
        this.startDrag = new TexElemDrag("start", AnimatedTex$$Lambda$4.lambdaFactory$(this), AnimatedTex$$Lambda$5.lambdaFactory$(this)){

            @Override
            public List<TreeElement.TreeSettingElement> getSettingsElements() {
                return ((AnimatedTex)AnimatedTex.this).region.elements;
            }

            @Override
            public void accept(TreeElement treeElement) {
                TreeElement$.accept(this, treeElement);
            }

            @Override
            public void delete() {
                TreeElement$.delete(this);
            }

            @Override
            public void setElemColor(int n) {
                TreeElement$.setElemColor(this, n);
            }

            @Override
            public void switchEffect(Effect effect) {
                TreeElement$.switchEffect(this, effect);
            }

            @Override
            public void addNew() {
                TreeElement$.addNew(this);
            }

            @Override
            public String getElemName() {
                return TreeElement$.getElemName(this);
            }

            @Override
            public void setValue(float f) {
                TreeElement$.setValue(this, f);
            }

            @Override
            public void onRefreshTree() {
                TreeElement$.onRefreshTree(this);
            }

            @Override
            public boolean canAccept(TreeElement treeElement) {
                return TreeElement$.canAccept(this, treeElement);
            }

            @Override
            public void populatePopup(PopupMenu popupMenu) {
                TreeElement$.populatePopup(this, popupMenu);
            }

            @Override
            public void modeSwitch() {
                TreeElement$.modeSwitch(this);
            }

            @Override
            public boolean canEditVec(VecType vecType) {
                return TreeElement$.canEditVec(this, vecType);
            }

            @Override
            public void switchVis() {
                TreeElement$.switchVis(this);
            }

            @Override
            public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
                TreeElement$.onClick(this, iGui, editor, mouseEvent);
            }

            @Override
            public void setElemName(String string) {
                TreeElement$.setElemName(this, string);
            }

            @Override
            public void getTreeElements(Consumer consumer) {
                TreeElement$.getTreeElements(this, consumer);
            }

            @Override
            public boolean isSelected(Editor editor, TreeElement treeElement) {
                return TreeElement$.isSelected(this, editor, treeElement);
            }

            @Override
            public boolean canMove() {
                return TreeElement$.canMove(this);
            }

            @Override
            public void drawName(IGui iGui, int n, int n2, int n3) {
                TreeElement$.drawName(this, iGui, n, n2, n3);
            }

            @Override
            public void setMCScale(float f) {
                TreeElement$.setMCScale(this, f);
            }

            @Override
            public int textColor(IGui iGui) {
                return TreeElement$.textColor(this, iGui);
            }

            @Override
            public float getValue() {
                return TreeElement$.getValue(this);
            }

            @Override
            public boolean canSelect() {
                return TreeElement$.canSelect(this);
            }

            @Override
            public int bgColor(IGui iGui) {
                return TreeElement$.bgColor(this, iGui);
            }

            @Override
            public int getExtraWidth(IGui iGui) {
                return TreeElement$.getExtraWidth(this, iGui);
            }
        };
        this.region = new RegionSize();
        this.options.add(this.startDrag);
        this.options.add(new TexElem("size", AnimatedTex$$Lambda$6.lambdaFactory$(this)));
        this.options.add(new TexElemDrag("from", AnimatedTex$$Lambda$7.lambdaFactory$(this), AnimatedTex$$Lambda$8.lambdaFactory$(this)));
        this.options.add(new ValElem("frameTime", AnimatedTex$$Lambda$9.lambdaFactory$(this), AnimatedTex$$Lambda$10.lambdaFactory$(this)));
        this.options.add(new ValElem("frameCount", AnimatedTex$$Lambda$11.lambdaFactory$(this), AnimatedTex$$Lambda$12.lambdaFactory$(this)));
        this.options.add(new BoolElem("anX", AnimatedTex$$Lambda$13.lambdaFactory$(this), AnimatedTex$$Lambda$14.lambdaFactory$(this)));
        this.options.add(new BoolElem("interpolate", AnimatedTex$$Lambda$15.lambdaFactory$(this), AnimatedTex$$Lambda$16.lambdaFactory$(this)));
    }

    public void save(JsonMap map) {
        map.put("frameTime", this.frameTime);
        map.put("frameCount", this.frameCount);
        map.put("start", this.uvStart.toMap());
        map.put("size", this.uvSize.toMap());
        map.put("from", this.animStart.toMap());
        map.put("anX", this.anX);
        map.put("interpolate", this.interpolate);
    }

    public boolean apply(Image ri, Image img) {
        if (this.frameCount == 0 || this.frameTime == 0) {
            return false;
        }
        long time = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine().getTime();
        int frm = (int)(time / (long)this.frameTime % (long)this.frameCount);
        if (this.interpolate) {
            if (time - this.lastUpdate > 50L) {
                float t = (float)frm + (float)(time % (long)this.frameTime) / (float)this.frameTime;
                int uvx = this.uvStart.x;
                int uvy = this.uvStart.y;
                int sx = this.uvSize.x;
                int sy = this.uvSize.y;
                int ax = this.animStart.x;
                int ay = this.animStart.y;
                AnimatedTexture.copyTextureInt(ri, img, uvx, uvy, sx, sy, ax, ay, t, this.anX, this.frameCount);
                return true;
            }
        } else if (frm != this.lastFrame) {
            this.lastFrame = frm;
            int uvx = this.uvStart.x;
            int uvy = this.uvStart.y;
            int sx = this.uvSize.x;
            int sy = this.uvSize.y;
            int ax = this.animStart.x;
            int ay = this.animStart.y;
            AnimatedTexture.copyTexture(ri, img, uvx, uvy, sx, sy, ax, ay, frm, this.anX);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.editor.ui.i18nFormat("label.cpm.tree.animatedRegion", new Object[0]);
    }

    @Override
    public void getTreeElements(Consumer<TreeElement> c) {
        this.options.forEach(c);
    }

    @Override
    public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
        gui.drawBox((float)x + (float)this.uvStart.x * xs, (float)y + (float)this.uvStart.y * ys, (float)this.uvSize.x * xs, (float)this.uvSize.y * ys, -2130706688);
        gui.drawBox((float)x + (float)this.animStart.x * xs, (float)y + (float)this.animStart.y * ys, (float)this.uvSize.x * xs, (float)this.uvSize.y * ys, -2130706433);
        if (this.anX) {
            gui.drawBox((float)x + (float)(this.animStart.x + this.uvSize.x) * xs, (float)y + (float)this.animStart.y * ys, (float)(this.uvSize.x * (this.frameCount - 1)) * xs, (float)this.uvSize.y * ys, -2136298838);
        } else {
            gui.drawBox((float)x + (float)this.animStart.x * xs, (float)y + (float)(this.animStart.y + this.uvSize.y) * ys, (float)this.uvSize.x * xs, (float)(this.uvSize.y * (this.frameCount - 1)) * ys, -2136298838);
        }
        Box b = this.getOverlap();
        if (b.w > 0 && b.h > 0) {
            gui.drawBox((float)x + (float)b.x * xs, (float)y + (float)b.y * ys, (float)b.w * xs, (float)b.h * ys, -2130771968);
        }
    }

    private Box getOverlap() {
        Box b = new Box(this.animStart.x, this.animStart.y, (this.anX ? this.frameCount : 1) * this.uvSize.x, (this.anX ? 1 : this.frameCount) * this.uvSize.y);
        return new Box(this.uvStart.x, this.uvStart.y, this.uvSize.x, this.uvSize.y).intersect(b);
    }

    @Override
    public int textColor(IGui gui) {
        Box b = this.getOverlap();
        return b.w > 0 && b.h > 0 ? -65536 : 0;
    }

    @Override
    public Tooltip getTooltip(IGui gui) {
        Box b = this.getOverlap();
        return b.w > 0 && b.h > 0 ? new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.animatedTexOverlap", new Object[0])) : null;
    }

    @Override
    public ETextures getTexture() {
        ETextures tex = this.editor.textures.get((Object)this.sheet);
        if (tex != null) {
            return tex;
        }
        return this.editor.textures.get((Object)TextureSheetType.SKIN);
    }

    @Override
    public void delete() {
        ETextures tex = this.editor.textures.get((Object)this.sheet);
        this.editor.action("remove", "action.cpm.animTex").removeFromList(tex.animatedTexs, this).onRun(AnimatedTex$$Lambda$17.lambdaFactory$(this, tex)).execute();
        this.editor.updateGui();
    }

    @Override
    public void updateGui() {
        this.editor.setDelEn.accept(true);
    }

    protected void markDirty() {
        this.editor.textures.get((Object)this.sheet).refreshTexture();
        this.lastFrame = -1;
    }

    public static void applyAnims(TreeElement sel, Consumer<TreeElement> c) {
        if (sel instanceof AnimatedTex) {
            sel.getTreeElements(c);
        } else if (sel instanceof OptionElem) {
            ((OptionElem)sel).outer().getTreeElements(c);
        }
    }

    static /* synthetic */ void lambda$delete$13(AnimatedTex this_, ETextures tex) {
        this_.editor.selectedElement = null;
        tex.refreshTexture();
    }

    static /* synthetic */ void lambda$new$12(AnimatedTex this_, Boolean v) {
        this_.interpolate = v;
    }

    static /* synthetic */ boolean lambda$new$11(AnimatedTex this_) {
        return this_.interpolate;
    }

    static /* synthetic */ void lambda$new$10(AnimatedTex this_, Boolean v) {
        this_.anX = v;
    }

    static /* synthetic */ boolean lambda$new$9(AnimatedTex this_) {
        return this_.anX;
    }

    static /* synthetic */ void lambda$new$8(AnimatedTex this_, int v) {
        this_.frameCount = v;
    }

    static /* synthetic */ int lambda$new$7(AnimatedTex this_) {
        return this_.frameCount;
    }

    static /* synthetic */ void lambda$new$6(AnimatedTex this_, int v) {
        this_.frameTime = v;
    }

    static /* synthetic */ int lambda$new$5(AnimatedTex this_) {
        return this_.frameTime;
    }

    static /* synthetic */ Vec2i lambda$new$4(AnimatedTex this_) {
        return new Vec2i(this_.uvSize.x * (this_.anX ? this_.frameCount : 1), this_.uvSize.y * (this_.anX ? 1 : this_.frameCount));
    }

    static /* synthetic */ Vec2i lambda$new$3(AnimatedTex this_) {
        return this_.animStart;
    }

    static /* synthetic */ Vec2i lambda$new$2(AnimatedTex this_) {
        return this_.uvSize;
    }

    static /* synthetic */ Vec2i lambda$new$1(AnimatedTex this_) {
        return this_.uvSize;
    }

    static /* synthetic */ Vec2i lambda$new$0(AnimatedTex this_) {
        return this_.uvStart;
    }

    @Override
    public void setVec(Vec3f vec3f, VecType vecType) {
        TreeElement$.setVec(this, vec3f, vecType);
    }

    @Override
    public void setElemColor(int n) {
        TreeElement$.setElemColor(this, n);
    }

    @Override
    public void setValue(float f) {
        TreeElement$.setValue(this, f);
    }

    @Override
    public void setVecTemp(VecType vecType, Vec3f vec3f) {
        TreeElement$.setVecTemp(this, vecType, vec3f);
    }

    @Override
    public boolean canAccept(TreeElement treeElement) {
        return TreeElement$.canAccept(this, treeElement);
    }

    @Override
    public void populatePopup(PopupMenu popupMenu) {
        TreeElement$.populatePopup(this, popupMenu);
    }

    @Override
    public void modeSwitch() {
        TreeElement$.modeSwitch(this);
    }

    @Override
    public boolean canEditVec(VecType vecType) {
        return TreeElement$.canEditVec(this, vecType);
    }

    @Override
    public void switchVis() {
        TreeElement$.switchVis(this);
    }

    @Override
    public boolean isSelected(Editor editor, TreeElement treeElement) {
        return TreeElement$.isSelected(this, editor, treeElement);
    }

    @Override
    public void drawName(IGui iGui, int n, int n2, int n3) {
        TreeElement$.drawName(this, iGui, n, n2, n3);
    }

    @Override
    public void setMCScale(float f) {
        TreeElement$.setMCScale(this, f);
    }

    @Override
    public float getValue() {
        return TreeElement$.getValue(this);
    }

    @Override
    public int bgColor(IGui iGui) {
        return TreeElement$.bgColor(this, iGui);
    }

    @Override
    public void accept(TreeElement treeElement) {
        TreeElement$.accept(this, treeElement);
    }

    @Override
    public Vec3f getVec(VecType vecType) {
        return TreeElement$.getVec(this, vecType);
    }

    @Override
    public void switchEffect(Effect effect) {
        TreeElement$.switchEffect(this, effect);
    }

    @Override
    public void addNew() {
        TreeElement$.addNew(this);
    }

    @Override
    public String getElemName() {
        return TreeElement$.getElemName(this);
    }

    @Override
    public Box getTextureBox() {
        return TreeElement$.getTextureBox(this);
    }

    @Override
    public void onRefreshTree() {
        TreeElement$.onRefreshTree(this);
    }

    public List getSettingsElements() {
        return TreeElement$.getSettingsElements(this);
    }

    @Override
    public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
        TreeElement$.onClick(this, iGui, editor, mouseEvent);
    }

    @Override
    public void setElemName(String string) {
        TreeElement$.setElemName(this, string);
    }

    @Override
    public boolean canMove() {
        return TreeElement$.canMove(this);
    }

    @Override
    public boolean canSelect() {
        return TreeElement$.canSelect(this);
    }

    @Override
    public int getExtraWidth(IGui iGui) {
        return TreeElement$.getExtraWidth(this, iGui);
    }

    private class RegionSize
    extends UVResizableArea {
        public RegionSize() {
            super(AnimatedTex.this.editor, AnimatedTex.this.startDrag);
        }

        @Override
        protected UVResizableArea.Area getArea() {
            return new UVResizableArea.Area(AnimatedTex.this.uvStart.x, AnimatedTex.this.uvStart.y, AnimatedTex.this.uvStart.x + AnimatedTex.this.uvSize.x, AnimatedTex.this.uvStart.y + AnimatedTex.this.uvSize.y);
        }

        @Override
        protected void setArea(UVResizableArea.Area v, boolean moveOnly) {
            int sx = Math.min(v.sx, v.ex);
            int sy = Math.min(v.sy, v.ey);
            int ex = Math.max(v.sx, v.ex);
            int ey = Math.max(v.sy, v.ey);
            this.editor.action("set", "label.cpm.tree.at.start").updateValueOp(AnimatedTex.this.uvStart, AnimatedTex.this.uvStart.x, sx, AnimatedTex$RegionSize$$Lambda$1.lambdaFactory$()).updateValueOp(AnimatedTex.this.uvStart, AnimatedTex.this.uvStart.y, sy, AnimatedTex$RegionSize$$Lambda$2.lambdaFactory$()).updateValueOp(AnimatedTex.this.uvSize, AnimatedTex.this.uvSize.x, ex - sx, AnimatedTex$RegionSize$$Lambda$3.lambdaFactory$()).updateValueOp(AnimatedTex.this.uvSize, AnimatedTex.this.uvSize.y, ey - sy, AnimatedTex$RegionSize$$Lambda$4.lambdaFactory$()).onAction(AnimatedTex$RegionSize$$Lambda$5.lambdaFactory$(AnimatedTex.this)).execute();
        }

        @Override
        protected void setAreaTemp(UVResizableArea.Area v) {
            int sx = Math.min(v.sx, v.ex);
            int sy = Math.min(v.sy, v.ey);
            int ex = Math.max(v.sx, v.ex);
            int ey = Math.max(v.sy, v.ey);
            AnimatedTex.this.uvStart.x = sx;
            AnimatedTex.this.uvStart.y = sy;
            AnimatedTex.this.uvSize.x = ex - sx;
            AnimatedTex.this.uvSize.y = ey - sy;
            this.editor.textures.get((Object)AnimatedTex.this.sheet).refreshTexture();
        }

        static /* synthetic */ void lambda$setArea$3(Vec2i a, Integer b) {
            a.y = b;
        }

        static /* synthetic */ void lambda$setArea$2(Vec2i a, Integer b) {
            a.x = b;
        }

        static /* synthetic */ void lambda$setArea$1(Vec2i a, Integer b) {
            a.y = b;
        }

        static /* synthetic */ void lambda$setArea$0(Vec2i a, Integer b) {
            a.x = b;
        }
    }

    private class BoolElem
    extends OptionElem {
        private BooleanSupplier get;
        private Consumer<Boolean> set;

        public BoolElem(String name, BooleanSupplier get, Consumer<Boolean> set) {
            super(name);
            this.get = get;
            this.set = set;
        }

        @Override
        public void updateGui() {
            ((AnimatedTex)AnimatedTex.this).editor.setModeBtn.accept(((AnimatedTex)AnimatedTex.this).editor.ui.i18nFormat("button.cpm.at." + this.name + "." + (this.get.getAsBoolean() ? "on" : "off"), new Object[0]));
        }

        @Override
        public void modeSwitch() {
            AnimatedTex.this.editor.action("set", "label.cpm.tree.at." + this.name).updateValueOp(this.set, this.get.getAsBoolean(), !this.get.getAsBoolean(), AnimatedTex$BoolElem$$Lambda$1.lambdaFactory$()).onAction(AnimatedTex$BoolElem$$Lambda$2.lambdaFactory$(AnimatedTex.this)).onAction(AnimatedTex$BoolElem$$Lambda$3.lambdaFactory$(this)).execute();
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public Vec3f getVec(VecType vecType) {
            return TreeElement$.getVec(this, vecType);
        }

        @Override
        public void setVec(Vec3f vec3f, VecType vecType) {
            TreeElement$.setVec(this, vec3f, vecType);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void setVecTemp(VecType vecType, Vec3f vec3f) {
            TreeElement$.setVecTemp(this, vecType, vec3f);
        }

        @Override
        public Box getTextureBox() {
            return TreeElement$.getTextureBox(this);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        @Override
        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    private class ValElem
    extends OptionElem {
        private IntSupplier get;
        private IntConsumer set;

        public ValElem(String name, IntSupplier get, IntConsumer set) {
            super(name);
            this.get = get;
            this.set = set;
        }

        @Override
        public void updateGui() {
            ((AnimatedTex)AnimatedTex.this).editor.setModePanel.accept(ModeDisplayType.VALUE);
            ((AnimatedTex)AnimatedTex.this).editor.setValue.accept(Float.valueOf(this.get.getAsInt()));
        }

        @Override
        public void setValue(float value) {
            this.set.accept((int)value);
            AnimatedTex.this.editor.action("set", "label.cpm.tree.at." + this.name).updateValueOp(this.set, this.get.getAsInt(), (int)value, AnimatedTex$ValElem$$Lambda$1.lambdaFactory$()).onAction(AnimatedTex$ValElem$$Lambda$2.lambdaFactory$(AnimatedTex.this)).execute();
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public Vec3f getVec(VecType vecType) {
            return TreeElement$.getVec(this, vecType);
        }

        @Override
        public void setVec(Vec3f vec3f, VecType vecType) {
            TreeElement$.setVec(this, vec3f, vecType);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setVecTemp(VecType vecType, Vec3f vec3f) {
            TreeElement$.setVecTemp(this, vecType, vec3f);
        }

        @Override
        public Box getTextureBox() {
            return TreeElement$.getTextureBox(this);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        @Override
        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    private class TexElemDrag
    extends TexElem {
        private Supplier<Vec2i> vecSize;

        public TexElemDrag(String name, Supplier<Vec2i> vec, Supplier<Vec2i> vecSize) {
            super(name, vec);
            this.vecSize = vecSize;
        }

        @Override
        public Box getTextureBox() {
            Vec2i vec = (Vec2i)this.vec.get();
            Vec2i size = this.vecSize.get();
            return new Box(vec.x, vec.y, size.x, size.y);
        }

        @Override
        public Vec3f getVec(VecType type) {
            Vec2i vec = (Vec2i)this.vec.get();
            if (type == VecType.TEXTURE) {
                return new Vec3f(vec.x, vec.y, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVecTemp(VecType type, Vec3f v) {
            Vec2i vec = (Vec2i)this.vec.get();
            vec.x = (int)v.x;
            vec.y = (int)v.y;
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        @Override
        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    private class TexElem
    extends OptionElem {
        protected Supplier<Vec2i> vec;

        public TexElem(String name, Supplier<Vec2i> vec) {
            super(name);
            this.vec = vec;
        }

        @Override
        public void updateGui() {
            Vec2i vec = this.vec.get();
            ((AnimatedTex)AnimatedTex.this).editor.setModePanel.accept(ModeDisplayType.TEX);
            ((AnimatedTex)AnimatedTex.this).editor.setTexturePanel.accept(new Vec3i(vec.x, vec.y, 0));
        }

        @Override
        public void setVec(Vec3f v, VecType object) {
            if (object == VecType.TEXTURE) {
                Vec2i vec = this.vec.get();
                AnimatedTex.this.editor.action("set", "label.cpm.tree.at." + this.name).updateValueOp(vec, vec.x, (int)v.x, AnimatedTex$TexElem$$Lambda$1.lambdaFactory$()).updateValueOp(vec, vec.y, (int)v.y, AnimatedTex$TexElem$$Lambda$2.lambdaFactory$()).onAction(AnimatedTex$TexElem$$Lambda$3.lambdaFactory$(AnimatedTex.this)).execute();
            }
        }

        static /* synthetic */ void lambda$setVec$1(Vec2i a, Integer b) {
            a.y = b;
        }

        static /* synthetic */ void lambda$setVec$0(Vec2i a, Integer b) {
            a.x = b;
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public Vec3f getVec(VecType vecType) {
            return TreeElement$.getVec(this, vecType);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void setVecTemp(VecType vecType, Vec3f vec3f) {
            TreeElement$.setVecTemp(this, vecType, vec3f);
        }

        @Override
        public Box getTextureBox() {
            return TreeElement$.getTextureBox(this);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        @Override
        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    private class OptionElem
    implements TreeElement {
        protected String name;

        public OptionElem(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return ((AnimatedTex)AnimatedTex.this).editor.ui.i18nFormat("label.cpm.tree.at." + this.name, new Object[0]);
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            AnimatedTex.this.drawTexture(gui, x, y, xs, ys);
        }

        @Override
        public ETextures getTexture() {
            return AnimatedTex.this.getTexture();
        }

        @Override
        public Tooltip getTooltip(IGui gui) {
            return new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.tree.at." + this.name, new Object[0]));
        }

        protected AnimatedTex outer() {
            return AnimatedTex.this;
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public Vec3f getVec(VecType vecType) {
            return TreeElement$.getVec(this, vecType);
        }

        @Override
        public void setVec(Vec3f vec3f, VecType vecType) {
            TreeElement$.setVec(this, vec3f, vecType);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public void updateGui() {
            TreeElement$.updateGui(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void setVecTemp(VecType vecType, Vec3f vec3f) {
            TreeElement$.setVecTemp(this, vecType, vec3f);
        }

        @Override
        public Box getTextureBox() {
            return TreeElement$.getTextureBox(this);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }
}

