/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.anim;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IAnimation$;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.animation.interpolator.Interpolator;
import com.tom.cpm.shared.animation.interpolator.InterpolatorType;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.AnimationProperties;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$1;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$10;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$11;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$12;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$13;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$14;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$15;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$16;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$17;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$18;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$19;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$2;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$20;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$21;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$22;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$23;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$24;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$25;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$26;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$27;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$28;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$29;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$3;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$30;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$31;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$32;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$33;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$34;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$35;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$36;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$37;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$38;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$39;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$4;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$40;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$41;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$42;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$5;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$6;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$7;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$8;
import com.tom.cpm.shared.editor.anim.EditorAnim$$Lambda$9;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.elements.MultiSelector;
import com.tom.cpm.shared.editor.project.loaders.AnimationsLoaderV1;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EditorAnim
implements IAnimation {
    private List<ModelElement> components;
    private final List<AnimFrame> frames = new ArrayList<AnimFrame>();
    public int duration = 1000;
    private Interpolator[][] psfs;
    private AnimFrame currentFrame;
    public final Editor editor;
    public String filename;
    public AnimationType type;
    public IPose pose;
    public String displayName;
    public boolean add = true;
    public boolean loop;
    public boolean command;
    public boolean layerControlled = true;
    public int priority;
    public InterpolatorType intType = InterpolatorType.POLY_LOOP;
    public float layerDefault;
    public int order;
    public boolean isProperty;
    public String group;
    public int maxValue = 100;
    public boolean interpolateValue = true;
    public boolean mustFinish;
    public boolean hidden;

    public EditorAnim(Editor e, String filename, AnimationType type, boolean initNew) {
        this.editor = e;
        this.filename = filename;
        this.type = type;
        if (initNew) {
            this.addFrame();
        }
    }

    public EditorAnim(EditorAnim anim) {
        this.editor = anim.editor;
        this.filename = AnimationsLoaderV1.getFileName(anim.pose, anim.displayName);
        this.type = anim.type;
        this.displayName = anim.displayName;
        this.pose = anim.pose;
        this.add = anim.add;
        this.duration = anim.duration;
        this.priority = anim.priority;
        this.loop = anim.loop;
        this.intType = anim.intType;
        this.layerDefault = anim.layerDefault;
        this.order = anim.order;
        this.isProperty = anim.isProperty;
        this.group = anim.group;
        this.command = anim.command;
        Stream stream = anim.frames.stream().map(EditorAnim$$Lambda$1.lambdaFactory$());
        List<AnimFrame> list = this.frames;
        list.getClass();
        stream.forEach(EditorAnim$$Lambda$2.lambdaFactory$(list));
        if (this.frames.size() > 0) {
            this.currentFrame = this.frames.get(0);
        }
    }

    public void setProperties(AnimationProperties p, ActionBuilder ab) {
        String fn = AnimationsLoaderV1.getFileName(p.pose, p.displayName);
        ab.updateValueOp(this, this.add, p.add, EditorAnim$$Lambda$3.lambdaFactory$()).updateValueOp(this, this.loop, p.loop, EditorAnim$$Lambda$4.lambdaFactory$()).updateValueOp(this, this.displayName, p.displayName, EditorAnim$$Lambda$5.lambdaFactory$()).updateValueOp(this, this.pose, p.pose, EditorAnim$$Lambda$6.lambdaFactory$()).updateValueOp(this, this.type, p.type, EditorAnim$$Lambda$7.lambdaFactory$()).updateValueOp(this, this.filename, fn, EditorAnim$$Lambda$8.lambdaFactory$()).updateValueOp(this, this.intType, p.it, EditorAnim$$Lambda$9.lambdaFactory$()).updateValueOp(this, this.command, p.command, EditorAnim$$Lambda$10.lambdaFactory$()).updateValueOp(this, this.layerControlled, p.layerCtrl, EditorAnim$$Lambda$11.lambdaFactory$()).updateValueOp(this, this.mustFinish, p.mustFinish, EditorAnim$$Lambda$12.lambdaFactory$()).updateValueOp(this, this.hidden, p.hidden, EditorAnim$$Lambda$13.lambdaFactory$());
    }

    private void calculateSplines() {
        this.components = this.frames.stream().flatMap(EditorAnim$$Lambda$14.lambdaFactory$()).distinct().collect(Collectors.toList());
        this.psfs = new Interpolator[this.components.size()][InterpolatorChannel.VALUES.length];
        for (int component = 0; component < this.components.size(); ++component) {
            for (InterpolatorChannel channel : InterpolatorChannel.VALUES) {
                Interpolator i = this.intType.create();
                i.init(AnimFrame.toArray(this, this.components.get(component), channel), channel.createInterpolatorSetup());
                this.psfs[component][channel.channelID()] = i;
            }
        }
    }

    public float getValue(ModelElement component, InterpolatorChannel attribute, double time) {
        return (float)this.psfs[this.components.indexOf(component)][attribute.channelID()].applyAsDouble(time);
    }

    public void apply() {
        if (this.currentFrame != null) {
            this.currentFrame.apply();
        }
    }

    @Override
    public void animate(long millis, ModelDefinition def, AnimationEngine.AnimationMode mode) {
        float step;
        if (this.components == null || this.psfs == null) {
            this.calculateSplines();
        }
        boolean remap = false;
        if (this.pose != null && this.pose instanceof VanillaPose && ((VanillaPose)this.pose).hasStateGetter()) {
            step = this.editor.animTestSliders.getOrDefault("__pose", Float.valueOf(0.0f)).floatValue();
            remap = true;
        } else if (this.type == AnimationType.VALUE_LAYER) {
            step = this.editor.animTestSliders.getOrDefault(this.getId(), Float.valueOf(this.layerDefault)).floatValue();
            remap = true;
        } else {
            step = (float)millis % (float)this.duration / (float)this.duration * (float)this.frames.size();
        }
        if (remap) {
            int dd = (int)(step * 1000.0f);
            step = (float)dd % 1001.0f / 1001.0f * (float)this.frames.size();
        }
        for (int i = 0; i < this.components.size(); ++i) {
            ModelElement component = this.components.get(i);
            component.rc.setRotation(this.add, this.getValue(component, InterpolatorChannel.ROT_X, step), this.getValue(component, InterpolatorChannel.ROT_Y, step), this.getValue(component, InterpolatorChannel.ROT_Z, step));
            component.rc.setPosition(this.add, this.getValue(component, InterpolatorChannel.POS_X, step), this.getValue(component, InterpolatorChannel.POS_Y, step), this.getValue(component, InterpolatorChannel.POS_Z, step));
            component.rc.setColor(this.getValue(component, InterpolatorChannel.COLOR_R, step), this.getValue(component, InterpolatorChannel.COLOR_G, step), this.getValue(component, InterpolatorChannel.COLOR_B, step));
            component.rc.setVisible(this.frames.get((int)step).getVisible(component));
            component.rc.setRenderScale(this.add, this.getValue(component, InterpolatorChannel.SCALE_X, step), this.getValue(component, InterpolatorChannel.SCALE_Y, step), this.getValue(component, InterpolatorChannel.SCALE_Z, step));
        }
    }

    public void setPosition(Vec3f v) {
        if (this.currentFrame != null) {
            if (this.editor.selectedElement instanceof MultiSelector.ElementImpl) {
                MultiSelector.ElementImpl elementImpl = (MultiSelector.ElementImpl)this.editor.selectedElement;
                Function function = EditorAnim$$Lambda$15.lambdaFactory$(this);
                AnimFrame animFrame = this.currentFrame;
                animFrame.getClass();
                elementImpl.setVecAnim(v, function, EditorAnim$$Lambda$16.lambdaFactory$(animFrame));
            } else if (this.editor.getSelectedElement() != null) {
                this.currentFrame.setPos(this.editor.getSelectedElement(), v);
            }
        }
        this.components = null;
        this.psfs = null;
    }

    public void setRotation(Vec3f v) {
        if (this.currentFrame != null) {
            if (this.editor.selectedElement instanceof MultiSelector.ElementImpl) {
                MultiSelector.ElementImpl elementImpl = (MultiSelector.ElementImpl)this.editor.selectedElement;
                Function function = EditorAnim$$Lambda$17.lambdaFactory$(this);
                AnimFrame animFrame = this.currentFrame;
                animFrame.getClass();
                elementImpl.setVecAnim(v, function, EditorAnim$$Lambda$18.lambdaFactory$(animFrame));
            } else if (this.editor.getSelectedElement() != null) {
                this.currentFrame.setRot(this.editor.getSelectedElement(), v);
            }
        }
        this.components = null;
        this.psfs = null;
    }

    public void setScale(Vec3f v) {
        if (this.currentFrame != null) {
            if (this.editor.selectedElement instanceof MultiSelector.ElementImpl) {
                MultiSelector.ElementImpl elementImpl = (MultiSelector.ElementImpl)this.editor.selectedElement;
                Function function = EditorAnim$$Lambda$19.lambdaFactory$(this);
                AnimFrame animFrame = this.currentFrame;
                animFrame.getClass();
                elementImpl.setVecAnim(v, function, EditorAnim$$Lambda$20.lambdaFactory$(animFrame));
            } else if (this.editor.getSelectedElement() != null) {
                this.currentFrame.setScale(this.editor.getSelectedElement(), v);
            }
        }
        this.components = null;
        this.psfs = null;
    }

    public void switchVisible() {
        if (this.currentFrame != null) {
            if (this.editor.selectedElement instanceof MultiSelector.ElementImpl) {
                MultiSelector.ElementImpl e = (MultiSelector.ElementImpl)this.editor.selectedElement;
                e.forEachSelected(EditorAnim$$Lambda$21.lambdaFactory$(this));
            } else if (this.editor.getSelectedElement() != null) {
                this.currentFrame.switchVis(this.editor.getSelectedElement());
            }
        }
        this.components = null;
        this.psfs = null;
    }

    public void clearSelectedData(boolean all) {
        if (this.currentFrame != null) {
            if (this.editor.selectedElement instanceof MultiSelector.ElementImpl) {
                ActionBuilder ab = this.editor.action("clearAnim");
                MultiSelector.ElementImpl e = (MultiSelector.ElementImpl)this.editor.selectedElement;
                e.forEachSelected(EditorAnim$$Lambda$22.lambdaFactory$(this, ab, all));
                ab.execute();
            } else if (this.editor.getSelectedElement() != null) {
                ActionBuilder ab = this.editor.action("clearAnim");
                this.clearFrameData(ab, this.editor.getSelectedElement(), all);
                ab.execute();
            }
        }
        this.components = null;
        this.psfs = null;
    }

    private void clearFrameData(ActionBuilder ab, ModelElement me, boolean all) {
        if (all) {
            this.frames.forEach(EditorAnim$$Lambda$23.lambdaFactory$(ab, me));
        } else {
            this.currentFrame.clearSelectedData(ab, me);
        }
    }

    public void setColor(int rgb) {
        if (this.currentFrame != null) {
            if (this.editor.selectedElement instanceof MultiSelector.ElementImpl) {
                MultiSelector.ElementImpl e = (MultiSelector.ElementImpl)this.editor.selectedElement;
                e.forEachSelected(EditorAnim$$Lambda$24.lambdaFactory$(this, rgb));
            } else if (this.editor.getSelectedElement() != null) {
                this.currentFrame.setColor(this.editor.getSelectedElement(), rgb);
            }
        }
        this.components = null;
        this.psfs = null;
    }

    public void addFrame() {
        this.addFrame(true);
    }

    public void addFrame(boolean copyCurrent) {
        if (this.currentFrame != null && copyCurrent) {
            this.addFrame(this.currentFrame);
        } else {
            AnimFrame frm = new AnimFrame(this);
            this.editor.action("add", "action.cpm.animFrame").addToList(this.frames, frm).onAction(EditorAnim$$Lambda$25.lambdaFactory$(this)).execute();
            this.currentFrame = frm;
        }
    }

    public void addFrame(AnimFrame cpyFrame) {
        AnimFrame frm = new AnimFrame(this, cpyFrame);
        this.editor.action("add", "action.cpm.animFrame").addToList(this.frames, frm).onAction(EditorAnim$$Lambda$26.lambdaFactory$(this)).execute();
        this.currentFrame = frm;
    }

    public void deleteFrame() {
        if (this.currentFrame != null) {
            int ind = this.frames.indexOf(this.currentFrame) - 1 + this.frames.size();
            this.editor.action("remove", "action.cpm.animFrame").removeFromList(this.frames, this.currentFrame).onAction(EditorAnim$$Lambda$27.lambdaFactory$(this)).execute();
            if (!this.frames.isEmpty()) {
                this.currentFrame = this.frames.get(ind % this.frames.size());
            }
        }
    }

    public List<AnimFrame> getFrames() {
        return this.frames;
    }

    public List<ModelElement> getComponentsFiltered() {
        return this.frames.stream().flatMap(EditorAnim$$Lambda$28.lambdaFactory$()).distinct().collect(Collectors.toList());
    }

    public String toString() {
        if (this.pose != null) {
            return this.editor.ui.i18nFormat("label.cpm.anim_pose", this.pose.getName(this.editor.ui, this.getDisplayName()));
        }
        if (this.type.isStaged()) {
            EditorAnim anim = this.findLinkedAnim();
            if (anim == null) {
                return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), this.getDisplayName());
            }
            return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), anim.toString());
        }
        return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), this.getDisplayName());
    }

    public AnimFrame getSelectedFrame() {
        return this.currentFrame;
    }

    public void setSelectedFrame(AnimFrame currentFrame) {
        this.currentFrame = currentFrame;
    }

    public void prevFrame() {
        if (this.currentFrame == null && !this.frames.isEmpty()) {
            this.currentFrame = this.frames.get(0);
        }
        if (this.frames.size() > 1) {
            int ind = this.frames.indexOf(this.currentFrame) - 1 + this.frames.size();
            this.currentFrame = this.frames.get(ind % this.frames.size());
        }
    }

    public void nextFrame() {
        if (this.currentFrame == null && !this.frames.isEmpty()) {
            this.currentFrame = this.frames.get(0);
        }
        if (this.frames.size() > 1) {
            int ind = this.frames.indexOf(this.currentFrame) + 1;
            this.currentFrame = this.frames.get(ind % this.frames.size());
        }
    }

    public boolean isCustom() {
        return this.type.isCustom();
    }

    public void clearCache() {
        this.components = null;
        this.psfs = null;
    }

    public void moveFrame(int i) {
        if (this.currentFrame == null || this.frames.size() < 2) {
            return;
        }
        int ind = this.frames.indexOf(this.currentFrame);
        if (ind == -1) {
            return;
        }
        int newInd = ind + i;
        if (newInd < 0 || newInd > this.frames.size()) {
            return;
        }
        ActionBuilder ab = this.editor.action("move", "action.cpm.animFrame");
        HashMap<AnimFrame, Float> map = new HashMap<AnimFrame, Float>();
        for (int j = 0; j < this.frames.size(); ++j) {
            map.put(this.frames.get(j), Float.valueOf(j));
        }
        ab.addToMap(map, this.currentFrame, Float.valueOf((float)newInd + 0.1f * (float)i));
        ab.onAction(EditorAnim$$Lambda$29.lambdaFactory$(this, map));
        ab.onAction(EditorAnim$$Lambda$30.lambdaFactory$(this));
        ab.execute();
    }

    public float getAnimProgess() {
        int ind = this.frames.indexOf(this.currentFrame);
        if (ind == -1) {
            return 0.0f;
        }
        if (this.frames.size() == 1) {
            return 1.0f;
        }
        return (float)ind / (float)(this.frames.size() - 1);
    }

    public IPose getPose() {
        return this.pose;
    }

    public String getId() {
        String nm = this.displayName;
        int i = nm.indexOf(35);
        if (i == -1) {
            return nm;
        }
        if (i == 0) {
            return "";
        }
        return nm.substring(0, i);
    }

    public String getDisplayGroup() {
        if (this.pose != null) {
            return this.editor.ui.i18nFormat("label.cpm.anim_pose", this.pose.getName(this.editor.ui, this.getId()));
        }
        if (this.type.isStaged()) {
            EditorAnim anim = this.findLinkedAnim();
            if (anim == null) {
                return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), this.getId());
            }
            return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), anim.getDisplayGroup());
        }
        return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), this.getId());
    }

    public EditorAnim findLinkedAnim() {
        return this.findLinkedAnims().findFirst().orElse(null);
    }

    public Stream<EditorAnim> findLinkedAnims() {
        String[] nm = this.displayName.split(":", 2);
        if (nm.length == 2) {
            Predicate search = null;
            String string = nm[0];
            int n = -1;
            switch (string.hashCode()) {
                case 112: {
                    if (!string.equals("p")) break;
                    n = 0;
                    break;
                }
                case 99: {
                    if (!string.equals("c")) break;
                    n = 1;
                    break;
                }
                case 103: {
                    if (!string.equals("g")) break;
                    n = 2;
                }
            }
            block5 : switch (n) {
                case 0: {
                    for (VanillaPose p : VanillaPose.VALUES) {
                        if (!nm[1].equals(p.name().toLowerCase(Locale.ROOT))) continue;
                        search = EditorAnim$$Lambda$31.lambdaFactory$(p);
                        break block5;
                    }
                    break;
                }
                case 1: {
                    search = EditorAnim$$Lambda$32.lambdaFactory$(nm);
                    break;
                }
                case 2: {
                    search = EditorAnim$$Lambda$33.lambdaFactory$(nm);
                    break;
                }
            }
            if (search != null) {
                return this.editor.animations.stream().filter(search);
            }
        }
        return Stream.empty();
    }

    public void updateGui() {
        AnimFrame selFrm = this.getSelectedFrame();
        if (selFrm != null) {
            MultiSelector.ElementImpl e;
            ModelElement selectedElement = this.editor.getSelectedElement();
            this.editor.setAnimFrame.accept(this.getFrames().indexOf(selFrm));
            if (selectedElement != null) {
                IElem dt = selFrm.getData(selectedElement);
                if (dt == null) {
                    if (this.add) {
                        this.editor.setAnimPos.accept(new Vec3f());
                        this.editor.setAnimRot.accept(new Vec3f());
                        if (selectedElement.type != ElementType.ROOT_PART) {
                            this.editor.setAnimScale.accept(new Vec3f(1.0f, 1.0f, 1.0f));
                        }
                    } else if (selectedElement.type == ElementType.ROOT_PART) {
                        PartValues val = ((VanillaModelPart)selectedElement.typeData).getDefaultSize(this.editor.skinType);
                        this.editor.setAnimPos.accept(val.getPos().add(selectedElement.pos));
                        this.editor.setAnimRot.accept(selectedElement.rotation);
                        this.editor.setAnimScale.accept(null);
                    } else {
                        this.editor.setAnimPos.accept(selectedElement.pos);
                        this.editor.setAnimRot.accept(selectedElement.rotation);
                        this.editor.setAnimScale.accept(new Vec3f(1.0f, 1.0f, 1.0f));
                    }
                    if (selectedElement.type != ElementType.ROOT_PART) {
                        if (!selectedElement.texture || selectedElement.recolor) {
                            this.editor.setAnimColor.accept(selectedElement.rgb);
                        }
                        this.editor.setAnimShow.accept(!selectedElement.hidden);
                    }
                } else {
                    if (!selectedElement.texture || selectedElement.recolor) {
                        Vec3f c = dt.getColor();
                        this.editor.setAnimColor.accept((int)c.x << 16 | (int)c.y << 8 | (int)c.z);
                    }
                    this.editor.setAnimPos.accept(dt.getPosition());
                    this.editor.setAnimRot.accept(dt.getRotation());
                    if (selectedElement.type != ElementType.ROOT_PART) {
                        this.editor.setAnimScale.accept(dt.getScale());
                        this.editor.setAnimShow.accept(dt.isVisible());
                    }
                }
            } else if (this.editor.selectedElement instanceof MultiSelector.ElementImpl && (e = (MultiSelector.ElementImpl)this.editor.selectedElement).hasElements()) {
                Vec3f p = e.getVecAnim(EditorAnim$$Lambda$34.lambdaFactory$(this, selFrm));
                Vec3f r = e.getVecAnim(EditorAnim$$Lambda$35.lambdaFactory$(this, selFrm));
                Vec3f s = e.getVecAnim(EditorAnim$$Lambda$36.lambdaFactory$(this, selFrm));
                this.editor.setAnimPos.accept(p);
                this.editor.setAnimRot.accept(r);
                this.editor.setAnimScale.accept(s);
                if (e.allMatch(EditorAnim$$Lambda$37.lambdaFactory$())) {
                    this.editor.setAnimColor.accept(e.getFirst().rgb);
                }
                ModelElement f = e.getFirst();
                IElem dt = selFrm.getData(e.getFirst());
                if (dt != null) {
                    this.editor.setAnimShow.accept(dt.isVisible());
                } else {
                    this.editor.setAnimShow.accept(!f.hidden);
                }
            }
            this.editor.setFrameDelEn.accept(true);
        }
        this.editor.setFrameAddEn.accept(true);
        this.editor.setAnimDelEn.accept(true);
        if (!(this.pose instanceof VanillaPose) || !((VanillaPose)this.pose).hasStateGetter()) {
            this.editor.setAnimDuration.accept(this.duration);
        }
        this.editor.setAnimPlayEn.accept(this.getFrames().size() > 1);
        this.editor.setAnimPriority.accept(this.priority);
        if (this.type.isCustom() && !this.type.isStaged()) {
            this.editor.setAnimOrder.accept(this.order);
        }
    }

    public void beginDrag() {
        ModelElement sel = this.editor.getSelectedElement();
        if (this.currentFrame != null && sel != null) {
            this.currentFrame.beginDrag(sel);
        }
    }

    public void endDrag() {
        if (this.currentFrame != null) {
            this.currentFrame.endDrag();
        }
    }

    public void dragVal(VecType type, Vec3f vec) {
        if (this.currentFrame != null) {
            this.currentFrame.dragVal(type, vec);
        }
    }

    public boolean isDragging() {
        return this.currentFrame != null ? this.currentFrame.isDragging() : false;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isLayer() {
        return this.type.isLayer();
    }

    @Override
    public int getPriority(AnimationEngine.AnimationMode mode) {
        return this.priority;
    }

    @Override
    public int getDuration(AnimationEngine.AnimationMode mode) {
        return this.duration;
    }

    public void reverseFrameOrder(ActionBuilder ab) {
        ArrayList<AnimFrame> f = new ArrayList<AnimFrame>(this.frames);
        ArrayList<AnimFrame> nf = new ArrayList<AnimFrame>(this.frames);
        Collections.reverse(nf);
        ab.onRun(EditorAnim$$Lambda$38.lambdaFactory$(this, nf));
        ab.onUndo(EditorAnim$$Lambda$39.lambdaFactory$(this, f));
        ab.onAction(EditorAnim$$Lambda$40.lambdaFactory$(this));
        Editor editor = this.editor;
        editor.getClass();
        ab.onRun(EditorAnim$$Lambda$41.lambdaFactory$(editor));
    }

    public int getSelectedFrameIndex() {
        return this.frames.indexOf(this.currentFrame);
    }

    static /* synthetic */ void lambda$reverseFrameOrder$27(EditorAnim this_, List f) {
        this_.frames.clear();
        this_.frames.addAll(f);
    }

    static /* synthetic */ void lambda$reverseFrameOrder$26(EditorAnim this_, List nf) {
        this_.frames.clear();
        this_.frames.addAll(nf);
    }

    static /* synthetic */ boolean lambda$updateGui$25(ModelElement x) {
        return x.recolor || !x.texture;
    }

    static /* synthetic */ Vec3f lambda$updateGui$24(EditorAnim this_, AnimFrame selFrm, ModelElement me) {
        IElem dt = selFrm.getData(me);
        if (dt != null) {
            return dt.getScale();
        }
        if (this_.add) {
            return new Vec3f();
        }
        return me.scale;
    }

    static /* synthetic */ Vec3f lambda$updateGui$23(EditorAnim this_, AnimFrame selFrm, ModelElement me) {
        IElem dt = selFrm.getData(me);
        if (dt != null) {
            return dt.getRotation();
        }
        if (this_.add) {
            return new Vec3f();
        }
        return me.rotation;
    }

    static /* synthetic */ Vec3f lambda$updateGui$22(EditorAnim this_, AnimFrame selFrm, ModelElement me) {
        IElem dt = selFrm.getData(me);
        if (dt != null) {
            return dt.getPosition();
        }
        if (this_.add) {
            return new Vec3f();
        }
        if (me.type == ElementType.ROOT_PART) {
            PartValues val = ((VanillaModelPart)me.typeData).getDefaultSize(this_.editor.skinType);
            return val.getPos().add(me.pos);
        }
        return me.pos;
    }

    static /* synthetic */ boolean lambda$findLinkedAnims$21(String[] nm, EditorAnim a) {
        return a.pose == null && a.getId().equals(nm[1]);
    }

    static /* synthetic */ boolean lambda$findLinkedAnims$20(String[] nm, EditorAnim a) {
        return a.pose instanceof CustomPose && ((CustomPose)a.pose).getName().equals(nm[1]);
    }

    static /* synthetic */ boolean lambda$findLinkedAnims$19(VanillaPose p, EditorAnim a) {
        return a.pose == p;
    }

    static /* synthetic */ void lambda$moveFrame$18(EditorAnim this_, Map map) {
        Map map2 = map;
        map2.getClass();
        this_.frames.sort(Comparator.comparing(EditorAnim$$Lambda$42.lambdaFactory$(map2)));
    }

    static /* synthetic */ void lambda$setColor$17(EditorAnim this_, int rgb, TreeElement el) {
        if (el instanceof ModelElement) {
            this_.currentFrame.setColor((ModelElement)el, rgb);
        }
    }

    static /* synthetic */ void lambda$clearFrameData$16(ActionBuilder ab, ModelElement me, AnimFrame f) {
        f.clearSelectedData(ab, me);
    }

    static /* synthetic */ void lambda$clearSelectedData$15(EditorAnim this_, ActionBuilder ab, boolean all, TreeElement el) {
        if (el instanceof ModelElement) {
            this_.clearFrameData(ab, (ModelElement)el, all);
        }
    }

    static /* synthetic */ void lambda$switchVisible$14(EditorAnim this_, TreeElement el) {
        if (el instanceof ModelElement) {
            this_.currentFrame.switchVis((ModelElement)el);
        }
    }

    static /* synthetic */ Vec3f lambda$setScale$13(EditorAnim this_, ModelElement me) {
        IElem dt = this_.currentFrame.getData(me);
        if (dt != null) {
            return dt.getScale();
        }
        if (this_.add) {
            return new Vec3f();
        }
        return me.scale;
    }

    static /* synthetic */ Vec3f lambda$setRotation$12(EditorAnim this_, ModelElement me) {
        IElem dt = this_.currentFrame.getData(me);
        if (dt != null) {
            return dt.getRotation();
        }
        if (this_.add) {
            return new Vec3f();
        }
        return me.rotation;
    }

    static /* synthetic */ Vec3f lambda$setPosition$11(EditorAnim this_, ModelElement me) {
        IElem dt = this_.currentFrame.getData(me);
        if (dt != null) {
            return dt.getPosition();
        }
        if (this_.add) {
            return new Vec3f();
        }
        if (me.type == ElementType.ROOT_PART) {
            PartValues val = ((VanillaModelPart)me.typeData).getDefaultSize(this_.editor.skinType);
            return val.getPos().add(me.pos);
        }
        return me.pos;
    }

    static /* synthetic */ void lambda$setProperties$10(EditorAnim a, Boolean b) {
        a.hidden = b;
    }

    static /* synthetic */ void lambda$setProperties$9(EditorAnim a, Boolean b) {
        a.mustFinish = b;
    }

    static /* synthetic */ void lambda$setProperties$8(EditorAnim a, Boolean b) {
        a.layerControlled = b;
    }

    static /* synthetic */ void lambda$setProperties$7(EditorAnim a, Boolean b) {
        a.command = b;
    }

    static /* synthetic */ void lambda$setProperties$6(EditorAnim a, InterpolatorType b) {
        a.intType = b;
    }

    static /* synthetic */ void lambda$setProperties$5(EditorAnim a, String b) {
        a.filename = b;
    }

    static /* synthetic */ void lambda$setProperties$4(EditorAnim a, AnimationType b) {
        a.type = b;
    }

    static /* synthetic */ void lambda$setProperties$3(EditorAnim a, IPose b) {
        a.pose = b;
    }

    static /* synthetic */ void lambda$setProperties$2(EditorAnim a, String b) {
        a.displayName = b;
    }

    static /* synthetic */ void lambda$setProperties$1(EditorAnim a, Boolean b) {
        a.loop = b;
    }

    static /* synthetic */ void lambda$setProperties$0(EditorAnim a, Boolean b) {
        a.add = b;
    }

    @Override
    public void prepare(AnimationEngine.AnimationMode animationMode) {
        IAnimation$.prepare(this, animationMode);
    }

    @Override
    public boolean checkAndUpdateRemove(AnimationEngine.AnimationMode animationMode) {
        return IAnimation$.checkAndUpdateRemove(this, animationMode);
    }

    @Override
    public boolean useTriggerTime() {
        return IAnimation$.useTriggerTime(this);
    }
}

