/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.elements.MultiSelector$;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$1;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$10;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$11;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$12;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$13;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$14;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$15;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$16;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$17;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$18;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$19;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$2;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$20;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$21;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$22;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$23;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$24;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$25;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$26;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$27;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$28;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$29;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$3;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$4;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$5;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$6;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$7;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$8;
import com.tom.cpm.shared.editor.elements.MultiSelector$ElementImpl$$Lambda$9;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.gui.TextureDisplay;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.TreeElement$;
import com.tom.cpm.shared.editor.tree.VecType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface MultiSelector
extends TreeElement {
    public boolean add(TreeElement var1);

    public void forEachSelected(Consumer<TreeElement> var1);

    @Override
    public String getName();

    public static class ElementImpl
    implements MultiSelector {
        private List<ModelElement> elements = new ArrayList<ModelElement>();
        private final Editor editor;

        public ElementImpl(Editor editor) {
            this.editor = editor;
        }

        private void addImpl(ModelElement modelElement) {
            if (this.elements.contains(modelElement)) {
                this.elements.remove(modelElement);
            } else {
                this.elements.add(modelElement);
            }
        }

        @Override
        public boolean isSelected(Editor e, TreeElement other) {
            return this.elements.contains(other);
        }

        public boolean allMatch(Predicate<ModelElement> test) {
            for (int i = 0; i < this.elements.size(); ++i) {
                ModelElement e = this.elements.get(i);
                if (test.test(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void updateGui() {
            if (this.elements.isEmpty()) {
                return;
            }
            ModelElement first = this.elements.get(0);
            if (this.allMatch(MultiSelector$ElementImpl$$Lambda$1.lambdaFactory$())) {
                this.editor.setOffset.accept(this.getVec(VecType.OFFSET));
                if (this.allMatch(MultiSelector$ElementImpl$$Lambda$2.lambdaFactory$())) {
                    if (this.allMatch(MultiSelector$ElementImpl$$Lambda$3.lambdaFactory$())) {
                        if (this.allMatch(MultiSelector$ElementImpl$$Lambda$4.lambdaFactory$())) {
                            this.editor.setModeBtn.accept(this.editor.ui.i18nFormat("button.cpm.mode.tex", new Object[0]));
                            this.editor.setModePanel.accept(ModeDisplayType.TEX);
                            this.editor.setTexturePanel.accept(this.getVecUV());
                            this.editor.setReColor.accept(first.recolor);
                            if (this.allMatch(MultiSelector$ElementImpl$$Lambda$5.lambdaFactory$())) {
                                this.editor.setPartColor.accept(first.rgb);
                            }
                        }
                    } else {
                        this.editor.setModeBtn.accept(this.editor.ui.i18nFormat("button.cpm.mode.color", new Object[0]));
                        this.editor.setModePanel.accept(ModeDisplayType.COLOR);
                        this.editor.setPartColor.accept(first.rgb);
                    }
                    double mc = this.elements.stream().mapToDouble(MultiSelector$ElementImpl$$Lambda$6.lambdaFactory$()).average().orElse(0.0);
                    this.editor.setMCScale.accept(Float.valueOf((float)mc));
                }
                this.editor.setDelEn.accept(true);
                this.editor.setHiddenEffect.accept(first.hidden);
                this.editor.setGlow.accept(first.glow);
                this.editor.setMirror.accept(first.mirror);
                this.editor.setSingleTex.accept(first.singleTex);
            }
            this.editor.setPosition.accept(this.getVec(VecType.POSITION));
            this.editor.setRot.accept(this.getVec(VecType.ROTATION));
        }

        @Override
        public void setElemColor(int color) {
            this.elements.forEach(MultiSelector$ElementImpl$$Lambda$7.lambdaFactory$(color));
        }

        @Override
        public void setVec(Vec3f v, VecType object) {
            if (object == VecType.TEXTURE) {
                Vec3i uv = this.getVecUV();
                float uOff = v.x - (float)uv.x;
                float vOff = v.y - (float)uv.y;
                this.elements.forEach(MultiSelector$ElementImpl$$Lambda$8.lambdaFactory$(uOff, vOff, object));
            } else {
                Vec3f s = this.getVec(object);
                Vec3f off = v.sub(s);
                this.elements.forEach(MultiSelector$ElementImpl$$Lambda$9.lambdaFactory$(this, object, off));
            }
        }

        public Vec3f getVecAnim(Function<ModelElement, Vec3f> getter) {
            return this.elements.stream().map(getter).reduce(new Vec3f(), MultiSelector$ElementImpl$$Lambda$10.lambdaFactory$()).mul(1.0f / (float)this.elements.size());
        }

        public void setVecAnim(Vec3f v, Function<ModelElement, Vec3f> getter, BiConsumer<ModelElement, Vec3f> setter) {
            Vec3f s = this.elements.stream().map(getter).reduce(new Vec3f(), MultiSelector$ElementImpl$$Lambda$11.lambdaFactory$()).mul(1.0f / (float)this.elements.size());
            Vec3f off = v.sub(s);
            this.elements.forEach(MultiSelector$ElementImpl$$Lambda$12.lambdaFactory$(setter, getter, off));
        }

        @Override
        public void delete() {
            this.elements.forEach(MultiSelector$ElementImpl$$Lambda$13.lambdaFactory$());
        }

        @Override
        public void switchVis() {
            this.elements.forEach(MultiSelector$ElementImpl$$Lambda$14.lambdaFactory$());
        }

        @Override
        public void switchEffect(Effect effect) {
            this.elements.forEach(MultiSelector$ElementImpl$$Lambda$15.lambdaFactory$(effect));
        }

        @Override
        public void modeSwitch() {
            this.elements.forEach(MultiSelector$ElementImpl$$Lambda$16.lambdaFactory$());
        }

        @Override
        public void setMCScale(float scale) {
            float mc = (float)((double)scale - this.elements.stream().mapToDouble(MultiSelector$ElementImpl$$Lambda$17.lambdaFactory$()).average().orElse(0.0));
            this.elements.forEach(MultiSelector$ElementImpl$$Lambda$18.lambdaFactory$(mc));
        }

        @Override
        public Vec3f getVec(VecType type) {
            if (type == VecType.TEXTURE) {
                Vec3i uv = this.getVecUV();
                return new Vec3f(uv.x, uv.y, uv.z);
            }
            return this.elements.stream().map(MultiSelector$ElementImpl$$Lambda$19.lambdaFactory$(this, type)).reduce(new Vec3f(), MultiSelector$ElementImpl$$Lambda$20.lambdaFactory$()).mul(1.0f / (float)this.elements.size());
        }

        public Vec3i getVecUV() {
            return this.elements.stream().map(MultiSelector$ElementImpl$$Lambda$21.lambdaFactory$()).reduce(new Vec3i(Integer.MAX_VALUE, Integer.MAX_VALUE, 256), MultiSelector$ElementImpl$$Lambda$22.lambdaFactory$());
        }

        public Vec3f getVec(ModelElement e, VecType type) {
            switch (type) {
                case OFFSET: {
                    return e.offset;
                }
                case POSITION: {
                    return e.getPosition();
                }
                case ROTATION: {
                    return e.getRotation();
                }
                case MESH_SCALE: {
                    return e.meshScale;
                }
                case SIZE: {
                    return e.size;
                }
            }
            return null;
        }

        @Override
        public ETextures getTexture() {
            List texs = this.elements.stream().map(MultiSelector$ElementImpl$$Lambda$23.lambdaFactory$()).distinct().collect(Collectors.toList());
            return texs.size() == 1 ? (ETextures)texs.get(0) : null;
        }

        @Override
        public Box getTextureBox() {
            return this.elements.stream().map(MultiSelector$ElementImpl$$Lambda$24.lambdaFactory$()).filter(MultiSelector$ElementImpl$$Lambda$25.lambdaFactory$()).reduce(null, MultiSelector$ElementImpl$$Lambda$26.lambdaFactory$());
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            this.elements.forEach(MultiSelector$ElementImpl$$Lambda$27.lambdaFactory$(gui, x, y, xs, ys));
        }

        @Override
        public void setVecTemp(VecType object, Vec3f v) {
            if (object == VecType.TEXTURE) {
                Vec3i uv = this.getVecUV();
                float uOff = v.x - (float)uv.x;
                float vOff = v.y - (float)uv.y;
                this.elements.forEach(MultiSelector$ElementImpl$$Lambda$28.lambdaFactory$(object, uOff, vOff));
            } else {
                Vec3f s = this.getVec(object);
                Vec3f off = v.sub(s);
                this.elements.forEach(MultiSelector$ElementImpl$$Lambda$29.lambdaFactory$(this, object, off));
            }
        }

        @Override
        public boolean add(TreeElement elem) {
            if (elem instanceof ModelElement) {
                this.addImpl((ModelElement)elem);
            }
            return this.elements.isEmpty();
        }

        @Override
        public void forEachSelected(Consumer<TreeElement> c) {
            this.elements.forEach(c);
        }

        public ModelElement getFirst() {
            return this.elements.get(0);
        }

        public boolean hasElements() {
            return !this.elements.isEmpty();
        }

        static /* synthetic */ void lambda$setVecTemp$20(ElementImpl this_, VecType object, Vec3f off, ModelElement e) {
            e.setVecTemp(object, this_.getVec(e, object).add(off));
        }

        static /* synthetic */ void lambda$setVecTemp$19(VecType object, float uOff, float vOff, ModelElement e) {
            e.setVecTemp(object, new Vec3f((float)e.u + uOff, (float)e.v + vOff, e.textureSize));
        }

        static /* synthetic */ void lambda$drawTexture$18(IGui gui, int x, int y, float xs, float ys, ModelElement e) {
            TextureDisplay.drawBoxTextureOverlay(gui, e, x, y, xs, ys, TextureDisplay.getAlphaForBox(true));
        }

        static /* synthetic */ Box lambda$getTextureBox$17(Box a, Box b) {
            return a == null ? b : (b == null ? a : a.union(b));
        }

        static /* synthetic */ boolean lambda$getTextureBox$16(Box e) {
            return e != null;
        }

        static /* synthetic */ Vec3i lambda$getVecUV$15(Vec3i a, Vec3i b) {
            return new Vec3i(Math.min(a.x, b.x), Math.min(a.y, b.y), Math.min(a.z, b.z));
        }

        static /* synthetic */ Vec3i lambda$getVecUV$14(ModelElement e) {
            return new Vec3i(e.u, e.v, e.textureSize);
        }

        static /* synthetic */ Vec3f lambda$getVec$13(ElementImpl this_, VecType type, ModelElement e) {
            return this_.getVec(e, type);
        }

        static /* synthetic */ void lambda$setMCScale$12(float mc, ModelElement e) {
            e.setMCScale(e.mcScale + mc);
        }

        static /* synthetic */ double lambda$setMCScale$11(ModelElement e) {
            return e.mcScale;
        }

        static /* synthetic */ void lambda$switchEffect$10(Effect effect, ModelElement e) {
            e.switchEffect(effect);
        }

        static /* synthetic */ void lambda$setVecAnim$9(BiConsumer setter, Function getter, Vec3f off, ModelElement e) {
            setter.accept(e, ((Vec3f)getter.apply(e)).add(off));
        }

        static /* synthetic */ void lambda$setVec$8(ElementImpl this_, VecType object, Vec3f off, ModelElement e) {
            e.setVec(this_.getVec(e, object).add(off), object);
        }

        static /* synthetic */ void lambda$setVec$7(float uOff, float vOff, VecType object, ModelElement e) {
            e.setVec(new Vec3f((float)e.u + uOff, (float)e.v + vOff, e.textureSize), object);
        }

        static /* synthetic */ void lambda$setElemColor$6(int color, ModelElement e) {
            e.setElemColor(color);
        }

        static /* synthetic */ double lambda$updateGui$5(ModelElement e) {
            return e.mcScale;
        }

        static /* synthetic */ boolean lambda$updateGui$4(ModelElement e) {
            return e.recolor;
        }

        static /* synthetic */ boolean lambda$updateGui$3(ModelElement e) {
            return e.faceUV == null;
        }

        static /* synthetic */ boolean lambda$updateGui$2(ModelElement e) {
            return e.texture;
        }

        static /* synthetic */ boolean lambda$updateGui$1(ModelElement e) {
            return e.itemRenderer == null;
        }

        static /* synthetic */ boolean lambda$updateGui$0(ModelElement e) {
            return e.type == ElementType.NORMAL;
        }

        @Override
        public String getName() {
            return MultiSelector$.getName(this);
        }

        @Override
        public Tooltip getTooltip(IGui iGui) {
            return TreeElement$.getTooltip(this, iGui);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }
}

