/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.math.Vec2f;
import com.tom.cpl.math.Vec2i;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorRenderer;
import com.tom.cpm.shared.editor.EditorTool;
import com.tom.cpm.shared.editor.gui.ViewportPaintPanel$$Lambda$1;
import com.tom.cpm.shared.editor.gui.ViewportPaintPanel$$Lambda$2;
import com.tom.cpm.shared.editor.gui.ViewportPanel;
import com.tom.cpm.shared.editor.tree.VecType;

public class ViewportPaintPanel
extends ViewportPanel {
    private int dragging;
    private boolean hovered;

    public ViewportPaintPanel(Frame frm, Editor editor) {
        super(frm, editor);
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.hovered = event.isHovered(this.bounds);
        super.draw(event, partialTicks);
    }

    public Vec2i getHoveredTexPos() {
        ETextures tex = this.editor.getTextureProvider();
        Vec2i size = tex != null ? tex.provider.size : new Vec2i(64, 64);
        EditorRenderer.Bounds hovered = this.editor.definition.bounds.stream().filter(ViewportPaintPanel$$Lambda$1.lambdaFactory$()).findFirst().orElse(null);
        if (hovered == null) {
            return null;
        }
        Vec2f h = hovered.bb.getHoverPointer();
        return new Vec2i(h.x * (float)size.x, h.y * (float)size.y);
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (event.isHovered(this.bounds) && event.btn == 0 && this.editor.drawMode.get() != EditorTool.SELECT && this.editor.definition.bounds.stream().anyMatch(ViewportPaintPanel$$Lambda$2.lambdaFactory$())) {
            this.dragging = 1;
            Vec2i v = this.getHoveredTexPos();
            if (v != null) {
                if (this.gui.isCtrlDown() || this.editor.drawMode.get() == EditorTool.COLOR_PICKER) {
                    ETextures tex = this.editor.getTextureProvider();
                    if (tex != null) {
                        this.editor.penColor = tex.getImage().getRGB(v.x, v.y);
                        this.editor.setPenColor.accept(this.editor.penColor);
                        this.dragging = 2;
                    }
                } else {
                    this.editor.drawPixel(v.x, v.y, true);
                }
            }
            event.consume();
        }
        super.mouseClick(event);
    }

    @Override
    public void mouseDrag(MouseEvent event) {
        if (event.btn == 0 && this.dragging > 0) {
            Vec2i v;
            if (event.isHovered(this.bounds) && (v = this.getHoveredTexPos()) != null) {
                ETextures tex;
                if (this.dragging == 1) {
                    this.editor.drawPixel(v.x, v.y, true);
                } else if (this.dragging == 2 && (tex = this.editor.getTextureProvider()) != null) {
                    this.editor.penColor = tex.getImage().getRGB(v.x, v.y);
                    this.editor.setPenColor.accept(this.editor.penColor);
                }
            }
            event.consume();
        }
        super.mouseDrag(event);
    }

    @Override
    public void mouseRelease(MouseEvent event) {
        if (event.btn == 0 && this.dragging > 0) {
            this.dragging = 0;
            event.consume();
        }
        super.mouseRelease(event);
    }

    @Override
    protected VecType[] getVecTypes() {
        return new VecType[0];
    }

    @Override
    protected boolean keysCanControlCamera() {
        return this.hovered;
    }

    static /* synthetic */ boolean lambda$mouseClick$1(EditorRenderer.Bounds b) {
        return b.isHovered && b.type != EditorRenderer.BoundType.DRAG_PANE;
    }

    static /* synthetic */ boolean lambda$getHoveredTexPos$0(EditorRenderer.Bounds b) {
        return b.isHovered;
    }
}

