/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.KeybindHandler;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.ButtonIconToggle;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.ElementGroup;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Quaternion;
import com.tom.cpl.math.TriangleBoundingBox;
import com.tom.cpl.math.Vec2f;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VirtualTriangleRenderer;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorRenderer;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$1;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$10;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$11;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$12;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$13;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$14;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$15;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$16;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$17;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$18;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$19;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$2;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$3;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$4;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$5;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$6;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$7;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$8;
import com.tom.cpm.shared.editor.gui.ViewportPanel$$Lambda$9;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.gui.Keybinds;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ViewportPanelBase3d;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.builtin.VanillaPlayerModel;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.PlayerModelLayer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class ViewportPanel
extends ViewportPanelBase3d {
    protected Editor editor;
    private TextureProvider debugTexture;
    public TreeElement draggingElement;
    public EditorRenderer.BoundType draggingType;
    public Vec3f[] oldValue;
    private ElementGroup<VecType, ButtonIconToggle> dragGroup;
    public VecType draggingVec;
    public Vec2f draggingClickOffset;
    public Mat4f modelView;
    public int dragged;
    public int dragged2;

    public ViewportPanel(Frame frm, Editor editor) {
        super(frm);
        this.editor = editor;
        this.dragGroup = new ElementGroup(ViewportPanel$$Lambda$1.lambdaFactory$());
        VecType[] vs = this.getVecTypes();
        for (int i = 0; i < vs.length; ++i) {
            VecType v = vs[i];
            ButtonIconToggle icon = new ButtonIconToggle(this.gui, "editor", v.ordinal() * 16, 48, true, ViewportPanel$$Lambda$2.lambdaFactory$(this, v));
            icon.setBounds(new Box(i * 20, 0, 20, 20));
            icon.setTooltip(new Tooltip(frm, this.gui.i18nFormat("label.cpm." + v.name().toLowerCase(Locale.ROOT), new Object[0]), Keybinds.EDITOR_TOOL_KBS.get((Object)v)));
            this.addElement(icon);
            this.dragGroup.addElement(v, icon);
        }
        if (vs.length != 0) {
            this.setVec(vs[0]);
        }
    }

    @Override
    public void render(MatrixStack stack, VBuffers buf, float partialTicks) {
        if (MinecraftObjectHolder.DEBUGGING && this.gui.isCtrlDown()) {
            Vec2i ws = this.get3dSize();
            if (this.debugTexture == null) {
                this.debugTexture = new TextureProvider();
            }
            if (this.debugTexture.getImage() == null || this.debugTexture.getImage().getWidth() != ws.x || this.debugTexture.getImage().getHeight() != ws.y) {
                this.debugTexture.setImage(new Image(ws.x, ws.y));
            }
            this.debugTexture.getImage().fill(0);
        }
        if (this.editor.renderBase.get()) {
            this.renderBase(stack, buf);
        }
        this.editor.definition.renderingPanel = this;
        this.renderModel(stack, buf, partialTicks);
        VBuffers rp = buf.replay();
        this.editor.render(stack, rp, this);
        rp.finishAll();
        this.editor.definition.renderingPanel = null;
        if (MinecraftObjectHolder.DEBUGGING && this.gui.isCtrlDown()) {
            this.debugTexture.texture.markDirty();
            this.debugTexture.bind();
        }
    }

    public void finishTransform(EditorRenderer.Bounds b) {
        ETextures tex;
        TriangleBoundingBox t = b.bb;
        Mat4f view = this.getView();
        Mat4f proj = this.getProjection();
        t.transform(this.modelView);
        t.transform(view);
        t.transform(proj);
        Vec2i ws = this.get3dSize();
        t.finishTransform(ws.x, ws.y, this.get3dMousePos());
        if (MinecraftObjectHolder.DEBUGGING && this.gui.isCtrlDown() && (tex = this.editor.getTextureProvider()) != null) {
            VirtualTriangleRenderer.plot(t, this.debugTexture.getImage(), this.get3dMousePos(), b.type == EditorRenderer.BoundType.CLICK ? tex.getImage() : null);
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.gui.drawText(0, -10, "a", -1);
        super.draw(event, partialTicks);
        if (MinecraftObjectHolder.DEBUGGING && this.gui.isCtrlDown()) {
            this.debugTexture.bind();
            this.draw3dOverlay();
        }
        if (MinecraftObjectHolder.DEBUGGING) {
            ViewportCamera cam = this.getCamera();
            this.gui.drawText(this.bounds.x, this.bounds.y + 50, "Cam Pos: " + cam.position.x + " " + cam.position.y + " " + cam.position.z, -16777216, -1);
            this.gui.drawText(this.bounds.x, this.bounds.y + 60, "Cam Look: " + cam.look.x + " " + cam.look.y + " " + cam.look.z, -16777216, -1);
            this.gui.drawText(this.bounds.x, this.bounds.y + 70, "Cam Dist: " + cam.camDist, -16777216, -1);
            EditorRenderer.Bounds hovered = this.editor.definition.bounds.stream().filter(ViewportPanel$$Lambda$3.lambdaFactory$()).findFirst().orElse(null);
            if (hovered != null) {
                Vec2f h = hovered.bb.getHoverPointer();
                this.gui.drawText(this.bounds.x, this.bounds.y + 80, "Hover Pos: " + h.x + " " + h.y + " D: " + hovered.bb.isHovered(), -16777216, -1);
            }
        }
    }

    @Override
    public ViewportCamera getCamera() {
        return this.editor.camera;
    }

    @Override
    public void preRender(MatrixStack stack, VBuffers buf) {
        this.editor.preRender();
    }

    @Override
    protected void postRender(MatrixStack stack, VBuffers buf) {
        EditorRenderer.Bounds hovered = this.editor.definition.select();
        if (hovered != null && Float.isFinite(hovered.bb.isHovered())) {
            if (hovered.drawHover != null) {
                hovered.drawHover.run();
            }
            hovered.isHovered = true;
        }
    }

    @Override
    public ModelDefinition getDefinition() {
        return this.editor.definition;
    }

    @Override
    public DisplayItem getHeldItem(ItemSlot hand) {
        return this.editor.handDisplay.getOrDefault((Object)hand, DisplayItem.NONE);
    }

    @Override
    public float getScale() {
        return this.editor.applyScaling ? this.editor.scalingElem.getScale() : 1.0f;
    }

    @Override
    public AnimationEngine.AnimationMode getAnimMode() {
        return this.editor.getRenderedPose() == VanillaPose.SKULL_RENDER ? AnimationEngine.AnimationMode.SKULL : AnimationEngine.AnimationMode.PLAYER;
    }

    @Override
    public Set<PlayerModelLayer> getArmorLayers() {
        PlayerModelLayer l;
        ModelElement root;
        ModelElement el = this.editor.getSelectedElement();
        if (el != null && (root = el.getRoot()) != null && root.typeData instanceof RootModelType && (l = PlayerModelLayer.getLayer((RootModelType)root.typeData)) != null) {
            HashSet<PlayerModelLayer> set = new HashSet<PlayerModelLayer>(this.editor.modelDisplayLayers);
            set.add(l);
            return set;
        }
        return this.editor.modelDisplayLayers;
    }

    @Override
    protected void poseModel(VanillaPlayerModel p, MatrixStack matrixstack, float partialTicks) {
        p.reset();
        p.setAllVisible(true);
        p.rightArmPose = this.getHeldItem((ItemSlot)ItemSlot.RIGHT_HAND).pose;
        p.leftArmPose = this.getHeldItem((ItemSlot)ItemSlot.LEFT_HAND).pose;
        Hand hand = this.poseModel0(p, matrixstack, partialTicks);
        PlayerModelSetup.setRotationAngles(p, 0.0f, 0.0f, hand, false);
        if (!this.editor.applyAnim && this.editor.playerTpose.get()) {
            p.rightArm.zRot = (float)Math.toRadians(90.0);
            p.leftArm.zRot = (float)Math.toRadians(-90.0);
        }
        float lsa = 0.75f;
        float ls = this.editor.playVanillaAnims.get() || this.editor.selectedAnim == null ? (float)MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine().getTicks() * 0.2f - 1.5f * (1.0f - partialTicks) : 1.0f;
        this.editor.applyRenderPoseForAnim(ViewportPanel$$Lambda$4.lambdaFactory$(this, matrixstack, p, hand, ls, lsa));
        this.modelView = new Mat4f(matrixstack.getLast().getMatrix());
    }

    protected Hand poseModel0(VanillaPlayerModel p, MatrixStack matrixstack, float partialTicks) {
        return Hand.RIGHT;
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes() {
        return super.getRenderTypes();
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes(String tex) {
        return super.getRenderTypes(tex);
    }

    @Override
    protected int drawParrots() {
        return this.editor.drawParrots.get() ? 3 : 0;
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (!this.elements.isEmpty()) {
            ArrayList elements = new ArrayList(this.elements);
            for (int i = elements.size() - 1; i >= 0; --i) {
                GuiElement guiElement = (GuiElement)elements.get(i);
                if (!guiElement.isVisible()) continue;
                guiElement.mouseClick(event.offset(this.getBounds()));
            }
        }
        if (this.isMenu(event.btn) && event.isHovered(this.bounds)) {
            this.dragged2 = 1;
        } else if (event.btn == EditorGui.getSelectMouseButton() && event.isHovered(this.bounds)) {
            EditorRenderer.Bounds hovered = this.editor.definition.bounds.stream().filter(ViewportPanel$$Lambda$5.lambdaFactory$()).sorted(Comparator.comparingInt(ViewportPanel$$Lambda$6.lambdaFactory$())).findFirst().orElse(null);
            if (hovered != null) {
                this.dragged = 1;
                if (hovered.type != EditorRenderer.BoundType.CLICK && this.draggingVec != null && this.canEdit()) {
                    this.draggingElement = hovered.elem;
                    this.draggingType = hovered.type;
                    this.oldValue = this.draggingType == EditorRenderer.BoundType.DRAG_NX || this.draggingType == EditorRenderer.BoundType.DRAG_NY || this.draggingType == EditorRenderer.BoundType.DRAG_NZ ? new Vec3f[]{this.getVec(this.draggingVec), this.getVec(VecType.OFFSET)} : new Vec3f[]{this.getVec(this.draggingVec)};
                }
                hovered.elem.onClick(this.gui, this.editor, event);
                event.consume();
                this.editor.updateGui();
            } else {
                this.dragged = -1;
            }
        }
        super.mouseClick(event);
        if (event.btn == EditorGui.getSelectMouseButton() && !this.enableDrag && this.dragged == -1 && event.isConsumed()) {
            this.dragged = 0;
        }
        if (this.isMenu(event.btn) && event.isHovered(this.bounds)) {
            event.consume();
        }
    }

    protected Vec3f getVec(VecType type) {
        return this.draggingElement.getVec(type);
    }

    protected void setVec(VecType type, Vec3f vec, boolean temp) {
        if (temp) {
            this.draggingElement.setVecTemp(type, vec);
        } else {
            this.draggingElement.setVec(vec, type);
        }
    }

    @Override
    public void mouseDrag(MouseEvent event) {
        if (event.btn == EditorGui.getSelectMouseButton() && event.isHovered(this.bounds) && this.canEdit()) {
            if (this.dragged > 0) {
                this.dragged = 2;
                EditorRenderer.Bounds hovered = this.editor.definition.bounds.stream().filter(ViewportPanel$$Lambda$7.lambdaFactory$()).findFirst().orElse(null);
                event.consume();
                if (hovered != null && this.draggingElement != null && this.draggingVec != null) {
                    Vec3f[] n = this.makeDragVec(hovered);
                    this.setVec(this.draggingVec, n[0], true);
                    if (n.length > 1) {
                        this.setVec(VecType.OFFSET, n[1], true);
                    }
                }
            } else if (this.dragged < 0) {
                this.dragged = -2;
            }
        }
        if (this.isMenu(event.btn) && event.isHovered(this.bounds) && this.dragged2 > 0) {
            this.dragged2 = 2;
        }
        super.mouseDrag(event);
        if (this.isMenu(event.btn) && event.isHovered(this.bounds)) {
            event.consume();
        }
    }

    @Override
    public void mouseRelease(MouseEvent event) {
        if (event.btn == EditorGui.getSelectMouseButton() && event.isHovered(this.bounds) && this.dragged < 0) {
            if (this.dragged == -1 && this.editor.getSelectedElement() != null) {
                this.editor.selectedElement = null;
                this.editor.updateGui();
                event.consume();
            }
            this.dragged = 0;
        }
        if (this.isMenu(event.btn) && event.isHovered(this.bounds) && this.dragged2 == 1) {
            this.dragged2 = 0;
            event.consume();
            ModelElement elem = this.editor.getSelectedElement();
            if (elem != null) {
                ((TreeElement.ModelTree)this.editor.treeHandler.getModel()).displayPopup(this.gui, event, elem);
            }
        }
        if (event.btn == EditorGui.getSelectMouseButton() && this.dragged > 0 && this.canEdit()) {
            event.consume();
            this.endGizmoDrag(true);
        }
        super.mouseRelease(event);
    }

    protected void endGizmoDrag(boolean apply) {
        EditorRenderer.Bounds hovered = this.editor.definition.bounds.stream().filter(ViewportPanel$$Lambda$8.lambdaFactory$()).findFirst().orElse(null);
        this.dragged = 0;
        if (this.draggingElement != null && this.draggingVec != null) {
            if (hovered != null) {
                Vec3f[] n = this.makeDragVec(hovered);
                this.setVec(this.draggingVec, this.oldValue[0], true);
                if (apply) {
                    this.setVec(this.draggingVec, n[0], false);
                }
                if (n.length > 1) {
                    this.setVec(VecType.OFFSET, this.oldValue[1], true);
                    if (apply) {
                        this.setVec(VecType.OFFSET, n[1], false);
                    }
                }
            } else {
                this.setVec(this.draggingVec, this.oldValue[0], true);
                if (this.oldValue.length > 1) {
                    this.setVec(VecType.OFFSET, this.oldValue[1], true);
                }
            }
            this.editor.updateGui();
        }
        this.draggingElement = null;
        this.draggingType = null;
        this.oldValue = null;
        this.draggingClickOffset = null;
    }

    protected Vec3f[] makeDragVec(EditorRenderer.Bounds hovered) {
        Vec3f[] res;
        if (this.draggingClickOffset == null) {
            this.draggingClickOffset = hovered.bb.getHoverPointer();
            return this.oldValue;
        }
        Vec3f v = this.oldValue[0];
        float hx = hovered.bb.getHoverPointer().x - this.draggingClickOffset.x;
        float hy = hovered.bb.getHoverPointer().y - this.draggingClickOffset.y;
        if (this.draggingVec == VecType.ROTATION) {
            Vec3f t = new Vec3f(hovered.bb.getHoverPointer(), 0.0f);
            t.normalize();
            double a = Math.toDegrees(Math.acos(t.y));
            double d = t.x;
            t = new Vec3f(this.draggingClickOffset, 0.0f);
            t.normalize();
            double o = Math.toDegrees(Math.acos(t.y));
            if (d < 0.0) {
                a = 360.0 - a;
            }
            if (t.x < 0.0f) {
                o = 360.0 - o;
            }
            hx = (float)(a - o);
            Quaternion.RotationOrder r = this.draggingType == EditorRenderer.BoundType.DRAG_X ? Quaternion.RotationOrder.ZYX : (this.draggingType == EditorRenderer.BoundType.DRAG_Y ? Quaternion.RotationOrder.ZXY : Quaternion.RotationOrder.XYZ);
            v = Quaternion.reorder(v, Quaternion.RotationOrder.ZYX, r);
            float x = v.x;
            float y = v.y;
            float z = v.z;
            switch (this.draggingType) {
                case DRAG_X: {
                    v = new Vec3f(x + hx, y, z);
                    break;
                }
                case DRAG_Y: {
                    v = new Vec3f(x, y + hx, z);
                    break;
                }
                case DRAG_Z: {
                    v = new Vec3f(x, y, z + hx);
                    break;
                }
            }
            res = new Vec3f[]{Quaternion.reorder(v, r, Quaternion.RotationOrder.ZYX)};
        } else {
            float x = v.x;
            float y = v.y;
            float z = v.z;
            switch (this.draggingType) {
                case DRAG_NX: {
                    res = new Vec3f[]{new Vec3f(x - hx, y, z), new Vec3f(this.oldValue[1].x + hy, this.oldValue[1].y, this.oldValue[1].z)};
                    break;
                }
                case DRAG_NY: {
                    res = new Vec3f[]{new Vec3f(x, y - hx, z), new Vec3f(this.oldValue[1].x, this.oldValue[1].y + hy, this.oldValue[1].z)};
                    break;
                }
                case DRAG_NZ: {
                    res = new Vec3f[]{new Vec3f(x, y, z - hx), new Vec3f(this.oldValue[1].x, this.oldValue[1].y, this.oldValue[1].z + hy)};
                    break;
                }
                case DRAG_X: {
                    res = new Vec3f[]{new Vec3f(x + hx, y, z)};
                    break;
                }
                case DRAG_Y: {
                    res = new Vec3f[]{new Vec3f(x, y + hx, z)};
                    break;
                }
                case DRAG_Z: {
                    res = new Vec3f[]{new Vec3f(x, y, z + hx)};
                    break;
                }
                default: {
                    res = this.oldValue;
                }
            }
        }
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Vec3f(res[i]);
            if (this.draggingVec == VecType.ROTATION) {
                if (this.gui.isShiftDown()) {
                    res[i].round(1);
                    continue;
                }
                res[i].x = Math.round(res[i].x / 5.0f) * 5;
                res[i].y = Math.round(res[i].y / 5.0f) * 5;
                res[i].z = Math.round(res[i].z / 5.0f) * 5;
                continue;
            }
            res[i].round(this.gui.isShiftDown() ? 10 : 1);
        }
        return res;
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (event.matches(this.gui.getKeyCodes().KEY_ESCAPE) && this.draggingElement != null) {
            event.consume();
            this.endGizmoDrag(false);
        }
        KeybindHandler h = this.frame.getKeybindHandler();
        h.registerKeybind(Keybinds.POSITION, ViewportPanel$$Lambda$9.lambdaFactory$(this));
        h.registerKeybind(Keybinds.OFFSET, ViewportPanel$$Lambda$10.lambdaFactory$(this));
        h.registerKeybind(Keybinds.SIZE, ViewportPanel$$Lambda$11.lambdaFactory$(this));
        h.registerKeybind(Keybinds.ROTATION, ViewportPanel$$Lambda$12.lambdaFactory$(this));
        h.registerKeybind(Keybinds.PIVOT, ViewportPanel$$Lambda$13.lambdaFactory$(this));
        Editor editor = this.editor;
        editor.getClass();
        h.registerKeybind(Keybinds.DELETE, ViewportPanel$$Lambda$14.lambdaFactory$(editor));
        Editor editor2 = this.editor;
        editor2.getClass();
        h.registerKeybind(Keybinds.NEW_PART, ViewportPanel$$Lambda$15.lambdaFactory$(editor2));
        h.registerKeybind(Keybinds.FOCUS_CAMERA, ViewportPanel$$Lambda$16.lambdaFactory$(this));
        h.registerKeybind(Keybinds.TOGGLE_HIDDEN_ACTION, ViewportPanel$$Lambda$17.lambdaFactory$(this));
        Editor editor3 = this.editor;
        editor3.getClass();
        h.registerKeybind(Keybinds.TOGGLE_VIS_ACTION, ViewportPanel$$Lambda$18.lambdaFactory$(editor3));
        Editor editor4 = this.editor;
        editor4.getClass();
        h.registerKeybind(Keybinds.TOGGLE_LOCK_ACTION, ViewportPanel$$Lambda$19.lambdaFactory$(editor4));
        super.keyPressed(event);
    }

    private void focusOnSelected() {
        ModelElement me = this.editor.getSelectedElement();
        if (me != null && me.matrixPosition != null) {
            Vec4f v = new Vec4f(0.0f, 0.0f, 1.0f, 1.0f);
            v.transform(me.matrixPosition);
            ViewportCamera cam = this.getCamera();
            cam.position.x = v.z - 0.5f;
            cam.position.y = 1.5f - v.y;
            cam.position.z = v.x + 0.5f;
        }
    }

    @Override
    protected boolean isRotate(int btn) {
        return btn == EditorGui.getRotateMouseButton() || btn == EditorGui.getDragMouseButton();
    }

    @Override
    protected boolean isDrag(int btn) {
        int d = EditorGui.getDragMouseButton();
        return d == -1 ? this.gui.isShiftDown() : d == btn;
    }

    protected boolean isMenu(int btn) {
        int d = EditorGui.getMenuMouseButton();
        return d == -1 ? this.gui.isAltDown() && btn == EditorGui.getSelectMouseButton() : d == btn;
    }

    protected VecType[] getVecTypes() {
        return VecType.MOUSE_EDITOR_TYPES;
    }

    private void setVec(VecType vt) {
        if (this.dragGroup.containsKey(vt)) {
            this.draggingVec = vt;
            this.dragGroup.accept(vt);
        }
    }

    public boolean canEdit() {
        return this.editor.selectedElement != null && this.editor.selectedElement.canEditVec(this.draggingVec);
    }

    static /* synthetic */ void lambda$keyPressed$12(ViewportPanel this_) {
        this_.editor.switchEffect(Effect.HIDE);
    }

    static /* synthetic */ void lambda$keyPressed$11(ViewportPanel this_) {
        this_.setVec(VecType.PIVOT);
    }

    static /* synthetic */ void lambda$keyPressed$10(ViewportPanel this_) {
        this_.setVec(VecType.ROTATION);
    }

    static /* synthetic */ void lambda$keyPressed$9(ViewportPanel this_) {
        this_.setVec(VecType.SIZE);
    }

    static /* synthetic */ void lambda$keyPressed$8(ViewportPanel this_) {
        this_.setVec(VecType.OFFSET);
    }

    static /* synthetic */ void lambda$keyPressed$7(ViewportPanel this_) {
        this_.setVec(VecType.POSITION);
    }

    static /* synthetic */ boolean lambda$endGizmoDrag$6(EditorRenderer.Bounds b) {
        return b.isHovered && b.type == EditorRenderer.BoundType.DRAG_PANE;
    }

    static /* synthetic */ boolean lambda$mouseDrag$5(EditorRenderer.Bounds b) {
        return b.isHovered && b.type == EditorRenderer.BoundType.DRAG_PANE;
    }

    static /* synthetic */ int lambda$mouseClick$4(EditorRenderer.Bounds b) {
        return -b.type.ordinal();
    }

    static /* synthetic */ boolean lambda$mouseClick$3(EditorRenderer.Bounds b) {
        return b.isHovered && b.type != EditorRenderer.BoundType.DRAG_PANE;
    }

    static /* synthetic */ void lambda$poseModel$2(ViewportPanel this_, MatrixStack matrixstack, VanillaPlayerModel p, Hand hand, float ls, float lsa, VanillaPose pose) {
        switch (pose) {
            case SLEEPING: {
                matrixstack.translate(0.0, 1.501f, 0.0);
                matrixstack.rotate(Vec3f.POSITIVE_Z.getDegreesQuaternion(-90.0f));
                matrixstack.rotate(Vec3f.POSITIVE_Y.getDegreesQuaternion(270.0f));
                break;
            }
            case SNEAKING: {
                p.crouching = true;
                PlayerModelSetup.setRotationAngles(p, 0.0f, 0.0f, hand, false);
                break;
            }
            case SNEAK_WALK: {
                p.crouching = true;
                PlayerModelSetup.setRotationAngles(p, ls, lsa, hand, false);
                break;
            }
            case RIDING: {
                p.riding = true;
                PlayerModelSetup.setRotationAngles(p, 0.0f, 0.0f, hand, false);
                break;
            }
            case FLYING: 
            case TRIDENT_SPIN: {
                matrixstack.translate(0.0, 1.0, -0.5);
                matrixstack.rotate(Vec3f.POSITIVE_X.getDegreesQuaternion(90.0f));
                p.head.xRot = -0.7853982f;
                break;
            }
            case RUNNING: {
                PlayerModelSetup.setRotationAngles(p, ls, 1.0f, hand, false);
                break;
            }
            case SWIMMING: 
            case CRAWLING: {
                PlayerModelSetup.setRotationAngles(p, ls, lsa, hand, true);
                matrixstack.translate(0.0, 1.0, -0.5);
                matrixstack.rotate(Vec3f.POSITIVE_X.getDegreesQuaternion(90.0f));
                break;
            }
            case WALKING: {
                PlayerModelSetup.setRotationAngles(p, ls, lsa, hand, false);
                break;
            }
            case SKULL_RENDER: {
                p.setAllVisible(false);
                p.head.visible = true;
                matrixstack.translate(0.0, 1.501f, 0.0);
                break;
            }
            case HEAD_ROTATION_YAW: {
                if (this_.editor.selectedAnim == null || !this_.editor.playVanillaAnims.get()) break;
                int f = this_.editor.selectedAnim.getSelectedFrameIndex();
                int frms = this_.editor.selectedAnim.getFrames().size() - 1;
                if (f < 0 || frms < 1) break;
                p.head.yRot = (float)Math.toRadians((float)f / (float)frms * 180.0f - 90.0f);
                break;
            }
            case HEAD_ROTATION_PITCH: {
                if (this_.editor.selectedAnim == null || !this_.editor.playVanillaAnims.get()) break;
                int f = this_.editor.selectedAnim.getSelectedFrameIndex();
                int frms = this_.editor.selectedAnim.getFrames().size() - 1;
                if (f < 0 || frms < 1) break;
                p.head.xRot = (float)(-Math.toRadians((1.0f - (float)f / (float)frms) * 180.0f - 90.0f));
                break;
            }
        }
    }

    static /* synthetic */ boolean lambda$draw$1(EditorRenderer.Bounds b) {
        return b.isHovered;
    }

    static /* synthetic */ void lambda$new$0(ViewportPanel this_, VecType v) {
        this_.setVec(v);
    }

    static /* synthetic */ void access$lambda$0(ViewportPanel viewportPanel) {
        viewportPanel.focusOnSelected();
    }
}

