/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.ButtonGroup;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$1;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$10;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$11;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$2;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$3;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$4;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$5;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$6;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$7;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$8;
import com.tom.cpm.shared.editor.gui.popup.DescPopup$$Lambda$9;
import com.tom.cpm.shared.editor.gui.popup.ScreenshotPopup;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.model.SkinType;

public class DescPopup
extends PopupPanel {
    private EditorTexture icon;
    private SkinType skinType;

    public DescPopup(EditorGui g, boolean skinTypeSettings, Runnable onOk) {
        super(g.getGui());
        this.setBounds(new Box(0, 0, 320, 220));
        Editor editor = g.getEditor();
        this.skinType = editor.skinType;
        Label nameLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0]));
        nameLbl.setBounds(new Box(5, 5, 130, 10));
        this.addElement(nameLbl);
        TextField nameField = new TextField(this.gui);
        nameField.setBounds(new Box(5, 15, 130, 20));
        this.addElement(nameField);
        Label descLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]));
        descLbl.setBounds(new Box(5, 40, 130, 10));
        this.addElement(descLbl);
        TextField descField = new TextField(this.gui);
        descField.setBounds(new Box(5, 50, 130, 20));
        this.addElement(descField);
        this.icon = new EditorTexture();
        if (editor.description != null) {
            nameField.setText(editor.description.name);
            descField.setText(editor.description.desc);
            if (editor.description.icon != null) {
                this.icon.setImage(editor.description.icon);
            }
        }
        Button setIcon = new Button(this.gui, this.gui.i18nFormat("button.cpm.setIcon", new Object[0]), DescPopup$$Lambda$1.lambdaFactory$(this, g));
        setIcon.setBounds(new Box(5, 80, 100, 20));
        this.addElement(setIcon);
        Checkbox chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
        chbxClone.setTooltip(new Tooltip(g, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
        chbxClone.setBounds(new Box(5, 110, 60, 20));
        chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
        this.addElement(chbxClone);
        Checkbox chbxUUIDLock = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uuidlock", new Object[0]));
        chbxUUIDLock.setTooltip(new Tooltip(g, this.gui.i18nFormat("tooltip.cpm.uuidlock", MinecraftClientAccess$.get().getClientPlayer().getUUID().toString())));
        chbxUUIDLock.setBounds(new Box(5, 135, 60, 20));
        chbxUUIDLock.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
        this.addElement(chbxUUIDLock);
        chbxClone.setAction(DescPopup$$Lambda$2.lambdaFactory$(chbxClone, chbxUUIDLock));
        chbxUUIDLock.setAction(DescPopup$$Lambda$3.lambdaFactory$(chbxUUIDLock, chbxClone));
        if (skinTypeSettings) {
            ButtonGroup<SkinType, Checkbox> group = new ButtonGroup<SkinType, Checkbox>(DescPopup$$Lambda$4.lambdaFactory$(), DescPopup$$Lambda$5.lambdaFactory$(), DescPopup$$Lambda$6.lambdaFactory$(this));
            for (int j = 0; j < SkinType.VANILLA_TYPES.length; ++j) {
                SkinType s = SkinType.VANILLA_TYPES[j];
                Checkbox chbxSt = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.skin_type." + s.getName(), new Object[0]));
                chbxSt.setBounds(new Box(this.bounds.w - 135, this.bounds.y + 5 + j * 25, 60, 20));
                this.addElement(chbxSt);
                group.addElement(s, chbxSt);
            }
            group.accept(this.skinType);
        }
        Label modelIdLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.modelPropertyId", new Object[0]));
        modelIdLbl.setBounds(new Box(5, 160, 130, 10));
        modelIdLbl.setTooltip(new Tooltip(g, this.gui.i18nFormat("tooltip.cpm.modelPropertyId", new Object[0])));
        this.addElement(modelIdLbl);
        TextField modelIdField = new TextField(this.gui);
        modelIdField.setBounds(new Box(5, 170, 130, 20));
        if (editor.modelId != null) {
            modelIdField.setText(editor.modelId);
        }
        this.addElement(modelIdField);
        Button ok = new Button(this.gui, this.gui.i18nFormat("button.cpm.ok", new Object[0]), DescPopup$$Lambda$7.lambdaFactory$(this, skinTypeSettings, editor, g, nameField, descField, chbxUUIDLock, chbxClone, modelIdField, onOk));
        ok.setBounds(new Box(5, 195, 60, 20));
        this.addElement(ok);
    }

    @Override
    public void onClosed() {
        this.icon.free();
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        super.draw(event, partialTicks);
        if (this.icon.getImage() != null) {
            int y = 55;
            this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + y, 130, 130, this.gui.getColors().color_picker_border);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + y + 1, 128, 128, -1);
            this.icon.bind();
            this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + y + 1, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    private static void openScreenshot(EditorGui e, EditorTexture icon, DescPopup popup) {
        popup.close();
        EditorTexture editorTexture = icon;
        editorTexture.getClass();
        e.openPopup(new ScreenshotPopup(e, DescPopup$$Lambda$8.lambdaFactory$(editorTexture), DescPopup$$Lambda$9.lambdaFactory$(e, popup)));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.desc", new Object[0]);
    }

    static /* synthetic */ void lambda$openScreenshot$7(EditorGui e, DescPopup popup) {
        e.openPopup(popup);
    }

    static /* synthetic */ void lambda$new$6(DescPopup this_, boolean skinTypeSettings, Editor editor, EditorGui g, TextField nameField, TextField descField, Checkbox chbxUUIDLock, Checkbox chbxClone, TextField modelIdField, Runnable onOk) {
        if (skinTypeSettings && editor.skinType != this_.skinType) {
            if (editor.elements.stream().anyMatch(DescPopup$$Lambda$10.lambdaFactory$())) {
                g.openPopup(new ConfirmPopup(g, this_.gui.i18nFormat("label.cpm.confirmSkinTypeEdit", this_.gui.i18nFormat("label.cpm.skin_type." + editor.skinType.getName(), new Object[0]), this_.gui.i18nFormat("label.cpm.skin_type." + this_.skinType.getName(), new Object[0])), DescPopup$$Lambda$11.lambdaFactory$(this_, editor), null));
            } else {
                editor.skinType = this_.skinType;
                editor.markDirty();
            }
        }
        if (editor.description == null) {
            editor.description = new ModelDescription();
        }
        editor.description.name = nameField.getText();
        editor.description.desc = descField.getText();
        ModelDescription.CopyProtection copyProtection = chbxUUIDLock.isSelected() ? ModelDescription.CopyProtection.UUID_LOCK : (editor.description.copyProtection = chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : ModelDescription.CopyProtection.NORMAL);
        if (!modelIdField.getText().isEmpty()) {
            editor.modelId = modelIdField.getText();
        }
        editor.markDirty();
        this_.close();
        if (onOk != null) {
            onOk.run();
        }
    }

    static /* synthetic */ void lambda$null$5(DescPopup this_, Editor editor) {
        editor.skinType = this_.skinType;
        editor.markDirty();
    }

    static /* synthetic */ boolean lambda$null$4(ModelElement m) {
        return !m.hidden;
    }

    static /* synthetic */ void lambda$new$3(DescPopup this_, SkinType i) {
        this_.skinType = i;
    }

    static /* synthetic */ void lambda$new$2(Checkbox chbxUUIDLock, Checkbox chbxClone) {
        if (!chbxUUIDLock.isSelected()) {
            chbxUUIDLock.setSelected(true);
            chbxClone.setSelected(false);
        } else {
            chbxUUIDLock.setSelected(false);
        }
    }

    static /* synthetic */ void lambda$new$1(Checkbox chbxClone, Checkbox chbxUUIDLock) {
        if (!chbxClone.isSelected()) {
            chbxUUIDLock.setSelected(false);
            chbxClone.setSelected(true);
        } else {
            chbxClone.setSelected(false);
        }
    }

    static /* synthetic */ void lambda$new$0(DescPopup this_, EditorGui g) {
        DescPopup.openScreenshot(g, this_.icon, this_);
    }
}

